/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.BipedMech;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.VTOL;
import megamek.common.actions.PhysicalAttackAction;

public class PunchAttackAction
extends PhysicalAttackAction {
    private static final long serialVersionUID = 3684646558944678180L;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private int arm;

    public PunchAttackAction(int n, int n2, int n3) {
        super(n, n2);
        this.arm = n3;
    }

    public PunchAttackAction(int n, int n2, int n3, int n4) {
        super(n, n2, n3);
        this.arm = n4;
    }

    public int getArm() {
        return this.arm;
    }

    public void setArm(int n) {
        this.arm = n;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 61 * n + this.arm;
        return n;
    }

    public boolean equals(Object object) {
        return super.equals(object) && ((PunchAttackAction)object).getArm() == this.arm;
    }

    public ToHitData toHit(IGame iGame) {
        return PunchAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this.getArm());
    }

    protected static String toHitIsImpossible(IGame iGame, Entity entity, Targetable targetable) {
        String string = PhysicalAttackAction.toHitIsImpossible(iGame, entity, targetable);
        String string2 = null;
        if (entity instanceof Mech && ((Mech)entity).hasExtendedRetractableBlade()) {
            string2 = "Extended retractable blade";
        }
        if (string != null) {
            return string;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2) {
        int n3;
        Entity entity = iGame.getEntity(n);
        if (entity == null || targetable == null) {
            throw new IllegalArgumentException("Attacker or target not valid");
        }
        String string = PunchAttackAction.toHitIsImpossible(iGame, entity, targetable);
        if (string != null) {
            return new ToHitData(Integer.MAX_VALUE, "impossible");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        int n4 = entity.absHeight() + iHex.getElevation();
        int n5 = targetable.getElevation() + iHex2.getElevation();
        int n6 = n5 + targetable.getHeight();
        int n7 = n2 == 2 ? 4 : 5;
        int n8 = n3 = n2 == 2 ? 3 : 2;
        if (n2 != 2 && n2 != 1) {
            throw new IllegalArgumentException("Arm must be LEFT or RIGHT");
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't punch");
        }
        if (entity.entityIsQuad()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is a quad");
        }
        if (entity.getArmsFlipped()) {
            return new ToHitData(Integer.MAX_VALUE, "Arms are flipped to the rear. Can not punch.");
        }
        if (entity.isLocationBad(n7)) {
            return new ToHitData(Integer.MAX_VALUE, "Arm missing");
        }
        if (!entity.hasWorkingSystem(7, n7)) {
            return new ToHitData(Integer.MAX_VALUE, "Shoulder destroyed");
        }
        if (entity.weaponFiredFrom(n7)) {
            return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
        }
        if (targetable instanceof VTOL && ((VTOL)targetable).isFlying() ? n5 - n4 > 2 || n5 - n4 < 1 : n4 < n5 || n4 > n6) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (entity.hasActiveShield(n7)) {
            return new ToHitData(Integer.MAX_VALUE, "Cannot punch with shield in active mode");
        }
        int n9 = entity.getCrew().getPiloting();
        ToHitData toHitData = new ToHitData(n9, "base");
        PunchAttackAction.setCommonModifiers(toHitData, iGame, entity, targetable);
        if (entity.isProne()) {
            if (entity.isLocationBad(4) || entity.isLocationBad(5) || !(targetable instanceof Tank) || entity.getPosition().distance(targetable.getPosition()) != 0) return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
            toHitData.addModifier(2, "attacker is prone");
        } else if (!Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable.getPosition(), n3)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15 || targetable instanceof GunEmplacement) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        if (!entity.hasWorkingSystem(8, n7)) {
            toHitData.addModifier(2, "Upper arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(9, n7)) {
            toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
        }
        boolean bl = ((BipedMech)entity).hasClaw(n7);
        if (!entity.hasWorkingSystem(10, n7) && !bl) {
            toHitData.addModifier(1, "Hand actuator missing or destroyed");
        }
        if (bl) {
            toHitData.addModifier(1, "Using Claws");
        }
        if (n4 == n5) {
            if (targetable.getHeight() == 0) {
                toHitData.setHitTable(0);
            } else {
                toHitData.setHitTable(2);
            }
        } else {
            toHitData.setHitTable(1);
        }
        toHitData.setSideTable(Compute.targetSideTable(entity, targetable));
        return toHitData;
    }

    public static int getDamageFor(Entity entity, int n, boolean bl) {
        int n2 = n == 2 ? 4 : 5;
        int n3 = (int)Math.ceil((double)entity.getWeight() / 10.0);
        if (((BipedMech)entity).hasClaw(n2)) {
            n3 = (int)Math.ceil((double)entity.getWeight() / 7.0);
        }
        float f = 1.0f;
        if (!entity.hasWorkingSystem(8, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(9, n2)) {
            f /= 2.0f;
        }
        if (!entity.hasWorkingSystem(7, n2)) {
            n3 = 0;
        }
        if (entity.heat >= 9 && ((Mech)entity).hasTSM()) {
            f *= 2.0f;
        }
        int n4 = (int)Math.floor((float)n3 * f) + entity.getCrew().modifyPhysicalDamagaForMeleeSpecialist();
        if (entity.getLocationStatus(n2) == 2) {
            n4 = (int)Math.ceil((float)n4 * 0.5f);
        }
        if (bl) {
            n4 = Math.max(1, n4 / 10);
        }
        return n4;
    }
}

