/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.util.Enumeration;
import megamek.common.Aero;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Dropship;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Jumpship;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.SpaceStation;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.Warship;
import megamek.common.actions.AbstractAttackAction;

public class RamAttackAction
extends AbstractAttackAction {
    private static final long serialVersionUID = -3549351664290057785L;

    public RamAttackAction(Entity entity, Targetable targetable) {
        this(entity.getId(), targetable.getTargetType(), targetable.getTargetId(), targetable.getPosition());
    }

    public RamAttackAction(int n, int n2, int n3, Coords coords) {
        super(n, n2, n3);
    }

    public ToHitData toHit(IGame iGame) {
        Entity entity = iGame.getEntity(this.getEntityId());
        return this.toHit(iGame, iGame.getTarget(this.getTargetType(), this.getTargetId()), entity.getPosition(), entity.getElevation(), entity.getPriorPosition(), entity.moved);
    }

    public ToHitData toHit(IGame iGame, Targetable targetable, Coords coords, int n, Coords coords2, int n2) {
        int n3;
        Entity entity = this.getEntity(iGame);
        if (entity == null) {
            throw new IllegalStateException("Attacker is null");
        }
        if (targetable == null) {
            return new ToHitData(Integer.MAX_VALUE, "Target is null");
        }
        if (!(entity instanceof Aero)) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is not Aero");
        }
        if (!(targetable instanceof Aero)) {
            return new ToHitData(Integer.MAX_VALUE, "Target is not Aero");
        }
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        IHex iHex = iGame.getBoard().getHex(coords);
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        int n4 = n + iHex.getElevation();
        int n5 = targetable.getElevation() + iHex2.getElevation();
        ToHitData toHitData = null;
        if (entity.equals(entity2)) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target yourself");
        }
        if (entity2 != null && -1 != entity2.getTransportId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is a passenger.");
        }
        if (coords.distance(targetable.getPosition()) > 0) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (n4 != n5) {
            return new ToHitData(Integer.MAX_VALUE, "Target must be at the same elevation level");
        }
        if (entity2 != null && entity2.isRamming()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is already making a ramming attack");
        }
        if (entity2 != null && !entity2.isDone()) {
            return new ToHitData(Integer.MAX_VALUE, "Target must be done with movement");
        }
        int n6 = 6 + entity2.getCrew().getPiloting() - entity.getCrew().getPiloting();
        toHitData = new ToHitData(n6, "base");
        Aero aero = (Aero)entity;
        if (targetable instanceof SpaceStation) {
            toHitData.addModifier(-1, "target is a space station");
        } else if (targetable instanceof Warship) {
            toHitData.addModifier(1, "target is a warship");
        } else if (targetable instanceof Jumpship) {
            toHitData.addModifier(0, "target is a jumpship");
        } else if (targetable instanceof Dropship) {
            toHitData.addModifier(2, "target is a dropship");
        } else {
            toHitData.addModifier(4, "target is a fighter");
        }
        if (aero instanceof SpaceStation) {
            toHitData.addModifier(0, "attacker is a space station");
        } else if (aero instanceof Warship) {
            toHitData.addModifier(1, "attacker is a warship");
        } else if (aero instanceof Jumpship) {
            toHitData.addModifier(0, "attacker is a jumpship");
        } else if (aero instanceof Dropship) {
            toHitData.addModifier(-1, "attacker is a dropship");
        } else {
            toHitData.addModifier(-2, "target is a fighter");
        }
        if (targetable.isImmobile() || entity2.getWalkMP() == 0) {
            toHitData.addModifier(-2, "target cannot spend thrust");
        }
        if (aero.getSensorHits() > 0) {
            toHitData.addModifier(1, "sensor damage");
        }
        if ((n3 = aero.getAvionicsHits()) > 3) {
            n3 = 3;
        }
        if (n3 > 0) {
            toHitData.addModifier(n3, "avionics damage");
        }
        toHitData.setSideTable(entity2.sideTable(coords2));
        toHitData.setHitTable(0);
        return toHitData;
    }

    public ToHitData toHit(IGame iGame, MovePath movePath) {
        MoveStep moveStep;
        Entity entity = iGame.getEntity(this.getEntityId());
        Targetable targetable = this.getTarget(iGame);
        Coords coords = entity.getPosition();
        int n = entity.getElevation();
        Coords coords2 = movePath.getSecondFinalPosition(entity.getPosition());
        MoveStep moveStep2 = null;
        if (!movePath.contains(46)) {
            return new ToHitData(Integer.MAX_VALUE, "Ram action not found in movement path");
        }
        movePath.compile(iGame, entity);
        Enumeration<MoveStep> enumeration = movePath.getSteps();
        while (enumeration.hasMoreElements() && (moveStep = enumeration.nextElement()).getMovementType() != -1) {
            if (moveStep.getType() != 46) continue;
            moveStep2 = moveStep;
            coords = moveStep.getPosition();
            n = moveStep.getElevation();
        }
        if (moveStep2 == null || !targetable.getPosition().equals(moveStep2.getPosition())) {
            return new ToHitData(Integer.MAX_VALUE, "Could not reach target with movement");
        }
        return this.toHit(iGame, targetable, coords, n, coords2, moveStep2.getMovementType());
    }

    public static int getDamageFor(Aero aero, Aero aero2) {
        int n = aero.getCurrentVelocity();
        int n2 = aero2.getCurrentVelocity();
        return RamAttackAction.getDamageFor(aero, aero2, aero.getPriorPosition(), n, n2);
    }

    public static int getDamageFor(Aero aero, Aero aero2, Coords coords, int n, int n2) {
        int n3 = Compute.getNetVelocity(coords, aero2, n, n2);
        return (int)Math.ceil((double)aero.getWeight() / 10.0 * (double)n3);
    }

    public static int getDamageTakenBy(Aero aero, Aero aero2) {
        int n = aero.getCurrentVelocity();
        int n2 = aero2.getCurrentVelocity();
        return RamAttackAction.getDamageTakenBy(aero, aero2, aero.getPriorPosition(), n, n2);
    }

    public static int getDamageTakenBy(Aero aero, Aero aero2, Coords coords, int n, int n2) {
        int n3 = Compute.getNetVelocity(coords, aero2, n, n2);
        return (int)Math.ceil((double)aero2.getWeight() / 10.0 * (double)n3);
    }
}

