/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Dropship;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.FighterSquadron;
import megamek.common.GunEmplacement;
import megamek.common.HexTarget;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.LandAirMech;
import megamek.common.LosEffects;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.MinefieldTarget;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.RangeType;
import megamek.common.RoundUpdated;
import megamek.common.SmallCraft;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.VTOL;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.EntityAction;
import megamek.common.weapons.ScreenLauncherBayWeapon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaponAttackAction
extends AbstractAttackAction
implements Serializable {
    private static final long serialVersionUID = -9096603813317359351L;
    private int weaponId;
    private int ammoId = -1;
    private int aimedLocation = -1;
    private int aimMode = 0;
    private int otherAttackInfo = -1;
    private boolean nemesisConfused;
    private boolean swarmingMissiles;
    private int oldTargetId = -1;
    private int swarmMissiles = 0;
    private transient ArrayList<Mounted> vCounterEquipment;

    public WeaponAttackAction(int n, int n2, int n3) {
        super(n, n2);
        this.weaponId = n3;
    }

    public WeaponAttackAction(int n, int n2, int n3, int n4) {
        super(n, n2, n3);
        this.weaponId = n4;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 61 * n + this.weaponId;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && ((WeaponAttackAction)object).getWeaponId() == this.weaponId;
    }

    public int getWeaponId() {
        return this.weaponId;
    }

    public int getAmmoId() {
        return this.ammoId;
    }

    public int getAimedLocation() {
        return this.aimedLocation;
    }

    public int getAimingMode() {
        return this.aimMode;
    }

    public ArrayList<Mounted> getCounterEquipment() {
        return this.vCounterEquipment;
    }

    public void setWeaponId(int n) {
        this.weaponId = n;
    }

    public void setAmmoId(int n) {
        this.ammoId = n;
    }

    public void setAimedLocation(int n) {
        this.aimedLocation = n;
    }

    public void setAimingMode(int n) {
        this.aimMode = n;
    }

    public void addCounterEquipment(Mounted mounted) {
        if (this.vCounterEquipment == null) {
            this.vCounterEquipment = new ArrayList();
        }
        this.vCounterEquipment.add(mounted);
    }

    public void setOtherAttackInfo(int n) {
        this.otherAttackInfo = n;
    }

    public int getOtherAttackInfo() {
        return this.otherAttackInfo;
    }

    public ToHitData toHit(IGame iGame) {
        return WeaponAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this.getWeaponId(), this.getAimedLocation(), this.getAimingMode(), this.nemesisConfused, this.swarmingMissiles, iGame.getEntity(this.oldTargetId));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2) {
        return WeaponAttackAction.toHit(iGame, n, targetable, n2, -1, 0, false, false, null);
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2, int n3, int n4) {
        return WeaponAttackAction.toHit(iGame, n, targetable, n2, n3, n4, false, false, null);
    }

    private static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2, int n3, int n4, boolean bl, boolean bl2, Entity entity) {
        int n5;
        LandAirMech landAirMech;
        LandAirMech landAirMech2;
        int n6;
        Object object;
        int n7;
        Object object2;
        ToHitData toHitData;
        LosEffects losEffects;
        boolean bl3;
        Targetable targetable2;
        Entity entity2 = iGame.getEntity(n);
        Mounted mounted = entity2.getEquipment(n2);
        WeaponType weaponType = (WeaponType)mounted.getType();
        if (bl2) {
            if (RangeType.rangeBracket(entity2.getPosition().distance(targetable.getPosition()), weaponType.getRanges(), iGame.getOptions().booleanOption("maxtech_range")) == Integer.MAX_VALUE) {
                return new ToHitData(0x7FFFFFFE, "swarm target out of range");
            }
            targetable2 = targetable;
            targetable = entity;
            entity = targetable2;
        }
        targetable2 = null;
        if (targetable.getTargetType() == 0) {
            targetable2 = (Entity)targetable;
        }
        boolean bl4 = entity2 instanceof Infantry;
        boolean bl5 = weaponType.hasFlag(2048L);
        boolean bl6 = weaponType.getAmmoType() != -1 && !bl5;
        Mounted mounted2 = bl6 ? mounted.getLinked() : null;
        AmmoType ammoType = mounted2 == null ? null : (AmmoType)mounted2.getType();
        boolean bl7 = Compute.isInBuilding(iGame, (Entity)targetable2);
        boolean bl8 = weaponType.hasModes() && mounted.curMode().equals("Indirect");
        boolean bl9 = ammoType != null && (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 45) && ammoType.getMunitionType() == 0x10000000L || bl5 && weaponType.hasFlag(1024L);
        boolean bl10 = weaponType.hasFlag(32768L) && iGame.getPhase() == IGame.Phase.PHASE_FIRING;
        boolean bl11 = weaponType.hasFlag(32768L) && (iGame.getPhase() == IGame.Phase.PHASE_TARGETING || iGame.getPhase() == IGame.Phase.PHASE_OFFBOARD);
        boolean bl12 = bl10 && targetable.getTargetType() == 0 && ((Entity)targetable2).getMovementMode() == 6 && ((Entity)targetable2).getElevation() > 0 && bl6 && ammoType.getMunitionType() == 0L;
        boolean bl13 = entity2.isINarcedWith(4L);
        boolean bl14 = false;
        boolean bl15 = Compute.isAffectedByECM(entity2, entity2.getPosition(), targetable.getPosition());
        boolean bl16 = Compute.isAffectedByECM(entity2, targetable.getPosition(), targetable.getPosition());
        boolean bl17 = weaponType.hasFlag(0x4000000L);
        boolean bl18 = false;
        boolean bl19 = ammoType != null && (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 45 || ammoType.getAmmoType() == 7) && ammoType.getMunitionType() == 16384L;
        boolean bl20 = bl3 = ammoType != null && (ammoType.getAmmoType() == 45 || ammoType.getAmmoType() == 7) && ammoType.getMunitionType() == 0x4000000L;
        if (targetable2 != null && !bl16 && ((Entity)targetable2).isINarcedBy(entity2.getOwner().getTeam()) && ammoType != null && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45 || ammoType.getAmmoType() == 9) && ammoType.getMunitionType() == 2048L) {
            bl14 = true;
        }
        int n8 = 0;
        int n9 = targetable.getTargetType();
        ToHitData toHitData2 = null;
        String string = null;
        string = WeaponAttackAction.toHitIsImpossible(iGame, entity2, targetable, mounted, ammoType, weaponType, n9, bl2, bl6, (Entity)targetable2, bl17, bl9, bl4, bl8, n, n2, bl11, mounted2, bl12, bl7, bl10, bl16);
        if (string != null) {
            return new ToHitData(Integer.MAX_VALUE, string);
        }
        long l = 0L;
        if (ammoType != null) {
            l = ammoType.getMunitionType();
        }
        if (l == 0x1000000000L) {
            bl18 = true;
        }
        int n10 = targetable2 == null ? iGame.getBoard().getHex(targetable.getPosition()).floor() : ((Entity)targetable2).absHeight();
        Targetable targetable3 = null;
        boolean bl21 = false;
        if (bl8) {
            if (targetable instanceof Entity && !bl16 && targetable2 != null && ammoType != null && bl6 && ammoType.getMunitionType() == 2048L && (((Entity)targetable2).isNarcedBy(entity2.getOwner().getTeam()) || ((Entity)targetable2).isINarcedBy(entity2.getOwner().getTeam()))) {
                targetable3 = targetable2;
                bl21 = true;
            } else {
                targetable3 = Compute.findSpotter(iGame, entity2, targetable);
            }
        }
        int n11 = 0;
        boolean bl22 = false;
        if (bl6 && weaponType.getAmmoType() == 7 && ammoType != null && ammoType.getMunitionType() == 0x8000000L && entity2.getElevation() == -1 && entity2.getLocationStatus(mounted.getLocation()) == 2) {
            bl22 = true;
            entity2.setElevation(0);
        }
        if (!bl8) {
            losEffects = LosEffects.calculateLos(iGame, n, targetable);
            if (entity2.hasActiveEiCockpit()) {
                n11 = losEffects.getLightWoods() > 0 ? 2 : 1;
            }
            toHitData = losEffects.losModifiers(iGame, n11);
            if (ammoType != null && (ammoType.getAmmoType() == 8 || ammoType.getAmmoType() == 10 || (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 12 || ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45) && l == 0x40000000L) && losEffects.getMinimumWaterDepth() < 1) {
                return new ToHitData(Integer.MAX_VALUE, "Torpedos must follow water their entire LOS");
            }
        } else {
            losEffects = LosEffects.calculateLos(iGame, ((Entity)targetable3).getId(), targetable);
            losEffects.setAttackerCover(0);
            if (!bl21 && ((Entity)targetable3).hasActiveEiCockpit()) {
                n11 = losEffects.getLightWoods() > 0 ? 2 : 1;
            }
            toHitData = losEffects.losModifiers(iGame);
        }
        if (bl22) {
            entity2.setElevation(-1);
        }
        if ("LegAttack".equals(weaponType.getInternalName())) {
            toHitData2 = Compute.getLegAttackBaseToHit(entity2, (Entity)targetable2);
            if (toHitData2.getValue() == Integer.MAX_VALUE) {
                return toHitData2;
            }
            for (RoundUpdated roundUpdated : entity2.getMisc()) {
                object2 = roundUpdated.getType();
                if (!"BA-Assault Claws".equals(((EquipmentType)object2).getInternalName())) continue;
                toHitData2.addModifier(-1, "attacker has assault claws");
                break;
            }
        } else if ("SwarmMek".equals(weaponType.getInternalName())) {
            toHitData2 = Compute.getSwarmMekBaseToHit(entity2, (Entity)targetable2);
            if (toHitData2.getValue() == Integer.MAX_VALUE) {
                return toHitData2;
            }
            if (targetable2 instanceof Tank) {
                toHitData2.addModifier(-2, "target is vehicle");
            }
            for (RoundUpdated roundUpdated : entity2.getMisc()) {
                object2 = roundUpdated.getType();
                if ("BA-Assault Claws".equals(((EquipmentType)object2).getInternalName())) {
                    toHitData2.addModifier(-1, "attacker has assault claws");
                    break;
                }
                if (!((EquipmentType)object2).hasFlag(0x200000L)) continue;
                toHitData2.addModifier(-1, "attacker has magnetic claws");
                break;
            }
            for (RoundUpdated roundUpdated : ((Entity)targetable2).getExternalUnits()) {
                if (!(roundUpdated instanceof BattleArmor)) continue;
                object2 = (BattleArmor)roundUpdated;
                n7 = ((BattleArmor)object2).getShootingStrength();
                int n12 = ((Infantry)entity2).getShootingStrength();
                if (!(entity2 instanceof BattleArmor)) {
                    n12 = n12 >= 28 ? 5 : (n12 >= 24 ? 4 : (n12 >= 21 ? 3 : (n12 >= 18 ? 2 : 1)));
                }
                if ((n7 = n7 + 2 - n12) <= 0) continue;
                toHitData2.addModifier(n7, "Defending mechanized BA");
            }
        } else {
            if ("StopSwarm".equals(weaponType.getInternalName())) {
                return new ToHitData(Integer.MIN_VALUE, "End swarm attack.");
            }
            if ("BAMineLauncher".equals(weaponType.getInternalName())) {
                toHitData2 = new ToHitData(8, "magnetic mine attack");
            } else {
                if (targetable2 != null && entity2.getSwarmTargetId() == ((Entity)targetable2).getId()) {
                    int n13;
                    if (weaponType.hasFlag(262144L)) {
                        return new ToHitData(Integer.MAX_VALUE, "Missile weapons can't be used in swarm attack");
                    }
                    int n14 = n13 = targetable2 instanceof Tank ? 4 : 0;
                    if (entity2 instanceof BattleArmor) {
                        return new ToHitData(Integer.MIN_VALUE, "Attack during swarm.", 3, n13);
                    }
                    return new ToHitData(Integer.MIN_VALUE, "Attack during swarm.", 7, n13);
                }
                if (bl12) {
                    toHitData2 = new ToHitData(9, "artillery FLAK");
                } else {
                    toHitData2 = new ToHitData(entity2.crew.getGunnery(), "gunnery skill");
                    if (iGame.getOptions().booleanOption("rpg_gunnery")) {
                        if (weaponType.hasFlag(131072L)) {
                            toHitData2 = new ToHitData(entity2.crew.getGunneryL(), "gunnery (L) skill");
                        }
                        if (weaponType.hasFlag(262144L)) {
                            toHitData2 = new ToHitData(entity2.crew.getGunneryM(), "gunnery (M) skill");
                        }
                        if (weaponType.hasFlag(65536L)) {
                            toHitData2 = new ToHitData(entity2.crew.getGunneryB(), "gunnery (B) skill");
                        }
                    }
                }
            }
        }
        if (weaponType.hasFlag(0x20000000L)) {
            toHitData2 = new ToHitData(8, "fire extinguisher");
            if (targetable instanceof Entity && ((Entity)targetable).infernos.isStillBurning() || targetable instanceof Tank && ((Tank)targetable).isInfernoFire()) {
                toHitData2.addModifier(2, "inferno fire");
            }
            if (8 == targetable.getTargetType() && iGame.getBoard().isInfernoBurning(targetable.getPosition())) {
                toHitData2.addModifier(2, "inferno fire");
            }
            return toHitData2;
        }
        if (entity2.isSpotting()) {
            toHitData2.addModifier(1, "attacker is spotting for indirect LRM fire");
        }
        if (entity2.isSufferingEMI()) {
            toHitData2.addModifier(2, "electromagnetic interference");
        }
        if (entity2 instanceof Aero) {
            Jumpship jumpship;
            int n152;
            int n16;
            object = (Aero)entity2;
            int n17 = ((Aero)object).getSensorHits();
            if (n17 > 0 && n17 < 3) {
                toHitData2.addModifier(n17, "sensor damage");
            }
            if (n17 > 2) {
                toHitData2.addModifier(5, "sensors destroyed");
            }
            if ((n16 = ((Aero)object).getFCSHits()) > 0) {
                toHitData2.addModifier(n16 * 2, "fcs damage");
            }
            if ((n7 = ((Entity)object).getCrew().getHits()) > 0) {
                toHitData2.addModifier(n7, "pilot hits");
            }
            if (((Aero)object).isOutControlTotal()) {
                toHitData2.addModifier(2, "out-of-control");
            }
            if (object instanceof Jumpship && (n152 = (jumpship = (Jumpship)object).getCICHits()) > 0) {
                toHitData2.addModifier(n152 * 2, "CIC damage");
            }
            if (((Aero)object).isEvading()) {
                toHitData2.addModifier(2, "attacker is evading");
            }
            if (mounted.getName().indexOf("Heavy Gauss Rifle") != -1 && entity2 instanceof Aero && !(entity2 instanceof Dropship) && !(entity2 instanceof Jumpship)) {
                toHitData2.addModifier(1, "weapon to-hit modifier");
            }
            if (iGame.getBoard().inAtmosphere() && 1 == entity2.getElevation() - iGame.getBoard().getHex(entity2.getPosition()).ceiling()) {
                if (entity2.isOmni()) {
                    toHitData2.addModifier(1, "attacker is flying at NOE (omni)");
                } else {
                    toHitData2.addModifier(2, "attacker is flying at NOE");
                }
            }
            if (entity2.usesWeaponBays()) {
                Object object3;
                if (weaponType.getAtClass() == 1) {
                    for (int n152 : mounted.getBayWeapons()) {
                        Mounted mounted3 = entity2.getEquipment(n152);
                        object3 = (WeaponType)mounted3.getType();
                        if (((EquipmentType)object3).getInternalName().indexOf("Heavy") == -1 || ((EquipmentType)object3).getInternalName().indexOf("Laser") == -1) continue;
                        toHitData2.addModifier(1, "bay contains heavy laser");
                        break;
                    }
                } else if (weaponType.getAtClass() == 19) {
                    for (int n152 : mounted.getBayWeapons()) {
                        AmmoType ammoType2;
                        Mounted mounted4 = entity2.getEquipment(n152);
                        object3 = mounted4.getLinked();
                        if (object3 == null || (ammoType2 = (AmmoType)((Mounted)object3).getType()).getAmmoType() != 59) continue;
                        toHitData2.addModifier(-2, "barracuda missile");
                        break;
                    }
                } else if (weaponType.getAtClass() == 20) {
                    boolean bl23 = true;
                    for (int n18 : mounted.getBayWeapons()) {
                        AmmoType ammoType3;
                        object3 = entity2.getEquipment(n18);
                        Mounted mounted5 = ((Mounted)object3).getLinked();
                        if (mounted5 == null || (ammoType3 = (AmmoType)mounted5.getType()).hasFlag(256L)) continue;
                        bl23 = false;
                        break;
                    }
                    if (bl23) {
                        toHitData2.addModifier(-2, "barracuda missile");
                    }
                } else if (weaponType.getAtClass() == 8) {
                    boolean bl24 = true;
                    for (int n19 : mounted.getBayWeapons()) {
                        AmmoType ammoType4;
                        object3 = entity2.getEquipment(n19);
                        Mounted mounted6 = ((Mounted)object3).getLinked();
                        if (mounted6 == null || (ammoType4 = (AmmoType)mounted6.getType()).getMunitionType() == 1L) continue;
                        bl24 = false;
                        break;
                    }
                    if (bl24) {
                        toHitData2.addModifier(-1, "cluster LBX ammo");
                    }
                }
            }
        }
        if (targetable instanceof Aero) {
            object = (Aero)targetable;
            if (((Aero)object).getCurrentVelocity() == 0) {
                toHitData2.addModifier(-2, "target is not moving");
            }
            if (((Aero)object).isEvading()) {
                if (targetable instanceof SmallCraft) {
                    toHitData2.addModifier(2, "target is evading");
                } else if (targetable instanceof Jumpship) {
                    toHitData2.addModifier(1, "target is evading");
                } else {
                    toHitData2.addModifier(3, "target is evading");
                }
            }
            if (weaponType.isCapital() && weaponType.getAtClass() != 19 && weaponType.getAtClass() != 20 && (((Entity)object).getWeight() < 500.0f || targetable instanceof FighterSquadron)) {
                toHitData2.addModifier(5, "capital weapon at small target");
            }
        }
        if (entity2 instanceof Tank) {
            int n20;
            object = (Tank)entity2;
            if (((Tank)object).isCommanderHit()) {
                if (entity2 instanceof VTOL) {
                    toHitData2.addModifier(1, "copilot injured");
                } else {
                    toHitData2.addModifier(1, "commander injured");
                }
            }
            if ((n20 = ((Tank)object).getSensorHits()) > 0) {
                toHitData2.addModifier(n20, "sensor damage");
            }
            if (((Tank)object).isStabiliserHit(mounted.getLocation())) {
                toHitData2.addModifier(Compute.getAttackerMovementModifier(iGame, ((Entity)object).getId()).getValue(), "stabiliser damage");
            }
        }
        if (entity2.hasShield()) {
            if (entity2.hasPassiveShield(mounted.getLocation(), mounted.isRearMounted())) {
                toHitData2.addModifier(2, "weapon hampered by passive shield");
            } else if (entity2.hasNoDefenseShield(mounted.getLocation())) {
                toHitData2.addModifier(1, "weapon hampered by shield");
            }
        }
        if (iGame.getOptions().booleanOption("maxtech_bap") && !bl8 && targetable2 != null && entity2.hasBAP() && entity2.getBAPRange() >= Compute.effectiveDistance(iGame, entity2, targetable2) && !Compute.isAffectedByECM(entity2, entity2.getPosition(), ((Entity)targetable2).getPosition()) && (iGame.getBoard().getHex(((Entity)targetable2).getPosition()).containsTerrain(1) || iGame.getBoard().getHex(((Entity)targetable2).getPosition()).containsTerrain(23) || losEffects.getLightWoods() > 0 || losEffects.getHeavyWoods() > 0 || losEffects.getUltraWoods() > 0)) {
            toHitData2.addModifier(-1, "target in/behind woods and attacker has BAP");
        }
        if (entity2.crew.getOptions().stringOption("weapon_specialist").equals(weaponType.getName())) {
            toHitData2.addModifier(-2, "weapon specialist");
        }
        if (entity2.crew.getOptions().booleanOption("gunnery_laser") && weaponType.hasFlag(131072L)) {
            toHitData2.addModifier(-1, "Gunnery/Laser");
        }
        if (entity2.crew.getOptions().booleanOption("gunnery_ballistic") && weaponType.hasFlag(65536L)) {
            toHitData2.addModifier(-1, "Gunnery/Ballistic");
        }
        if (entity2.crew.getOptions().booleanOption("gunnery_missile") && weaponType.hasFlag(262144L)) {
            toHitData2.addModifier(-1, "Gunnery/Missile");
        }
        if (entity2.crew.getOptions().booleanOption("vdni") || entity2.crew.getOptions().booleanOption("bvdni")) {
            toHitData2.addModifier(-1, "VDNI");
        }
        if (entity2 instanceof Mech && ((Mech)entity2).getCockpitType() == 1 && (n6 = entity2.getBadCriticals(0, 1, 0)) == 2) {
            toHitData2.addModifier(4, "Head Sensors Destroyed for Torso-Mounted Cockpit");
        }
        if (!(bl15 || ammoType == null || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 45 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 512L || targetable2 != null && ((Entity)targetable2).isClan())) {
            toHitData2.addModifier(-1, "Listen-Kill ammo");
        }
        int n21 = entity2.getElevation();
        int n22 = targetable.getElevation();
        int n23 = Compute.effectiveDistance(iGame, entity2, targetable);
        toHitData2.append(WeaponAttackAction.nightModifiers(iGame, targetable, ammoType, entity2));
        if (iGame.getOptions().booleanOption("blizzard")) {
            if (weaponType.hasFlag(65536L)) {
                toHitData2.addModifier(2, "Blizzard");
            } else {
                toHitData2.addModifier(1, "Blizzard");
            }
        }
        if (iGame.getOptions().booleanOption("blowing_sand")) {
            if (weaponType.hasFlag(65536L)) {
                toHitData2.addModifier(1, "Blowing sand");
            } else {
                toHitData2.addModifier(2, "Blowing sand");
            }
        }
        if (iGame.getOptions().booleanOption("heavy_snowfall")) {
            toHitData2.addModifier(1, "Heavy snowfall");
        }
        if (iGame.getOptions().booleanOption("light_rainfall") || iGame.getOptions().booleanOption("heavy_rainfall")) {
            toHitData2.addModifier(1, "Rainfall");
        }
        if (iGame.getOptions().booleanOption("moderate_winds") && weaponType.hasFlag(65536L)) {
            toHitData2.addModifier(1, "Moderate winds");
        }
        if (iGame.getOptions().booleanOption("high_winds") && weaponType.hasFlag(65536L)) {
            toHitData2.addModifier(2, "High winds");
        }
        if (entity2 instanceof LandAirMech && (landAirMech2 = (LandAirMech)entity2).isInMode(2)) {
            toHitData2.addModifier(2, "Attacker is a Flying Airmek");
        }
        if (targetable instanceof LandAirMech && (landAirMech = (LandAirMech)targetable).isInMode(2) && landAirMech.isFlying()) {
            if (entity2.isFlying()) {
                toHitData2.addModifier(-1, "Target is a flying Airmek");
            } else {
                toHitData2.addModifier(4, "Target is a flying Airmek");
            }
        }
        if (bl10) {
            if (!bl12) {
                toHitData2.addModifier(5, "direct artillery modifer");
            }
            toHitData2.append(Compute.getAttackerMovementModifier(iGame, n));
            toHitData2.append(toHitData);
            toHitData2.append(Compute.getSecondaryTargetMod(iGame, entity2, targetable));
            toHitData2.append(Compute.getDamageWeaponMods(entity2, mounted));
            if (entity2.getHeatFiringModifier() != 0) {
                toHitData2.addModifier(entity2.getHeatFiringModifier(), "heat");
            }
            if (weaponType.getToHitModifier() != 0) {
                toHitData2.addModifier(weaponType.getToHitModifier(), "weapon to-hit modifier");
            }
            if (bl6 && ammoType.getToHitModifier() != 0) {
                toHitData2.addModifier(ammoType.getToHitModifier(), "ammunition to-hit modifier");
            }
            if (bl18) {
                return new ToHitData(4, "Homing shot");
            }
            if (iGame.getEntity(n).getOwner().getArtyAutoHitHexes().contains(targetable.getPosition()) && !bl12) {
                return new ToHitData(Integer.MIN_VALUE, "Artillery firing at designated artillery target.");
            }
            return toHitData2;
        }
        if (bl11) {
            if (bl18) {
                return new ToHitData(4, "Homing shot (will miss if TAG misses)");
            }
            if (iGame.getEntity(n).getOwner().getArtyAutoHitHexes().contains(targetable.getPosition())) {
                return new ToHitData(Integer.MIN_VALUE, "Artillery firing at designated artillery target.");
            }
            toHitData2.addModifier(7, "indirect artillery modifier");
            int n24 = entity2.aTracker.getModifier(mounted, targetable.getPosition());
            if (n24 == Integer.MIN_VALUE) {
                return new ToHitData(Integer.MIN_VALUE, "Artillery firing at target that's been hit before.");
            }
            if (n24 != 0) {
                toHitData2.addModifier(n24, "adjusted fire");
            }
            return toHitData2;
        }
        if (n23 == 1 && (targetable.getTargetType() == 3 || targetable.getTargetType() == 4 || targetable.getTargetType() == 15 || targetable.getTargetType() == 16 || targetable instanceof GunEmplacement)) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        if (null != losEffects.getThruBldg() && (targetable.getTargetType() == 3 || targetable.getTargetType() == 4 || targetable.getTargetType() == 15 || targetable.getTargetType() == 16 || targetable instanceof GunEmplacement)) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting building from inside (are you SURE this is a good idea?).");
        }
        toHitData2.append(Compute.getRangeMods(iGame, entity2, n2, targetable));
        if (entity2.getTargSysType() == 5 && targetable instanceof Entity) {
            if (targetable instanceof VTOL) {
                toHitData2.addModifier(-2, "anti-air targetting system vs. VTOL");
            } else {
                toHitData2.addModifier(1, "anti-air targetting system vs. non-aerial unit");
            }
        }
        if (!bl4 && targetable2 != null && targetable2 instanceof BattleArmor) {
            toHitData2.addModifier(1, "battle armor target");
        }
        if (targetable2 != null && targetable2 instanceof MechWarrior) {
            toHitData2.addModifier(2, "ejected MechWarrior target");
        }
        if (bl8) {
            toHitData2.addModifier(1, "indirect fire");
        }
        toHitData2.append(Compute.getAttackerMovementModifier(iGame, n));
        if (targetable2 != null) {
            int n25;
            ToHitData toHitData3 = Compute.getTargetMovementModifier(iGame, targetable.getTargetId());
            toHitData2.append(toHitData3);
            n8 += toHitData3.getValue();
            if (ammoType != null && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45) && ammoType.getMunitionType() == 262144L && ((Entity)targetable2).getTaggedBy() != -1) {
                int n26 = toHitData3.getValue();
                if (n26 > 0) {
                    toHitData2.append(new ToHitData(-n26, "Semi-guided ammo vs tagged target"));
                }
            } else if (ammoType != null && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 34) && ammoType.getMunitionType() == 16L && (n25 = Math.min(2, toHitData3.getValue())) > 0) {
                toHitData2.append(new ToHitData(-n25, "Precision Ammo"));
            }
        }
        if (ammoType != null && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 34) && ammoType.getMunitionType() == 2L) {
            toHitData2.addModifier(1, "Armor-Piercing Ammo");
        }
        if (bl8) {
            if (ammoType != null && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45) && ammoType.getMunitionType() == 262144L && ((Entity)targetable2).getTaggedBy() != -1) {
                toHitData2.addModifier(-1, "semiguided ignores spotter movement & indirect fire penalties");
            } else if (!bl21) {
                toHitData2.append(Compute.getSpotterMovementModifier(iGame, ((Entity)targetable3).getId()));
                if (((Entity)targetable3).isAttackingThisTurn()) {
                    toHitData2.addModifier(1, "spotter is making an attack this turn");
                }
            }
        }
        toHitData2.append(Compute.getAttackerTerrainModifier(iGame, n));
        if (targetable.getTargetType() != 6) {
            toHitData2.append(Compute.getTargetTerrainModifier(iGame, targetable, n11));
            n8 += Compute.getTargetTerrainModifier(iGame, targetable, n11).getValue();
        }
        IHex iHex = iGame.getBoard().getHex(targetable.getPosition());
        if (targetable.getTargetType() == 0 && iHex.containsTerrain(4) && iHex.terrainLevel(4) == 1 && n10 == 0 && ((Entity)targetable2).height() > 0) {
            losEffects.setTargetCover(losEffects.getTargetCover() | 3);
            toHitData = losEffects.losModifiers(iGame, n11);
        }
        if (targetable instanceof Infantry && !weaponType.hasFlag(2L) && (iHex.containsTerrain(21) || ((Infantry)targetable).getDugIn() == 2)) {
            toHitData2.addModifier(2, "infantry dug in");
        }
        toHitData2.append(toHitData);
        if (targetable2 != null && ((Entity)targetable2).isHullDown() && (targetable2 instanceof Mech && losEffects.getTargetCover() > 0 || targetable2 instanceof Tank && iHex.containsTerrain(21) && ((Entity)targetable2).sideTable(entity2.getPosition()) == 0)) {
            toHitData2.addModifier(2, "Hull down target");
        }
        if (!bl) {
            toHitData2.append(Compute.getSecondaryTargetMod(iGame, entity2, targetable, bl2));
        }
        if (entity2.getHeatFiringModifier() != 0) {
            toHitData2.addModifier(entity2.getHeatFiringModifier(), "heat");
        }
        toHitData2.append(Compute.getDamageWeaponMods(entity2, mounted));
        ToHitData toHitData4 = Compute.getImmobileMod(targetable, n3, n4);
        if (toHitData4 != null) {
            toHitData2.append(toHitData4);
            n8 += toHitData4.getValue();
        }
        toHitData2.append(Compute.getProneMods(iGame, entity2, n2));
        TargetRoll targetRoll = null;
        if (targetable2 != null && ((Entity)targetable2).isProne()) {
            targetRoll = n23 <= 1 ? new ToHitData(-2, "target prone and adjacent") : new ToHitData(1, "target prone and at range");
        }
        if (targetRoll != null) {
            toHitData2.append(targetRoll);
            n8 += targetRoll.getValue();
        }
        if (weaponType.getToHitModifier() != 0) {
            toHitData2.addModifier(weaponType.getToHitModifier(), "weapon to-hit modifier");
        }
        if (targetable2 != null && ((Entity)targetable2).getMovementMode() == 6 && ammoType != null && ((ammoType.getAmmoType() == 19 || ammoType.getAmmoType() == 32) && ammoType.getMunitionType() == 1L || ammoType.getAmmoType() == 44) && ((Entity)targetable2).getElevation() > 0 && ((Entity)targetable2).getElevation() > iGame.getBoard().getHex(((Entity)targetable2).getPosition()).terrainLevel(12) && ((Entity)targetable2).getElevation() != iGame.getBoard().getHex(((Entity)targetable2).getPosition()).terrainLevel(16)) {
            toHitData2.addModifier(-3, "flak to-hit modifier");
        } else if (bl6 && ammoType.getToHitModifier() != 0) {
            toHitData2.addModifier(ammoType.getToHitModifier(), "ammunition to-hit modifier");
        }
        if (bl14) {
            toHitData2.addModifier(-1, "iNarc homing pod");
        }
        if (bl13) {
            toHitData2.addModifier(1, "iNarc Haywire pod");
        }
        if (toHitData2.getValue() != Integer.MAX_VALUE && (weaponType.getAmmoType() == 62 || weaponType instanceof ScreenLauncherBayWeapon)) {
            return new ToHitData(Integer.MIN_VALUE, "Screen launchers always hit");
        }
        if (bl19) {
            if (targetable2 == null || ((Entity)targetable2).heat == 0) {
                toHitData2.addModifier(2, "ammunition to-hit modifier");
            } else if (((Entity)targetable2).heat < 6) {
                toHitData2.addModifier(0, "ammunition to-hit modifier");
            } else if (((Entity)targetable2).heat < 11) {
                toHitData2.addModifier(-1, "ammunition to-hit modifier");
            } else if (((Entity)targetable2).heat < 16) {
                toHitData2.addModifier(-2, "ammunition to-hit modifier");
            } else {
                toHitData2.addModifier(-3, "ammunition to-hit modifier");
            }
        }
        if (bl3) {
            toHitData2.addModifier(2, "ammunition to-hit modifier");
        }
        if (entity2 instanceof Infantry && entity2.hasWorkingMisc(0x100000L, 16)) {
            toHitData2.addModifier(1, "Heavy Armor");
        }
        if (n4 == 2 && n3 != -1) {
            if (entity2.hasActiveEiCockpit()) {
                if (entity2.hasTargComp()) {
                    toHitData2.addModifier(2, "aiming with targeting computer & EI system");
                } else {
                    toHitData2.addModifier(6, "aiming with EI system");
                }
            } else {
                toHitData2.addModifier(3, "aiming with targeting computer");
            }
        } else if (entity2.hasTargComp() && weaponType.hasFlag(1L) && (!bl6 || ammoType.getAmmoType() != 19 && ammoType.getAmmoType() != 32 || ammoType.getMunitionType() != 1L)) {
            toHitData2.addModifier(-1, "targeting computer");
        }
        if (null != losEffects.getThruBldg() && n21 != n22) {
            if (targetable instanceof Tank) {
                toHitData2.setSideTable(4);
            } else if (targetable instanceof Mech) {
                if (n21 > n22) {
                    toHitData2.setHitTable(4);
                } else {
                    toHitData2.setHitTable(5);
                }
            }
        }
        if (entity2 instanceof Aero && targetable instanceof Aero && iGame.getBoard().inAtmosphere()) {
            if (n21 - n22 > 2) {
                toHitData2.setHitTable(4);
            } else if (n22 - n21 > 2) {
                toHitData2.setHitTable(5);
            }
        }
        if (losEffects.getTargetCover() != 0) {
            if (entity2.getLocationStatus(mounted.getLocation()) == 2 && iHex.containsTerrain(4) && n10 == 0 && ((Entity)targetable2).height() > 0) {
                toHitData2.setHitTable(6);
                toHitData2.setCover(12);
            } else if (iGame.getOptions().booleanOption("maxtech_partial_cover")) {
                toHitData2.setHitTable(6);
                toHitData2.setCover(losEffects.getTargetCover());
            } else {
                toHitData2.setHitTable(6);
                toHitData2.setCover(3);
            }
        }
        if (bl4 && 0 == n23) {
            toHitData2.setSideTable(0);
        } else {
            toHitData2.setSideTable(Compute.targetSideTable(entity2, targetable));
        }
        if (targetable instanceof Aero) {
            if (((Aero)targetable).isSpheroid() && iGame.getBoard().inAtmosphere()) {
                if (toHitData2.getHitTable() == 4) {
                    toHitData2.setSideTable(0);
                    toHitData2.setHitTable(0);
                }
                if (toHitData2.getHitTable() == 5) {
                    toHitData2.setSideTable(1);
                    toHitData2.setHitTable(0);
                }
            } else {
                int n27 = toHitData2.getSideTable();
                if (targetable instanceof Aero && iGame.useVectorMove()) {
                    n27 = ((Entity)targetable).chooseSide(entity2.getPosition(), Compute.usePrior(entity2, targetable));
                }
                if (n27 == 0) {
                    toHitData2.addModifier(1, "attack against nose");
                }
                if (n27 == 2 || n27 == 3) {
                    toHitData2.addModifier(2, "attack against side");
                }
            }
        }
        if (targetable instanceof Mech && (n5 = ((Mech)targetable).getGrappled()) != -1) {
            if (n5 == entity2.getId()) {
                toHitData2.addModifier(-4, "target grappled");
            } else if (!bl2) {
                toHitData2.addModifier(1, "CQC, possible friendly fire");
            } else {
                toHitData2.addModifier(-1, "friendly fire");
                return toHitData2;
            }
        }
        if (bl2) {
            toHitData2.addModifier(-n8, "original target mods");
            toHitData2.append(Compute.getImmobileMod(entity, n3, n4));
            toHitData2.append(Compute.getTargetMovementModifier(iGame, entity.getId()));
            toHitData2.append(Compute.getTargetTerrainModifier(iGame, iGame.getEntity(entity.getId())));
            n23 = Compute.effectiveDistance(iGame, entity2, entity);
            if (entity.isProne()) {
                targetRoll = n23 <= 1 ? new ToHitData(-2, "target prone and adjacent") : new ToHitData(1, "target prone and at range");
            }
            toHitData2.append(targetRoll);
            if (!bl15 && ammoType != null && !entity.isEnemyOf(entity2) && entity.getBadCriticals(0, 1, 0) <= 0 && ammoType.getMunitionType() == 0x100000L) {
                toHitData2.addModifier(2, "Swarm-I at friendly unit with intact sensors");
            }
        }
        return toHitData2;
    }

    private static String toHitIsImpossible(IGame iGame, Entity entity, Targetable targetable, Mounted mounted, AmmoType ammoType, WeaponType weaponType, int n, boolean bl, boolean bl2, Entity entity2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, int n3, boolean bl7, Mounted mounted2, boolean bl8, boolean bl9, boolean bl10, boolean bl11) {
        int n4;
        int n5;
        int n6;
        Object object;
        Object object2;
        int n72;
        int n8;
        int n9;
        boolean bl12 = false;
        ToHitData toHitData = null;
        if (entity.hasShield() && entity.hasActiveShield(mounted.getLocation(), mounted.isRearMounted())) {
            return "Weapon blocked by active shield";
        }
        if (entity instanceof Mech && ((Mech)entity).getCockpitType() == 1 && (n9 = entity.getBadCriticals(0, 1, 0)) + (n8 = entity.getBadCriticals(0, 1, 1)) == 3) {
            return "Sensors Completely Destroyed for Torso-Mounted Cockpit";
        }
        if (!mounted.canFire() && !bl) {
            return "Weapon is not in a state where it can be fired";
        }
        if (bl6 && iGame.getOptions().booleanOption("indirect_fire") && !iGame.getOptions().booleanOption("indirect_always_possible") && LosEffects.calculateLos(iGame, entity.getId(), targetable).canSee()) {
            return new String("Indirect-fire LRM cannot be fired with direct LOS from attacker to target.");
        }
        if (entity.isLayingMines()) {
            return "Can't fire weapons when laying mines";
        }
        if (targetable.getTargetType() == 6 && !AmmoType.canDeliverMinefield(ammoType)) {
            return "Weapon can't deliver minefields";
        }
        if (targetable.getTargetType() == 13 && (!bl2 || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 45 || ammoType.getMunitionType() != 131072L)) {
            return "Weapon can't deliver flares";
        }
        if (iGame.getPhase() == IGame.Phase.PHASE_TARGETING && !bl7) {
            return "Only indirect artillery can be fired in the targeting phase";
        }
        if (iGame.getPhase() == IGame.Phase.PHASE_OFFBOARD && !bl3) {
            return "Only TAG can be fired in the offboard attack phase";
        }
        if (iGame.getPhase() != IGame.Phase.PHASE_OFFBOARD && bl3) {
            return "TAG can only be fired in the offboard attack phase";
        }
        if (!(ammoType == null || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 45 || ammoType.getMunitionType() != 0x200000L && ammoType.getMunitionType() != 0x2000000L && ammoType.getMunitionType() != 0x800000L && ammoType.getMunitionType() != 0x1000000L && ammoType.getMunitionType() != 0x400000L || targetable.getTargetType() == 6)) {
            return "Weapon can only deliver minefields";
        }
        if (ammoType != null && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45) && ammoType.getMunitionType() == 131072L && targetable.getTargetType() != 13) {
            return "Weapon can only deliver flares";
        }
        if (weaponType.hasFlag(0x2000000L) && (entity2 != null && !(entity2 instanceof Infantry) || targetable.getTargetType() != 0)) {
            return "Weapon can only be used against infantry";
        }
        if (targetable instanceof MinefieldTarget && !AmmoType.canClearMinefield(ammoType)) {
            return "Weapon can't clear minefields";
        }
        if (weaponType.hasFlag(32768L)) {
            long l = 0L;
            if (ammoType != null) {
                l = ammoType.getMunitionType();
            }
            if (l == 0x1000000000L) {
                bl12 = true;
            } else if (n != 7 && !bl8) {
                return "Weapon must make artillery attacks.";
            }
        } else if (n == 7) {
            return "Weapon can't make artillery attacks.";
        }
        if (entity.equals(entity2) && !bl) {
            return "You can't target yourself";
        }
        if (mounted.isDestroyed() || mounted.isBreached()) {
            return "Weapon not operational.";
        }
        if (bl2 && !bl && (mounted2 == null || mounted2.getShotsLeft() == 0 || mounted2.isBreached())) {
            return "Weapon out of ammo.";
        }
        if (bl2 && mounted2.isDumping()) {
            entity.loadWeaponWithSameAmmo(mounted);
            if (mounted2.getShotsLeft() == 0 || mounted2.isDumping()) {
                return "Dumping remaining ammo.";
            }
        }
        if (entity.isShutDown() || !entity.getCrew().isActive()) {
            return "Attacker is in no condition to fire weapons.";
        }
        int n10 = entity.getBadCriticals(0, 1, 0);
        if (entity instanceof Mech && ((Mech)entity).getCockpitType() == 1 ? (n10 += entity.getBadCriticals(0, 1, 1)) > 2 : n10 > 1) {
            return "Attacker sensors destroyed.";
        }
        if (entity instanceof Aero) {
            Iterator<Integer> iterator;
            Aero aero = (Aero)entity;
            int n11 = aero.getFCSHits();
            if (n11 > 2) {
                return "Fire control system destroyed.";
            }
            if (aero instanceof Jumpship && (n72 = ((Aero)((Object)(iterator = (Jumpship)aero))).getCICHits()) > 2) {
                return "CIC destroyed.";
            }
            if (aero.isEvading() && !(entity instanceof Dropship) && !(entity instanceof Jumpship)) {
                return "Attacker is evading.";
            }
            iterator = iGame.getActions();
            while (iterator.hasMoreElements()) {
                Object e = iterator.nextElement();
                if (!(e instanceof WeaponAttackAction) || ((AbstractEntityAction)(object2 = (WeaponAttackAction)e)).getEntityId() != n2 || n3 == ((WeaponAttackAction)object2).getWeaponId() || !entity.getEquipment(((WeaponAttackAction)object2).getWeaponId()).getType().getInternalName().equals("SpaceBombAttack")) continue;
                return "Already space bombing";
            }
            if (bl7 || bl10 || bl8) {
                return "This unit cannot make artillery attacks";
            }
        }
        if (entity instanceof Tank) {
            n10 = ((Tank)entity).getSensorHits();
            if (n10 > 3) {
                return "Attacker sensors destroyed.";
            }
            if (((Tank)entity).getStunnedTurns() > 0) {
                return "Crew stunned";
            }
        }
        if (entity.isWeaponBlockedAt(mounted.getLocation(), mounted.isRearMounted())) {
            return "Weapon blocked by passenger.";
        }
        if (entity2 != null && -1 != entity2.getSwarmTargetId()) {
            return "Target is swarming a Mek.";
        }
        n8 = 0;
        if (ammoType != null && weaponType.hasFlag(2L) && mounted.curMode().equals("Cool")) {
            n8 = 1;
            if (!entity.hasWorkingMisc(0x200000000L, -1)) {
                return "Vehicle does not have a working coolant system";
            }
        }
        if (8 == targetable.getTargetType()) {
            if (!weaponType.hasFlag(0x20000000L) && n8 == 0) {
                return "Weapon can't put out fires";
            }
            IHex iHex = iGame.getBoard().getHex(targetable.getPosition());
            if (!iHex.containsTerrain(7)) {
                return "Target is not on fire.";
            }
        } else if (!(!weaponType.hasFlag(0x20000000L) || targetable instanceof Tank && ((Tank)targetable).isOnFire() || targetable instanceof Entity && ((Entity)targetable).infernos.getTurnsLeftToBurn() > 0)) {
            return "Target is not on fire.";
        }
        if (bl5 && 1 == targetable.getTargetType()) {
            return "Infantry can not clear woods.";
        }
        if (17 == targetable.getTargetType() && weaponType.getAmmoType() != 62 && !(weaponType instanceof ScreenLauncherBayWeapon)) {
            return "Only screen launchers may launch screens";
        }
        if (17 != targetable.getTargetType() && (weaponType.getAmmoType() == 62 || weaponType instanceof ScreenLauncherBayWeapon)) {
            return "Screen launchers may only target hexes";
        }
        if ((n8 != 0 || weaponType.hasFlag(32L) && !bl4) && 2 == targetable.getTargetType()) {
            return "Weapon can not cause fires.";
        }
        if (!(targetable.getTargetType() != 2 || !iGame.getOptions().booleanOption("no_ignite_clear") || iGame.getBoard().getHex(((HexTarget)targetable).getPosition()).containsTerrain(1) || iGame.getBoard().getHex(((HexTarget)targetable).getPosition()).containsTerrain(23) || iGame.getBoard().getHex(((HexTarget)targetable).getPosition()).containsTerrain(34) || iGame.getBoard().getHex(((HexTarget)targetable).getPosition()).containsTerrain(10))) {
            return "Only woods and building hexes can be set on fire intentionally.";
        }
        if (bl4 && (entity2 instanceof Tank && iGame.getOptions().booleanOption("vehicles_safe_from_infernos") || entity2 instanceof Protomech && iGame.getOptions().booleanOption("protos_safe_from_infernos"))) {
            return "Can not target that unit type with Inferno rounds.";
        }
        if (bl3 && entity2 instanceof Infantry) {
            return "Can not target infantry with TAG.";
        }
        if (weaponType.hasFlag(2L) && weaponType.hasModes() && mounted.curMode().equals("Heat") && !(entity2 instanceof Mech)) {
            return "Can only raise the heat level of Meks.";
        }
        if (entity.usesWeaponBays()) {
            int n12;
            Object object3;
            int n13;
            boolean bl13 = false;
            for (int n72 : mounted.getBayWeapons()) {
                object2 = entity.getEquipment(n72);
                object = (WeaponType)((Mounted)object2).getType();
                int n14 = n13 = ((WeaponType)object).getAmmoType() != -1 ? 1 : 0;
                if (((Mounted)object2).isBreached() || ((Mounted)object2).isDestroyed() || ((Mounted)object2).isJammed()) continue;
                if (n13 != 0) {
                    if (((Mounted)object2).getLinked() == null || ((Mounted)object2).getLinked().getShotsLeft() <= 0) continue;
                    bl13 = true;
                    break;
                }
                bl13 = true;
                break;
            }
            if (!bl13) {
                return "weapon bay out of ammo or otherwise unusable";
            }
            int n15 = 0;
            n72 = entity.getHeatCapacity();
            object2 = new boolean[entity.locations()];
            object = new boolean[entity.locations()];
            for (n13 = 0; n13 < entity.locations(); ++n13) {
                object2[n13] = false;
                object[n13] = false;
            }
            Enumeration<EntityAction> enumeration = iGame.getActions();
            while (enumeration.hasMoreElements()) {
                WeaponAttackAction weaponAttackAction;
                EntityAction entityAction = enumeration.nextElement();
                if (!(entityAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId() != n2 || n3 == weaponAttackAction.getWeaponId()) continue;
                object3 = entity.getEquipment(weaponAttackAction.getWeaponId());
                n12 = ((Mounted)object3).getLocation();
                boolean bl14 = ((Mounted)object3).isRearMounted();
                if (iGame.getOptions().booleanOption("heat_by_bay")) {
                    for (int n16 : ((Mounted)object3).getBayWeapons()) {
                        n15 += entity.getEquipment(n16).getCurrentHeat();
                    }
                    continue;
                }
                if (!bl14) {
                    if (object2[n12] != false) continue;
                    n15 += entity.getHeatInArc(n12, bl14);
                    object2[n12] = true;
                    continue;
                }
                if (object[n12] != false) continue;
                n15 += entity.getHeatInArc(n12, bl14);
                object[n12] = true;
            }
            n6 = mounted.getLocation();
            n5 = mounted.isRearMounted();
            n4 = entity.getHeatInArc(n6, n5 != 0);
            if (iGame.getOptions().booleanOption("heat_by_bay")) {
                object3 = mounted.getBayWeapons().iterator();
                while (object3.hasNext()) {
                    n12 = (Integer)object3.next();
                    n4 = entity.getEquipment(n12).getCurrentHeat();
                }
            }
            boolean bl15 = true;
            for (n12 = 0; n12 < entity.locations(); ++n12) {
                if (n12 == n6 || object2[n12] == false && object[n12] == false) continue;
                bl15 = false;
                break;
            }
            if (iGame.getOptions().booleanOption("heat_by_bay") ? n15 + n4 > n72 : (n5 == 0 ? object2[n6] == false && n15 + n4 > n72 && !bl15 : object[n6] == false && n15 + n4 > n72 && !bl15)) {
                return "heat exceeds capacity";
            }
        }
        if (weaponType.hasFlag(0x100000000L) && weaponType.hasModes() && mounted.curMode().equals("Off")) {
            return "MG Array is disabled";
        }
        if (weaponType.hasFlag(512L) && entity.hasLinkedMGA(mounted)) {
            return "Machine gun is slaved to array equipment";
        }
        if (weaponType.hasFlag(128L)) {
            Enumeration<EntityAction> enumeration = iGame.getActions();
            while (enumeration.hasMoreElements()) {
                WeaponAttackAction weaponAttackAction;
                EntityAction entityAction = enumeration.nextElement();
                if (!(entityAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId() != n2 || n3 == weaponAttackAction.getWeaponId()) continue;
                return "Other weapon attacks declared.";
            }
        } else if (bl5 && !(entity instanceof BattleArmor)) {
            if (entity.getMovementMode() == 10 && weaponType.hasFlag(2048L) && !weaponType.hasFlag(4L) && weaponType.getAmmoType() != 1 && entity.moved != 0) {
                return "Foot platoons can only fire rifles in same turn as moving";
            }
            if (!weaponType.hasFlag(2048L) && entity.moved != 0) {
                return "Can't fire field guns in same turn as moving";
            }
            Enumeration<EntityAction> enumeration = iGame.getActions();
            while (enumeration.hasMoreElements()) {
                WeaponAttackAction weaponAttackAction;
                EntityAction entityAction = enumeration.nextElement();
                if (!(entityAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId() != n2 || ((Mounted)(object2 = entity.getEquipment(weaponAttackAction.getWeaponId()))).getType().hasFlag(2048L) == weaponType.hasFlag(2048L)) continue;
                return "Can't fire field guns and small arms at the same time.";
            }
            if (weaponType.getName().equals("Compact Narc")) {
                enumeration = iGame.getActions();
                while (enumeration.hasMoreElements()) {
                    WeaponAttackAction weaponAttackAction;
                    EntityAction entityAction = enumeration.nextElement();
                    if (!(entityAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId() != n2 || !((Mounted)(object2 = entity.getEquipment(weaponAttackAction.getWeaponId()))).getType().getName().equals("Compact Narc") || weaponAttackAction.getTargetId() == targetable.getTargetId()) continue;
                    return "Can fire multiple compact narcs only at one target.";
                }
            }
        }
        if (bl6 && !iGame.getOptions().booleanOption("indirect_fire")) {
            return "Indirect fire option not enabled";
        }
        if (bl6 && iGame.getOptions().booleanOption("indirect_fire") && !iGame.getOptions().booleanOption("indirect_always_possible") && LosEffects.calculateLos(iGame, n2, targetable).canSee()) {
            return "Indirect fire impossible with direct LOS";
        }
        if (bl6 && bl2 && ammoType.getAmmoType() == 45 && !ammoType.hasFlag(32L)) {
            return "only LRM ammo can be fired indirectly";
        }
        if (entity instanceof Tank && entity.isHullDown() && mounted.getLocation() == 1) {
            return "Nearby terrain blocks front weapons.";
        }
        if (ammoType != null && ammoType.getAmmoType() == 25) {
            if (entity.getElevation() == 0) {
                return "attacker must be at least at elevation 1";
            }
            if (targetable.getTargetType() != 14) {
                return "must target hex with bombs";
            }
        }
        if (!(targetable.getTargetType() != 14 || bl2 && ammoType.getAmmoType() == 25)) {
            return "Weapon can't deliver bombs";
        }
        Entity entity3 = null;
        if (bl6 && (entity3 = targetable instanceof Entity && !bl11 && bl2 && ammoType.getMunitionType() == 2048L && entity2.isNarcedBy(entity.getOwner().getTeam()) ? entity2 : Compute.findSpotter(iGame, entity, targetable)) == null) {
            return "No available spotter";
        }
        int n17 = 0;
        n72 = 0;
        if (bl2 && weaponType.getAmmoType() == 7 && ammoType.getMunitionType() == 0x8000000L && entity.getElevation() == -1 && entity.getLocationStatus(mounted.getLocation()) == 2) {
            n72 = 1;
            entity.setElevation(0);
        }
        if (!bl6) {
            object2 = LosEffects.calculateLos(iGame, n2, targetable);
            if (entity.hasActiveEiCockpit()) {
                n17 = ((LosEffects)object2).getLightWoods() > 0 ? 2 : 1;
            }
            object = ((LosEffects)object2).losModifiers(iGame, n17);
        } else {
            object2 = LosEffects.calculateLos(iGame, entity3.getId(), targetable);
            ((LosEffects)object2).setAttackerCover(0);
            if (entity3.hasActiveEiCockpit()) {
                n17 = ((LosEffects)object2).getLightWoods() > 0 ? 2 : 1;
            }
            object = ((LosEffects)object2).losModifiers(iGame);
        }
        if (n72 != 0) {
            entity.setElevation(-1);
        }
        if (((TargetRoll)object).getValue() == Integer.MAX_VALUE && !bl7) {
            return ((TargetRoll)object).getDesc();
        }
        if (!Compute.isInArc(iGame, n2, n3, targetable)) {
            return "Target not in arc.";
        }
        if (entity instanceof Aero && ((Aero)entity).isSpheroid() && iGame.getBoard().inAtmosphere()) {
            n6 = entity.getElevation() - targetable.getElevation();
            if (mounted.getLocation() == 0 && n6 > -3) {
                return "Target is too low";
            }
            if (mounted.getLocation() == 3 && n6 < 3) {
                return "Target is too high";
            }
        }
        if (bl9 && entity2 instanceof Infantry && null == ((LosEffects)object2).getThruBldg()) {
            return "Attack on infantry crosses building exterior wall.";
        }
        if (weaponType.getAmmoType() == 13 || weaponType.getAmmoType() == 30) {
            if (bl9) {
                return "Narc pods cannot be fired into or inside buildings.";
            }
            if (targetable instanceof Infantry) {
                return "Narc pods cannot be used to attack infantry.";
            }
        }
        if (((LosEffects)object2).isAttackerCover() && entity.locationIsLeg(mounted.getLocation()) && entity.getLocationStatus(mounted.getLocation()) != 2) {
            return "Nearby terrain blocks leg weapons.";
        }
        if ("LegAttack".equals(weaponType.getInternalName())) {
            toHitData = Compute.getLegAttackBaseToHit(entity, entity2);
            if (Integer.MAX_VALUE == toHitData.getValue()) {
                return toHitData.getDesc();
            }
        } else if ("SwarmMek".equals(weaponType.getInternalName())) {
            toHitData = Compute.getSwarmMekBaseToHit(entity, entity2);
            if (Integer.MAX_VALUE == toHitData.getValue()) {
                return toHitData.getDesc();
            }
        } else if ("StopSwarm".equals(weaponType.getInternalName())) {
            if (-1 == entity.getSwarmTargetId()) {
                return "Not swarming a Mek.";
            }
        } else if ("BAMineLauncher".equals(weaponType.getInternalName())) {
            if (entity2 instanceof Infantry) {
                return "Can not attack infantry.";
            }
        } else if (entity2 != null && entity.getSwarmTargetId() == entity2.getId()) {
            if (weaponType.getDamage() == 0) {
                return "Weapon causes no damage.";
            }
        } else if (-1 != entity.getSwarmTargetId()) {
            return "Must target the Mek being swarmed.";
        }
        n6 = Compute.effectiveDistance(iGame, entity, targetable);
        if (bl10) {
            if (n6 > 17) {
                return "Direct artillery attack at range >17 hexes.";
            }
            if (bl12 && (entity2 == null || entity2.getTaggedBy() == -1)) {
                return "On board homing shot must target a unit tagged this turn";
            }
        }
        if (bl7) {
            n5 = (int)Math.ceil((float)n6 / 17.0f);
            if (n5 > weaponType.getLongRange()) {
                return "Indirect artillery attack out of range";
            }
            if (n6 <= 17 && ((TargetRoll)object).getValue() != Integer.MAX_VALUE) {
                return "Cannot fire indirectly at range <=17 hexes unless no LOS.";
            }
            if (bl12 && n != 7) {
                return "Off board homing shot must target a map sheet";
            }
        }
        if (entity instanceof Mech && (n5 = ((Mech)entity).getGrappled()) != -1) {
            if (n5 != targetable.getTargetId()) {
                return "Can only attack grappled mech";
            }
            n4 = mounted.getLocation();
            if (n4 != 1 && n4 != 3 && n4 != 2 && n4 != 0 || mounted.isRearMounted()) {
                return "Can only fire head and front torso weapons when grappled";
            }
        }
        if (entity.getMovementMode() == 15 && entity.getPosition() == targetable.getPosition()) {
            return "WiGE may not attack target in same hex";
        }
        if (weaponType.hasFlag(131072L) && iGame.getOptions().booleanOption("blowing_sand")) {
            return "Energy weapons can't hit in blowing sands";
        }
        return null;
    }

    public boolean isNemesisConfused() {
        return this.nemesisConfused;
    }

    public void setNemesisConfused(boolean bl) {
        this.nemesisConfused = bl;
    }

    public boolean isSwarmingMissiles() {
        return this.swarmingMissiles;
    }

    public void setSwarmingMissiles(boolean bl) {
        this.swarmingMissiles = bl;
    }

    public void setOldTargetId(int n) {
        this.oldTargetId = n;
    }

    public int getSwarmMissiles() {
        return this.swarmMissiles;
    }

    public void setSwarmMissiles(int n) {
        this.swarmMissiles = n;
    }
}

