/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.Aero;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKAeroFile
extends BLKFile
implements IMechLoader {
    public static final int NOSE = 0;
    public static final int RW = 1;
    public static final int LW = 2;
    public static final int AFT = 3;

    public BLKAeroFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        Aero aero = new Aero();
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        aero.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            aero.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            aero.setModel("");
        }
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find year block.");
        }
        aero.setYear(this.dataFile.getDataAsInt("year")[0]);
        if (!this.dataFile.exists("type")) {
            throw new EntityLoadingException("Could not find type block.");
        }
        if (this.dataFile.getDataAsString("type")[0].equals("IS")) {
            if (aero.getYear() == 3025) {
                aero.setTechLevel(0);
            } else {
                aero.setTechLevel(1);
            }
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 1")) {
            aero.setTechLevel(0);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 2")) {
            aero.setTechLevel(1);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 3")) {
            aero.setTechLevel(5);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan") || this.dataFile.getDataAsString("type")[0].equals("Clan Level 2")) {
            aero.setTechLevel(2);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan Level 3")) {
            aero.setTechLevel(6);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (IS Chassis)")) {
            aero.setTechLevel(5);
            aero.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (Clan Chassis)")) {
            aero.setTechLevel(6);
            aero.setMixedTech(true);
        } else {
            if (this.dataFile.getDataAsString("type")[0].equals("Mixed")) {
                throw new EntityLoadingException("Unsupported tech base: \"Mixed\" is no longer allowed by itself.  You must specify \"Mixed (IS Chassis)\" or \"Mixed (Clan Chassis)\".");
            }
            throw new EntityLoadingException("Unsupported tech level: " + this.dataFile.getDataAsString("type")[0]);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        aero.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        aero.setMaxBombPoints(Math.round(aero.getWeight() / 5.0f));
        int n = 16;
        aero.setMovementMode(n);
        if (!this.dataFile.exists("heatsinks")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        aero.setHeatSinks(this.dataFile.getDataAsInt("heatsinks")[0]);
        if (!this.dataFile.exists("sink_type")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        aero.setHeatType(this.dataFile.getDataAsInt("sink_type")[0]);
        if (!this.dataFile.exists("fuel")) {
            throw new EntityLoadingException("Could not find fuel block.");
        }
        aero.setFuel(this.dataFile.getDataAsInt("fuel")[0]);
        int n2 = 0;
        if (this.dataFile.exists("engine_type")) {
            n2 = this.dataFile.getDataAsInt("engine_type")[0];
        }
        int n3 = 2;
        if (aero.isClan()) {
            n3 |= 1;
        }
        if (!this.dataFile.exists("SafeThrust")) {
            throw new EntityLoadingException("Could not find SafeThrust block.");
        }
        int n4 = (this.dataFile.getDataAsInt("SafeThrust")[0] - 2) * (int)aero.getWeight();
        aero.setEngine(new Engine(n4, BLKFile.translateEngineCode(n2), n3));
        if (this.dataFile.exists("armor_type")) {
            aero.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (this.dataFile.exists("armor_tech")) {
            aero.setArmorTechLevel(this.dataFile.getDataAsInt("armor_tech")[0]);
        }
        if (this.dataFile.exists("internal_type")) {
            aero.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length != 4) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        aero.initializeArmor(nArray[0], 0);
        aero.initializeArmor(nArray[1], 2);
        aero.initializeArmor(nArray[2], 1);
        aero.initializeArmor(nArray[3], 3);
        aero.autoSetInternal();
        aero.autoSetSI();
        aero.autoSetThresh();
        this.loadEquipment(aero, "Nose", 0);
        this.loadEquipment(aero, "Right Wing", 2);
        this.loadEquipment(aero, "Left Wing", 1);
        this.loadEquipment(aero, "Aft", 3);
        if (this.dataFile.exists("omni")) {
            aero.setOmni(true);
        }
        if (aero.isClan()) {
            aero.addClanCase();
        }
        return aero;
    }

    protected void loadEquipment(Entity entity, String string, int n) throws EntityLoadingException {
        String[] stringArray = this.dataFile.getDataAsString(string + " Equipment");
        if (stringArray == null) {
            return;
        }
        String string2 = entity.getTechLevel() == 2 ? "Clan " : "IS ";
        boolean bl = false;
        if (stringArray[0] != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                EquipmentType equipmentType;
                bl = false;
                String string3 = stringArray[i].trim();
                if (string3.startsWith("(R) ")) {
                    bl = true;
                    string3 = string3.substring(4);
                }
                if ((equipmentType = EquipmentType.get(string3)) == null) {
                    equipmentType = EquipmentType.get(string2 + string3);
                }
                if (equipmentType != null) {
                    try {
                        entity.addEquipment(equipmentType, n, bl);
                        continue;
                    }
                    catch (LocationFullException locationFullException) {
                        throw new EntityLoadingException(locationFullException.getMessage());
                    }
                }
                if (string3 == "0") continue;
                entity.addFailedEquipment(string3);
            }
        }
    }
}

