/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.ConvFighter;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKConvFighterFile
extends BLKFile
implements IMechLoader {
    public static final int NOSE = 0;
    public static final int RW = 1;
    public static final int LW = 2;
    public static final int AFT = 3;

    public BLKConvFighterFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        ConvFighter convFighter = new ConvFighter();
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        convFighter.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            convFighter.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            convFighter.setModel("");
        }
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find year block.");
        }
        convFighter.setYear(this.dataFile.getDataAsInt("year")[0]);
        if (!this.dataFile.exists("type")) {
            throw new EntityLoadingException("Could not find type block.");
        }
        if (this.dataFile.getDataAsString("type")[0].equals("IS")) {
            if (convFighter.getYear() == 3025) {
                convFighter.setTechLevel(0);
            } else {
                convFighter.setTechLevel(1);
            }
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 1")) {
            convFighter.setTechLevel(0);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 2")) {
            convFighter.setTechLevel(1);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 3")) {
            convFighter.setTechLevel(5);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan") || this.dataFile.getDataAsString("type")[0].equals("Clan Level 2")) {
            convFighter.setTechLevel(2);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan Level 3")) {
            convFighter.setTechLevel(6);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (IS Chassis)")) {
            convFighter.setTechLevel(5);
            convFighter.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (Clan Chassis)")) {
            convFighter.setTechLevel(6);
            convFighter.setMixedTech(true);
        } else {
            if (this.dataFile.getDataAsString("type")[0].equals("Mixed")) {
                throw new EntityLoadingException("Unsupported tech base: \"Mixed\" is no longer allowed by itself.  You must specify \"Mixed (IS Chassis)\" or \"Mixed (Clan Chassis)\".");
            }
            throw new EntityLoadingException("Unsupported tech level: " + this.dataFile.getDataAsString("type")[0]);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        convFighter.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        convFighter.setMaxBombPoints(Math.round(convFighter.getWeight() / 5.0f));
        int n = 16;
        convFighter.setMovementMode(n);
        if (!this.dataFile.exists("heatsinks")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        convFighter.setHeatSinks(this.dataFile.getDataAsInt("heatsinks")[0]);
        if (!this.dataFile.exists("sink_type")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        convFighter.setHeatType(this.dataFile.getDataAsInt("sink_type")[0]);
        if (!this.dataFile.exists("fuel")) {
            throw new EntityLoadingException("Could not find fuel block.");
        }
        convFighter.setFuel(this.dataFile.getDataAsInt("fuel")[0]);
        int n2 = 0;
        if (this.dataFile.exists("engine_type")) {
            n2 = this.dataFile.getDataAsInt("engine_type")[0];
        }
        int n3 = 2;
        if (convFighter.isClan()) {
            n3 |= 1;
        }
        if (!this.dataFile.exists("SafeThrust")) {
            throw new EntityLoadingException("Could not find SafeThrust block.");
        }
        int n4 = (this.dataFile.getDataAsInt("SafeThrust")[0] - 2) * (int)convFighter.getWeight();
        convFighter.setEngine(new Engine(n4, BLKFile.translateEngineCode(n2), n3));
        if (this.dataFile.exists("armor_type")) {
            convFighter.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (this.dataFile.exists("armor_tech")) {
            convFighter.setArmorTechLevel(this.dataFile.getDataAsInt("armor_tech")[0]);
        }
        if (this.dataFile.exists("internal_type")) {
            convFighter.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length != 4) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        convFighter.initializeArmor(nArray[0], 0);
        convFighter.initializeArmor(nArray[1], 2);
        convFighter.initializeArmor(nArray[2], 1);
        convFighter.initializeArmor(nArray[3], 3);
        convFighter.autoSetInternal();
        convFighter.autoSetSI();
        convFighter.autoSetThresh();
        this.loadEquipment(convFighter, "Nose", 0);
        this.loadEquipment(convFighter, "Right Wing", 2);
        this.loadEquipment(convFighter, "Left Wing", 1);
        this.loadEquipment(convFighter, "Aft", 3);
        if (this.dataFile.exists("omni")) {
            convFighter.setOmni(true);
        }
        if (this.dataFile.exists("vstol")) {
            convFighter.setVSTOL(true);
        }
        if (convFighter.isClan()) {
            convFighter.addClanCase();
        }
        return convFighter;
    }

    protected void loadEquipment(Entity entity, String string, int n) throws EntityLoadingException {
        String[] stringArray = this.dataFile.getDataAsString(string + " Equipment");
        if (stringArray == null) {
            return;
        }
        String string2 = entity.getTechLevel() == 2 ? "Clan " : "IS ";
        boolean bl = false;
        if (stringArray[0] != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                EquipmentType equipmentType;
                bl = false;
                String string3 = stringArray[i].trim();
                if (string3.startsWith("(R) ")) {
                    bl = true;
                    string3 = string3.substring(4);
                }
                if ((equipmentType = EquipmentType.get(string3)) == null) {
                    equipmentType = EquipmentType.get(string2 + string3);
                }
                if (equipmentType != null) {
                    try {
                        entity.addEquipment(equipmentType, n, bl);
                        continue;
                    }
                    catch (LocationFullException locationFullException) {
                        throw new EntityLoadingException(locationFullException.getMessage());
                    }
                }
                if (string3 == "0") continue;
                entity.addFailedEquipment(string3);
            }
        }
    }
}

