/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.options;

import gd.xml.ParseException;
import gd.xml.tiny.ParsedXML;
import gd.xml.tiny.TinyParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.options.AbstractOptions;
import megamek.common.options.AbstractOptionsInfo;
import megamek.common.options.IBasicOption;
import megamek.common.options.IBasicOptionGroup;
import megamek.common.options.IOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameOptions
extends AbstractOptions
implements Serializable {
    private static final long serialVersionUID = 4916321960852747706L;
    private static final String GAME_OPTIONS_FILE_NAME = "mmconf/gameoptions.xml";

    @Override
    public void initialize() {
        IBasicOptionGroup iBasicOptionGroup = this.addGroup("base");
        this.addOption(iBasicOptionGroup, "friendly_fire", false);
        this.addOption(iBasicOptionGroup, "skip_ineligable_movement", false);
        this.addOption(iBasicOptionGroup, "skip_ineligable_firing", false);
        this.addOption(iBasicOptionGroup, "skip_ineligable_physical", true);
        this.addOption(iBasicOptionGroup, "push_off_board", true);
        this.addOption(iBasicOptionGroup, "rng_type", 1);
        this.addOption(iBasicOptionGroup, "team_initiative", true);
        this.addOption(iBasicOptionGroup, "is_eq_limits", true);
        this.addOption(iBasicOptionGroup, "autosave_msg", true);
        this.addOption(iBasicOptionGroup, "paranoid_autosave", false);
        this.addOption(iBasicOptionGroup, "exclusive_db_deployment", true);
        this.addOption(iBasicOptionGroup, "deep_deployment", false);
        this.addOption(iBasicOptionGroup, "restrict_game_commands", false);
        this.addOption(iBasicOptionGroup, "bridgeCF", 0);
        this.addOption(iBasicOptionGroup, "show_bay_detail", false);
        IBasicOptionGroup iBasicOptionGroup2 = this.addGroup("victory");
        this.addOption(iBasicOptionGroup2, "skip_forced_victory", false);
        this.addOption(iBasicOptionGroup2, "check_victory", true);
        this.addOption(iBasicOptionGroup2, "achieve_conditions", 1);
        this.addOption(iBasicOptionGroup2, "use_bv_destroyed", false);
        this.addOption(iBasicOptionGroup2, "bv_destroyed_percent", 100);
        this.addOption(iBasicOptionGroup2, "use_bv_ratio", false);
        this.addOption(iBasicOptionGroup2, "bv_ratio_percent", 300);
        this.addOption(iBasicOptionGroup2, "use_game_turn_limit", false);
        this.addOption(iBasicOptionGroup2, "game_turn_limit", 10);
        this.addOption(iBasicOptionGroup2, "commander_killed", false);
        IBasicOptionGroup iBasicOptionGroup3 = this.addGroup("AT2");
        this.addOption(iBasicOptionGroup3, "advanced_movement", false);
        this.addOption(iBasicOptionGroup3, "fuel_consumption", false);
        this.addOption(iBasicOptionGroup3, "variable_damage_thresh", false);
        this.addOption(iBasicOptionGroup3, "ammo_explosions", false);
        this.addOption(iBasicOptionGroup3, "air_breathers", false);
        this.addOption(iBasicOptionGroup3, "heat_by_bay", false);
        this.addOption(iBasicOptionGroup3, "at2_nukes", false);
        IBasicOptionGroup iBasicOptionGroup4 = this.addGroup("level2");
        this.addOption(iBasicOptionGroup4, "flamer_heat", true);
        this.addOption(iBasicOptionGroup4, "fire", false);
        this.addOption(iBasicOptionGroup4, "indirect_fire", true);
        this.addOption(iBasicOptionGroup4, "minefields", false);
        this.addOption(iBasicOptionGroup4, "temperature", 25);
        this.addOption(iBasicOptionGroup4, "gravity", 1.0f);
        this.addOption(iBasicOptionGroup4, "vacuum", false);
        this.addOption(iBasicOptionGroup4, "night_battle", false);
        this.addOption(iBasicOptionGroup4, "assault_drop", false);
        this.addOption(iBasicOptionGroup4, "hidden_units", false);
        IBasicOptionGroup iBasicOptionGroup5 = this.addGroup("level3");
        this.addOption(iBasicOptionGroup5, "allow_nukes", false);
        this.addOption(iBasicOptionGroup5, "really_allow_nukes", false);
        this.addOption(iBasicOptionGroup5, "allow_level_3_units", false);
        this.addOption(iBasicOptionGroup5, "allow_level_3_ammo", false);
        this.addOption(iBasicOptionGroup5, "double_blind", false);
        this.addOption(iBasicOptionGroup5, "supress_all_double_blind_messages", false);
        this.addOption(iBasicOptionGroup5, "dusk", false);
        this.addOption(iBasicOptionGroup5, "blizzard", false);
        this.addOption(iBasicOptionGroup5, "blowing_sand", false);
        this.addOption(iBasicOptionGroup5, "heavy_snowfall", false);
        this.addOption(iBasicOptionGroup5, "light_rainfall", false);
        this.addOption(iBasicOptionGroup5, "heavy_rainfall", false);
        this.addOption(iBasicOptionGroup5, "moderate_winds", false);
        this.addOption(iBasicOptionGroup5, "high_winds", false);
        this.addOption(iBasicOptionGroup5, "team_vision", true);
        this.addOption(iBasicOptionGroup5, "floating_crits", false);
        this.addOption(iBasicOptionGroup5, "engine_explosions", false);
        this.addOption(iBasicOptionGroup5, "pilot_advantages", false);
        this.addOption(iBasicOptionGroup5, "maxtech_physical_psr", false);
        this.addOption(iBasicOptionGroup5, "maxtech_round_damage", false);
        this.addOption(iBasicOptionGroup5, "maxtech_prone_fire", false);
        this.addOption(iBasicOptionGroup5, "maxtech_leg_damage", false);
        this.addOption(iBasicOptionGroup5, "maxtech_fire", false);
        this.addOption(iBasicOptionGroup5, "maxtech_range", false);
        this.addOption(iBasicOptionGroup5, "maxtech_LOS1", false);
        this.addOption(iBasicOptionGroup5, "maxtech_altdmg", false);
        this.addOption(iBasicOptionGroup5, "maxtech_mslhitpen", false);
        this.addOption(iBasicOptionGroup5, "maxtech_ppc_inhibitors", false);
        this.addOption(iBasicOptionGroup5, "maxtech_charge_damage", false);
        this.addOption(iBasicOptionGroup5, "maxtech_glancing_blows", false);
        this.addOption(iBasicOptionGroup5, "maxtech_burst", false);
        this.addOption(iBasicOptionGroup5, "maxtech_heat", false);
        this.addOption(iBasicOptionGroup5, "maxtech_partial_cover", false);
        this.addOption(iBasicOptionGroup5, "allow_level_3_targsys", false);
        this.addOption(iBasicOptionGroup5, "quad_hit_location", false);
        this.addOption(iBasicOptionGroup5, "hull_down", false);
        this.addOption(iBasicOptionGroup5, "vehicle_fires", false);
        this.addOption(iBasicOptionGroup5, "paratroopers", false);
        this.addOption(iBasicOptionGroup5, "ba_criticals", false);
        this.addOption(iBasicOptionGroup5, "maxtech_bap", false);
        this.addOption(iBasicOptionGroup5, "maxtech_artillery", false);
        this.addOption(iBasicOptionGroup5, "maxtech_eccm", false);
        this.addOption(iBasicOptionGroup5, "maxtech_dig_in", false);
        this.addOption(iBasicOptionGroup5, "maxtech_new_physicals", false);
        this.addOption(iBasicOptionGroup5, "maxtech_hotload", false);
        this.addOption(iBasicOptionGroup5, "maxtech_rapid_ac", false);
        this.addOption(iBasicOptionGroup5, "maxtech_walk_backwards", false);
        this.addOption(iBasicOptionGroup5, "manei_domini", false);
        this.addOption(iBasicOptionGroup5, "maxtech_angel_ecm", false);
        IBasicOptionGroup iBasicOptionGroup6 = this.addGroup("ruleBreakers");
        this.addOption(iBasicOptionGroup6, "no_tac", false);
        this.addOption(iBasicOptionGroup6, "rpg_gunnery", false);
        this.addOption(iBasicOptionGroup6, "no_immobile_vehicles", false);
        this.addOption(iBasicOptionGroup6, "vehicles_can_eject", false);
        this.addOption(iBasicOptionGroup6, "individual_initiative", false);
        this.addOption(iBasicOptionGroup6, "inf_move_even", false);
        this.addOption(iBasicOptionGroup6, "inf_deploy_even", false);
        this.addOption(iBasicOptionGroup6, "inf_move_later", false);
        this.addOption(iBasicOptionGroup6, "inf_move_multi", false);
        this.addOption(iBasicOptionGroup6, "protos_move_even", false);
        this.addOption(iBasicOptionGroup6, "protos_deploy_even", false);
        this.addOption(iBasicOptionGroup6, "protos_move_later", false);
        this.addOption(iBasicOptionGroup6, "protos_move_multi", false);
        this.addOption(iBasicOptionGroup6, "inf_proto_move_multi", 3);
        this.addOption(iBasicOptionGroup6, "blind_drop", false);
        this.addOption(iBasicOptionGroup6, "real_blind_drop", false);
        this.addOption(iBasicOptionGroup6, "visibility", 999);
        this.addOption(iBasicOptionGroup6, "clan_ignore_eq_limits", false);
        this.addOption(iBasicOptionGroup6, "no_clan_physical", false);
        this.addOption(iBasicOptionGroup6, "no_hover_charge", false);
        this.addOption(iBasicOptionGroup6, "woods_burn_down", false);
        this.addOption(iBasicOptionGroup6, "woods_burn_down_amount", 5);
        this.addOption(iBasicOptionGroup6, "vehicles_safe_from_infernos", false);
        this.addOption(iBasicOptionGroup6, "protos_safe_from_infernos", false);
        this.addOption(iBasicOptionGroup6, "lobby_ammo_dump", false);
        this.addOption(iBasicOptionGroup6, "set_arty_player_homeedge", false);
        this.addOption(iBasicOptionGroup6, "no_premove_vibra", false);
        this.addOption(iBasicOptionGroup6, "margin_scatter_distance", false);
        this.addOption(iBasicOptionGroup6, "allow_illegal_units", false);
        this.addOption(iBasicOptionGroup6, "ejected_pilots_flee", false);
        this.addOption(iBasicOptionGroup6, "a4homing_target_area", false);
        this.addOption(iBasicOptionGroup6, "all_have_ei_cockpit", false);
        this.addOption(iBasicOptionGroup6, "canon_only", false);
        this.addOption(iBasicOptionGroup6, "indirect_always_possible", false);
        this.addOption(iBasicOptionGroup6, "armed_mechwarriors", false);
        this.addOption(iBasicOptionGroup6, "auto_abandon_unit", false);
        this.addOption(iBasicOptionGroup6, "no_ignite_clear", false);
        this.addOption(iBasicOptionGroup6, "falls_end_movement", false);
        this.addOption(iBasicOptionGroup6, "extreme_temperature_survival", false);
        this.addOption(iBasicOptionGroup6, "pilots_visual_range_one", false);
        this.addOption(iBasicOptionGroup6, "pilots_cannot_spot", false);
        this.addOption(iBasicOptionGroup6, "no_force_size_mod", false);
        this.addOption(iBasicOptionGroup6, "tank_level_3_targsys", false);
        this.addOption(iBasicOptionGroup6, "dumping_from_round", 1);
    }

    public Vector<IOption> loadOptions() {
        return this.loadOptions(new File(GAME_OPTIONS_FILE_NAME));
    }

    public Vector<IOption> loadOptions(File file) {
        ParsedXML parsedXML = null;
        FileInputStream fileInputStream = null;
        Vector<IOption> vector = new Vector<IOption>(1, 1);
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return vector;
        }
        try {
            parsedXML = TinyParser.parseXML((InputStream)fileInputStream);
        }
        catch (ParseException parseException) {
            System.out.println("Error parsing game options xml file.");
            parseException.printStackTrace(System.out);
            return vector;
        }
        Enumeration enumeration = parsedXML.elements();
        ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
        if (parsedXML2.getName().equals("options")) {
            Enumeration enumeration2 = parsedXML2.elements();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = this.parseOptionNode((ParsedXML)enumeration2.nextElement());
                if (null == iOption) continue;
                vector.addElement(iOption);
            }
            return vector;
        }
        System.out.println("Root node of game options file is incorrectly named. Name should be 'options' but name is '" + parsedXML2.getName() + "'");
        return vector;
    }

    private IOption parseOptionNode(ParsedXML parsedXML) {
        Object object = null;
        if (parsedXML.getName().equals("gameoption")) {
            Object object2;
            Enumeration enumeration = parsedXML.elements();
            String string = null;
            Object object3 = null;
            while (enumeration.hasMoreElements()) {
                object2 = (ParsedXML)enumeration.nextElement();
                if (object2.getName().equals("optionname")) {
                    string = ((ParsedXML)object2.elements().nextElement()).getContent();
                    continue;
                }
                if (!object2.getName().equals("optionvalue")) continue;
                object3 = ((ParsedXML)object2.elements().nextElement()).getContent();
            }
            if (null != string && null != object3) {
                object2 = this.getOption(string);
                if (null != object2) {
                    if (!object2.getValue().toString().equals(object3.toString())) {
                        try {
                            switch (object2.getType()) {
                                case 3: {
                                    object2.setValue((String)object3);
                                    break;
                                }
                                case 0: {
                                    object2.setValue(new Boolean(object3.toString()));
                                    break;
                                }
                                case 1: {
                                    object2.setValue(new Integer(object3.toString()));
                                    break;
                                }
                                case 2: {
                                    object2.setValue(new Float(object3.toString()));
                                }
                            }
                            System.out.println("Set option '" + string + "' to '" + object3 + "'.");
                            object = object2;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            System.out.println("Error trying to load option '" + string + "' with a value of '" + object3 + "'.");
                        }
                    }
                } else {
                    System.out.println("Invalid option '" + string + "' when trying to load options file.");
                }
            }
        }
        return object;
    }

    public static void saveOptions(Vector<IBasicOption> vector) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(GAME_OPTIONS_FILE_NAME))));
            bufferedWriter.write("<?xml version=\"1.0\"?>");
            bufferedWriter.write("\r\n");
            bufferedWriter.write("<options>");
            bufferedWriter.write("\r\n");
            for (int i = 0; i < vector.size(); ++i) {
                IBasicOption iBasicOption = vector.elementAt(i);
                bufferedWriter.write("   <gameoption>");
                bufferedWriter.write("\r\n");
                bufferedWriter.write("      <optionname>");
                bufferedWriter.write(iBasicOption.getName());
                bufferedWriter.write("</optionname>");
                bufferedWriter.write("\r\n");
                bufferedWriter.write("      <optionvalue>");
                bufferedWriter.write(iBasicOption.getValue().toString());
                bufferedWriter.write("</optionvalue>");
                bufferedWriter.write("\r\n");
                bufferedWriter.write("   </gameoption>");
                bufferedWriter.write("\r\n");
            }
            bufferedWriter.write("</options>");
            bufferedWriter.write("\r\n");
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected AbstractOptionsInfo getOptionsInfoImp() {
        return GameOptionsInfo.getInstance();
    }

    private static class GameOptionsInfo
    extends AbstractOptionsInfo {
        private static AbstractOptionsInfo instance = new GameOptionsInfo();

        protected GameOptionsInfo() {
            super("GameOptionsInfo");
        }

        public static AbstractOptionsInfo getInstance() {
            return instance;
        }
    }
}

