/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.options;

import java.io.Serializable;
import java.util.Vector;
import megamek.common.options.IOption;
import megamek.common.options.IOptionInfo;
import megamek.common.options.IOptions;

public class Option
implements IOption,
Serializable {
    private static final long serialVersionUID = 8310472250031962888L;
    private String name;
    private int type;
    private Object defaultValue;
    private Object value;
    private IOptions owner;
    private transient IOptionInfo info;

    public Option(IOptions iOptions, String string, String string2) {
        this(iOptions, string, 3, string2);
    }

    public Option(IOptions iOptions, String string, boolean bl) {
        this(iOptions, string, 0, new Boolean(bl));
    }

    public Option(IOptions iOptions, String string, int n) {
        this(iOptions, string, 1, new Integer(n));
    }

    public Option(IOptions iOptions, String string, float f) {
        this(iOptions, string, 2, new Float(f));
    }

    public Option(IOptions iOptions, String string, Vector vector) {
        this(iOptions, string, 4, "");
    }

    public Option(IOptions iOptions, String string, int n, Object object) {
        this.owner = iOptions;
        this.name = string;
        this.type = n;
        if (!this.isValidValue(object)) {
            throw new IllegalArgumentException("Tried to give wrong type of value for option type.");
        }
        this.defaultValue = object;
        this.value = object;
    }

    public IOptions getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayableNameWithValue() {
        this.updateInfo();
        return this.info.getDisplayableName() + (this.type == 1 ? " " + this.value : "");
    }

    public String getDisplayableName() {
        this.updateInfo();
        return this.info.getDisplayableName();
    }

    public String getDescription() {
        this.updateInfo();
        return this.info.getDescription();
    }

    public int getTextFieldLength() {
        this.updateInfo();
        return this.info.getTextFieldLength();
    }

    public boolean isLabelBeforeTextField() {
        this.updateInfo();
        return this.info.isLabelBeforeTextField();
    }

    public int getType() {
        return this.type;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean booleanValue() {
        if (this.type == 1) {
            return (Integer)this.value > 0;
        }
        if (this.type == 4 || this.type == 3) {
            return !this.value.equals("None") && !this.value.equals("");
        }
        return (Boolean)this.value;
    }

    public int intValue() {
        return (Integer)this.value;
    }

    public float floatValue() {
        return ((Float)this.value).floatValue();
    }

    public String stringValue() {
        return this.value.toString();
    }

    public void setValue(Object object) {
        if (!this.isValidValue(object)) {
            throw new IllegalArgumentException("Tried to give wrong type of value for option type.");
        }
        this.value = object;
    }

    public void setValue(String string) {
        if (this.type != 3 && this.type != 4) {
            throw new IllegalArgumentException("Tried to give String value to non-String option.");
        }
        this.value = string;
    }

    public void setValue(boolean bl) {
        if (this.type != 0) {
            throw new IllegalArgumentException("Tried to give boolean value to non-boolean option.");
        }
        this.value = new Boolean(bl);
    }

    public void setValue(int n) {
        if (this.type != 1) {
            throw new IllegalArgumentException("Tried to give integer value to non-integer option.");
        }
        this.value = new Integer(n);
    }

    public void setValue(float f) {
        if (this.type != 2) {
            throw new IllegalArgumentException("Tried to give float value to non-float option.");
        }
        this.value = new Float(f);
    }

    public void clearValue() {
        switch (this.type) {
            case 3: 
            case 4: {
                this.setValue("");
                break;
            }
            case 0: {
                this.setValue(false);
                break;
            }
            case 1: {
                this.setValue(0);
                break;
            }
            case 2: {
                this.setValue(0);
            }
        }
    }

    private boolean isValidValue(Object object) {
        switch (this.type) {
            case 3: 
            case 4: {
                return object instanceof String;
            }
            case 0: {
                return object instanceof Boolean;
            }
            case 1: {
                return object instanceof Integer;
            }
            case 2: {
                return object instanceof Float;
            }
        }
        return false;
    }

    private void updateInfo() {
        if (this.info == null) {
            this.info = this.owner.getOptionInfo(this.name);
        }
    }
}

