/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Building;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACAPHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -4251291510045646817L;

    public ACAPHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        AmmoType ammoType = (AmmoType)this.weapon.getLinked().getType();
        HitData hitData = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
        hitData.setGeneralDamageType(this.generalDamageType);
        this.r = new Report(3405);
        this.r.subject = this.subjectId;
        this.r.add(this.toHit.getTableDesc());
        this.r.add(entity.getLocationAbbr(hitData));
        this.r.newlines = 0;
        vector.addElement(this.r);
        if (hitData.hitAimedLocation()) {
            this.r = new Report(3410);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        int n5 = n3 * Math.min(n2, n);
        if (n4 > 0) {
            int n6 = Math.min(n4, n5);
            n5 -= n6;
            Report.addNewline(vector);
            Vector<Report> vector2 = this.server.damageBuilding(building, n6);
            for (Report report : vector2) {
                report.subject = this.subjectId;
            }
            vector.addAll(vector2);
        }
        if (n5 == 0) {
            this.r = new Report(3415);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            this.r.addDesc(entity);
            this.r.newlines = 0;
            vector.addElement(this.r);
        } else {
            hitData.makeArmorPiercing(ammoType);
            if (this.bGlancing) {
                hitData.makeGlancingBlow();
            }
            vector.addAll(this.server.damageEntity(entity, hitData, n5, false, this.ae.getSwarmTargetId() == entity.getId() ? Server.DamageType.IGNORE_PASSENGER : this.damageType, false, false, this.throughFront));
        }
    }
}

