/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.Mounted;
import megamek.common.RangeType;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoBayWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACBayHandler
extends AmmoBayWeaponHandler {
    private static final long serialVersionUID = -1618484541772117621L;

    public ACBayHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcAttackValue() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        double d = 0.0;
        int n2 = RangeType.rangeBracket(n, this.wtype.getATRanges(), true);
        for (int n3 : this.weapon.getBayWeapons()) {
            Mounted mounted = this.ae.getEquipment(n3);
            int n4 = mounted.getCurrentShots();
            Mounted mounted2 = mounted.getLinked();
            if (null == mounted2 || mounted2.getShotsLeft() < 1) {
                this.ae.loadWeaponWithSameAmmo(mounted);
                mounted2 = mounted.getLinked();
            }
            for (int i = 0; i < n4; ++i) {
                if (null == mounted2 || mounted2.getShotsLeft() < 1) {
                    this.ae.loadWeaponWithSameAmmo(mounted);
                    mounted2 = mounted.getLinked();
                }
                if (mounted.isBreached() || mounted.isDestroyed() || mounted.isJammed() || mounted2 == null || mounted2.getShotsLeft() <= 0) continue;
                WeaponType weaponType = (WeaponType)mounted.getType();
                double d2 = 0.0;
                if (n2 == 1) {
                    d2 = weaponType.getShortAV();
                } else if (n2 == 2) {
                    d2 = weaponType.getMedAV();
                } else if (n2 == 3) {
                    d2 = weaponType.getLongAV();
                } else if (n2 == 4) {
                    d2 = weaponType.getExtAV();
                }
                d2 = this.updateAVforAmmo(d2, (AmmoType)mounted2.getType(), weaponType, n2);
                d += (d2 /= (double)n4);
                if (!(d2 > 0.0)) continue;
                mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
            }
        }
        return (int)Math.ceil(d);
    }

    @Override
    protected boolean doChecks(Vector<Report> vector) {
        for (int n : this.weapon.getBayWeapons()) {
            Mounted mounted = this.ae.getEquipment(n);
            WeaponType weaponType = (WeaponType)mounted.getType();
            int n2 = mounted.getCurrentShots();
            if (weaponType.getAmmoType() == 23) {
                boolean bl = false;
                switch (n2) {
                    case 6: {
                        if (this.roll > 4) break;
                        bl = true;
                        break;
                    }
                    case 4: 
                    case 5: {
                        if (this.roll > 3) break;
                        bl = true;
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (this.roll > 2) break;
                        bl = true;
                        break;
                    }
                }
                if (!bl) continue;
                this.r = new Report(3170);
                this.r.subject = this.subjectId;
                this.r.add(" shot(s)");
                this.r.newlines = 0;
                vector.addElement(this.r);
                mounted.setJammed(true);
                continue;
            }
            if (weaponType.getAmmoType() != 20 || this.roll != 2 || n2 != 2) continue;
            this.r = new Report();
            this.r.subject = this.subjectId;
            this.r.messageId = 3160;
            this.r.newlines = 0;
            mounted.setJammed(true);
            mounted.setHit(true);
            vector.addElement(this.r);
        }
        return false;
    }
}

