/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Mounted;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoBayWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapitalMissileBayHandler
extends AmmoBayWeaponHandler {
    private static final long serialVersionUID = -1618484541772117621L;

    public CapitalMissileBayHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int getCapMisMod() {
        int n = 0;
        for (int n2 : this.weapon.getBayWeapons()) {
            int n3 = 0;
            Mounted mounted = this.ae.getEquipment(n2);
            Mounted mounted2 = mounted.getLinked();
            AmmoType ammoType = (AmmoType)mounted2.getType();
            n3 = this.getCritMod(ammoType);
            if (n3 <= n) continue;
            n = n3;
        }
        return n;
    }

    protected int getCritMod(AmmoType ammoType) {
        if (ammoType == null) {
            return 0;
        }
        if (ammoType.getAmmoType() == 58) {
            return 9;
        }
        if (ammoType.getAmmoType() == 57) {
            return 10;
        }
        if (ammoType.getAmmoType() == 60) {
            return 8;
        }
        return 11;
    }

    @Override
    protected boolean specialResolution(Vector<Report> vector, Entity entity, boolean bl) {
        for (int n : this.weapon.getBayWeapons()) {
            Mounted mounted = this.ae.getEquipment(n);
            Mounted mounted2 = mounted.getLinked();
            AmmoType ammoType = (AmmoType)mounted2.getType();
            if (mounted.isBreached() || mounted.isDestroyed() || mounted.isJammed() || mounted2.getShotsLeft() <= 0 || !ammoType.hasFlag(1024L)) continue;
            this.server.deployTeleMissile(this.ae, ammoType, n, this.getCritMod(ammoType), vector);
            this.attackValue -= ammoType.getDamagePerShot();
        }
        return this.attackValue <= 0;
    }
}

