/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Report;
import megamek.common.Tank;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.WeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FireExtinguisherHandler
extends WeaponHandler {
    private static final long serialVersionUID = -7047033962986081773L;

    public FireExtinguisherHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected boolean specialResolution(Vector<Report> vector, Entity entity, boolean bl) {
        if (!bl) {
            this.r = new Report(2270);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.add(this.r);
            if (8 == this.target.getTargetType()) {
                this.r = new Report(3540);
                this.r.subject = this.subjectId;
                this.r.add(this.target.getPosition().getBoardNum());
                this.r.indent(3);
                vector.add(this.r);
                this.game.getBoard().getHex(this.target.getPosition()).removeTerrain(7);
                this.server.sendChangedHex(this.target.getPosition());
                this.game.getBoard().removeInfernoFrom(this.target.getPosition());
            } else if (this.target instanceof Entity) {
                if (entity.infernos.isStillBurning() || this.target instanceof Tank && ((Tank)this.target).isOnFire()) {
                    this.r = new Report(3550);
                    this.r.subject = this.subjectId;
                    this.r.addDesc(entity);
                    this.r.newlines = 0;
                    this.r.indent(3);
                    vector.add(this.r);
                }
                entity.infernos.clear();
                if (this.target instanceof Tank) {
                    for (int i = 0; i < entity.locations(); ++i) {
                        ((Tank)this.target).extinguishAll();
                    }
                }
            }
        }
        return true;
    }
}

