/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.PilotingRollData;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HGRHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -6599352761593455842L;

    public HGRHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected boolean doChecks(Vector<Report> vector) {
        if (this.ae.mpUsed > 0) {
            int n = this.ae.getWeight() <= 0.0f ? 2 : (this.ae.getWeight() <= 1.0f ? 1 : (this.ae.getWeight() <= 2.0f ? 0 : -1));
            PilotingRollData pilotingRollData = new PilotingRollData(this.ae.getId(), n, "fired HeavyGauss unbraced");
            pilotingRollData.setCumulative(false);
            this.game.addPSR(pilotingRollData);
        }
        return false;
    }

    @Override
    protected int calcDamagePerHit() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        float f = n <= this.wtype.getShortRange() ? 25.0f : (n <= this.wtype.getMediumRange() ? 20.0f : 10.0f);
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            f /= 10.0f;
        }
        if (this.bGlancing) {
            f = (int)Math.floor((double)f / 2.0);
        }
        return (int)Math.ceil(f);
    }
}

