/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.LBXACWeapon;
import megamek.common.weapons.PrototypeLBXHandler;
import megamek.server.Server;

public class ISLB10XACPrototype
extends LBXACWeapon {
    private static final long serialVersionUID = 4586376672142168553L;

    public ISLB10XACPrototype() {
        this.techLevel = 5;
        this.name = "LB 10-X AC Prototype";
        this.setInternalName("ISLBXAC10Prototype");
        this.addLookupName("IS LB 10-X AC Prototype");
        this.flags |= 0x200000L;
        this.criticals = 7;
        this.heat = 2;
        this.damage = 10;
        this.rackSize = 10;
        this.shortRange = 6;
        this.mediumRange = 12;
        this.longRange = 18;
        this.extremeRange = 24;
        this.tonnage = 11.0f;
        this.bv = 148.0;
        this.cost = 400000.0;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        AmmoType ammoType = (AmmoType)iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId()).getLinked().getType();
        if (ammoType.getMunitionType() == 1L) {
            return new PrototypeLBXHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return super.getCorrectHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

