/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.InfantrySRMHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfantryInfernoSRMHandler
extends InfantrySRMHandler {
    private static final long serialVersionUID = 5917196139361672006L;

    public InfantryInfernoSRMHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n = Compute.missilesHit(((Infantry)this.ae).getShootingStrength());
        this.r = new Report(3325);
        this.r.subject = this.subjectId;
        this.r.add(n);
        this.r.add(" trooper(s) ");
        this.r.add(this.toHit.getTableDesc() + ".");
        this.r.newlines = 0;
        vector.addElement(this.r);
        return this.damage[n - 1] / 2;
    }

    @Override
    public boolean handle(IGame.Phase phase, Vector<Report> vector) {
        if (!this.cares(phase)) {
            return true;
        }
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        boolean bl = Compute.isInBuilding(this.game, entity);
        Building building = this.game.getBoard().getBuildingAt(this.target.getPosition());
        this.r = new Report(3115);
        this.r.indent();
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.wtype.getName());
        if (entity != null) {
            this.r.addDesc(entity);
        } else {
            this.r.messageId = 3120;
            this.r.add(this.target.getDisplayName(), true);
        }
        vector.addElement(this.r);
        if (this.toHit.getValue() == Integer.MAX_VALUE) {
            this.r = new Report(3135);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
            return false;
        }
        if (this.toHit.getValue() == 0x7FFFFFFE) {
            this.r = new Report(3140);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else if (this.toHit.getValue() == Integer.MIN_VALUE) {
            this.r = new Report(3145);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else {
            this.r = new Report(3150);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getValue());
            vector.addElement(this.r);
        }
        this.r = new Report(3155);
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.roll);
        vector.addElement(this.r);
        boolean bl2 = this.bMissed = this.roll < this.toHit.getValue();
        if (this.game.getOptions().booleanOption("maxtech_glancing_blows")) {
            if (this.roll == this.toHit.getValue()) {
                this.bGlancing = true;
                this.r = new Report(3186);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                this.bGlancing = false;
            }
        } else {
            this.bGlancing = false;
        }
        this.useAmmo();
        this.addHeat();
        boolean bl3 = this.doChecks(vector);
        if (bl3) {
            this.bMissed = true;
        }
        if (this.bMissed && !bl3) {
            this.reportMiss(vector);
            if (!this.handleSpecialMiss(entity, bl, building, vector)) {
                return false;
            }
        }
        int n = this.calcHits(vector);
        Report.addNewline(vector);
        if (this.bMissed) {
            if (bl && building != null) {
                this.handleAccidentalBuildingDamage(vector, building, n, this.nDamPerHit);
            }
            return false;
        }
        vector.addAll(this.server.deliverInfernoMissiles(this.ae, this.target, n));
        return false;
    }
}

