/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LBXHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = 6803847280685526644L;

    public LBXHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            float f = this.wtype.getDamage();
            f /= 10.0f;
            return (int)Math.ceil(f += 1.0f);
        }
        return 1;
    }

    @Override
    protected int calcAttackValue() {
        return (int)Math.floor(0.6 * (double)this.wtype.getRackSize());
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            return 1;
        }
        int n2 = n = this.allShotsHit() ? this.wtype.getRackSize() : Compute.missilesHit(this.wtype.getRackSize());
        if (this.bGlancing) {
            n = (int)Math.floor((double)n / 2.0);
        }
        this.r = new Report(3325);
        this.r.subject = this.subjectId;
        this.r.add(n);
        this.r.add(" pellet(s) ");
        this.r.add(this.toHit.getTableDesc());
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n;
    }

    @Override
    protected boolean usesClusterTable() {
        return ((AmmoType)this.ammo.getType()).getMunitionType() == 1L;
    }
}

