/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.MissileWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRMScatterableHandler
extends MissileWeaponHandler {
    private static final long serialVersionUID = -3661776853552779877L;

    public LRMScatterableHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected boolean specialResolution(Vector<Report> vector, Entity entity, boolean bl) {
        Coords coords = this.target.getPosition();
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        if (!bl) {
            this.r = new Report(3190);
            this.r.subject = this.subjectId;
            this.r.add(coords.getBoardNum());
            vector.addElement(this.r);
        } else {
            coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? this.toHit.getValue() - this.roll : -1);
            if (this.game.getBoard().contains(coords)) {
                this.r = new Report(3195);
                this.r.subject = this.subjectId;
                this.r.add(coords.getBoardNum());
                vector.addElement(this.r);
            } else {
                this.r = new Report(3200);
                this.r.subject = this.subjectId;
                vector.addElement(this.r);
                return !bl;
            }
        }
        if (ammoType.getMunitionType() == 0x400000L) {
            this.server.deliverThunderAugMinefield(coords, this.ae.getOwner().getId(), ammoType.getRackSize());
        } else if (ammoType.getMunitionType() == 0x200000L) {
            this.server.deliverThunderMinefield(coords, this.ae.getOwner().getId(), ammoType.getRackSize());
        } else if (ammoType.getMunitionType() == 0x800000L) {
            this.server.deliverThunderInfernoMinefield(coords, this.ae.getOwner().getId(), ammoType.getRackSize());
        } else if (ammoType.getMunitionType() == 0x1000000L) {
            this.server.deliverThunderVibraMinefield(coords, this.ae.getOwner().getId(), ammoType.getRackSize(), this.waa.getOtherAttackInfo());
        } else if (ammoType.getMunitionType() == 0x2000000L) {
            this.server.deliverThunderActiveMinefield(coords, this.ae.getOwner().getId(), ammoType.getRackSize());
        } else if (ammoType.getMunitionType() == 131072L) {
            this.server.deliverFlare(coords, ammoType.getRackSize());
        }
        return true;
    }
}

