/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mounted;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.LRMHandler;
import megamek.common.weapons.Weapon;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRMSwarmHandler
extends LRMHandler {
    private static final long serialVersionUID = 7962873403915683220L;
    int swarmMissilesNowLeft = 0;
    boolean handledHeat = false;

    public LRMSwarmHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.sSalvoType = " swarm missile(s) ";
    }

    @Override
    public boolean handle(IGame.Phase phase, Vector<Report> vector) {
        if (!this.cares(phase)) {
            return true;
        }
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        boolean bl = Compute.isInBuilding(this.game, entity);
        if (entity != null) {
            this.ae.setLastTarget(entity.getId());
        }
        Building building = this.game.getBoard().getBuildingAt(this.target.getPosition());
        this.r = new Report(3115);
        this.r.indent();
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.wtype.getName());
        if (entity != null) {
            this.r.addDesc(entity);
            entity.addTargetedBySwarm(this.ae.getId(), this.waa.getWeaponId());
        } else {
            this.r.messageId = 3120;
            this.r.add(this.target.getDisplayName(), true);
        }
        vector.addElement(this.r);
        if (this.toHit.getValue() == Integer.MAX_VALUE) {
            this.r = new Report(3135);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else if (this.toHit.getValue() == 0x7FFFFFFE) {
            this.r = new Report(3140);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else if (this.toHit.getValue() == Integer.MIN_VALUE) {
            this.r = new Report(3145);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else {
            this.r = new Report(3150);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getValue());
            vector.addElement(this.r);
        }
        this.r = new Report(3155);
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.roll);
        vector.addElement(this.r);
        boolean bl2 = this.bMissed = this.roll < this.toHit.getValue();
        if (this.game.getOptions().booleanOption("maxtech_glancing_blows")) {
            if (this.roll == this.toHit.getValue()) {
                this.bGlancing = true;
                this.r = new Report(3186);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                this.bGlancing = false;
            }
        } else {
            this.bGlancing = false;
        }
        if (!this.handledHeat) {
            this.addHeat();
            this.handledHeat = true;
        }
        boolean bl3 = this.doChecks(vector);
        this.nDamPerHit = this.calcDamagePerHit();
        if (this.specialResolution(vector, entity, this.bMissed)) {
            return false;
        }
        if (this.bMissed && !bl3) {
            this.reportMiss(vector);
            if (!this.handleSpecialMiss(entity, bl, building, vector, phase)) {
                return false;
            }
        }
        int n = this.calcHits(vector);
        int n2 = this.calcnCluster();
        if (this.bMissed) {
            if (bl && building != null) {
                this.handleAccidentalBuildingDamage(vector, building, n, this.nDamPerHit);
            }
            return false;
        }
        int n3 = 0;
        if (bl && building != null) {
            n3 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
        }
        if (n == 0) {
            this.r = new Report(3365);
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
        }
        while (n > 0) {
            if (this.target.getTargetType() == 2 || this.target.getTargetType() == 4) {
                this.handleIgnitionDamage(vector, building, this.bSalvo, n);
                return false;
            }
            if (this.target.getTargetType() == 1) {
                int n4 = this.nDamPerHit * n;
                this.handleClearDamage(vector, building, n4, this.bSalvo);
                return false;
            }
            if (this.target.getTargetType() == 3) {
                int n5 = this.nDamPerHit * n;
                this.handleBuildingDamage(vector, building, n5, this.bSalvo);
                return false;
            }
            if (entity == null) continue;
            this.handleEntityDamage(entity, vector, building, n, n2, this.nDamPerHit, n3);
            this.server.creditKill(entity, this.ae);
            n -= n2;
        }
        Report.addNewline(vector);
        if (this.swarmMissilesNowLeft > 0) {
            Entity entity2 = Compute.getSwarmMissileTarget(this.game, this.ae.getId(), entity, this.waa.getWeaponId());
            if (entity2 != null) {
                this.r = new Report(3420);
                this.r.subject = this.subjectId;
                this.r.indent(2);
                this.r.add(this.swarmMissilesNowLeft);
                vector.addElement(this.r);
                this.weapon.setUsedThisRound(false);
                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(this.ae.getId(), entity2.getTargetId(), this.waa.getWeaponId());
                weaponAttackAction.setSwarmingMissiles(true);
                weaponAttackAction.setSwarmMissiles(this.swarmMissilesNowLeft);
                weaponAttackAction.setOldTargetId(this.target.getTargetId());
                weaponAttackAction.setAmmoId(this.waa.getAmmoId());
                Mounted mounted = this.ae.getEquipment(this.waa.getWeaponId());
                Weapon weapon = (Weapon)mounted.getType();
                this.weapon.getLinked().setShotsLeft(this.weapon.getLinked().getShotsLeft() + 1);
                AttackHandler attackHandler = weapon.fire(weaponAttackAction, this.game, this.server);
                LRMSwarmHandler lRMSwarmHandler = (LRMSwarmHandler)attackHandler;
                lRMSwarmHandler.handledHeat = true;
                lRMSwarmHandler.handle(phase, vector);
            } else {
                this.r = new Report(3425);
                this.r.add(this.swarmMissilesNowLeft);
                this.r.subject = this.subjectId;
                this.r.indent(2);
                vector.addElement(this.r);
            }
        }
        return false;
    }

    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector, IGame.Phase phase) {
        super.handleSpecialMiss(entity, bl, building, vector);
        int n = this.waa.getSwarmMissiles();
        if (n == 0) {
            n = this.wtype.getRackSize();
        }
        this.ae.setLastTarget(entity.getId());
        Entity entity2 = Compute.getSwarmMissileTarget(this.game, this.ae.getId(), entity, this.waa.getWeaponId());
        if (entity2 != null) {
            this.r = new Report(3420);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            this.r.add(n);
            vector.addElement(this.r);
            this.weapon.setUsedThisRound(false);
            WeaponAttackAction weaponAttackAction = new WeaponAttackAction(this.ae.getId(), entity2.getTargetId(), this.waa.getWeaponId());
            weaponAttackAction.setSwarmingMissiles(true);
            weaponAttackAction.setSwarmMissiles(n);
            weaponAttackAction.setOldTargetId(this.target.getTargetId());
            weaponAttackAction.setAmmoId(this.waa.getAmmoId());
            Mounted mounted = this.ae.getEquipment(this.waa.getWeaponId());
            Weapon weapon = (Weapon)mounted.getType();
            this.weapon.getLinked().setShotsLeft(this.weapon.getLinked().getShotsLeft() + 1);
            AttackHandler attackHandler = weapon.fire(weaponAttackAction, this.game, this.server);
            LRMSwarmHandler lRMSwarmHandler = (LRMSwarmHandler)attackHandler;
            lRMSwarmHandler.handledHeat = true;
            lRMSwarmHandler.handle(phase, vector);
        } else {
            this.r = new Report(3425);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            this.r.add(n);
            vector.addElement(this.r);
        }
        return false;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        int n2;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                this.bSalvo = true;
                return ((BattleArmor)this.ae).getShootingStrength();
            }
            return 1;
        }
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_mslhitpen");
        if (bl2) {
            n3 = this.nRange <= 1 ? ++n3 : (this.nRange <= this.wtype.getShortRange() ? (n3 += 0) : (this.nRange <= this.wtype.getMediumRange() ? --n3 : (n3 -= 2)));
        }
        if (this.bGlancing) {
            n3 -= 4;
        }
        if (this.game.getOptions().booleanOption("blizzard") && this.wtype.hasFlag(262144L)) {
            n3 -= 4;
            bl = true;
        }
        if (this.game.getOptions().booleanOption("moderate_winds") && this.wtype.hasFlag(262144L)) {
            n3 -= 2;
            bl = true;
        }
        if (this.game.getOptions().booleanOption("high_winds") && this.wtype.hasFlag(262144L)) {
            n3 -= 4;
            bl = true;
        }
        if ((n2 = this.waa.getSwarmMissiles()) > 0) {
            if (this.allShotsHit()) {
                n = n2;
            } else {
                int n4 = 5;
                if (n2 > 5 && n2 <= 10) {
                    n4 = 10;
                } else if (n2 > 10 && n2 <= 15) {
                    n4 = 15;
                } else if (n2 > 15 && n2 <= 20) {
                    n4 = 20;
                }
                n = Compute.missilesHit(n4, n3, bl2 | this.bGlancing);
                if (n > n2) {
                    n = n2;
                }
            }
        } else {
            n = this.allShotsHit() ? this.wtype.getRackSize() : Compute.missilesHit(this.wtype.getRackSize(), n3, bl || this.bGlancing || bl2);
            n2 = this.wtype.getRackSize();
        }
        this.swarmMissilesNowLeft = n2 - n;
        this.r = new Report(3325);
        this.r.subject = this.subjectId;
        this.r.add(n);
        this.r.add(this.sSalvoType);
        this.r.add(this.toHit.getTableDesc());
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n;
    }
}

