/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.LRMAntiTSMHandler;
import megamek.common.weapons.LRMDeadFireHandler;
import megamek.common.weapons.LRMFollowTheLeaderHandler;
import megamek.common.weapons.LRMFragHandler;
import megamek.common.weapons.LRMHandler;
import megamek.common.weapons.LRMScatterableHandler;
import megamek.common.weapons.LRMSwarmHandler;
import megamek.common.weapons.LRMSwarmIHandler;
import megamek.common.weapons.MissileWeapon;
import megamek.server.Server;

public abstract class LRMWeapon
extends MissileWeapon {
    public LRMWeapon() {
        this.ammoType = 7;
        this.setModes(new String[]{"", "Indirect"});
        this.atClass = 9;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        AmmoType ammoType = (AmmoType)iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId()).getLinked().getType();
        if (ammoType.getMunitionType() == 256L) {
            return new LRMFragHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 1024L) {
            return new LRMAntiTSMHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 0x200000L || ammoType.getMunitionType() == 0x2000000L || ammoType.getMunitionType() == 0x400000L || ammoType.getMunitionType() == 0x800000L || ammoType.getMunitionType() == 0x1000000L || ammoType.getMunitionType() == 131072L) {
            return new LRMScatterableHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 524288L) {
            return new LRMSwarmHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 0x100000L) {
            return new LRMSwarmIHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 8192L) {
            return new LRMDeadFireHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 0x4000000L) {
            return new LRMFollowTheLeaderHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return new LRMHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

