/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MineLauncherHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -6179453250580148965L;

    public MineLauncherHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                this.bSalvo = true;
                return ((BattleArmor)this.ae).getShootingStrength();
            }
            return 1;
        }
        int n = this.weapon.howManyShots();
        if (!this.allShotsHit()) {
            n = Compute.missilesHit(n);
        }
        this.bSalvo = true;
        String string = " mine(s) ";
        this.r = new Report(3325);
        this.r.subject = this.subjectId;
        this.r.add(n);
        this.r.add(string);
        this.r.add(this.toHit.getTableDesc());
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        return n;
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        HitData hitData = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
        hitData = this.target instanceof Mech ? new HitData(1) : new HitData(1);
        hitData.setGeneralDamageType(this.generalDamageType);
        Vector<Report> vector2 = this.server.criticalEntity(entity, hitData.getLocation(), 0);
        if (vector2.lastElement().messageId == 6005) {
            int n5 = 4;
            vector2 = this.server.damageEntity(entity, hitData, n5, false, this.ae.getSwarmTargetId() == entity.getId() ? Server.DamageType.IGNORE_PASSENGER : this.damageType, false, false, this.throughFront);
        } else {
            try {
                ++vector2.elementAt((int)(vector2.size() - 2)).newlines;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ERROR: no previous report when trying to add newline");
            }
        }
        vector.addAll(vector2);
    }

    @Override
    protected void useAmmo() {
        int n;
        int n2;
        this.setDone();
        this.checkAmmo();
        if (n2 > 1) {
            n = this.ae.getTotalAmmoOfType(this.ammo.getType());
            for (n2 = this.weapon.howManyShots(); n < n2; --n2) {
            }
        }
        for (n = 0; n < n2; ++n) {
            if (this.ammo.getShotsLeft() <= 0) {
                this.ae.loadWeaponWithSameAmmo(this.weapon);
                this.ammo = this.weapon.getLinked();
            }
            this.ammo.setShotsLeft(this.ammo.getShotsLeft() - 1);
        }
    }
}

