/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.RangeType;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.Weapon;
import megamek.common.weapons.WeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissileWeaponHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -4801130911083653548L;
    String sSalvoType = " missile(s) ";
    boolean amsEnganged = false;
    int nSalvoBonus = 0;

    public MissileWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.generalDamageType = -4;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                this.bSalvo = true;
                this.r = new Report(3325);
                this.r.subject = this.subjectId;
                this.r.add(this.wtype.getRackSize() * ((BattleArmor)this.ae).getShootingStrength());
                this.r.add(this.sSalvoType);
                this.r.add(this.toHit.getTableDesc());
                this.r.newlines = 0;
                vector.add(this.r);
                return ((BattleArmor)this.ae).getShootingStrength();
            }
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(this.wtype.getRackSize());
            this.r.add(this.sSalvoType);
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.add(this.r);
            return 1;
        }
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        int n2 = this.nSalvoBonus;
        boolean bl = false;
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_mslhitpen");
        if (bl2) {
            n2 = this.nRange <= 1 ? ++n2 : (this.nRange <= this.wtype.getShortRange() ? (n2 += 0) : (this.nRange <= this.wtype.getMediumRange() ? --n2 : (n2 -= 2)));
        }
        boolean bl3 = false;
        if (this.ae instanceof Mech) {
            bl3 = this.ae.isStealthActive();
        }
        Mounted mounted = this.weapon.getLinkedBy();
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        boolean bl4 = false;
        if (Compute.isAffectedByECM(this.ae, this.ae.getPosition(), this.target.getPosition())) {
            bl4 = true;
        }
        if (mounted != null && mounted.getType() instanceof MiscType && !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && mounted.getType().hasFlag(512L) && ammoType.getMunitionType() == 4096L) {
            if (bl4) {
                this.r = new Report(3330);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else if (bl3) {
                this.r = new Report(3335);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                n2 += 2;
            }
        } else if (ammoType.getAmmoType() == 28) {
            if (bl4) {
                this.r = new Report(3330);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else if (bl3) {
                this.r = new Report(3335);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                n2 += 2;
            }
        } else if (entity != null && (entity.isNarcedBy(this.ae.getOwner().getTeam()) || entity.isINarcedBy(this.ae.getOwner().getTeam()))) {
            boolean bl5 = false;
            bl5 = Compute.isAffectedByECM(this.ae, this.target.getPosition(), this.target.getPosition());
            if (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 45 && ammoType.getMunitionType() == 2048L && (this.weapon.curMode() == null || !this.weapon.curMode().equals("Indirect"))) {
                if (bl5) {
                    this.r = new Report(3330);
                    this.r.subject = this.subjectId;
                    this.r.newlines = 0;
                    vector.addElement(this.r);
                } else {
                    n2 += 2;
                }
            }
        }
        if (this.bGlancing) {
            n2 -= 4;
        }
        if (this.game.getOptions().booleanOption("blizzard") && this.wtype.hasFlag(262144L)) {
            n2 -= 4;
            bl = true;
        }
        if (this.game.getOptions().booleanOption("moderate_winds") && this.wtype.hasFlag(262144L)) {
            n2 -= 2;
            bl = true;
        }
        if (this.game.getOptions().booleanOption("high_winds") && this.wtype.hasFlag(262144L)) {
            n2 -= 4;
            bl = true;
        }
        if ((n = this.allShotsHit() ? this.wtype.getRackSize() : (this.ae instanceof BattleArmor ? Compute.missilesHit(this.wtype.getRackSize() * ((BattleArmor)this.ae).getShootingStrength(), n2, bl || this.bGlancing || bl2, this.weapon.isHotLoaded()) : Compute.missilesHit(this.wtype.getRackSize(), n2 += this.getAMSHitsMod(vector), bl || this.bGlancing || bl2, this.weapon.isHotLoaded()))) > 0) {
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(n);
            this.r.add(this.sSalvoType);
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.addElement(this.r);
            if (n2 != 0) {
                this.r = n2 > 0 ? new Report(3340) : new Report(3341);
                this.r.subject = this.subjectId;
                this.r.add(n2);
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
        }
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n;
    }

    @Override
    protected int calcnCluster() {
        return 5;
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            double d = this.wtype.getRackSize();
            d /= 5.0;
            d = Math.ceil(d);
            if (this.bGlancing) {
                d = (int)Math.floor(d / 2.0);
            }
            return (int)d;
        }
        return 1;
    }

    @Override
    protected int calcAttackValue() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        int n2 = 0;
        int n3 = RangeType.rangeBracket(n, this.wtype.getATRanges(), true);
        if (n3 == 1) {
            n2 = this.wtype.getRoundShortAV();
        } else if (n3 == 2) {
            n2 = this.wtype.getRoundMedAV();
        } else if (n3 == 3) {
            n2 = this.wtype.getRoundLongAV();
        } else if (n3 == 4) {
            n2 = this.wtype.getRoundExtAV();
        }
        Mounted mounted = this.weapon.getLinkedBy();
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        int n4 = 0;
        if (mounted != null && mounted.getType() instanceof MiscType && !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && mounted.getType().hasFlag(512L) && ammoType.getMunitionType() == 4096L) {
            n4 = (int)Math.ceil((double)ammoType.getRackSize() / 5.0);
            if (ammoType.getAmmoType() == 9) {
                n4 = 2;
            }
        }
        n2 += n4;
        if (ammoType.getAmmoType() == 45 && !ammoType.hasFlag(32L)) {
            n2 *= 2;
        }
        return n2;
    }

    @Override
    protected boolean handleSpecialMiss(Entity entity, boolean bl, Building building, Vector<Report> vector) {
        if (entity != null && building == null && this.wtype.getFireTN() != Integer.MAX_VALUE) {
            this.server.tryIgniteHex(this.target.getPosition(), this.subjectId, false, 11, vector);
        }
        if (this.amsEnganged) {
            this.r = new Report(3230);
            this.r.indent();
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
        }
        return bl && this.toHit.getValue() != 0x7FFFFFFE;
    }

    protected int getAMSHitsMod(Vector<Report> vector) {
        ArrayList<Mounted> arrayList;
        Entity entity;
        Entity entity2 = entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        if (entity != null && null != (arrayList = this.waa.getCounterEquipment())) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Mounted mounted = arrayList.get(i);
                if (!mounted.getType().hasFlag(0x800000L) || this.amsEnganged) continue;
                Mounted mounted2 = mounted.getLinked();
                Entity entity3 = this.waa.getEntity(this.game);
                if (!(mounted.getType() instanceof WeaponType) || !mounted.isReady() || mounted.isMissing() || entity.hasShield() && entity.hasActiveShield(mounted.getLocation(), false) || entity.isShutDown() || !Compute.isInArc(this.game, entity.getId(), entity.getEquipmentNum(mounted), entity3)) continue;
                entity.heatBuildup = mounted.getType().hasFlag(0x400000L) ? (entity.heatBuildup += Compute.d6(((WeaponType)mounted.getType()).getHeat())) : (entity.heatBuildup += ((WeaponType)mounted.getType()).getHeat());
                if (mounted2 != null) {
                    mounted2.setShotsLeft(Math.max(0, mounted2.getShotsLeft() - 1));
                }
                mounted.setUsedThisRound(true);
                this.amsEnganged = true;
                this.r = new Report(3350);
                this.r.newlines = 0;
                vector.add(this.r);
                return -4;
            }
        }
        return 0;
    }

    @Override
    public boolean handle(IGame.Phase phase, Vector<Report> vector) {
        if (!this.cares(phase)) {
            return true;
        }
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        boolean bl = Compute.isInBuilding(this.game, entity);
        boolean bl2 = this.isNemesisConfusable();
        if (entity != null) {
            this.ae.setLastTarget(entity.getId());
        }
        Building building = this.game.getBoard().getBuildingAt(this.target.getPosition());
        this.r = new Report(3115);
        this.r.indent();
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.wtype.getName());
        if (entity != null) {
            this.r.addDesc(entity);
        } else {
            this.r.messageId = 3120;
            this.r.add(this.target.getDisplayName(), true);
        }
        vector.addElement(this.r);
        boolean bl3 = false;
        if (bl2 && !this.waa.isNemesisConfused()) {
            Enumeration<Entity> enumeration = this.game.getNemesisTargets(this.ae, this.target.getPosition());
            while (enumeration.hasMoreElements()) {
                Entity entity2 = enumeration.nextElement();
                this.r = new Report(3125);
                this.r.subject = this.subjectId;
                vector.addElement(this.r);
                this.weapon.setUsedThisRound(false);
                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(this.ae.getId(), entity2.getTargetId(), this.waa.getWeaponId());
                weaponAttackAction.setNemesisConfused(true);
                Entity entity3 = this.game.getEntity(this.waa.getEntityId());
                Mounted mounted = entity3.getEquipment(this.waa.getWeaponId());
                Weapon weapon = (Weapon)mounted.getType();
                AttackHandler attackHandler = weapon.fire(weaponAttackAction, this.game, this.server);
                this.weapon.getLinked().setShotsLeft(this.weapon.getLinked().getShotsLeft() + 1);
                WeaponHandler weaponHandler = (WeaponHandler)attackHandler;
                weaponHandler.handle(phase, vector);
                if (!weaponHandler.bMissed) {
                    return false;
                }
                bl3 = true;
            }
            if (bl3) {
                this.r = new Report(3130);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                this.r.indent();
                vector.addElement(this.r);
            }
        }
        if (this.toHit.getValue() == Integer.MAX_VALUE) {
            this.r = new Report(3135);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
            return false;
        }
        if (this.toHit.getValue() == 0x7FFFFFFE) {
            this.r = new Report(3140);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else if (this.toHit.getValue() == Integer.MIN_VALUE) {
            this.r = new Report(3145);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else {
            this.r = new Report(3150);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getValue());
            vector.addElement(this.r);
        }
        this.r = new Report(3155);
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.roll);
        vector.addElement(this.r);
        boolean bl4 = this.bMissed = this.roll < this.toHit.getValue();
        if (this.game.getOptions().booleanOption("maxtech_glancing_blows")) {
            if (this.roll == this.toHit.getValue()) {
                this.bGlancing = true;
                this.r = new Report(3186);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                this.bGlancing = false;
            }
        } else {
            this.bGlancing = false;
        }
        if (!bl3) {
            this.addHeat();
        }
        boolean bl5 = this.doChecks(vector);
        this.nDamPerHit = this.calcDamagePerHit();
        if (this.specialResolution(vector, entity, this.bMissed)) {
            return false;
        }
        if (this.bMissed && !bl5) {
            this.reportMiss(vector);
            if (!this.handleSpecialMiss(entity, bl, building, vector)) {
                return false;
            }
        }
        int n = this.calcHits(vector);
        int n2 = this.calcnCluster();
        if (this.ae instanceof Aero && this.target instanceof Aero) {
            if (n == 1 && n2 == 1) {
                this.nDamPerHit = this.attackValue;
            } else {
                this.nDamPerHit = 1;
                n = this.attackValue;
                n2 = 5;
            }
        }
        if (this.bMissed) {
            if (bl && building != null) {
                this.handleAccidentalBuildingDamage(vector, building, n, this.nDamPerHit);
            }
            return false;
        }
        int n3 = 0;
        if (bl && building != null) {
            n3 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
        }
        if (n == 0) {
            this.r = new Report(3365);
            this.r.subject = this.subjectId;
            vector.addElement(this.r);
        }
        while (n > 0) {
            if (this.target.getTargetType() == 2 || this.target.getTargetType() == 4) {
                this.handleIgnitionDamage(vector, building, this.bSalvo, n);
                return false;
            }
            if (this.target.getTargetType() == 1) {
                int n4 = this.nDamPerHit * n;
                this.handleClearDamage(vector, building, n4, this.bSalvo);
                return false;
            }
            if (this.target.getTargetType() == 3) {
                int n5 = this.nDamPerHit * n;
                this.handleBuildingDamage(vector, building, n5, this.bSalvo);
                return false;
            }
            if (entity == null) continue;
            this.handleEntityDamage(entity, vector, building, n, n2, this.nDamPerHit, n3);
            this.server.creditKill(entity, this.ae);
            n -= n2;
        }
        Report.addNewline(vector);
        return false;
    }

    protected boolean isNemesisConfusable() {
        boolean bl = false;
        AmmoType ammoType = (AmmoType)this.weapon.getLinked().getType();
        Mounted mounted = this.weapon.getLinkedBy();
        if (this.wtype.getAmmoType() == 28 || mounted != null && mounted.getType() instanceof MiscType && !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && mounted.getType().hasFlag(512L)) {
            if (!(this.weapon.getType().hasModes() && this.weapon.curMode().equals("Indirect") || (ammoType.getAmmoType() != 28 || ammoType.getMunitionType() != 0L && ammoType.getMunitionType() != 64L && ammoType.getMunitionType() != 128L) && (ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 4096L))) {
                bl = true;
            }
        } else if (!(this.wtype.getAmmoType() != 7 && this.wtype.getAmmoType() != 9 || ammoType.getMunitionType() != 2048L && ammoType.getMunitionType() != 512L)) {
            bl = true;
        }
        return bl;
    }

    @Override
    protected boolean usesClusterTable() {
        return true;
    }
}

