/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.BattleArmor;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.WeaponHandler;
import megamek.server.Server;

public class PulseLaserWeaponHandler
extends WeaponHandler {
    private static final long serialVersionUID = -5701939682138221449L;

    public PulseLaserWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    protected int calcDamagePerHit() {
        float f = this.wtype.getDamage();
        if (this.ae instanceof BattleArmor && this.weapon.getLocation() == 0 && this.ae.getSwarmTargetId() == this.target.getTargetId()) {
            f *= (float)((BattleArmor)this.ae).getShootingStrength();
        }
        int n = this.ae.getPosition().distance(this.target.getPosition());
        if (this.game.getOptions().booleanOption("maxtech_altdmg")) {
            if (n <= 1) {
                f += 1.0f;
            } else if (n > this.wtype.getMediumRange()) {
                if (n <= this.wtype.getLongRange()) {
                    f -= 1.0f;
                } else if (n <= this.wtype.getExtremeRange()) {
                    f = (int)Math.floor((double)f / 2.0);
                }
            }
        }
        if (this.bGlancing) {
            f = (int)Math.floor((double)f / 2.0);
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            f /= 10.0f;
            f += 2.0f;
        }
        return (int)Math.ceil(f);
    }
}

