/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.MissileWeapon;
import megamek.common.weapons.SRMAXHandler;
import megamek.common.weapons.SRMAntiTSMHandler;
import megamek.common.weapons.SRMDeadFireHandler;
import megamek.common.weapons.SRMFragHandler;
import megamek.common.weapons.SRMHandler;
import megamek.common.weapons.SRMInfernoHandler;
import megamek.common.weapons.SRMTandemChargeHandler;
import megamek.server.Server;

public abstract class SRMWeapon
extends MissileWeapon {
    public SRMWeapon() {
        this.ammoType = 9;
        this.atClass = 10;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        AmmoType ammoType = (AmmoType)iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId()).getLinked().getType();
        if (ammoType.getMunitionType() == 256L) {
            return new SRMFragHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 0x20000000L) {
            return new SRMAXHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 1024L) {
            return new SRMAntiTSMHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 0x10000000L) {
            return new SRMInfernoHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 8192L) {
            return new SRMDeadFireHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 32768L) {
            return new SRMTandemChargeHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return new SRMHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

