/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.io.Serializable;
import megamek.common.IGame;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.LRMSwarmHandler;
import megamek.common.weapons.LRMSwarmIHandler;
import megamek.common.weapons.WeaponHandler;
import megamek.server.Server;

public abstract class Weapon
extends WeaponType
implements Serializable {
    public Weapon() {
        this.ammoType = -1;
        this.minimumRange = Integer.MIN_VALUE;
    }

    public AttackHandler fire(WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        ToHitData toHitData = weaponAttackAction.toHit(iGame);
        AttackHandler attackHandler = this.getCorrectHandler(toHitData, weaponAttackAction, iGame, server);
        if (attackHandler instanceof LRMSwarmHandler || attackHandler instanceof LRMSwarmIHandler) {
            return attackHandler;
        }
        return toHitData.getValue() == Integer.MAX_VALUE ? null : attackHandler;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        return new WeaponHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

