/**
 * MegaMek - Copyright (C) 2004,2005 Ben Mazur (bmazur@sev.org)
 * 
 *  This program is free software; you can redistribute it and/or modify it 
 *  under the terms of the GNU General Public License as published by the Free 
 *  Software Foundation; either version 2 of the License, or (at your option) 
 *  any later version.
 * 
 *  This program is distributed in the hope that it will be useful, but 
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 *  for more details.
 */
/*
 * Created on Oct 15, 2004
 *
 */
package megamek.common.weapons;

import java.util.Vector;

import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.server.Server;

/**
 * @author Andrew Hunter
 */
public class LBXHandler extends AmmoWeaponHandler {
    /**
     * 
     */
    private static final long serialVersionUID = 6803847280685526644L;

    /**
     * @param t
     * @param w
     * @param g
     * @param s
     */
    public LBXHandler(ToHitData t, WeaponAttackAction w, IGame g, Server s) {
        super(t, w, g, s);
    }

    /*
     * (non-Javadoc)
     * 
     * @see megamek.common.weapons.WeaponHandler#calcDamagePerHit()
     */
    protected int calcDamagePerHit() {
        if (target instanceof Infantry && !(target instanceof BattleArmor)) {
            float toReturn = wtype.getDamage();
            toReturn /= 10;
            toReturn += 1;
            return (int) Math.ceil(toReturn);
        }
        return 1;
    }
    
    /**
     * Calculate the attack value based on range
     * 
     * @return an <code>int</code> representing the attack value at that range.
     */
    protected int calcAttackValue() {
        //basically 60% of racksize
        return (int)Math.floor(0.6*wtype.getRackSize());
    }

    /*
     * (non-Javadoc)
     * 
     * @see megamek.common.weapons.WeaponHandler#calcHits(Vector<Report>
     *      vPhaseReport)
     */
    protected int calcHits(Vector<Report> vPhaseReport) {
        // conventional infantry gets hit in one lump
        // BAs can't mount LBXs
        if (target instanceof Infantry && !(target instanceof BattleArmor)) {
            return 1;
        }
        int shotsHit = allShotsHit() ? wtype.getRackSize() : Compute
                .missilesHit(wtype.getRackSize());
        if (bGlancing) {
            shotsHit = (int) Math.floor(shotsHit / 2.0);
        }
        r = new Report(3325);
        r.subject = subjectId;
        r.add(shotsHit);
        r.add(" pellet(s) ");
        r.add(toHit.getTableDesc());
        r.newlines = 0;
        vPhaseReport.addElement(r);
        r = new Report(3345);
        r.subject = subjectId;
        r.newlines = 0;
        vPhaseReport.addElement(r);
        bSalvo = true;
        return shotsHit;
    }
    
    protected boolean usesClusterTable() {
        return ((AmmoType)ammo.getType()).getMunitionType() == AmmoType.M_CLUSTER;
    }
}
