/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Iterator;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.IMapSettingsObserver;
import megamek.client.ui.AWT.MapPreview;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.RandomMapDialog;
import megamek.common.Board;
import megamek.common.MapSettings;
import megamek.common.util.BoardUtilities;

public class BoardSelectionDialog
extends Dialog
implements ActionListener,
ItemListener,
KeyListener,
IMapSettingsObserver {
    private static final long serialVersionUID = 1498160432750299823L;
    private ClientGUI client;
    private MapSettings mapSettings;
    private RandomMapDialog randomMapDialog;
    private Panel panTypeChooser = new Panel();
    private Choice typeChooser = new Choice();
    private Panel panMapSize = new Panel();
    private Label labBoardSize = new Label(Messages.getString("BoardSelectionDialog.BoardSize"), 2);
    private Label labBoardDivider = new Label("x", 1);
    private TextField texBoardWidth = new TextField(2);
    private TextField texBoardHeight = new TextField(2);
    private Label labMapSize = new Label(Messages.getString("BoardSelectionDialog.MapSize"), 2);
    private Label labMapDivider = new Label("x", 1);
    private TextField texMapWidth = new TextField(2);
    private TextField texMapHeight = new TextField(2);
    private ScrollPane scrMapButtons = new ScrollPane(0);
    private Panel panMapButtons = new Panel();
    private Panel panBoardsSelected = new Panel();
    private Label labBoardsSelected = new Label(Messages.getString("BoardSelectionDialog.MapsSelected"), 1);
    private List lisBoardsSelected = new List(10);
    private Checkbox chkSelectAll = new Checkbox(Messages.getString("BoardSelectionDialog.SelectAll"));
    private Button butChange = new Button("<<");
    private Panel panBoardsAvailable = new Panel();
    private Label labBoardsAvailable = new Label(Messages.getString("BoardSelectionDialog.mapsAvailable"), 1);
    private List lisBoardsAvailable = new List(10);
    private Checkbox chkRotateBoard = new Checkbox(Messages.getString("BoardSelectionDialog.RotateBoard"));
    private Panel panButtons = new Panel();
    private Button butUpdate = new Button(Messages.getString("BoardSelectionDialog.UpdateSize"));
    private Button butRandomMap = new Button(Messages.getString("BoardSelectionDialog.GeneratedMapSettings"));
    private Label labButtonSpace = new Label("", 1);
    private Button butOkay = new Button(Messages.getString("Okay"));
    private Button butCancel = new Button(Messages.getString("Cancel"));
    private Button butPreview = new Button(Messages.getString("BoardSelectionDialog.Preview"));
    Dialog mapPreviewW;
    private boolean bDelayedSingleSelect = false;

    public BoardSelectionDialog(ClientGUI clientGUI) {
        super(clientGUI.frame, Messages.getString("BoardSelectionDialog.EditBoardLaout"), true);
        this.client = clientGUI;
        this.mapSettings = (MapSettings)clientGUI.getClient().getMapSettings().clone();
        this.setResizable(true);
        this.randomMapDialog = new RandomMapDialog(clientGUI.frame, this, this.mapSettings);
        this.setupMapChoice();
        this.setupMapSize();
        this.setupSelected();
        this.setupAvailable();
        this.setupButtons();
        this.butChange.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.panTypeChooser, gridBagConstraints);
        this.add(this.panTypeChooser);
        gridBagLayout.setConstraints(this.panMapSize, gridBagConstraints);
        this.add(this.panMapSize);
        gridBagLayout.setConstraints(this.panBoardsSelected, gridBagConstraints);
        this.add(this.panBoardsSelected);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.butChange, gridBagConstraints);
        this.add(this.butChange);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.panBoardsAvailable, gridBagConstraints);
        this.add(this.panBoardsAvailable);
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.add(this.panButtons);
        this.mapPreviewW = new Dialog(this.client.frame, Messages.getString("BoardSelectionDialog.MapPreview"), false);
        this.mapPreviewW.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BoardSelectionDialog.this.setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BoardSelectionDialog.this.setVisible(false);
                BoardSelectionDialog.this.mapPreviewW.setVisible(false);
            }
        });
        this.pack();
        this.setResizable(false);
        this.setLocation(clientGUI.frame.getLocation().x + clientGUI.frame.getSize().width / 2 - this.getSize().width / 2, clientGUI.frame.getLocation().y + clientGUI.frame.getSize().height / 2 - this.getSize().height / 2);
    }

    private void setupMapChoice() {
        this.typeChooser.add(MapSettings.getMediumName(0));
        this.typeChooser.add(MapSettings.getMediumName(1));
        this.typeChooser.add(MapSettings.getMediumName(2));
        this.typeChooser.addItemListener(this);
        this.refreshMapChoice();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panTypeChooser.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.typeChooser, gridBagConstraints);
        this.panTypeChooser.add(this.typeChooser);
    }

    private void setupMapSize() {
        this.refreshMapSize();
        this.refreshMapButtons();
        this.scrMapButtons.add(this.panMapButtons);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panMapSize.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.typeChooser, gridBagConstraints);
        this.panMapSize.add(this.typeChooser);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.labBoardSize, gridBagConstraints);
        this.panMapSize.add(this.labBoardSize);
        gridBagLayout.setConstraints(this.texBoardWidth, gridBagConstraints);
        this.panMapSize.add(this.texBoardWidth);
        gridBagLayout.setConstraints(this.labBoardDivider, gridBagConstraints);
        this.panMapSize.add(this.labBoardDivider);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.texBoardHeight, gridBagConstraints);
        this.panMapSize.add(this.texBoardHeight);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.labMapSize, gridBagConstraints);
        this.panMapSize.add(this.labMapSize);
        gridBagLayout.setConstraints(this.texMapWidth, gridBagConstraints);
        this.panMapSize.add(this.texMapWidth);
        gridBagLayout.setConstraints(this.labMapDivider, gridBagConstraints);
        this.panMapSize.add(this.labMapDivider);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.texMapHeight, gridBagConstraints);
        this.panMapSize.add(this.texMapHeight);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.scrMapButtons, gridBagConstraints);
        this.panMapSize.add(this.scrMapButtons);
    }

    private void setupSelected() {
        this.refreshBoardsSelected();
        this.lisBoardsSelected.addItemListener(this);
        this.lisBoardsSelected.addKeyListener(this);
        this.chkSelectAll.addItemListener(this);
        this.panBoardsSelected.setLayout(new BorderLayout());
        this.panBoardsSelected.add((Component)this.labBoardsSelected, "North");
        this.panBoardsSelected.add((Component)this.lisBoardsSelected, "Center");
        this.panBoardsSelected.add((Component)this.chkSelectAll, "South");
    }

    private void setupAvailable() {
        this.refreshBoardsAvailable();
        this.lisBoardsAvailable.addActionListener(this);
        this.panBoardsAvailable.setLayout(new BorderLayout());
        this.panBoardsAvailable.add((Component)this.labBoardsAvailable, "North");
        this.panBoardsAvailable.add((Component)this.lisBoardsAvailable, "Center");
        this.panBoardsAvailable.add((Component)this.chkRotateBoard, "South");
    }

    private void setupButtons() {
        this.butUpdate.addActionListener(this);
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.butRandomMap.addActionListener(this);
        this.butPreview.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butUpdate, gridBagConstraints);
        this.panButtons.add(this.butUpdate);
        gridBagLayout.setConstraints(this.butRandomMap, gridBagConstraints);
        this.panButtons.add(this.butRandomMap);
        gridBagLayout.setConstraints(this.butPreview, gridBagConstraints);
        this.panButtons.add(this.butPreview);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.labButtonSpace, gridBagConstraints);
        this.panButtons.add(this.labButtonSpace);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    private void refreshMapChoice() {
        this.typeChooser.select(this.mapSettings.getMedium());
    }

    private void refreshMapSize() {
        this.texBoardWidth.setText(new Integer(this.mapSettings.getBoardWidth()).toString());
        this.texBoardHeight.setText(new Integer(this.mapSettings.getBoardHeight()).toString());
        this.texMapWidth.setText(new Integer(this.mapSettings.getMapWidth()).toString());
        this.texMapHeight.setText(new Integer(this.mapSettings.getMapHeight()).toString());
    }

    private void refreshMapButtons() {
        this.panMapButtons.removeAll();
        this.panMapButtons.setLayout(new GridLayout(this.mapSettings.getMapHeight(), this.mapSettings.getMapWidth()));
        for (int i = 0; i < this.mapSettings.getMapHeight(); ++i) {
            for (int j = 0; j < this.mapSettings.getMapWidth(); ++j) {
                Button button = new Button(new Integer(i * this.mapSettings.getMapWidth() + j).toString());
                button.addActionListener(this);
                this.panMapButtons.add(button);
            }
        }
        this.scrMapButtons.validate();
    }

    private void refreshBoardsSelected() {
        this.lisBoardsSelected.removeAll();
        int n = 0;
        Iterator<String> iterator = this.mapSettings.getBoardsSelected();
        while (iterator.hasNext()) {
            this.lisBoardsSelected.add(n++ + ": " + iterator.next());
        }
        this.lisBoardsSelected.select(0);
        this.refreshSelectAllCheck();
    }

    private void refreshSelectAllCheck() {
        this.chkSelectAll.setState(this.lisBoardsSelected.getSelectedIndexes().length == this.lisBoardsSelected.getItemCount());
    }

    private void refreshBoardsAvailable() {
        this.lisBoardsAvailable.removeAll();
        Iterator<String> iterator = this.mapSettings.getBoardsAvailable();
        while (iterator.hasNext()) {
            this.lisBoardsAvailable.add(iterator.next());
        }
    }

    private void change(String string) {
        int[] nArray = this.lisBoardsSelected.getSelectedIndexes();
        for (int i = 0; i < nArray.length; ++i) {
            String string2 = string;
            if (!"[RANDOM]".equals(string2) && !"[SURPRISE]".equals(string2) && this.chkRotateBoard.getState()) {
                string2 = "rotate:" + string2;
            }
            this.lisBoardsSelected.replaceItem(nArray[i] + ": " + string2, nArray[i]);
            this.mapSettings.getBoardsSelectedVector().set(nArray[i], string2);
            this.lisBoardsSelected.select(nArray[i]);
        }
    }

    private void apply() {
        int n;
        int n2;
        int n3;
        int n4;
        try {
            n4 = Integer.parseInt(this.texBoardWidth.getText());
            n3 = Integer.parseInt(this.texBoardHeight.getText());
            n2 = Integer.parseInt(this.texMapWidth.getText());
            n = Integer.parseInt(this.texMapHeight.getText());
        }
        catch (NumberFormatException numberFormatException) {
            new AlertDialog(this.client.frame, Messages.getString("BoardSelectionDialog.InvalidMapSize"), Messages.getString("BoardSelectionDialog.InvalidNumberOfmaps")).setVisible(true);
            return;
        }
        if (n3 <= 0 || n3 <= 0 || n2 <= 0 || n <= 0) {
            new AlertDialog(this.client.frame, Messages.getString("BoardSelectionDialog.InvalidMapSize"), Messages.getString("BoardSelectionDialog.MapSizeMustBeGreateter0")).setVisible(true);
            return;
        }
        this.butOkay.setEnabled(false);
        this.mapSettings.setBoardSize(n4, n3);
        this.mapSettings.setMapSize(n2, n);
        this.randomMapDialog.setMapSettings(this.mapSettings);
        this.refreshMapSize();
        this.refreshMapButtons();
        this.lisBoardsSelected.removeAll();
        this.lisBoardsSelected.add(Messages.getString("BoardSelectionDialog.Updating"));
        this.lisBoardsAvailable.removeAll();
        this.lisBoardsAvailable.add(Messages.getString("BoardSelectionDialog.Updating"));
        this.client.getClient().sendMapQuery(this.mapSettings);
    }

    public void update(MapSettings mapSettings, boolean bl) {
        this.mapSettings = (MapSettings)mapSettings.clone();
        if (bl) {
            this.refreshMapSize();
            this.refreshMapButtons();
        }
        this.refreshBoardsSelected();
        this.refreshBoardsAvailable();
        this.butOkay.setEnabled(true);
    }

    public void send() {
        if (!(this.texBoardWidth.getText().equals(Integer.toString(this.mapSettings.getBoardWidth())) && this.texBoardHeight.getText().equals(Integer.toString(this.mapSettings.getBoardHeight())) && this.texMapWidth.getText().equals(Integer.toString(this.mapSettings.getMapWidth())) && this.texMapHeight.getText().equals(Integer.toString(this.mapSettings.getMapHeight())))) {
            new AlertDialog(this.client.frame, Messages.getString("BoardSelectionDialog.UpdateMapSize.title"), Messages.getString("BoardSelectionDialog.UpdateMapSize.message")).setVisible(true);
            return;
        }
        if (this.mapSettings.getBoardsAvailableVector().size() <= 0) {
            new AlertDialog(this.client.frame, Messages.getString("BoardSelectionDialog.NoBoardOfSelectedSize.title"), Messages.getString("BoardSelectionDialog.NoBoardOfSelectedSize.message")).setVisible(true);
            return;
        }
        if (this.typeChooser.getSelectedIndex() == 2) {
            this.mapSettings.setMedium(2);
        } else if (this.typeChooser.getSelectedIndex() == 1) {
            this.mapSettings.setMedium(1);
        } else if (this.typeChooser.getSelectedIndex() == 0) {
            this.mapSettings.setMedium(0);
        }
        this.client.getClient().sendMapSettings(this.mapSettings);
        this.setVisible(false);
        this.mapPreviewW.setVisible(false);
    }

    public void previewBoard() {
        String string = this.lisBoardsAvailable.getSelectedItem();
        if (this.lisBoardsAvailable.getSelectedIndex() > 2) {
            Board board = new Board(new Integer(this.texBoardWidth.getText()), new Integer(this.texBoardHeight.getText()));
            board.load(string + ".board");
            if (this.chkRotateBoard.getState()) {
                BoardUtilities.flip(board, true, true);
            }
            MapPreview mapPreview = null;
            try {
                mapPreview = new MapPreview(this.mapPreviewW, board);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.mapPreviewW.removeAll();
            this.mapPreviewW.add(mapPreview);
            this.mapPreviewW.setVisible(true);
            mapPreview.initializeMap();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butChange || actionEvent.getSource() == this.lisBoardsAvailable) {
            if (this.lisBoardsAvailable.getSelectedIndex() != -1) {
                this.change(this.lisBoardsAvailable.getSelectedItem());
            }
        } else if (actionEvent.getSource() == this.butUpdate) {
            this.apply();
        } else if (actionEvent.getSource() == this.butOkay) {
            this.send();
        } else if (actionEvent.getSource() == this.butCancel) {
            this.setVisible(false);
            this.mapPreviewW.setVisible(false);
        } else if (actionEvent.getSource() == this.butRandomMap) {
            this.randomMapDialog.setVisible(true);
        } else if (actionEvent.getSource() == this.butPreview) {
            this.previewBoard();
        } else {
            try {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                this.lisBoardsSelected.select(n);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.chkSelectAll) {
            this.lisBoardsSelected.setMultipleMode(this.chkSelectAll.getState());
            for (int i = 0; i < this.lisBoardsSelected.getItemCount(); ++i) {
                if (this.chkSelectAll.getState()) {
                    this.lisBoardsSelected.select(i);
                    continue;
                }
                this.lisBoardsSelected.deselect(i);
            }
        } else if (itemEvent.getSource() == this.lisBoardsSelected) {
            if (this.bDelayedSingleSelect) {
                this.lisBoardsSelected.setMultipleMode(false);
            }
            this.refreshSelectAllCheck();
        } else if (itemEvent.getSource() != this.typeChooser || this.typeChooser.getSelectedIndex() == 2 || this.typeChooser.getSelectedIndex() == 1 || this.typeChooser.getSelectedIndex() == 0) {
            // empty if block
        }
    }

    public void updateMapSettings(MapSettings mapSettings) {
        this.mapSettings = mapSettings;
        this.refreshMapSize();
        this.refreshMapButtons();
        this.lisBoardsSelected.removeAll();
        this.lisBoardsSelected.add(Messages.getString("BoardSelectionDialog.Updating"));
        this.lisBoardsAvailable.removeAll();
        this.lisBoardsAvailable.add(Messages.getString("BoardSelectionDialog.Updating"));
        this.client.getClient().sendMapQuery(mapSettings);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17) {
            System.out.println("Multiple on!");
            this.lisBoardsSelected.setMultipleMode(true);
            this.bDelayedSingleSelect = false;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17) {
            System.out.println("Multiple off!");
            this.bDelayedSingleSelect = true;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

