/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import gov.nist.gui.TabPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import megamek.client.ui.AWT.ClientGUI;
import megamek.client.ui.AWT.DialogOptionComponent;
import megamek.client.ui.AWT.DialogOptionListener;
import megamek.client.ui.AWT.Messages;
import megamek.common.options.GameOptions;
import megamek.common.options.IBasicOption;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameOptionsDialog
extends Dialog
implements ActionListener,
DialogOptionListener {
    private static final long serialVersionUID = -4076751608068469452L;
    private ClientGUI client;
    private GameOptions options;
    private boolean editable = true;
    private Vector<DialogOptionComponent> optionComps = new Vector();
    private int maxOptionWidth = 0;
    private TabPanel panOptions;
    private Panel groupPanel;
    private ScrollPane scrOptions = new ScrollPane();
    private TextArea texDesc = new TextArea(Messages.getString("GameOptionsDialog.optionDescriptionHint"), 3, 35, 1);
    private Panel panPassword = new Panel();
    private Label labPass = new Label(Messages.getString("GameOptionsDialog.Password"));
    private TextField texPass = new TextField(15);
    private Panel panButtons = new Panel();
    private Button butDefaults = new Button(Messages.getString("GameOptionsDialog.Defaults"));
    private Button butOkay = new Button(Messages.getString("Okay"));
    private Button butCancel = new Button(Messages.getString("Cancel"));
    private Frame currentFrame = new Frame();

    private void init(Frame frame, GameOptions gameOptions) {
        this.options = gameOptions;
        this.currentFrame = frame;
        this.panOptions = new TabPanel();
        this.texDesc.setEditable(false);
        this.setupButtons();
        this.setupPassword();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.panOptions, gridBagConstraints);
        this.add(this.panOptions);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.texDesc, gridBagConstraints);
        this.add(this.texDesc);
        gridBagLayout.setConstraints(this.panPassword, gridBagConstraints);
        this.add(this.panPassword);
        gridBagLayout.setConstraints(this.panButtons, gridBagConstraints);
        this.add(this.panButtons);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GameOptionsDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setSize(this.getSize().width, Math.max(this.getSize().height, 400));
        this.setResizable(true);
        this.setLocation(frame.getLocation().x + frame.getSize().width / 2 - this.getSize().width / 2, frame.getLocation().y + frame.getSize().height / 2 - this.getSize().height / 2);
    }

    public GameOptionsDialog(ClientGUI clientGUI) {
        super(clientGUI.frame, Messages.getString("GameOptionsDialog.title"), true);
        this.client = clientGUI;
        this.init(clientGUI.frame, clientGUI.getClient().game.getOptions());
    }

    public GameOptionsDialog(Frame frame, GameOptions gameOptions) {
        super(frame, Messages.getString("GameOptionsDialog.title"), true);
        this.init(frame, gameOptions);
        this.butOkay.setEnabled(false);
    }

    public void update(GameOptions gameOptions) {
        this.options = gameOptions;
        this.refreshOptions();
    }

    public void send() {
        Vector<IBasicOption> vector = new Vector<IBasicOption>();
        Enumeration<DialogOptionComponent> enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = enumeration.nextElement();
            if (!dialogOptionComponent.hasChanged()) continue;
            vector.addElement(dialogOptionComponent.changedOption());
        }
        if (this.client != null && vector.size() > 0) {
            this.client.getClient().sendGameOptions(this.texPass.getText(), vector);
        }
    }

    public void doSave() {
        GameOptions.saveOptions(this.getOptions());
    }

    public Vector<IBasicOption> getOptions() {
        Vector<IBasicOption> vector = new Vector<IBasicOption>();
        Enumeration<DialogOptionComponent> enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = enumeration.nextElement();
            IBasicOption iBasicOption = dialogOptionComponent.changedOption();
            vector.addElement(iBasicOption);
        }
        return vector;
    }

    public void resetToDefaults() {
        Enumeration<DialogOptionComponent> enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = enumeration.nextElement();
            dialogOptionComponent.resetToDefault();
        }
    }

    private void refreshOptions() {
        this.panOptions.removeAll();
        this.optionComps.clear();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 0, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        Enumeration<IOptionGroup> enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = enumeration.nextElement();
            this.addGroup(iOptionGroup, gridBagLayout, gridBagConstraints);
            Enumeration<IOption> enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = enumeration2.nextElement();
                this.addOption(iOption, gridBagLayout, gridBagConstraints);
            }
        }
        this.setSize(Math.min(this.currentFrame.getSize().width, this.maxOptionWidth + 30), Math.max(this.getSize().height, 400));
        this.validate();
    }

    private void addGroup(IOptionGroup iOptionGroup, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        this.groupPanel = new Panel();
        this.scrOptions = new ScrollPane();
        this.groupPanel.setLayout(gridBagLayout);
        this.scrOptions.add(this.groupPanel);
        this.scrOptions.getVAdjustable().setUnitIncrement(10);
        gridBagLayout.setConstraints(this.groupPanel, gridBagConstraints);
        this.panOptions.add(iOptionGroup.getDisplayableName(), this.scrOptions);
    }

    private void addOption(IOption iOption, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        DialogOptionComponent dialogOptionComponent = new DialogOptionComponent(this, iOption);
        gridBagLayout.setConstraints(dialogOptionComponent, gridBagConstraints);
        this.groupPanel.add(dialogOptionComponent);
        this.maxOptionWidth = Math.max(this.maxOptionWidth, dialogOptionComponent.getPreferredSize().width);
        if (iOption.getName().equals("hidden_units")) {
            dialogOptionComponent.setEditable(false);
        } else if (iOption.getName().equals("inf_deploy_even")) {
            if (!this.options.getOption("inf_move_even").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("inf_move_multi")) {
            if (this.options.getOption("inf_move_even").booleanValue() || this.options.getOption("inf_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("inf_move_even")) {
            if (this.options.getOption("inf_move_multi").booleanValue() || this.options.getOption("inf_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("inf_move_later")) {
            if (this.options.getOption("inf_move_even").booleanValue() || this.options.getOption("inf_move_multi").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("protos_deploy_even")) {
            if (!this.options.getOption("protos_move_even").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("protos_move_multi")) {
            if (this.options.getOption("protos_move_even").booleanValue() || this.options.getOption("protos_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("protos_move_even")) {
            if (this.options.getOption("protos_move_multi").booleanValue() || this.options.getOption("protos_move_later").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("protos_move_later")) {
            if (this.options.getOption("protos_move_even").booleanValue() || this.options.getOption("protos_move_multi").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("visibility")) {
            if (!this.options.getOption("double_blind").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else if (iOption.getName().equals("tacops_falling_expanded")) {
            if (!this.options.getOption("tacops_hull_down").booleanValue() || !this.editable) {
                dialogOptionComponent.setEditable(false);
            }
        } else {
            dialogOptionComponent.setEditable(this.editable);
        }
        this.optionComps.addElement(dialogOptionComponent);
    }

    @Override
    public void showDescFor(IOption iOption) {
        this.texDesc.setText(iOption.getDescription());
    }

    @Override
    public void optionClicked(DialogOptionComponent dialogOptionComponent, IOption iOption, boolean bl) {
        DialogOptionComponent dialogOptionComponent2;
        Enumeration<DialogOptionComponent> enumeration;
        if (iOption.getName().equals("inf_move_even")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("inf_deploy_even")) {
                    dialogOptionComponent2.setEditable(bl);
                    dialogOptionComponent2.setState(false);
                }
                if (dialogOptionComponent2.option.getName().equals("inf_move_multi")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("inf_move_later")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("inf_move_multi")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("inf_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("inf_move_later")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("inf_move_later")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("inf_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("inf_move_multi")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("protos_move_even")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("protos_deploy_even")) {
                    dialogOptionComponent2.setEditable(bl);
                    dialogOptionComponent2.setState(false);
                }
                if (dialogOptionComponent2.option.getName().equals("protos_move_multi")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("protos_move_later")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("protos_move_multi")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("protos_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("protos_move_later")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("protos_move_later")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("protos_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                }
                if (!dialogOptionComponent2.option.getName().equals("protos_move_multi")) continue;
                dialogOptionComponent2.setEditable(!bl);
            }
        }
        if (iOption.getName().equals("individual_initiative")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = enumeration.nextElement();
                if (dialogOptionComponent2.option.getName().equals("protos_deploy_even")) {
                    dialogOptionComponent2.setEditable(false);
                    dialogOptionComponent2.setState(false);
                }
                if (dialogOptionComponent2.option.getName().equals("protos_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                    dialogOptionComponent2.setState(false);
                }
                if (dialogOptionComponent2.option.getName().equals("protos_move_multi")) {
                    dialogOptionComponent2.setEditable(!bl);
                    dialogOptionComponent2.setState(false);
                }
                if (dialogOptionComponent2.option.getName().equals("protos_move_later")) {
                    dialogOptionComponent2.setEditable(!bl);
                    dialogOptionComponent2.setState(false);
                }
                if (dialogOptionComponent2.option.getName().equals("inf_deploy_even")) {
                    dialogOptionComponent2.setEditable(false);
                    dialogOptionComponent2.setState(false);
                }
                if (dialogOptionComponent2.option.getName().equals("inf_move_even")) {
                    dialogOptionComponent2.setEditable(!bl);
                    dialogOptionComponent2.setState(false);
                }
                if (dialogOptionComponent2.option.getName().equals("inf_move_multi")) {
                    dialogOptionComponent2.setEditable(!bl);
                    dialogOptionComponent2.setState(false);
                }
                if (!dialogOptionComponent2.option.getName().equals("inf_move_later")) continue;
                dialogOptionComponent2.setEditable(!bl);
                dialogOptionComponent2.setState(false);
            }
        }
        if (iOption.getName().equals("vacuum")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = enumeration.nextElement();
                if (!dialogOptionComponent2.option.getName().equals("fire")) continue;
                dialogOptionComponent2.setEditable(!bl);
                dialogOptionComponent2.setState(false);
            }
        }
        if (iOption.getName().equals("double_blind")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = enumeration.nextElement();
                if (!dialogOptionComponent2.option.getName().equals("visibility")) continue;
                dialogOptionComponent2.setEditable(bl);
            }
        }
        if (iOption.getName().equals("tacops_hull_down")) {
            enumeration = this.optionComps.elements();
            while (enumeration.hasMoreElements()) {
                dialogOptionComponent2 = enumeration.nextElement();
                if (!dialogOptionComponent2.option.getName().equals("tacops_falling_expanded")) continue;
                dialogOptionComponent2.setEditable(bl);
                dialogOptionComponent2.setState(false);
            }
        }
    }

    private void setupButtons() {
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.butDefaults.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.panButtons.add(this.butOkay);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.butDefaults, gridBagConstraints);
        this.panButtons.add(this.butDefaults);
    }

    private void setupPassword() {
        this.panPassword.setLayout(new BorderLayout());
        this.panPassword.add((Component)this.labPass, "West");
        this.panPassword.add((Component)this.texPass, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butOkay) {
            if (this.client != null) {
                this.send();
            }
            this.doSave();
        } else {
            if (actionEvent.getSource() == this.butDefaults) {
                this.resetToDefaults();
                return;
            }
            if (actionEvent.getSource() == this.butCancel) {
                this.refreshOptions();
            }
        }
        this.setVisible(false);
    }

    public void setEditable(boolean bl) {
        Enumeration<DialogOptionComponent> enumeration = this.optionComps.elements();
        while (enumeration.hasMoreElements()) {
            DialogOptionComponent dialogOptionComponent = enumeration.nextElement();
            dialogOptionComponent.setEditable(bl);
        }
        this.texPass.setEnabled(bl);
        this.butOkay.setEnabled(bl);
        this.butDefaults.setEnabled(bl);
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }
}

