/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import megamek.client.ui.AWT.AlertDialog;
import megamek.client.ui.AWT.IMapSettingsObserver;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.widget.SimpleLine;
import megamek.common.MapSettings;

public class RandomMapDialog
extends Dialog
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = -1676096571134662220L;
    private static final String NONE = Messages.getString("RandomMapDialog.elevNONE");
    private static final String LOW = Messages.getString("RandomMapDialog.elevLow");
    private static final String MEDIUM = Messages.getString("RandomMapDialog.elevMedium");
    private static final String HIGH = Messages.getString("RandomMapDialog.elevHigh");
    private static final String INVALID_SETTING = Messages.getString("RandomMapDialog.InvalidSetting");
    private static final int NORMAL_LINE_WIDTH = 195;
    private static final int ADVANCED_LINE_WIDTH = 295;
    private ScrollPane scrAll = new ScrollPane();
    private Button butOK = null;
    private Button butAdvanced = null;
    private Button butSave = null;
    private Button butLoad = null;
    private Panel panButtons = null;
    private Panel panOptions = null;
    private Label labBoardSize = null;
    private TextField texBoardWidth = null;
    private TextField texBoardHeight = null;
    private Choice choElevation = null;
    private Choice choCliffs = null;
    private Choice choWoods = null;
    private Choice choLakes = null;
    private Choice choPavement = null;
    private Choice choRubble = null;
    private Choice choFortified = null;
    private Choice choIce = null;
    private Choice choRough = null;
    private Choice choRoads = null;
    private Choice choRivers = null;
    private Choice choSwamp = null;
    private Choice choCraters = null;
    private Choice choCity = null;
    private Choice choMountain = null;
    private Label labElevation = null;
    private Label labCliffs = null;
    private Label labWoods = null;
    private Label labLakes = null;
    private Label labPavement = null;
    private Label labRubble = null;
    private Label labFortified = null;
    private Label labIce = null;
    private Label labRough = null;
    private Label labRoads = null;
    private Label labRivers = null;
    private Label labSwamp = null;
    private Label labTheme = null;
    private Label labCraters = null;
    private Label labCity = null;
    private Label labMountain = null;
    private SimpleLine slElevation = null;
    private SimpleLine slCliffs = null;
    private SimpleLine slWoods = null;
    private SimpleLine slLakes = null;
    private SimpleLine slPavement = null;
    private SimpleLine slRubble = null;
    private SimpleLine slFortified = null;
    private SimpleLine slIce = null;
    private SimpleLine slRough = null;
    private SimpleLine slRoads = null;
    private SimpleLine slRivers = null;
    private SimpleLine slSwamp = null;
    private SimpleLine slBoardSize = null;
    private SimpleLine slCraters = null;
    private SimpleLine slCity = null;
    private SimpleLine slMountain = null;
    private SimpleLine slElevationAd = null;
    private SimpleLine slWoodsAd = null;
    private SimpleLine slLakesAd = null;
    private SimpleLine slPavementAd = null;
    private SimpleLine slRubbleAd = null;
    private SimpleLine slFortifiedAd = null;
    private SimpleLine slIceAd = null;
    private SimpleLine slRoughAd = null;
    private SimpleLine slRoadsAd = null;
    private SimpleLine slRiversAd = null;
    private SimpleLine slSwampAd = null;
    private SimpleLine slBoardSizeAd = null;
    private SimpleLine slCratersAd = null;
    private SimpleLine slCityAd = null;
    private SimpleLine slInvertNegativeAd = null;
    private TextField texTheme;
    private Label labHilliness;
    private TextField texHilliness;
    private Label labInvertNegative = null;
    private TextField texInvertNegative = null;
    private Label labRange;
    private TextField texRange;
    private Label labProbInvert;
    private TextField texProbInvert;
    private Label labCliffsAd;
    private TextField texCliffs;
    private Label labWaterSpots;
    private TextField texMinWaterSpots;
    private TextField texMaxWaterSpots;
    private Label labWaterSize;
    private TextField texMinWaterSize;
    private TextField texMaxWaterSize;
    private Label labProbDeep;
    private TextField texProbDeep;
    private Label labForestSpots;
    private TextField texMinForestSpots;
    private TextField texMaxForestSpots;
    private Label labForestSize;
    private TextField texMinForestSize;
    private TextField texMaxForestSize;
    private Label labProbHeavy;
    private TextField texProbHeavy;
    private Label labRoughSpots;
    private TextField texMinRoughSpots;
    private TextField texMaxRoughSpots;
    private Label labRoughSize;
    private TextField texMinRoughSize;
    private TextField texMaxRoughSize;
    private Label labSwampSpots;
    private TextField texMinSwampSpots;
    private TextField texMaxSwampSpots;
    private Label labSwampSize;
    private TextField texMinSwampSize;
    private TextField texMaxSwampSize;
    private Label labPavementSpots;
    private TextField texMinPavementSpots;
    private TextField texMaxPavementSpots;
    private Label labPavementSize;
    private TextField texMinPavementSize;
    private TextField texMaxPavementSize;
    private Label labIceSpots;
    private TextField texMinIceSpots;
    private TextField texMaxIceSpots;
    private Label labIceSize;
    private TextField texMinIceSize;
    private TextField texMaxIceSize;
    private Label labRubbleSpots;
    private TextField texMinRubbleSpots;
    private TextField texMaxRubbleSpots;
    private Label labRubbleSize;
    private TextField texMinRubbleSize;
    private TextField texMaxRubbleSize;
    private Label labFortifiedSpots;
    private TextField texMinFortifiedSpots;
    private TextField texMaxFortifiedSpots;
    private Label labFortifiedSize;
    private TextField texMinFortifiedSize;
    private TextField texMaxFortifiedSize;
    private Label labProbRoad;
    private TextField texProbRoad;
    private Label labProbRiver;
    private TextField texProbRiver;
    private Label labProbCrater;
    private TextField texProbCrater;
    private Label labRadius;
    private TextField texMinRadius;
    private TextField texMaxRadius;
    private Label labMaxCraters;
    private TextField texMaxCraters;
    private TextField texMinCraters;
    private Label labProbDrought;
    private TextField texProbDrought;
    private Label labProbFire;
    private TextField texProbFire;
    private Label labProbFlood;
    private TextField texProbFlood;
    private Label labProbFreeze;
    private TextField texProbFreeze;
    private Label labFxMod;
    private TextField texFxMod;
    private Label labCityBlocks;
    private Label labCityCF;
    private Label labCityFloors;
    private Label labCityDensity;
    private Label labTownSize;
    private TextField texCityBlocks;
    private TextField texCityMinCF;
    private TextField texCityMaxCF;
    private TextField texCityMinFloors;
    private TextField texCityMaxFloors;
    private TextField texCityDensity;
    private TextField texTownSize;
    private Label labMountainPeaks;
    private Label labMountainHeight;
    private Label labMountainWidth;
    private Label labMountainStyle;
    private TextField texMountainPeaks;
    private TextField texMountainStyle;
    private TextField texMountainHeightMin;
    private TextField texMountainHeightMax;
    private TextField texMountainWidthMin;
    private TextField texMountainWidthMax;
    private Label labAlgorithmToUse;
    private TextField texAlgorithmToUse;
    GridBagLayout gridbag;
    private MapSettings mapSettings = null;
    private Frame frame = null;
    private IMapSettingsObserver bsd = null;
    private boolean advanced = false;
    private boolean initiated = false;

    public RandomMapDialog(Frame frame, IMapSettingsObserver iMapSettingsObserver, MapSettings mapSettings) {
        super(frame, Messages.getString("RandomMapDialog.title"), true);
        this.mapSettings = mapSettings;
        this.frame = frame;
        this.bsd = iMapSettingsObserver;
        this.setResizable(true);
        this.createComponents();
        this.loadValues();
        this.setLayout(new BorderLayout());
        this.setupOptions();
        this.add((Component)this.scrAll, "Center");
        this.setupButtons();
        this.add((Component)this.panButtons, "South");
        this.validate();
        this.pack();
        this.setProperSize();
        this.butOK.requestFocus();
        this.setProperSize();
        this.setProperLocation();
        this.initiated = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.butOK)) {
            if (this.applyValues()) {
                this.setVisible(false);
            }
        } else if (actionEvent.getSource().equals(this.butSave)) {
            FileDialog fileDialog = new FileDialog(this.frame, Messages.getString("RandomMapDialog.FileSaveDialog"), 1);
            fileDialog.setDirectory("data" + File.separatorChar + "boards");
            fileDialog.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".xml");
                }
            });
            fileDialog.setModal(true);
            fileDialog.setVisible(true);
            String string = fileDialog.getDirectory() + File.separator + fileDialog.getFile();
            if (string.indexOf(46) == -1) {
                string = string + ".xml";
            }
            File file = new File(string);
            try {
                this.mapSettings.save(new FileOutputStream(file));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (actionEvent.getSource().equals(this.butLoad)) {
            FileDialog fileDialog = new FileDialog(this.frame, Messages.getString("RandomMapDialog.FileLoadDialog"), 0);
            fileDialog.setDirectory("./data/boards/");
            fileDialog.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".xml");
                }
            });
            fileDialog.setModal(true);
            fileDialog.setVisible(true);
            File file = new File(fileDialog.getDirectory() + File.separator + fileDialog.getFile());
            try {
                this.mapSettings.load(new FileInputStream(file));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.loadValues();
            if (!this.advanced) {
                this.advanced = true;
                this.butAdvanced.setLabel(Messages.getString("RandomMapDialog.Normal"));
                this.setupOptions();
                this.setProperSize();
            }
        } else {
            boolean bl = this.advanced = !this.advanced;
            if (this.advanced) {
                this.butAdvanced.setLabel(Messages.getString("RandomMapDialog.Normal"));
            } else {
                this.butAdvanced.setLabel(Messages.getString("RandomMapDialog.Advanced"));
            }
            this.setupOptions();
            this.setProperSize();
        }
    }

    private void setupOptions() {
        this.panOptions.removeAll();
        this.addLabelTextField(this.labBoardSize, this.texBoardWidth, this.texBoardHeight, "x");
        this.texBoardWidth.requestFocus();
        if (!this.advanced) {
            this.addSeparator(this.slBoardSize);
            this.addLabelTextField(this.labTheme, this.texTheme);
            this.addOption(this.labElevation, this.choElevation, this.slElevation);
            this.addOption(this.labCliffs, this.choCliffs, this.slCliffs);
            this.addOption(this.labWoods, this.choWoods, this.slWoods);
            this.addOption(this.labRough, this.choRough, this.slRough);
            this.addOption(this.labSwamp, this.choSwamp, this.slSwamp);
            this.addOption(this.labRoads, this.choRoads, this.slRoads);
            this.addOption(this.labLakes, this.choLakes, this.slLakes);
            this.addOption(this.labRivers, this.choRivers, this.slRivers);
            this.addOption(this.labCraters, this.choCraters, this.slCraters);
            this.addOption(this.labPavement, this.choPavement, this.slPavement);
            this.addOption(this.labIce, this.choIce, this.slIce);
            this.addOption(this.labRubble, this.choRubble, this.slRubble);
            this.addOption(this.labFortified, this.choFortified, this.slFortified);
            this.addOption(this.labCity, this.choCity, this.slCity);
            this.addOption(this.labMountain, this.choMountain, this.slMountain);
        } else {
            this.addSeparator(this.slBoardSizeAd);
            this.addLabelTextField(this.labTheme, this.texTheme);
            this.addLabelTextField(this.labHilliness, this.texHilliness);
            this.addLabelTextField(this.labRange, this.texRange);
            this.addLabelTextField(this.labProbInvert, this.texProbInvert);
            this.addLabelTextField(this.labAlgorithmToUse, this.texAlgorithmToUse);
            this.addLabelTextField(this.labCliffsAd, this.texCliffs);
            this.addLabelTextField(this.labMountainPeaks, this.texMountainPeaks);
            this.addLabelTextField(this.labMountainStyle, this.texMountainStyle);
            this.addLabelTextField(this.labMountainHeight, this.texMountainHeightMin, this.texMountainHeightMax, "-");
            this.addLabelTextField(this.labMountainWidth, this.texMountainWidthMin, this.texMountainWidthMax, "-");
            this.addSeparator(this.slElevationAd);
            this.addLabelTextField(this.labForestSpots, this.texMinForestSpots, this.texMaxForestSpots, "-");
            this.addLabelTextField(this.labForestSize, this.texMinForestSize, this.texMaxForestSize, "-");
            this.addLabelTextField(this.labProbHeavy, this.texProbHeavy);
            this.addSeparator(this.slWoodsAd);
            this.addLabelTextField(this.labRoughSpots, this.texMinRoughSpots, this.texMaxRoughSpots, "-");
            this.addLabelTextField(this.labRoughSize, this.texMinRoughSize, this.texMaxRoughSize, "-");
            this.addSeparator(this.slRoughAd);
            this.addLabelTextField(this.labSwampSpots, this.texMinSwampSpots, this.texMaxSwampSpots, "-");
            this.addLabelTextField(this.labSwampSize, this.texMinSwampSize, this.texMaxSwampSize, "-");
            this.addSeparator(this.slSwampAd);
            this.addLabelTextField(this.labProbRoad, this.texProbRoad);
            this.addSeparator(this.slRoadsAd);
            this.addLabelTextField(this.labWaterSpots, this.texMinWaterSpots, this.texMaxWaterSpots, "-");
            this.addLabelTextField(this.labWaterSize, this.texMinWaterSize, this.texMaxWaterSize, "-");
            this.addLabelTextField(this.labProbDeep, this.texProbDeep);
            this.addSeparator(this.slLakesAd);
            this.addLabelTextField(this.labProbRiver, this.texProbRiver);
            this.addSeparator(this.slRiversAd);
            this.addLabelTextField(this.labProbCrater, this.texProbCrater);
            this.addLabelTextField(this.labMaxCraters, this.texMinCraters, this.texMaxCraters, "-");
            this.addLabelTextField(this.labRadius, this.texMinRadius, this.texMaxRadius, "-");
            this.addSeparator(this.slCratersAd);
            this.addLabelTextField(this.labPavementSpots, this.texMinPavementSpots, this.texMaxPavementSpots, "-");
            this.addLabelTextField(this.labPavementSize, this.texMinPavementSize, this.texMaxPavementSize, "-");
            this.addSeparator(this.slPavementAd);
            this.addLabelTextField(this.labRubbleSpots, this.texMinRubbleSpots, this.texMaxRubbleSpots, "-");
            this.addLabelTextField(this.labRubbleSize, this.texMinRubbleSize, this.texMaxRubbleSize, "-");
            this.addSeparator(this.slRubbleAd);
            this.addLabelTextField(this.labFortifiedSpots, this.texMinFortifiedSpots, this.texMaxFortifiedSpots, "-");
            this.addLabelTextField(this.labFortifiedSize, this.texMinFortifiedSize, this.texMaxFortifiedSize, "-");
            this.addSeparator(this.slFortifiedAd);
            this.addLabelTextField(this.labIceSpots, this.texMinIceSpots, this.texMaxIceSpots, "-");
            this.addLabelTextField(this.labIceSize, this.texMinIceSize, this.texMaxIceSize, "-");
            this.addSeparator(this.slIceAd);
            this.addLabelTextField(this.labProbDrought, this.texProbDrought);
            this.addLabelTextField(this.labProbFire, this.texProbFire);
            this.addLabelTextField(this.labProbFreeze, this.texProbFreeze);
            this.addLabelTextField(this.labProbFlood, this.texProbFlood);
            this.addLabelTextField(this.labFxMod, this.texFxMod);
            this.addSeparator(this.slCityAd);
            this.addOption(this.labCity, this.choCity, this.slCity);
            this.addLabelTextField(this.labCityBlocks, this.texCityBlocks);
            this.addLabelTextField(this.labCityCF, this.texCityMinCF, this.texCityMaxCF, "-");
            this.addLabelTextField(this.labCityFloors, this.texCityMinFloors, this.texCityMaxFloors, "-");
            this.addLabelTextField(this.labCityDensity, this.texCityDensity);
            this.addLabelTextField(this.labTownSize, this.texTownSize);
            this.addSeparator(this.slInvertNegativeAd);
            this.addLabelTextField(this.labInvertNegative, this.texInvertNegative);
        }
        this.scrAll.add(this.panOptions);
        if (this.initiated) {
            this.pack();
            this.setProperSize();
            this.setProperLocation();
        }
    }

    private void setupButtons() {
        this.panButtons.add(this.butOK);
        this.panButtons.add(this.butAdvanced);
        this.panButtons.add(this.butSave);
        this.panButtons.add(this.butLoad);
    }

    private void createComponents() {
        this.butOK = new Button(Messages.getString("Okay"));
        this.butOK.addActionListener(this);
        this.butAdvanced = new Button(Messages.getString("RandomMapDialog.Advanced"));
        this.butAdvanced.addActionListener(this);
        this.butSave = new Button(Messages.getString("RandomMapDialog.Save"));
        this.butSave.addActionListener(this);
        this.butLoad = new Button(Messages.getString("RandomMapDialog.Load"));
        this.butLoad.addActionListener(this);
        this.panButtons = new Panel();
        this.panButtons.setLayout(new FlowLayout());
        this.panOptions = new Panel();
        this.gridbag = new GridBagLayout();
        this.panOptions.setLayout(this.gridbag);
        this.labBoardSize = new Label(Messages.getString("RandomMapDialog.BoardSize"), 0);
        this.texBoardWidth = new TextField(2);
        this.texBoardWidth.addFocusListener(this);
        this.texBoardHeight = new TextField(2);
        this.texBoardHeight.addFocusListener(this);
        this.slBoardSize = new SimpleLine(195);
        this.labElevation = new Label(Messages.getString("RandomMapDialog.labElevation"), 0);
        this.choElevation = new Choice();
        this.fillChoice(this.choElevation);
        this.slElevation = new SimpleLine(195);
        this.labCliffs = new Label(Messages.getString("RandomMapDialog.labCliffs"), 0);
        this.choCliffs = new Choice();
        this.fillChoice(this.choCliffs);
        this.slCliffs = new SimpleLine(195);
        this.labWoods = new Label(Messages.getString("RandomMapDialog.labWoods"), 0);
        this.choWoods = new Choice();
        this.fillChoice(this.choWoods);
        this.slWoods = new SimpleLine(195);
        this.labLakes = new Label(Messages.getString("RandomMapDialog.labLakes"), 0);
        this.choLakes = new Choice();
        this.fillChoice(this.choLakes);
        this.slLakes = new SimpleLine(195);
        this.labRough = new Label(Messages.getString("RandomMapDialog.labRough"), 0);
        this.choRough = new Choice();
        this.fillChoice(this.choRough);
        this.slRough = new SimpleLine(195);
        this.labSwamp = new Label(Messages.getString("RandomMapDialog.labSwamp"), 0);
        this.choSwamp = new Choice();
        this.fillChoice(this.choSwamp);
        this.slSwamp = new SimpleLine(195);
        this.labPavement = new Label(Messages.getString("RandomMapDialog.labPavement"), 0);
        this.choPavement = new Choice();
        this.fillChoice(this.choPavement);
        this.slPavement = new SimpleLine(195);
        this.labRubble = new Label(Messages.getString("RandomMapDialog.labRubble"), 0);
        this.choRubble = new Choice();
        this.fillChoice(this.choRubble);
        this.slRubble = new SimpleLine(195);
        this.labFortified = new Label(Messages.getString("RandomMapDialog.labFortified"), 0);
        this.choFortified = new Choice();
        this.fillChoice(this.choFortified);
        this.slFortified = new SimpleLine(195);
        this.labIce = new Label(Messages.getString("RandomMapDialog.labIce"), 0);
        this.choIce = new Choice();
        this.fillChoice(this.choIce);
        this.slIce = new SimpleLine(195);
        this.labCraters = new Label(Messages.getString("RandomMapDialog.labCraters"), 0);
        this.choCraters = new Choice();
        this.fillChoice(this.choCraters);
        this.slCraters = new SimpleLine(195);
        this.labRivers = new Label(Messages.getString("RandomMapDialog.labRivers"), 0);
        this.choRivers = new Choice();
        this.fillChoice(this.choRivers);
        this.slRivers = new SimpleLine(195);
        this.labRoads = new Label(Messages.getString("RandomMapDialog.labRoads"), 0);
        this.choRoads = new Choice();
        this.fillChoice(this.choRoads);
        this.slRoads = new SimpleLine(195);
        this.labCity = new Label(Messages.getString("RandomMapDialog.labCity"), 0);
        this.choCity = new Choice();
        this.choCity.add(NONE);
        this.choCity.add("HUB");
        this.choCity.add("GRID");
        this.choCity.add("METRO");
        this.choCity.add("TOWN");
        this.slCity = new SimpleLine(195);
        this.labMountain = new Label(Messages.getString("RandomMapDialog.labMountain"), 0);
        this.choMountain = new Choice();
        this.fillChoice(this.choMountain);
        this.slMountain = new SimpleLine(195);
        this.labTheme = new Label(Messages.getString("RandomMapDialog.labTheme"), 0);
        this.texTheme = new TextField(20);
        this.labHilliness = new Label(Messages.getString("RandomMapDialog.labHilliness"), 0);
        this.texHilliness = new TextField(2);
        this.texHilliness.addFocusListener(this);
        this.labRange = new Label(Messages.getString("RandomMapDialog.labRange"), 0);
        this.texRange = new TextField(2);
        this.texRange.addFocusListener(this);
        this.labProbInvert = new Label(Messages.getString("RandomMapDialog.labProbInvert"), 0);
        this.texProbInvert = new TextField(2);
        this.texProbInvert.addFocusListener(this);
        this.labCliffsAd = new Label(Messages.getString("RandomMapDialog.labCliffs"), 0);
        this.texCliffs = new TextField(2);
        this.texCliffs.addFocusListener(this);
        this.labMountainHeight = new Label(Messages.getString("RandomMapDialog.labMountainHeight"), 0);
        this.labMountainWidth = new Label(Messages.getString("RandomMapDialog.labMountainWidth"), 0);
        this.labMountainPeaks = new Label(Messages.getString("RandomMapDialog.labMountainPeaks"), 0);
        this.labMountainStyle = new Label(Messages.getString("RandomMapDialog.labMountainStyle"), 0);
        this.texMountainPeaks = new TextField(2);
        this.texMountainPeaks.addFocusListener(this);
        this.texMountainHeightMin = new TextField(2);
        this.texMountainHeightMin.addFocusListener(this);
        this.texMountainHeightMax = new TextField(2);
        this.texMountainHeightMax.addFocusListener(this);
        this.texMountainWidthMin = new TextField(2);
        this.texMountainWidthMin.addFocusListener(this);
        this.texMountainWidthMax = new TextField(2);
        this.texMountainWidthMax.addFocusListener(this);
        this.texMountainStyle = new TextField(2);
        this.texMountainStyle.addFocusListener(this);
        this.labWaterSpots = new Label(Messages.getString("RandomMapDialog.labWaterSpots"), 0);
        this.texMinWaterSpots = new TextField(2);
        this.texMinWaterSpots.addFocusListener(this);
        this.texMaxWaterSpots = new TextField(2);
        this.texMaxWaterSpots.addFocusListener(this);
        this.labWaterSize = new Label(Messages.getString("RandomMapDialog.labWaterSize"), 0);
        this.texMinWaterSize = new TextField(2);
        this.texMinWaterSize.addFocusListener(this);
        this.texMaxWaterSize = new TextField(2);
        this.texMaxWaterSize.addFocusListener(this);
        this.labProbDeep = new Label(Messages.getString("RandomMapDialog.labProbDeep"), 0);
        this.texProbDeep = new TextField(2);
        this.texProbDeep.addFocusListener(this);
        this.labForestSpots = new Label(Messages.getString("RandomMapDialog.labForestSpots"), 0);
        this.texMinForestSpots = new TextField(2);
        this.texMinForestSpots.addFocusListener(this);
        this.texMaxForestSpots = new TextField(2);
        this.texMaxForestSpots.addFocusListener(this);
        this.labForestSize = new Label(Messages.getString("RandomMapDialog.labForestSize"), 0);
        this.texMinForestSize = new TextField(2);
        this.texMinForestSize.addFocusListener(this);
        this.texMaxForestSize = new TextField(2);
        this.texMaxForestSize.addFocusListener(this);
        this.labProbHeavy = new Label(Messages.getString("RandomMapDialog.labProbHeavy"), 0);
        this.texProbHeavy = new TextField(2);
        this.texProbHeavy.addFocusListener(this);
        this.labRoughSpots = new Label(Messages.getString("RandomMapDialog.labRoughSpots"), 0);
        this.texMinRoughSpots = new TextField(2);
        this.texMinRoughSpots.addFocusListener(this);
        this.texMaxRoughSpots = new TextField(2);
        this.texMaxRoughSpots.addFocusListener(this);
        this.labRoughSize = new Label(Messages.getString("RandomMapDialog.labRoughSize"), 0);
        this.texMinRoughSize = new TextField(2);
        this.texMinRoughSize.addFocusListener(this);
        this.texMaxRoughSize = new TextField(2);
        this.texMaxRoughSize.addFocusListener(this);
        this.labSwampSpots = new Label(Messages.getString("RandomMapDialog.labSwampSpots"), 0);
        this.texMinSwampSpots = new TextField(2);
        this.texMinSwampSpots.addFocusListener(this);
        this.texMaxSwampSpots = new TextField(2);
        this.texMaxSwampSpots.addFocusListener(this);
        this.labSwampSize = new Label(Messages.getString("RandomMapDialog.labSwampSize"), 0);
        this.texMinSwampSize = new TextField(2);
        this.texMinSwampSize.addFocusListener(this);
        this.texMaxSwampSize = new TextField(2);
        this.texMaxSwampSize.addFocusListener(this);
        this.labPavementSpots = new Label(Messages.getString("RandomMapDialog.labPavementSpots"), 0);
        this.texMinPavementSpots = new TextField(2);
        this.texMinPavementSpots.addFocusListener(this);
        this.texMaxPavementSpots = new TextField(2);
        this.texMaxPavementSpots.addFocusListener(this);
        this.labPavementSize = new Label(Messages.getString("RandomMapDialog.labPavementSize"), 0);
        this.texMinPavementSize = new TextField(2);
        this.texMinPavementSize.addFocusListener(this);
        this.texMaxPavementSize = new TextField(2);
        this.texMaxPavementSize.addFocusListener(this);
        this.labRubbleSpots = new Label(Messages.getString("RandomMapDialog.labRubbleSpots"), 0);
        this.texMinRubbleSpots = new TextField(2);
        this.texMinRubbleSpots.addFocusListener(this);
        this.texMaxRubbleSpots = new TextField(2);
        this.texMaxRubbleSpots.addFocusListener(this);
        this.labRubbleSize = new Label(Messages.getString("RandomMapDialog.labRubbleSize"), 0);
        this.texMinRubbleSize = new TextField(2);
        this.texMinRubbleSize.addFocusListener(this);
        this.texMaxRubbleSize = new TextField(2);
        this.texMaxRubbleSize.addFocusListener(this);
        this.labFortifiedSpots = new Label(Messages.getString("RandomMapDialog.labFortifiedSpots"), 0);
        this.texMinFortifiedSpots = new TextField(2);
        this.texMinFortifiedSpots.addFocusListener(this);
        this.texMaxFortifiedSpots = new TextField(2);
        this.texMaxFortifiedSpots.addFocusListener(this);
        this.labFortifiedSize = new Label(Messages.getString("RandomMapDialog.labFortifiedSize"), 0);
        this.texMinFortifiedSize = new TextField(2);
        this.texMinFortifiedSize.addFocusListener(this);
        this.texMaxFortifiedSize = new TextField(2);
        this.texMaxFortifiedSize.addFocusListener(this);
        this.labIceSpots = new Label(Messages.getString("RandomMapDialog.labIceSpots"), 0);
        this.texMinIceSpots = new TextField(2);
        this.texMinIceSpots.addFocusListener(this);
        this.texMaxIceSpots = new TextField(2);
        this.texMaxIceSpots.addFocusListener(this);
        this.labIceSize = new Label(Messages.getString("RandomMapDialog.labIceSize"), 0);
        this.texMinIceSize = new TextField(2);
        this.texMinIceSize.addFocusListener(this);
        this.texMaxIceSize = new TextField(2);
        this.texMaxIceSize.addFocusListener(this);
        this.labProbRoad = new Label(Messages.getString("RandomMapDialog.labProbRoad"), 0);
        this.texProbRoad = new TextField(2);
        this.texProbRoad.addFocusListener(this);
        this.labProbRiver = new Label(Messages.getString("RandomMapDialog.labProbRiver"), 0);
        this.texProbRiver = new TextField(2);
        this.texProbRiver.addFocusListener(this);
        this.labProbCrater = new Label(Messages.getString("RandomMapDialog.labProbCrater"), 0);
        this.texProbCrater = new TextField(2);
        this.texProbCrater.addFocusListener(this);
        this.labRadius = new Label(Messages.getString("RandomMapDialog.labRadius"), 0);
        this.texMinRadius = new TextField(2);
        this.texMinRadius.addFocusListener(this);
        this.texMaxRadius = new TextField(2);
        this.texMaxRadius.addFocusListener(this);
        this.labMaxCraters = new Label(Messages.getString("RandomMapDialog.labMaxCraters"), 0);
        this.texMaxCraters = new TextField(2);
        this.texMaxCraters.addFocusListener(this);
        this.texMinCraters = new TextField(2);
        this.texMinCraters.addFocusListener(this);
        this.labProbDrought = new Label(Messages.getString("RandomMapDialog.labProbDrought"), 0);
        this.labProbFire = new Label(Messages.getString("RandomMapDialog.labProbFire"), 0);
        this.labProbFreeze = new Label(Messages.getString("RandomMapDialog.labProbFreeze"), 0);
        this.labProbFlood = new Label(Messages.getString("RandomMapDialog.labProbFlood"), 0);
        this.labFxMod = new Label(Messages.getString("RandomMapDialog.labFxMod"), 0);
        this.texProbDrought = new TextField(2);
        this.texProbFire = new TextField(2);
        this.texProbFreeze = new TextField(2);
        this.texProbFlood = new TextField(2);
        this.texFxMod = new TextField(2);
        this.labCityBlocks = new Label(Messages.getString("RandomMapDialog.labCityBlocks"), 0);
        this.labCityCF = new Label(Messages.getString("RandomMapDialog.labCityCF"), 0);
        this.labCityFloors = new Label(Messages.getString("RandomMapDialog.labCityFloors"), 0);
        this.labCityDensity = new Label(Messages.getString("RandomMapDialog.labCityDensity"), 0);
        this.labTownSize = new Label(Messages.getString("RandomMapDialog.labTownSize"), 0);
        this.texCityBlocks = new TextField(2);
        this.texCityMinCF = new TextField(2);
        this.texCityMaxCF = new TextField(2);
        this.texCityMinFloors = new TextField(2);
        this.texCityMaxFloors = new TextField(2);
        this.texCityDensity = new TextField(2);
        this.texTownSize = new TextField(2);
        this.labInvertNegative = new Label(Messages.getString("RandomMapDialog.labInvertNegative"), 0);
        this.texInvertNegative = new TextField(1);
        this.labAlgorithmToUse = new Label(Messages.getString("RandomMapDialog.labAlgorithmToUse"), 0);
        this.texAlgorithmToUse = new TextField(2);
        this.slElevationAd = new SimpleLine(295);
        this.slWoodsAd = new SimpleLine(295);
        this.slLakesAd = new SimpleLine(295);
        this.slPavementAd = new SimpleLine(295);
        this.slRubbleAd = new SimpleLine(295);
        this.slFortifiedAd = new SimpleLine(295);
        this.slIceAd = new SimpleLine(295);
        this.slRoughAd = new SimpleLine(295);
        this.slRoadsAd = new SimpleLine(295);
        this.slRiversAd = new SimpleLine(295);
        this.slSwampAd = new SimpleLine(295);
        this.slBoardSizeAd = new SimpleLine(295);
        this.slCratersAd = new SimpleLine(295);
        this.slCityAd = new SimpleLine(295);
        this.slInvertNegativeAd = new SimpleLine(295);
    }

    private void addOption(Label label, Choice choice, SimpleLine simpleLine) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.gridbag.setConstraints(label, gridBagConstraints);
        this.panOptions.add(label);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.gridbag.setConstraints(choice, gridBagConstraints);
        this.panOptions.add(choice);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.gridbag.setConstraints(simpleLine, gridBagConstraints);
        this.panOptions.add(simpleLine);
    }

    private void fillChoice(Choice choice) {
        choice.add(NONE);
        choice.add(LOW);
        choice.add(MEDIUM);
        choice.add(HIGH);
    }

    private void addLabelTextField(Label label, TextField textField) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.gridbag.setConstraints(label, gridBagConstraints);
        this.panOptions.add(label);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.gridbag.setConstraints(textField, gridBagConstraints);
        this.panOptions.add(textField);
    }

    private void addLabelTextField(Label label, TextField textField, TextField textField2, String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.gridbag.setConstraints(label, gridBagConstraints);
        this.panOptions.add(label);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.gridbag.setConstraints(textField, gridBagConstraints);
        this.panOptions.add(textField);
        Label label2 = new Label(string, 1);
        this.gridbag.setConstraints(label2, gridBagConstraints);
        this.panOptions.add(label2);
        gridBagConstraints.gridwidth = 0;
        this.gridbag.setConstraints(textField2, gridBagConstraints);
        this.panOptions.add(textField2);
    }

    private void addSeparator(SimpleLine simpleLine) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.gridbag.setConstraints(simpleLine, gridBagConstraints);
        this.panOptions.add(simpleLine);
    }

    private void loadValues() {
        this.texBoardWidth.setText(new Integer(this.mapSettings.getBoardWidth()).toString());
        this.texBoardHeight.setText(new Integer(this.mapSettings.getBoardHeight()).toString());
        this.texTheme.setText(this.mapSettings.getTheme());
        this.texHilliness.setText(new Integer(this.mapSettings.getHilliness()).toString());
        this.texRange.setText(new Integer(this.mapSettings.getRange()).toString());
        this.texProbInvert.setText(new Integer(this.mapSettings.getProbInvert()).toString());
        this.texCliffs.setText(new Integer(this.mapSettings.getCliffs()).toString());
        this.texMinWaterSpots.setText(new Integer(this.mapSettings.getMinWaterSpots()).toString());
        this.texMaxWaterSpots.setText(new Integer(this.mapSettings.getMaxWaterSpots()).toString());
        this.texMinWaterSize.setText(new Integer(this.mapSettings.getMinWaterSize()).toString());
        this.texMaxWaterSize.setText(new Integer(this.mapSettings.getMaxWaterSize()).toString());
        this.texMinForestSpots.setText(new Integer(this.mapSettings.getMinForestSpots()).toString());
        this.texMaxForestSpots.setText(new Integer(this.mapSettings.getMaxForestSpots()).toString());
        this.texMinForestSize.setText(new Integer(this.mapSettings.getMinForestSize()).toString());
        this.texMaxForestSize.setText(new Integer(this.mapSettings.getMaxForestSize()).toString());
        this.texMinRoughSpots.setText(new Integer(this.mapSettings.getMinRoughSpots()).toString());
        this.texMaxRoughSpots.setText(new Integer(this.mapSettings.getMaxRoughSpots()).toString());
        this.texMinRoughSize.setText(new Integer(this.mapSettings.getMinRoughSize()).toString());
        this.texMaxRoughSize.setText(new Integer(this.mapSettings.getMaxRoughSize()).toString());
        this.texMinSwampSpots.setText(new Integer(this.mapSettings.getMinSwampSpots()).toString());
        this.texMaxSwampSpots.setText(new Integer(this.mapSettings.getMaxSwampSpots()).toString());
        this.texMinSwampSize.setText(new Integer(this.mapSettings.getMinSwampSize()).toString());
        this.texMaxSwampSize.setText(new Integer(this.mapSettings.getMaxSwampSize()).toString());
        this.texMinPavementSpots.setText(new Integer(this.mapSettings.getMinPavementSpots()).toString());
        this.texMaxPavementSpots.setText(new Integer(this.mapSettings.getMaxPavementSpots()).toString());
        this.texMinPavementSize.setText(new Integer(this.mapSettings.getMinPavementSize()).toString());
        this.texMaxPavementSize.setText(new Integer(this.mapSettings.getMaxPavementSize()).toString());
        this.texMinRubbleSpots.setText(new Integer(this.mapSettings.getMinRubbleSpots()).toString());
        this.texMaxRubbleSpots.setText(new Integer(this.mapSettings.getMaxRubbleSpots()).toString());
        this.texMinRubbleSize.setText(new Integer(this.mapSettings.getMinRubbleSize()).toString());
        this.texMaxRubbleSize.setText(new Integer(this.mapSettings.getMaxRubbleSize()).toString());
        this.texMinFortifiedSpots.setText(new Integer(this.mapSettings.getMinFortifiedSpots()).toString());
        this.texMaxFortifiedSpots.setText(new Integer(this.mapSettings.getMaxFortifiedSpots()).toString());
        this.texMinFortifiedSize.setText(new Integer(this.mapSettings.getMinFortifiedSize()).toString());
        this.texMaxFortifiedSize.setText(new Integer(this.mapSettings.getMaxFortifiedSize()).toString());
        this.texMinIceSpots.setText(new Integer(this.mapSettings.getMinIceSpots()).toString());
        this.texMaxIceSpots.setText(new Integer(this.mapSettings.getMaxIceSpots()).toString());
        this.texMinIceSize.setText(new Integer(this.mapSettings.getMinIceSize()).toString());
        this.texMaxIceSize.setText(new Integer(this.mapSettings.getMaxIceSize()).toString());
        this.texProbDeep.setText(new Integer(this.mapSettings.getProbDeep()).toString());
        this.texProbHeavy.setText(new Integer(this.mapSettings.getProbHeavy()).toString());
        this.texProbRiver.setText(new Integer(this.mapSettings.getProbRiver()).toString());
        this.texProbRoad.setText(new Integer(this.mapSettings.getProbRoad()).toString());
        this.texProbCrater.setText(new Integer(this.mapSettings.getProbCrater()).toString());
        this.texMinRadius.setText(new Integer(this.mapSettings.getMinRadius()).toString());
        this.texMaxRadius.setText(new Integer(this.mapSettings.getMaxRadius()).toString());
        this.texMaxCraters.setText(new Integer(this.mapSettings.getMaxCraters()).toString());
        this.texMinCraters.setText(new Integer(this.mapSettings.getMinCraters()).toString());
        this.texProbDrought.setText(new Integer(this.mapSettings.getProbDrought()).toString());
        this.texProbFire.setText(new Integer(this.mapSettings.getProbForestFire()).toString());
        this.texProbFreeze.setText(new Integer(this.mapSettings.getProbFreeze()).toString());
        this.texProbFlood.setText(new Integer(this.mapSettings.getProbFlood()).toString());
        this.texFxMod.setText(new Integer(this.mapSettings.getFxMod()).toString());
        this.choCity.select(this.mapSettings.getCityType());
        this.texInvertNegative.setText(new Integer(this.mapSettings.getInvertNegativeTerrain()).toString());
        this.texCityBlocks.setText(new Integer(this.mapSettings.getCityBlocks()).toString());
        this.texCityMinCF.setText(new Integer(this.mapSettings.getCityMinCF()).toString());
        this.texCityMaxCF.setText(new Integer(this.mapSettings.getCityMaxCF()).toString());
        this.texCityMinFloors.setText(new Integer(this.mapSettings.getCityMinFloors()).toString());
        this.texCityMaxFloors.setText(new Integer(this.mapSettings.getCityMaxFloors()).toString());
        this.texCityDensity.setText(new Integer(this.mapSettings.getCityDensity()).toString());
        this.texTownSize.setText(new Integer(this.mapSettings.getTownSize()).toString());
        this.texMountainPeaks.setText(Integer.toString(this.mapSettings.getMountainPeaks()));
        this.texMountainStyle.setText(Integer.toString(this.mapSettings.getMountainStyle()));
        this.texMountainHeightMin.setText(Integer.toString(this.mapSettings.getMountainHeightMin()));
        this.texMountainHeightMax.setText(Integer.toString(this.mapSettings.getMountainHeightMax()));
        this.texMountainWidthMin.setText(Integer.toString(this.mapSettings.getMountainHeightMin()));
        this.texMountainWidthMax.setText(Integer.toString(this.mapSettings.getMountainHeightMax()));
        this.texAlgorithmToUse.setText(new Integer(this.mapSettings.getAlgorithmToUse()).toString());
    }

    private boolean applyValues() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21;
        int n22;
        int n23;
        int n24;
        int n25;
        int n26;
        int n27;
        int n28;
        int n29;
        int n30;
        int n31;
        int n32;
        int n33;
        int n34;
        int n35;
        int n36;
        int n37;
        int n38;
        int n39;
        int n40;
        int n41;
        int n42;
        int n43;
        int n44;
        int n45;
        int n46;
        int n47;
        int n48;
        int n49;
        int n50;
        int n51;
        int n52;
        int n53;
        int n54;
        int n55;
        int n56;
        int n57;
        int n58;
        int n59;
        String string = "";
        int n60 = 4;
        int n61 = 10;
        int n62 = 100;
        int n63 = 1;
        int n64 = 6;
        int n65 = 75;
        int n66 = 60;
        int n67 = 0;
        try {
            n59 = Integer.parseInt(this.texBoardWidth.getText());
            n58 = Integer.parseInt(this.texBoardHeight.getText());
        }
        catch (NumberFormatException numberFormatException) {
            new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.OnlyIntegersWarn")).setVisible(true);
            return false;
        }
        if (n58 <= 0 || n58 <= 0) {
            new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.BoardSizeWarn")).setVisible(true);
            return false;
        }
        string = this.texTheme.getText();
        if (this.advanced) {
            try {
                n57 = Integer.parseInt(this.texHilliness.getText());
                n56 = Integer.parseInt(this.texRange.getText());
                n55 = Integer.parseInt(this.texCliffs.getText());
                n54 = Integer.parseInt(this.texProbInvert.getText());
                n53 = Integer.parseInt(this.texMinWaterSpots.getText());
                n52 = Integer.parseInt(this.texMaxWaterSpots.getText());
                n51 = Integer.parseInt(this.texMinWaterSize.getText());
                n50 = Integer.parseInt(this.texMaxWaterSize.getText());
                n49 = Integer.parseInt(this.texMinForestSpots.getText());
                n48 = Integer.parseInt(this.texMaxForestSpots.getText());
                n47 = Integer.parseInt(this.texMinForestSize.getText());
                n46 = Integer.parseInt(this.texMaxForestSize.getText());
                n45 = Integer.parseInt(this.texMinRoughSpots.getText());
                n44 = Integer.parseInt(this.texMaxRoughSpots.getText());
                n43 = Integer.parseInt(this.texMinRoughSize.getText());
                n42 = Integer.parseInt(this.texMaxRoughSize.getText());
                n41 = Integer.parseInt(this.texMinSwampSpots.getText());
                n40 = Integer.parseInt(this.texMaxSwampSpots.getText());
                n39 = Integer.parseInt(this.texMinSwampSize.getText());
                n38 = Integer.parseInt(this.texMaxSwampSize.getText());
                n37 = Integer.parseInt(this.texMinPavementSpots.getText());
                n36 = Integer.parseInt(this.texMaxPavementSpots.getText());
                n35 = Integer.parseInt(this.texMinPavementSize.getText());
                n34 = Integer.parseInt(this.texMaxPavementSize.getText());
                n33 = Integer.parseInt(this.texMinRubbleSpots.getText());
                n32 = Integer.parseInt(this.texMaxRubbleSpots.getText());
                n31 = Integer.parseInt(this.texMinRubbleSize.getText());
                n30 = Integer.parseInt(this.texMaxRubbleSize.getText());
                n29 = Integer.parseInt(this.texMinFortifiedSpots.getText());
                n28 = Integer.parseInt(this.texMaxFortifiedSpots.getText());
                n27 = Integer.parseInt(this.texMinFortifiedSize.getText());
                n26 = Integer.parseInt(this.texMaxFortifiedSize.getText());
                n25 = Integer.parseInt(this.texMinIceSpots.getText());
                n24 = Integer.parseInt(this.texMaxIceSpots.getText());
                n23 = Integer.parseInt(this.texMinIceSize.getText());
                n22 = Integer.parseInt(this.texMaxIceSize.getText());
                n21 = Integer.parseInt(this.texProbRoad.getText());
                n20 = Integer.parseInt(this.texProbRiver.getText());
                n19 = Integer.parseInt(this.texProbHeavy.getText());
                n18 = Integer.parseInt(this.texProbDeep.getText());
                n17 = Integer.parseInt(this.texProbCrater.getText());
                n16 = Integer.parseInt(this.texMinRadius.getText());
                n15 = Integer.parseInt(this.texMaxRadius.getText());
                n14 = Integer.parseInt(this.texMaxCraters.getText());
                n13 = Integer.parseInt(this.texMinCraters.getText());
                n12 = Integer.parseInt(this.texAlgorithmToUse.getText());
                n11 = Integer.parseInt(this.texProbDrought.getText());
                n10 = Integer.parseInt(this.texProbFire.getText());
                n9 = Integer.parseInt(this.texProbFreeze.getText());
                n8 = Integer.parseInt(this.texProbFlood.getText());
                n7 = Integer.parseInt(this.texFxMod.getText());
                n60 = Integer.parseInt(this.texCityBlocks.getText());
                n61 = Integer.parseInt(this.texCityMinCF.getText());
                n62 = Integer.parseInt(this.texCityMaxCF.getText());
                n63 = Integer.parseInt(this.texCityMinFloors.getText());
                n64 = Integer.parseInt(this.texCityMaxFloors.getText());
                n65 = Integer.parseInt(this.texCityDensity.getText());
                n6 = Integer.parseInt(this.texMountainHeightMin.getText());
                n5 = Integer.parseInt(this.texMountainHeightMax.getText());
                n4 = Integer.parseInt(this.texMountainWidthMin.getText());
                n3 = Integer.parseInt(this.texMountainWidthMax.getText());
                n2 = Integer.parseInt(this.texMountainStyle.getText());
                n = Integer.parseInt(this.texMountainPeaks.getText());
                n67 = Integer.parseInt(this.texInvertNegative.getText());
                n66 = Integer.parseInt(this.texTownSize.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.OnlyIntegersWarn")).setVisible(true);
                return false;
            }
            if (n57 < 0 || n57 > 99) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.AmmountOfElevationWarn")).setVisible(true);
                return false;
            }
            if (n55 < 0 || n55 > 100) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.CliffsWarn")).setVisible(true);
                return false;
            }
            if (n56 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.elevRangeWarn")).setVisible(true);
                return false;
            }
            if (n54 < 0 || n54 > 100) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.depressionWarn")).setVisible(true);
                return false;
            }
            if (n53 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinLakesWarn")).setVisible(true);
                return false;
            }
            if (n52 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxLakesWarn1")).setVisible(true);
                return false;
            }
            if (n52 < n53) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxLakesWarn2")).setVisible(true);
                return false;
            }
            if (n51 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinLakeSizeWarn")).setVisible(true);
                return false;
            }
            if (n50 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxLakeSizeWarn")).setVisible(true);
                return false;
            }
            if (n50 < n51) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxLakeSizeWarn1")).setVisible(true);
                return false;
            }
            if (n18 < 0 || n18 > 100) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.DeepWaterProbWarn")).setVisible(true);
                return false;
            }
            if (n49 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinForestsWarn")).setVisible(true);
                return false;
            }
            if (n48 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxForestsWarn")).setVisible(true);
                return false;
            }
            if (n48 < n49) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxForestsWarn1")).setVisible(true);
                return false;
            }
            if (n47 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinForestSizeWarn")).setVisible(true);
                return false;
            }
            if (n46 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxForestSizeWarn")).setVisible(true);
                return false;
            }
            if (n46 < n47) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxForestSizeWarn1")).setVisible(true);
                return false;
            }
            if (n19 < 0 || n19 > 100) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.HeavyForestProbWarn")).setVisible(true);
                return false;
            }
            if (n45 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinRoughsWarn")).setVisible(true);
                return false;
            }
            if (n44 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxRoughsWarn")).setVisible(true);
                return false;
            }
            if (n44 < n45) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxRoughsWarn1")).setVisible(true);
                return false;
            }
            if (n43 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinRoughSizeWarn")).setVisible(true);
                return false;
            }
            if (n42 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxRoughSizeWarn")).setVisible(true);
                return false;
            }
            if (n42 < n43) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxRoughSizeWarn1")).setVisible(true);
                return false;
            }
            if (n41 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinSwampsWarn")).setVisible(true);
                return false;
            }
            if (n40 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxSwampsWarn")).setVisible(true);
                return false;
            }
            if (n40 < n41) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxSwampsWarn1")).setVisible(true);
                return false;
            }
            if (n39 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinSwampSizeWarn")).setVisible(true);
                return false;
            }
            if (n38 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxSwampSizeWarn")).setVisible(true);
                return false;
            }
            if (n38 < n39) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxSwampSizeWarn1")).setVisible(true);
                return false;
            }
            if (n37 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinPavementWarn")).setVisible(true);
                return false;
            }
            if (n36 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxPavementWarn")).setVisible(true);
                return false;
            }
            if (n36 < n37) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxPavementWarn1")).setVisible(true);
                return false;
            }
            if (n35 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinPavementSizeWarn")).setVisible(true);
                return false;
            }
            if (n34 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxPavementSizeWarn")).setVisible(true);
                return false;
            }
            if (n34 < n35) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxPavementSizeWarn1")).setVisible(true);
                return false;
            }
            if (n33 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinRubbleWarn")).setVisible(true);
                return false;
            }
            if (n32 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxRubbleWarn")).setVisible(true);
                return false;
            }
            if (n32 < n33) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxRubbleWarn1")).setVisible(true);
                return false;
            }
            if (n31 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinRubbleSizeWarn")).setVisible(true);
                return false;
            }
            if (n30 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxRubbleSizeWarn")).setVisible(true);
                return false;
            }
            if (n30 < n31) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxRubbleSizeWarn1")).setVisible(true);
                return false;
            }
            if (n29 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinFortifiedWarn")).setVisible(true);
                return false;
            }
            if (n28 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxFortifiedWarn")).setVisible(true);
                return false;
            }
            if (n28 < n29) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxFortifiedWarn1")).setVisible(true);
                return false;
            }
            if (n27 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinFortifiedSizeWarn")).setVisible(true);
                return false;
            }
            if (n26 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxFortifiedSizeWarn")).setVisible(true);
                return false;
            }
            if (n26 < n27) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxFortifiedSizeWarn1")).setVisible(true);
                return false;
            }
            if (n25 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinIceWarn")).setVisible(true);
                return false;
            }
            if (n24 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxIceWarn")).setVisible(true);
                return false;
            }
            if (n24 < n25) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxIceWarn1")).setVisible(true);
                return false;
            }
            if (n23 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinIceSizeWarn")).setVisible(true);
                return false;
            }
            if (n22 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxIceSizeWarn")).setVisible(true);
                return false;
            }
            if (n22 < n23) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxIceSizeWarn1")).setVisible(true);
                return false;
            }
            if (n20 < 0 || n20 > 100) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.RiverProbWarn")).setVisible(true);
                return false;
            }
            if (n21 < 0 || n21 > 100) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.RoadProbWarn")).setVisible(true);
                return false;
            }
            if (n17 < 0 || n17 > 100) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.CratersProbWarn")).setVisible(true);
                return false;
            }
            if (n16 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinCraterRadiusWarn")).setVisible(true);
                return false;
            }
            if (n15 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxCraterRadiusWarn")).setVisible(true);
                return false;
            }
            if (n15 < n16) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxCraterRadiusWarn1")).setVisible(true);
                return false;
            }
            if (n14 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxCratersWarn")).setVisible(true);
                return false;
            }
            if (n13 < 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MinCratersWarn")).setVisible(true);
                return false;
            }
            if (n14 < n13) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MaxCratersWarn1")).setVisible(true);
                return false;
            }
            if (n12 < 0 || n12 > 2) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.AlgorithmWarn")).setVisible(true);
                return false;
            }
            if (n61 < 1 || n62 > 150) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.CFOutOfRangeWarn")).setVisible(true);
                return false;
            }
            if (n63 < 1 || n64 > 100) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.FloorsOutOfRangeWarn")).setVisible(true);
                return false;
            }
            if (n65 < 1 || n65 > 100) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.DensityOutOfRangeWarn")).setVisible(true);
                return false;
            }
            if ((n4 < 1 || n3 < n4) && n > 0) {
                new AlertDialog(this.frame, INVALID_SETTING, Messages.getString("RandomMapDialog.MountainWidthOutOfRangeWarn")).setVisible(true);
            }
        } else {
            String string2 = this.choElevation.getSelectedItem();
            if (string2.equals(NONE)) {
                n57 = 0;
                n56 = 0;
            } else if (string2.equals(LOW)) {
                n57 = 25;
                n56 = 3;
            } else if (string2.equals(MEDIUM)) {
                n57 = 50;
                n56 = 5;
            } else {
                n57 = 75;
                n56 = 8;
            }
            string2 = this.choCliffs.getSelectedItem();
            n55 = string2.equals(NONE) ? 0 : (string2.equals(LOW) ? 25 : (string2.equals(MEDIUM) ? 50 : 75));
            string2 = this.choWoods.getSelectedItem();
            if (string2.equals(NONE)) {
                n47 = 0;
                n46 = 0;
                n49 = 0;
                n48 = 0;
                n19 = 0;
            } else if (string2.equals(LOW)) {
                n47 = 3;
                n46 = 6;
                n49 = 3;
                n48 = 6;
                n19 = 20;
            } else if (string2.equals(MEDIUM)) {
                n47 = 3;
                n46 = 10;
                n49 = 4;
                n48 = 8;
                n19 = 30;
            } else {
                n47 = 8;
                n46 = 13;
                n49 = 6;
                n48 = 10;
                n19 = 45;
            }
            string2 = this.choLakes.getSelectedItem();
            if (string2.equals(NONE)) {
                n51 = 0;
                n50 = 0;
                n53 = 0;
                n52 = 0;
                n18 = 0;
            } else if (string2.equals(LOW)) {
                n51 = 1;
                n50 = 5;
                n53 = 1;
                n52 = 5;
                n18 = 20;
            } else if (string2.equals(MEDIUM)) {
                n51 = 6;
                n50 = 10;
                n53 = 2;
                n52 = 5;
                n18 = 30;
            } else {
                n51 = 8;
                n50 = 15;
                n53 = 3;
                n52 = 6;
                n18 = 45;
            }
            string2 = this.choRough.getSelectedItem();
            if (string2.equals(NONE)) {
                n43 = 0;
                n42 = 0;
                n45 = 0;
                n44 = 0;
            } else if (string2.equals(LOW)) {
                n43 = 1;
                n42 = 2;
                n45 = 2;
                n44 = 6;
            } else if (string2.equals(MEDIUM)) {
                n43 = 2;
                n42 = 5;
                n45 = 3;
                n44 = 8;
            } else {
                n43 = 3;
                n42 = 7;
                n45 = 5;
                n44 = 10;
            }
            string2 = this.choSwamp.getSelectedItem();
            if (string2.equals(NONE)) {
                n39 = 0;
                n38 = 0;
                n41 = 0;
                n40 = 0;
            } else if (string2.equals(LOW)) {
                n39 = 1;
                n38 = 2;
                n41 = 2;
                n40 = 6;
            } else if (string2.equals(MEDIUM)) {
                n39 = 2;
                n38 = 5;
                n41 = 3;
                n40 = 8;
            } else {
                n39 = 3;
                n38 = 7;
                n41 = 5;
                n40 = 10;
            }
            string2 = this.choPavement.getSelectedItem();
            if (string2.equals(NONE)) {
                n35 = 0;
                n34 = 0;
                n37 = 0;
                n36 = 0;
            } else if (string2.equals(LOW)) {
                n35 = 1;
                n34 = 2;
                n37 = 2;
                n36 = 6;
            } else if (string2.equals(MEDIUM)) {
                n35 = 2;
                n34 = 5;
                n37 = 3;
                n36 = 8;
            } else {
                n35 = 3;
                n34 = 7;
                n37 = 5;
                n36 = 10;
            }
            string2 = this.choRubble.getSelectedItem();
            if (string2.equals(NONE)) {
                n31 = 0;
                n30 = 0;
                n33 = 0;
                n32 = 0;
            } else if (string2.equals(LOW)) {
                n31 = 1;
                n30 = 2;
                n33 = 2;
                n32 = 6;
            } else if (string2.equals(MEDIUM)) {
                n31 = 2;
                n30 = 5;
                n33 = 3;
                n32 = 8;
            } else {
                n31 = 3;
                n30 = 7;
                n33 = 5;
                n32 = 10;
            }
            string2 = this.choFortified.getSelectedItem();
            if (string2.equals(NONE)) {
                n27 = 0;
                n26 = 0;
                n29 = 0;
                n28 = 0;
            } else if (string2.equals(LOW)) {
                n27 = 1;
                n26 = 2;
                n29 = 1;
                n28 = 2;
            } else if (string2.equals(MEDIUM)) {
                n27 = 2;
                n26 = 3;
                n29 = 2;
                n28 = 4;
            } else {
                n27 = 2;
                n26 = 4;
                n29 = 3;
                n28 = 6;
            }
            string2 = this.choIce.getSelectedItem();
            if (string2.equals(NONE)) {
                n23 = 0;
                n22 = 0;
                n25 = 0;
                n24 = 0;
            } else if (string2.equals(LOW)) {
                n23 = 1;
                n22 = 2;
                n25 = 2;
                n24 = 6;
            } else if (string2.equals(MEDIUM)) {
                n23 = 2;
                n22 = 5;
                n25 = 3;
                n24 = 8;
            } else {
                n23 = 3;
                n22 = 7;
                n25 = 5;
                n24 = 10;
            }
            string2 = this.choRoads.getSelectedItem();
            n21 = string2.equals(NONE) ? 0 : (string2.equals(LOW) ? 25 : (string2.equals(MEDIUM) ? 50 : 75));
            string2 = this.choRivers.getSelectedItem();
            n20 = string2.equals(NONE) ? 0 : (string2.equals(LOW) ? 25 : (string2.equals(MEDIUM) ? 50 : 75));
            string2 = this.choCraters.getSelectedItem();
            if (string2.equals(NONE)) {
                n17 = 0;
                n16 = 0;
                n15 = 0;
                n13 = 0;
                n14 = 0;
            } else if (string2.equals(LOW)) {
                n17 = 25;
                n16 = 1;
                n15 = 3;
                n13 = 1;
                n14 = 3;
            } else if (string2.equals(MEDIUM)) {
                n17 = 50;
                n16 = 1;
                n15 = 5;
                n13 = 3;
                n14 = 8;
            } else {
                n17 = 75;
                n16 = 3;
                n15 = 9;
                n13 = 6;
                n14 = 14;
            }
            string2 = this.choMountain.getSelectedItem();
            if (string2.equals(NONE)) {
                n = 0;
                n6 = 4;
                n5 = 6;
                n4 = 7;
                n3 = 10;
                n2 = 0;
            } else if (string2.equals(LOW)) {
                n = 1;
                n6 = 4;
                n5 = 6;
                n4 = 7;
                n3 = 10;
                n2 = 0;
            } else if (string2.equals(MEDIUM)) {
                n = 2;
                n6 = 6;
                n5 = 8;
                n4 = 7;
                n3 = 10;
                n2 = 0;
            } else {
                n = 3;
                n6 = 8;
                n5 = 10;
                n4 = 9;
                n3 = 14;
                n2 = 4;
            }
            n60 = 16;
            n61 = 10;
            n62 = 100;
            n63 = 1;
            n64 = 6;
            n65 = 75;
            n66 = 60;
            n12 = 0;
            n54 = 0;
            n7 = 0;
            n8 = 0;
            n9 = 0;
            n10 = 0;
            n11 = 0;
        }
        String string3 = this.choCity.getSelectedItem();
        if (!this.advanced && string3.equals("TOWN")) {
            n60 = 3;
            n62 = 50;
            n64 = 3;
        }
        this.mapSettings.setBoardSize(n59, n58);
        this.mapSettings.setElevationParams(n57, n56, n54);
        this.mapSettings.setCliffParam(n55);
        this.mapSettings.setWaterParams(n53, n52, n51, n50, n18);
        this.mapSettings.setForestParams(n49, n48, n47, n46, n19);
        this.mapSettings.setRoughParams(n45, n44, n43, n42);
        this.mapSettings.setSwampParams(n41, n40, n39, n38);
        this.mapSettings.setPavementParams(n37, n36, n35, n34);
        this.mapSettings.setRubbleParams(n33, n32, n31, n30);
        this.mapSettings.setFortifiedParams(n29, n28, n27, n26);
        this.mapSettings.setIceParams(n25, n24, n23, n22);
        this.mapSettings.setRiverParam(n20);
        this.mapSettings.setRoadParam(n21);
        this.mapSettings.setCraterParam(n17, n13, n14, n16, n15);
        this.mapSettings.setSpecialFX(n7, n10, n9, n8, n11);
        this.mapSettings.setAlgorithmToUse(n12);
        this.mapSettings.setCityParams(n60, string3, n61, n62, n63, n64, n65, n66);
        this.mapSettings.setMountainParams(n, n4, n3, n6, n5, n2);
        this.mapSettings.setInvertNegativeTerrain(n67);
        this.mapSettings.setTheme(string);
        if (!this.advanced) {
            this.loadValues();
        }
        this.bsd.updateMapSettings(this.mapSettings);
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof TextField) {
            TextField textField = (TextField)focusEvent.getSource();
            textField.selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof TextField) {
            TextField textField = (TextField)focusEvent.getSource();
            textField.select(0, 0);
        }
    }

    public void setMapSettings(MapSettings mapSettings) {
        this.mapSettings = mapSettings;
        this.loadValues();
    }

    private void setProperSize() {
        this.validate();
        this.pack();
        Dimension dimension = this.panOptions.getPreferredSize();
        Dimension dimension2 = this.panButtons.getPreferredSize();
        int n = Math.min(dimension.width + dimension2.width + 50, this.getParent().getSize().width);
        int n2 = Math.min(dimension.height + dimension2.height + 50, this.getParent().getSize().height);
        this.setSize(n, n2);
    }

    private void setProperLocation() {
        int n = (this.getParent().getSize().width - this.getSize().width) / 2;
        int n2 = (this.getParent().getSize().height - this.getSize().height) / 2;
        this.setLocation(n, n2);
    }
}

