/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.boardview3d.BoardView3D;
import megamek.client.ui.IDisplayable;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.LosEffects;
import megamek.common.Minefield;
import megamek.common.Mounted;
import megamek.common.Player;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.ProtomechPhysicalAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.WeaponAttackAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HoverInfo
implements IDisplayable {
    private static final Font FONT = new Font("SansSerif", 0, 10);
    private static final int TOP = 5;
    private static final int LEFT = 5;
    private static final int PADDING = 5;
    private static final int WIDTH = 350;
    private FontMetrics fm;
    IGame game;
    Entity entity;
    Mounted equipment;
    Player localPlayer;
    Coords coords;
    Coords los;
    HashMap<Integer, Vector<String>> sources = new HashMap();
    HashMap<Integer, Vector<String>> destinations = new HashMap();

    public HoverInfo(IGame iGame, BoardView3D boardView3D) {
        this.game = iGame;
        this.coords = new Coords(0, 0);
        this.fm = boardView3D.getFontMetrics(FONT);
    }

    @Override
    public void draw(Graphics graphics, Point point, Dimension dimension) {
        int n;
        if (!(graphics instanceof Graphics2D)) {
            System.err.println("Warning: HoverInfo is meant to be used with Graphics2D");
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Vector<String> vector = this.getTipText();
        if (vector == null) {
            return;
        }
        for (n = 0; n < vector.size(); ++n) {
            int n2;
            String string = vector.elementAt(n);
            int n3 = string.length();
            while (this.fm.stringWidth(string.substring(0, n3)) > 340) {
                --n3;
            }
            if (n3 == string.length()) continue;
            for (n2 = n3; n2 > 0 && " \t\r\n".indexOf(string.charAt(n2)) < 0; --n2) {
            }
            if (n2 <= 0) {
                n2 = n3;
            }
            vector.removeElementAt(n);
            for (n3 = n2; n3 > 0 && " \t\r\n".indexOf(string.charAt(n3)) >= 0; --n3) {
            }
            vector.insertElementAt(string.substring(0, n3 + 1), n);
            n3 = string.length();
            while (n2 < n3 && " \t\r\n".indexOf(string.charAt(n2)) >= 0) {
                ++n2;
            }
            if (n2 >= n3) continue;
            vector.insertElementAt("    " + string.substring(n2, n3), n + 1);
        }
        graphics2D.setFont(FONT);
        n = vector.size() * this.fm.getHeight() + 10;
        graphics2D.setColor(new Color(Color.DARK_GRAY.getRed(), Color.DARK_GRAY.getGreen(), Color.DARK_GRAY.getBlue(), 128));
        graphics2D.fillRect(5, 5, 352, n);
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.draw3DRect(5, 5, 352, n, false);
        graphics2D.draw3DRect(6, 6, 350, n - 2, true);
        int n4 = 10 + this.fm.getAscent();
        for (String string : vector) {
            graphics2D.drawString(string, 10, n4);
            n4 += this.fm.getHeight();
        }
    }

    void setPosition(Coords coords) {
        this.coords = coords;
    }

    void setLOS(Coords coords) {
        this.los = coords;
    }

    Coords getLOS() {
        return this.los;
    }

    private void checkLOS(Vector<String> vector) {
        int n;
        int n2;
        Coords coords = this.los;
        if (this.los == null) {
            if (this.entity == null) {
                return;
            }
            coords = this.entity.getPosition();
        }
        Entity entity = this.entity;
        Entity entity2 = null;
        if (entity != null) {
            entity2 = this.game.getFirstEnemyEntity(this.coords, entity);
        }
        Coords coords2 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (entity != null && this.los != null) {
            coords2 = entity.getPosition();
            n3 = entity.getFacing();
            n4 = entity.getSecondaryFacing();
            n5 = entity.getElevation();
            entity.setGame(null);
            entity.setPosition(this.los);
            int n6 = coords.direction(this.coords);
            entity.setFacing(n6);
            entity.setSecondaryFacing(n6);
            n2 = this.game.getBoard().getHex(coords2).depth();
            n = this.game.getBoard().getHex(coords).depth();
            if (n > 0) {
                entity.setElevation(n5 == -n2 ? -n : (n5 > 0 ? n5 : (n5 <= -n ? n5 : -n)));
            } else if (n5 < 0) {
                entity.setElevation(0);
            }
            entity.setGame(this.game);
        }
        LosEffects.AttackInfo attackInfo = new LosEffects.AttackInfo();
        attackInfo.attackPos = coords;
        attackInfo.targetPos = this.coords;
        int n7 = entity != null ? (entity.height() == 1 ? 1 : 0) : (n2 = GUIPreferences.getInstance().getMechInFirst());
        int n8 = entity2 != null ? (entity2.height() == 1 ? 1 : 0) : (n = GUIPreferences.getInstance().getMechInSecond());
        int n9 = entity != null ? entity.height() : (attackInfo.attackHeight = n2 != 0 ? 1 : 0);
        int n10 = entity2 != null ? entity2.height() : (attackInfo.targetHeight = n != 0 ? 1 : 0);
        if (this.los == null && entity != null) {
            attackInfo.attackAbsHeight = this.game.getBoard().getHex(coords).floor() + entity.absHeight();
            attackInfo.targetAbsHeight = this.game.getBoard().getHex(this.coords).floor() + (entity2 == null ? 0 : entity2.absHeight());
        } else {
            attackInfo.attackAbsHeight = this.game.getBoard().getHex(coords).floor() + attackInfo.attackHeight;
            attackInfo.targetAbsHeight = this.game.getBoard().getHex(this.coords).floor() + attackInfo.targetHeight;
            vector.add(Messages.getString("BoardView1.Attacker", new Object[]{entity != null ? entity.getDisplayName() : (n2 != 0 ? Messages.getString("BoardView1.Mech") : Messages.getString("BoardView1.NonMech")), coords.getBoardNum()}));
        }
        if (entity2 == null) {
            vector.add(Messages.getString("BoardView1.Target", new Object[]{attackInfo.targetHeight == 1 ? Messages.getString("BoardView1.Mech") : Messages.getString("BoardView1.NonMech"), this.coords.getBoardNum()}));
        }
        if (entity2 != null && entity != null) {
            Mounted mounted;
            int n11 = 0;
            HashMap hashMap = new HashMap();
            while ((mounted = entity.getEquipment(n11++)) != null) {
                if (!(mounted.getType() instanceof WeaponType) || hashMap.containsKey(mounted.getName())) continue;
                ToHitData toHitData = WeaponAttackAction.toHit(this.game, entity.getId(), entity2, entity.getEquipmentNum(mounted), -1, 0);
                vector.add(mounted.getType().getName() + Messages.getString("BoardView1.needs") + toHitData.getValueAsString() + " " + toHitData.getTableDesc() + " [" + toHitData.getDesc() + "]");
                hashMap.put(mounted.getName(), null);
            }
        } else {
            LosEffects losEffects = LosEffects.calculateLos(this.game, attackInfo);
            if (losEffects.isBlocked()) {
                vector.add(Messages.getString("BoardView1.LOSBlocked", new Object[]{new Integer(coords.distance(this.coords))}));
            } else {
                vector.add(Messages.getString("BoardView1.LOSNotBlocked", new Object[]{new Integer(coords.distance(this.coords))}));
                if (losEffects.getHeavyWoods() > 0) {
                    vector.add(Messages.getString("BoardView1.HeavyWoods", new Object[]{new Integer(losEffects.getHeavyWoods())}));
                }
                if (losEffects.getLightWoods() > 0) {
                    vector.add(Messages.getString("BoardView1.LightWoods", new Object[]{new Integer(losEffects.getLightWoods())}));
                }
                if (losEffects.getLightSmoke() > 0) {
                    vector.add(Messages.getString("BoardView1.LightSmoke", new Object[]{new Integer(losEffects.getLightSmoke())}));
                }
                if (losEffects.getHeavySmoke() > 0) {
                    if (this.game.getOptions().booleanOption("maxtech_fire")) {
                        vector.add(Messages.getString("BoardView1.HeavySmoke", new Object[]{new Integer(losEffects.getHeavySmoke())}));
                    } else {
                        vector.add(Messages.getString("BoardView1.Smoke", new Object[]{new Integer(losEffects.getHeavySmoke())}));
                    }
                }
                if (losEffects.isTargetCover()) {
                    vector.add(Messages.getString("BoardView1.TargetPartialCover"));
                }
                if (losEffects.isAttackerCover()) {
                    vector.add(Messages.getString("BoardView1.AttackerPartialCover"));
                }
            }
        }
        if (coords2 != null) {
            entity.setGame(null);
            entity.setPosition(coords2);
            entity.setFacing(n3);
            entity.setSecondaryFacing(n4);
            entity.setElevation(n5);
            entity.setGame(this.game);
        }
    }

    void setSelected(Entity entity, Mounted mounted, Player player) {
        if (entity != null && !this.game.getBoard().contains(entity.getPosition())) {
            entity = null;
        }
        this.entity = entity;
        this.equipment = mounted;
        this.localPlayer = player;
        this.setLOS(this.los);
    }

    private Vector<String> getTipText() {
        String string;
        Serializable serializable;
        int n;
        int n2;
        IHex iHex = this.game.getBoard().getHex(this.coords);
        if (iHex == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        vector.add(Messages.getString("BoardView1.Hex") + this.coords.getBoardNum() + Messages.getString("BoardView1.level") + iHex.getElevation());
        if (iHex.containsTerrain(5)) {
            n2 = iHex.getTerrain(5).getLevel();
            n = iHex.getTerrain(5).getTerrainFactor();
            if (n2 == 1) {
                vector.add(Messages.getString("BoardView1.TipLightJungle", new Object[]{n}));
            } else if (n2 == 2) {
                vector.add(Messages.getString("BoardView1.TipHeavyJungle", new Object[]{n}));
            } else if (n2 == 3) {
                vector.add(Messages.getString("BoardView1.TipUltraJungle", new Object[]{n}));
            } else {
                vector.add(Messages.getString("BoardView1.TipJungle", new Object[]{n}));
            }
        } else if (iHex.containsTerrain(1)) {
            n2 = iHex.getTerrain(1).getLevel();
            n = iHex.getTerrain(1).getTerrainFactor();
            if (n2 == 1) {
                vector.add(Messages.getString("BoardView1.TipLightWoods", new Object[]{n}));
            } else if (n2 == 2) {
                vector.add(Messages.getString("BoardView1.TipHeavyWoods", new Object[]{n}));
            } else if (n2 == 3) {
                vector.add(Messages.getString("BoardView1.TipUltraWoods", new Object[]{n}));
            } else {
                vector.add(Messages.getString("BoardView1.TipWoods", new Object[]{n}));
            }
        }
        if (iHex.containsTerrain(17)) {
            n2 = iHex.getTerrain(17).getTerrainFactor();
            vector.add(Messages.getString("BoardView1.TipIce", new Object[]{n2}));
        }
        if (iHex.containsTerrain(4)) {
            vector.add(Messages.getString("BoardView1.Rubble"));
        }
        if (iHex.containsTerrain(14)) {
            vector.add(Messages.getString("BoardView1.TipSwamp"));
        }
        if (iHex.containsTerrain(29)) {
            Building building = this.game.getBoard().getBuildingAt(this.coords);
            StringBuffer stringBuffer = new StringBuffer(Messages.getString("BoardView1.Height"));
            stringBuffer.append(iHex.terrainLevel(31));
            stringBuffer.append(" ");
            stringBuffer.append(building.toString());
            stringBuffer.append(Messages.getString("BoardView1.CF"));
            stringBuffer.append(building.getCurrentCF(this.coords));
            vector.add(stringBuffer.toString());
        }
        if (iHex.containsTerrain(22)) {
            Building building = this.game.getBoard().getBuildingAt(this.coords);
            StringBuffer stringBuffer = new StringBuffer(Messages.getString("BoardView1.Height"));
            stringBuffer.append(iHex.terrainLevel(24));
            stringBuffer.append(" ");
            stringBuffer.append(building.toString());
            stringBuffer.append(Messages.getString("BoardView1.CF"));
            stringBuffer.append(building.getCurrentCF(this.coords));
            vector.add(stringBuffer.toString());
        }
        if (iHex.containsTerrain(26)) {
            Building building = this.game.getBoard().getBuildingAt(this.coords);
            StringBuffer stringBuffer = new StringBuffer(Messages.getString("BoardView1.Height"));
            stringBuffer.append(iHex.terrainLevel(28));
            stringBuffer.append(" ");
            stringBuffer.append(building.toString());
            stringBuffer.append(Messages.getString("BoardView1.CF"));
            stringBuffer.append(building.getCurrentCF(this.coords));
            vector.add(stringBuffer.toString());
        }
        if (this.game.containsMinefield(this.coords)) {
            Vector<Minefield> vector2 = this.game.getMinefields(this.coords);
            block7: for (int i = 0; i < vector2.size(); ++i) {
                serializable = vector2.elementAt(i);
                string = " (" + this.game.getPlayer(((Minefield)serializable).getPlayerId()).getName() + ")";
                switch (((Minefield)serializable).getType()) {
                    case 0: {
                        vector.add(((Minefield)serializable).getName() + Messages.getString("BoardView1.minefield") + " " + string);
                        continue block7;
                    }
                    case 1: {
                        vector.add(((Minefield)serializable).getName() + Messages.getString("BoardView1.minefield") + " " + string);
                        continue block7;
                    }
                    case 2: {
                        if (((Minefield)serializable).getPlayerId() == this.localPlayer.getId()) {
                            vector.add(((Minefield)serializable).getName() + Messages.getString("BoardView1.minefield") + "(" + ((Minefield)serializable).getSetting() + ") " + string);
                            continue block7;
                        }
                        vector.add(((Minefield)serializable).getName() + Messages.getString("BoardView1.minefield") + " " + string);
                        continue block7;
                    }
                    case 3: {
                        vector.add(((Minefield)serializable).getName() + Messages.getString("BoardView1.minefield") + "(" + ((Minefield)serializable).getDensity() + ")" + string);
                        continue block7;
                    }
                    case 5: {
                        vector.add(((Minefield)serializable).getName() + Messages.getString("BoardView1.minefield") + "(" + ((Minefield)serializable).getDensity() + ")" + string);
                    }
                }
            }
        }
        Enumeration<Serializable> enumeration = this.game.getEntities(this.coords);
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            this.addEntityText(vector, entity);
        }
        enumeration = this.game.getArtilleryAttacks();
        while (enumeration.hasMoreElements()) {
            ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)enumeration.nextElement();
            serializable = this.game.getEntity(artilleryAttackAction.getEntityId());
            string = null;
            if (serializable != null && artilleryAttackAction.getWeaponId() > -1) {
                Mounted mounted = ((Entity)serializable).getEquipment(artilleryAttackAction.getWeaponId());
                string = mounted.getName();
                if (artilleryAttackAction.getAmmoId() > -1) {
                    Mounted mounted2 = ((Entity)serializable).getEquipment(artilleryAttackAction.getAmmoId());
                    string = string + "(" + mounted2.getName() + ")";
                }
            }
            if (string == null) {
                string = Messages.getString("BoardView1.Artillery");
            }
            vector.add(Messages.getString("BoardView1.ArtilleryAttack", new Object[]{string, new Integer(artilleryAttackAction.turnsTilHit), artilleryAttackAction.toHit(this.game).getValueAsString()}));
        }
        if (this.equipment != null && this.entity != null && this.equipment.getType().hasFlag(32768L)) {
            int n3 = 0;
            n3 = this.entity.getOwner().getArtyAutoHitHexes().contains(this.coords) ? Integer.MIN_VALUE : this.entity.aTracker.getModifier(this.equipment, this.coords);
            if (n3 == Integer.MIN_VALUE) {
                vector.add(Messages.getString("BoardView1.ArtilleryAutohit"));
            } else {
                vector.add(Messages.getString("BoardView1.ArtilleryAdjustment", new Object[]{new Integer(n3)}));
            }
        }
        this.checkLOS(vector);
        return vector;
    }

    private void addEntityText(Vector<String> vector, Entity entity) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(entity.getChassis()).append(" (").append(entity.getOwner().getName()).append("); ").append(entity.getCrew().getGunnery()).append("/").append(entity.getCrew().getPiloting()).append(Messages.getString("BoardView1.pilot"));
        int n = entity.getCrew().countAdvantages();
        boolean bl2 = bl = entity.getCrew().countMDImplants() > 0;
        if (n > 0) {
            stringBuffer.append(" <").append(n).append(Messages.getString("BoardView1.advs"));
        }
        if (bl) {
            stringBuffer.append(Messages.getString("BoardView1.md"));
        }
        vector.add(stringBuffer.toString());
        GunEmplacement gunEmplacement = null;
        if (entity instanceof GunEmplacement) {
            gunEmplacement = (GunEmplacement)entity;
        }
        stringBuffer = new StringBuffer();
        if (gunEmplacement == null) {
            stringBuffer.append(Messages.getString("BoardView1.move")).append(entity.getMovementAbbr(entity.moved)).append(":").append(entity.delta_distance).append(" (+").append(Compute.getTargetMovementModifier(this.game, entity.getId()).getValue()).append(");").append(Messages.getString("BoardView1.Heat")).append(entity.heat);
            if (entity.isCharging()) {
                stringBuffer.append(" ").append(Messages.getString("BoardView1.charge1"));
            }
            if (entity.isMakingDfa()) {
                stringBuffer.append(" ").append(Messages.getString("BoardBiew1.DFA1"));
            }
        } else if (gunEmplacement.hasTurret() && gunEmplacement.isTurretLocked()) {
            stringBuffer.append(Messages.getString("BoardView1.TurretLocked"));
            if (gunEmplacement.getFirstWeapon() == -1) {
                stringBuffer.append(",");
                stringBuffer.append(Messages.getString("BoardView1.WeaponsDestroyed"));
            }
        } else if (gunEmplacement.getFirstWeapon() == -1) {
            stringBuffer.append(Messages.getString("BoardView1.WeaponsDestroyed"));
        } else {
            stringBuffer.append(Messages.getString("BoardView1.Operational"));
        }
        if (entity.isDone()) {
            stringBuffer.append(" (").append(Messages.getString("BoardView1.done")).append(")");
        }
        vector.add(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        if (gunEmplacement == null) {
            stringBuffer.append(Messages.getString("BoardView1.Armor")).append(entity.getTotalArmor()).append(Messages.getString("BoardView1.internal")).append(entity.getTotalInternal());
        } else {
            stringBuffer.append(Messages.getString("BoardView1.cf")).append(gunEmplacement.getCurrentCF()).append(Messages.getString("BoardView1.turretArmor")).append(gunEmplacement.getCurrentTurretArmor());
        }
        vector.add(stringBuffer.toString());
        Vector<String> vector2 = this.sources.get(new Integer(entity.getId()));
        if (vector2 != null) {
            vector.addAll(vector2);
        }
        if ((vector2 = this.destinations.get(new Integer(entity.getId()))) != null) {
            vector.add("Incoming:");
            vector.addAll(vector2);
        }
    }

    public void add(AttackAction attackAction) {
        String string;
        Vector<String> vector;
        Serializable serializable;
        int n = attackAction.getTargetType();
        int n2 = attackAction.getTargetId();
        Entity entity = this.game.getEntity(attackAction.getEntityId());
        Targetable targetable = this.game.getTarget(n, n2);
        String string2 = null;
        if (attackAction instanceof WeaponAttackAction) {
            serializable = (WeaponAttackAction)attackAction;
            vector = (WeaponType)entity.getEquipment(((WeaponAttackAction)serializable).getWeaponId()).getType();
            string = ((WeaponAttackAction)serializable).toHit(this.game).getValueAsString();
            String string3 = ((WeaponAttackAction)serializable).toHit(this.game).getTableDesc();
            string2 = ((EquipmentType)((Object)vector)).getName() + Messages.getString("BoardView1.needs") + string + " " + string3;
        }
        if (attackAction instanceof KickAttackAction) {
            serializable = (KickAttackAction)attackAction;
            vector = "";
            string = "";
            int n3 = ((KickAttackAction)serializable).getLeg();
            switch (n3) {
                case 0: {
                    vector = KickAttackAction.toHit(this.game, ((AbstractEntityAction)serializable).getEntityId(), this.game.getTarget(((AbstractAttackAction)serializable).getTargetType(), ((AbstractAttackAction)serializable).getTargetId()), 1).getValueAsString();
                    string = KickAttackAction.toHit(this.game, ((AbstractEntityAction)serializable).getEntityId(), this.game.getTarget(((AbstractAttackAction)serializable).getTargetType(), ((AbstractAttackAction)serializable).getTargetId()), 2).getValueAsString();
                    string2 = Messages.getString("BoardView1.kickBoth", new Object[]{vector, string});
                    break;
                }
                case 1: {
                    vector = KickAttackAction.toHit(this.game, ((AbstractEntityAction)serializable).getEntityId(), this.game.getTarget(((AbstractAttackAction)serializable).getTargetType(), ((AbstractAttackAction)serializable).getTargetId()), 1).getValueAsString();
                    string2 = Messages.getString("BoardView1.kickLeft", new Object[]{vector});
                    break;
                }
                case 2: {
                    string = KickAttackAction.toHit(this.game, ((AbstractEntityAction)serializable).getEntityId(), this.game.getTarget(((AbstractAttackAction)serializable).getTargetType(), ((AbstractAttackAction)serializable).getTargetId()), 2).getValueAsString();
                    string2 = Messages.getString("BoardView1.kickRight", new Object[]{string});
                }
            }
        }
        if (attackAction instanceof PunchAttackAction) {
            serializable = (PunchAttackAction)attackAction;
            vector = "";
            string = "";
            int n4 = ((PunchAttackAction)serializable).getArm();
            switch (n4) {
                case 0: {
                    vector = PunchAttackAction.toHit(this.game, ((AbstractEntityAction)serializable).getEntityId(), this.game.getTarget(((AbstractAttackAction)serializable).getTargetType(), ((AbstractAttackAction)serializable).getTargetId()), 1).getValueAsString();
                    string = PunchAttackAction.toHit(this.game, ((AbstractEntityAction)serializable).getEntityId(), this.game.getTarget(((AbstractAttackAction)serializable).getTargetType(), ((AbstractAttackAction)serializable).getTargetId()), 2).getValueAsString();
                    string2 = Messages.getString("BoardView1.punchBoth", new Object[]{vector, string});
                    break;
                }
                case 1: {
                    vector = PunchAttackAction.toHit(this.game, ((AbstractEntityAction)serializable).getEntityId(), this.game.getTarget(((AbstractAttackAction)serializable).getTargetType(), ((AbstractAttackAction)serializable).getTargetId()), 1).getValueAsString();
                    string2 = Messages.getString("BoardView1.punchLeft", new Object[]{vector});
                    break;
                }
                case 2: {
                    string = PunchAttackAction.toHit(this.game, ((AbstractEntityAction)serializable).getEntityId(), this.game.getTarget(((AbstractAttackAction)serializable).getTargetType(), ((AbstractAttackAction)serializable).getTargetId()), 2).getValueAsString();
                    string2 = Messages.getString("BoardView1.punchRight", new Object[]{string});
                }
            }
        }
        if (attackAction instanceof PushAttackAction) {
            serializable = (PushAttackAction)attackAction;
            vector = ((PushAttackAction)serializable).toHit(this.game).getValueAsString();
            string2 = Messages.getString("BoardView1.push", new Object[]{vector});
        }
        if (attackAction instanceof ClubAttackAction) {
            serializable = (ClubAttackAction)attackAction;
            vector = ((ClubAttackAction)serializable).toHit(this.game).getValueAsString();
            string = ((ClubAttackAction)serializable).getClub().getName();
            string2 = Messages.getString("BoardView1.hit", new Object[]{string, vector});
        }
        if (attackAction instanceof ChargeAttackAction) {
            serializable = (ChargeAttackAction)attackAction;
            vector = ((ChargeAttackAction)serializable).toHit(this.game).getValueAsString();
            string2 = Messages.getString("BoardView1.charge", new Object[]{vector});
        }
        if (attackAction instanceof DfaAttackAction) {
            serializable = (DfaAttackAction)attackAction;
            vector = ((DfaAttackAction)serializable).toHit(this.game).getValueAsString();
            string2 = Messages.getString("BoardView1.DFA", new Object[]{vector});
        }
        if (attackAction instanceof ProtomechPhysicalAttackAction) {
            serializable = (ProtomechPhysicalAttackAction)attackAction;
            vector = ((ProtomechPhysicalAttackAction)serializable).toHit(this.game).getValueAsString();
            string2 = Messages.getString("BoardView1.proto", new Object[]{vector});
        }
        if (attackAction instanceof SearchlightAttackAction) {
            string2 = Messages.getString("BoardView1.Searchlight");
        }
        if (string2 != null) {
            serializable = new Integer(entity.getId());
            vector = this.sources.get(serializable);
            if (vector == null) {
                vector = new Vector();
            }
            vector.add(string2 + " " + Messages.getString("BoardView1.on") + " " + targetable.getDisplayName());
            this.sources.put((Integer)serializable, vector);
            serializable = new Integer(n2);
            vector = this.destinations.get(serializable);
            if (vector == null) {
                vector = new Vector();
            }
            vector.add(string2 + " [" + entity.getDisplayName() + "]");
            this.destinations.put((Integer)serializable, vector);
        }
    }

    public void remove(Entity entity) {
        Integer n = new Integer(entity.getId());
        this.sources.remove(n);
        this.destinations.remove(n);
    }

    public void clear() {
        this.sources.clear();
        this.destinations.clear();
    }

    public void update() {
        this.clear();
        for (EntityAction entityAction : this.game.getActionsVector()) {
            if (!(entityAction instanceof AttackAction)) continue;
            this.add((AttackAction)entityAction);
        }
        for (AttackAction attackAction : this.game.getChargesVector()) {
            if (!(attackAction instanceof AttackAction)) continue;
            this.add(attackAction);
        }
    }

    @Override
    public void setIdleTime(long l, boolean bl) {
    }

    @Override
    public boolean isHit(Point point, Dimension dimension) {
        return false;
    }

    @Override
    public boolean isMouseOver(Point point, Dimension dimension) {
        return false;
    }

    @Override
    public boolean isSliding() {
        return false;
    }

    @Override
    public boolean slide() {
        return false;
    }

    @Override
    public boolean isDragged(Point point, Dimension dimension) {
        return false;
    }

    @Override
    public boolean isBeingDragged() {
        return false;
    }

    @Override
    public boolean isReleased() {
        return false;
    }
}

