/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui;

import java.text.DecimalFormat;
import java.util.Iterator;
import megamek.client.ui.AWT.Messages;
import megamek.common.Aero;
import megamek.common.BattleArmor;
import megamek.common.BombType;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.FighterSquadron;
import megamek.common.GunEmplacement;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.LargeSupportTank;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.SmallCraft;
import megamek.common.SpaceStation;
import megamek.common.SupportTank;
import megamek.common.SupportVTOL;
import megamek.common.Tank;
import megamek.common.TechConstants;
import megamek.common.Warship;
import megamek.common.WeaponType;
import megamek.common.weapons.BayWeapon;

public class MechView {
    private Entity entity;
    private boolean isMech;
    private boolean isInf;
    private boolean isBA;
    private boolean isVehicle;
    private boolean isProto;
    private boolean isGunEmplacement;
    private boolean isSupportVehicle;
    private boolean isLargeSupportVehicle;
    private boolean isSupportVTOL;
    private boolean isAero;
    private boolean isSquadron;
    private boolean isSmallCraft;
    private boolean isJumpship;
    private boolean isSpaceStation;
    StringBuffer sBasic = new StringBuffer();
    StringBuffer sLoadout = new StringBuffer();
    StringBuffer sFluff = new StringBuffer("");
    private static final String SPACES = "                                   ";

    public MechView(Entity entity, boolean bl) {
        Entity entity2;
        this.entity = entity;
        this.isMech = entity instanceof Mech;
        this.isInf = entity instanceof Infantry;
        this.isBA = entity instanceof BattleArmor;
        this.isVehicle = entity instanceof Tank;
        this.isProto = entity instanceof Protomech;
        this.isGunEmplacement = entity instanceof GunEmplacement;
        this.isSupportVehicle = entity instanceof SupportTank;
        this.isLargeSupportVehicle = entity instanceof LargeSupportTank;
        this.isSupportVTOL = entity instanceof SupportVTOL;
        this.isAero = entity instanceof Aero;
        this.isSquadron = entity instanceof FighterSquadron;
        this.isSmallCraft = entity instanceof SmallCraft;
        this.isJumpship = entity instanceof Jumpship;
        this.isSpaceStation = entity instanceof SpaceStation;
        this.sLoadout.append(this.getWeapons(bl)).append("\r\n");
        if (!entity.usesWeaponBays() || !bl) {
            this.sLoadout.append(this.getAmmo()).append("\r\n");
        }
        if (entity instanceof Aero) {
            this.sLoadout.append(this.getBombs()).append("\r\n");
        }
        this.sLoadout.append(this.getMisc()).append("\r\n").append(this.getFailed()).append("\r\n");
        DecimalFormat decimalFormat = new DecimalFormat("#,###.##");
        this.sLoadout.append("BV: ");
        this.sLoadout.append(decimalFormat.format(entity.calculateBattleValue()));
        this.sLoadout.append(" Cost: ");
        this.sLoadout.append(decimalFormat.format(entity.getCost()));
        this.sLoadout.append(" Cbills");
        this.sBasic.append(entity.getShortNameRaw());
        this.sBasic.append("\r\n");
        if (!this.isInf) {
            this.sBasic.append(Math.round(entity.getWeight())).append(Messages.getString("MechView.tons"));
        }
        if (this.isBA && ((BattleArmor)entity).isBurdened()) {
            this.sBasic.append(Messages.getString("MechView.Burdened"));
        }
        if (entity.isMixedTech()) {
            if (entity.isClan()) {
                this.sBasic.append(Messages.getString("MechView.MixedClan"));
            } else {
                this.sBasic.append(Messages.getString("MechView.MixedIS"));
            }
        } else {
            this.sBasic.append(TechConstants.getLevelDisplayableName(entity.getTechLevel()));
        }
        this.sBasic.append("\n");
        if (!this.isGunEmplacement) {
            this.sBasic.append("\n");
            this.sBasic.append(Messages.getString("MechView.Movement")).append(entity.getWalkMP()).append("/").append(entity.getRunMPasString());
            if (entity.getJumpMP() > 0) {
                this.sBasic.append("/").append(entity.getJumpMP());
            }
        }
        if (this.isVehicle) {
            this.sBasic.append(" (").append(Messages.getString("MovementType." + entity.getMovementModeAsString())).append(")");
        }
        this.sBasic.append("\n");
        if (this.isMech || this.isVehicle || this.isAero && !this.isSmallCraft && !this.isJumpship && !this.isSquadron) {
            this.sBasic.append(Messages.getString("MechView.Engine"));
            this.sBasic.append(entity.getEngine().getShortEngineName());
            this.sBasic.append("\n");
        }
        if (this.isSupportVehicle) {
            this.sBasic.append(Messages.getString("MechView.BARRating"));
            this.sBasic.append(((SupportTank)entity).getBARRating());
            this.sBasic.append("\n");
        }
        if (this.isSupportVTOL) {
            this.sBasic.append(Messages.getString("MechView.BARRating"));
            this.sBasic.append(((SupportVTOL)entity).getBARRating());
            this.sBasic.append("\n");
        }
        if (this.isAero) {
            entity2 = (Aero)entity;
            this.sBasic.append(Messages.getString("MechView.HeatSinks")).append(((Aero)entity2).getHeatSinks());
            if (((Aero)entity2).getHeatCapacity() > ((Aero)entity2).getHeatSinks()) {
                this.sBasic.append(" [").append(((Aero)entity2).getHeatCapacity()).append("]");
            }
            if (((Aero)entity2).getCockpitType() != 0) {
                this.sBasic.append("\n");
                this.sBasic.append(Messages.getString("MechView.Cockpit"));
                this.sBasic.append(((Aero)entity2).getCockpitTypeString());
            }
        }
        if (this.isMech) {
            entity2 = (Mech)entity;
            this.sBasic.append(Messages.getString("MechView.HeatSinks")).append(((Mech)entity2).heatSinks());
            if (((Mech)entity2).getHeatCapacity() > ((Mech)entity2).heatSinks()) {
                this.sBasic.append(" [").append(((Mech)entity2).getHeatCapacity()).append("]");
            }
            if (((Mech)entity2).getCockpitType() != 0) {
                this.sBasic.append("\n");
                this.sBasic.append(Messages.getString("MechView.Cockpit"));
                this.sBasic.append(((Mech)entity2).getCockpitTypeString());
            }
            if (((Mech)entity2).getGyroType() != 0) {
                this.sBasic.append("\n");
                this.sBasic.append(Messages.getString("MechView.Gyro"));
                this.sBasic.append(((Mech)entity2).getGyroTypeString());
            }
            this.sBasic.append("\n");
        }
        this.sBasic.append("\n");
        if (!this.isGunEmplacement) {
            if (this.isSquadron) {
                this.sBasic.append(this.getArmor());
            } else if (this.isAero) {
                this.sBasic.append(this.getSIandArmor());
            } else {
                this.sBasic.append(this.getInternalAndArmor());
            }
        } else {
            this.sBasic.append(Messages.getString("MechView.ConstructionFactor")).append(MechView.renderArmor(entity.getArmor(0))).append('\n');
            if (((GunEmplacement)entity).hasTurret()) {
                this.sBasic.append(Messages.getString("MechView.TurretArmor")).append(MechView.renderArmor(entity.getArmor(4))).append('\n');
            }
        }
        if (entity.getFluff() != null) {
            this.sFluff.append(entity.getFluff());
        }
        this.sFluff.append('\n');
    }

    public String getMechReadoutBasic() {
        return this.sBasic.toString();
    }

    public String getMechReadoutLoadout() {
        return this.sLoadout.toString();
    }

    public String getMechReadoutFluff() {
        return this.sFluff.toString();
    }

    public String getMechReadout() {
        return this.getMechReadoutBasic() + "\n" + this.getMechReadoutLoadout() + "\n" + this.getMechReadoutFluff();
    }

    private String getInternalAndArmor() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.entity.getTotalInternal() * 2 + 3;
        stringBuffer.append(Messages.getString("MechView.Internal")).append(this.entity.getTotalInternal());
        if (this.isMech) {
            stringBuffer.append(Messages.getString("MechView." + EquipmentType.getStructureTypeName(this.entity.getStructureType())));
        }
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("MechView.Armor")).append(this.entity.getTotalArmor());
        if (this.isMech) {
            stringBuffer.append("/").append(n);
        }
        if (!this.isInf && !this.isProto) {
            stringBuffer.append(Messages.getString("MechView." + EquipmentType.getArmorTypeName(this.entity.getArmorType())));
        }
        stringBuffer.append("\n");
        for (int i = 0; i < this.entity.locations(); ++i) {
            if (-1 == this.entity.getInternal(i) || this.isVehicle && (i == 5 && ((Tank)this.entity).hasNoTurret() || i == 0 || this.isLargeSupportVehicle && (i == 7 && ((LargeSupportTank)this.entity).hasNoTurret() || i == 0))) continue;
            if (this.entity.getLocationAbbr(i).length() < 2) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.entity.getLocationAbbr(i)).append(": ");
            stringBuffer.append(MechView.renderArmor(this.entity.getInternal(i))).append("   ");
            if (-1 != this.entity.getArmor(i)) {
                stringBuffer.append(MechView.renderArmor(this.entity.getArmor(i)));
            }
            if (this.entity.hasRearArmor(i)) {
                stringBuffer.append(" (").append(MechView.renderArmor(this.entity.getArmor(i, true))).append(")");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String getSIandArmor() {
        Aero aero = (Aero)this.entity;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("MechView.SI")).append(aero.getSI());
        stringBuffer.append("\n");
        if (this.isJumpship & !this.isSpaceStation) {
            Jumpship jumpship = (Jumpship)this.entity;
            stringBuffer.append(Messages.getString("MechView.SailIntegrity")).append(jumpship.getSailIntegrity());
            stringBuffer.append("\n");
            stringBuffer.append(Messages.getString("MechView.KFIntegrity")).append(jumpship.getKFIntegrity());
            stringBuffer.append("\n");
        }
        stringBuffer.append(Messages.getString("MechView.Armor")).append(this.entity.getTotalArmor());
        if (this.entity.isCapitalFighter()) {
            stringBuffer.append(Messages.getString("MechView.Armor")).append(aero.getCapArmor());
        } else {
            stringBuffer.append(Messages.getString("MechView.Armor")).append(this.entity.getTotalArmor());
        }
        if (this.isJumpship) {
            stringBuffer.append(Messages.getString("MechView.CapitalArmor"));
        }
        stringBuffer.append(Messages.getString("MechView." + EquipmentType.getArmorTypeName(this.entity.getArmorType())));
        stringBuffer.append("\n");
        for (int i = 0; i < this.entity.locations(); ++i) {
            if (-1 == this.entity.getInternal(i) || this.entity instanceof Warship && (i == 6 || i == 7) || !aero.isLargeCraft() && i == 4 || this.entity.isCapitalFighter()) continue;
            stringBuffer.append("  ");
            stringBuffer.append(this.entity.getLocationAbbr(i)).append(": ");
            if (-1 != this.entity.getArmor(i)) {
                stringBuffer.append(MechView.renderArmor(this.entity.getArmor(i)));
            }
            if (this.entity.hasRearArmor(i)) {
                stringBuffer.append(" (").append(MechView.renderArmor(this.entity.getArmor(i, true))).append(")");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String getArmor() {
        FighterSquadron fighterSquadron = (FighterSquadron)this.entity;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("MechView.Armor")).append(fighterSquadron.getTotalArmor());
        stringBuffer.append("\n");
        stringBuffer.append(Messages.getString("MechView.ActiveFighters")).append(fighterSquadron.getNFighters());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getWeapons(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Mounted mounted : this.entity.getWeaponList()) {
            Object object;
            WeaponType weaponType = (WeaponType)mounted.getType();
            stringBuffer.append(mounted.getDesc()).append("  [").append(this.entity.getLocationAbbr(mounted.getLocation()));
            if (mounted.isSplit()) {
                stringBuffer.append("/").append(this.entity.getLocationAbbr(mounted.getSecondLocation()));
            }
            stringBuffer.append("]");
            if (this.entity.isClan() && mounted.getType().getInternalName().substring(0, 2).equals("IS")) {
                stringBuffer.append(Messages.getString("MechView.IS"));
            }
            if (!this.entity.isClan() && mounted.getType().getInternalName().substring(0, 2).equals("CL")) {
                stringBuffer.append(Messages.getString("MechView.Clan"));
            }
            if (weaponType.hasFlag(16384L)) {
                stringBuffer.append(" <").append(mounted.getLinked().getDesc()).append(">");
            }
            if (weaponType instanceof BayWeapon) {
                int n = 0;
                for (int n2 : mounted.getBayWeapons()) {
                    object = this.entity.getEquipment(n2);
                    if (null == object) continue;
                    n += ((WeaponType)((Mounted)object).getType()).getHeat();
                }
                stringBuffer.append(" ").append(n).append(Messages.getString("MechView.Heat"));
            } else {
                stringBuffer.append(" ").append(weaponType.getHeat()).append(Messages.getString("MechView.Heat"));
            }
            stringBuffer.append("\n");
            if (!(weaponType instanceof BayWeapon) || !bl) continue;
            for (int n : mounted.getBayWeapons()) {
                Mounted mounted2 = this.entity.getEquipment(n);
                if (null == mounted2) continue;
                object = (WeaponType)mounted2.getType();
                stringBuffer.append("  ").append(mounted2.getDesc());
                if (this.entity.isClan() && mounted2.getType().getInternalName().substring(0, 2).equals("IS")) {
                    stringBuffer.append(Messages.getString("MechView.IS"));
                }
                if (!this.entity.isClan() && mounted2.getType().getInternalName().substring(0, 2).equals("CL")) {
                    stringBuffer.append(Messages.getString("MechView.Clan"));
                }
                if (((EquipmentType)object).hasFlag(16384L)) {
                    stringBuffer.append(" <").append(mounted.getLinked().getDesc()).append(">");
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private String getAmmo() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Mounted mounted : this.entity.getAmmo()) {
            if (mounted.getLocation() == -1) continue;
            stringBuffer.append(mounted.getDesc()).append("  [").append(this.entity.getLocationAbbr(mounted.getLocation())).append("]\n");
        }
        return stringBuffer.toString();
    }

    private String getBombs() {
        StringBuffer stringBuffer = new StringBuffer();
        Aero aero = (Aero)this.entity;
        int[] nArray = aero.getBombChoices();
        for (int i = 0; i < 15; ++i) {
            if (nArray[i] <= 0) continue;
            stringBuffer.append(BombType.getBombName(i)).append(" (").append(Integer.toString(nArray[i])).append(")\n");
        }
        return stringBuffer.toString();
    }

    private String getMisc() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Mounted mounted : this.entity.getMisc()) {
            String string = mounted.getName();
            if (string.indexOf("Jump Jet") != -1 || string.indexOf("CASE") != -1 && this.entity.isClan() || string.indexOf("Heat Sink") != -1 || string.indexOf("Endo Steel") != -1 || string.indexOf("Ferro-Fibrous") != -1) continue;
            stringBuffer.append(mounted.getDesc()).append("  [").append(this.entity.getLocationAbbr(mounted.getLocation())).append("]");
            if (this.entity.isClan() && mounted.getType().getInternalName().substring(0, 2).equals("IS")) {
                stringBuffer.append(Messages.getString("MechView.IS"));
            }
            if (!this.entity.isClan() && mounted.getType().getInternalName().substring(0, 2).equals("CL")) {
                stringBuffer.append(Messages.getString("MechView.Clan"));
            }
            stringBuffer.append("\n");
        }
        String string = this.entity.getUnusedString();
        if (string != null && string.length() > 0) {
            stringBuffer.append(Messages.getString("MechView.CarringCapacity")).append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private String getFailed() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = this.entity.getFailedEquipment();
        if (iterator.hasNext()) {
            stringBuffer.append("The following equipment\n slots failed to load:\n");
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next()).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private static String renderArmor(int n) {
        if (n <= 0) {
            return "xx";
        }
        return MechView.makeLength(String.valueOf(n), 3, true);
    }

    private static String makeLength(String string, int n, boolean bl) {
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 < n) {
            if (bl) {
                return SPACES.substring(0, n - n2) + string;
            }
            return string + SPACES.substring(0, n - n2);
        }
        return string.substring(0, n - 2) + "..";
    }
}

