/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import megamek.client.ui.swing.DialogOptionListener;
import megamek.common.options.IBasicOption;
import megamek.common.options.IOption;

public class DialogOptionComponent
extends JPanel
implements MouseListener,
ItemListener {
    private static final long serialVersionUID = -4190538980884459746L;
    IOption option;
    private JCheckBox checkbox;
    private JComboBox choice;
    private JTextField textField;
    private JLabel label;
    private DialogOptionListener dialogOptionListener;

    public DialogOptionComponent(DialogOptionListener dialogOptionListener, IOption iOption) {
        this(dialogOptionListener, iOption, true);
    }

    public DialogOptionComponent(DialogOptionListener dialogOptionListener, IOption iOption, boolean bl) {
        this.dialogOptionListener = dialogOptionListener;
        this.option = iOption;
        this.addMouseListener(this);
        this.setLayout(new BorderLayout());
        switch (iOption.getType()) {
            case 0: {
                this.checkbox = new JCheckBox(iOption.getDisplayableName(), iOption.booleanValue());
                this.checkbox.addMouseListener(this);
                this.checkbox.addItemListener(this);
                this.add((Component)this.checkbox, "Center");
                if (bl) break;
                this.checkbox.setEnabled(false);
                break;
            }
            case 4: {
                this.choice = new JComboBox();
                this.choice.addMouseListener(this);
                this.label = new JLabel(iOption.getDisplayableName());
                this.label.addMouseListener(this);
                this.add((Component)this.label, "West");
                this.add((Component)this.choice, "Center");
                if (bl) break;
                this.choice.setEnabled(false);
                break;
            }
            default: {
                this.textField = new JTextField(iOption.stringValue(), iOption.getTextFieldLength());
                this.textField.addMouseListener(this);
                this.label = new JLabel(iOption.getDisplayableName());
                this.label.addMouseListener(this);
                if (iOption.isLabelBeforeTextField()) {
                    this.add((Component)this.label, "Center");
                    this.add((Component)this.textField, "West");
                } else {
                    this.add((Component)this.textField, "West");
                    this.add((Component)this.label, "Center");
                }
                if (bl) break;
                this.textField.setEnabled(false);
            }
        }
    }

    public boolean hasChanged() {
        return !this.option.getValue().equals(this.getValue());
    }

    public Object getValue() {
        String string = "";
        switch (this.option.getType()) {
            case 0: {
                return this.checkbox.isSelected();
            }
            case 1: {
                string = this.textField.getText();
                if (string.trim().equals("")) {
                    string = "0";
                }
                return Integer.valueOf(this.textField.getText());
            }
            case 2: {
                string = this.textField.getText();
                if (string.trim().equals("")) {
                    string = "0";
                }
                return Float.valueOf(this.textField.getText());
            }
            case 3: {
                return this.textField.getText();
            }
            case 4: {
                return this.choice.getSelectedItem();
            }
        }
        return null;
    }

    public IOption getOption() {
        return this.option;
    }

    public void setEditable(boolean bl) {
        switch (this.option.getType()) {
            case 0: {
                this.checkbox.setEnabled(bl);
                break;
            }
            case 4: {
                this.choice.setEnabled(bl);
                break;
            }
            default: {
                this.textField.setEnabled(bl);
            }
        }
    }

    public void setSelected(boolean bl) {
        this.checkbox.setSelected(bl);
    }

    public void setSelected(String string) {
        this.choice.setSelectedItem(string);
    }

    public void addValue(String string) {
        this.choice.addItem(string);
    }

    public void resetToDefault() {
        switch (this.option.getType()) {
            case 0: {
                this.checkbox.setSelected((Boolean)this.option.getDefault());
                break;
            }
            case 4: {
                this.choice.setSelectedIndex(0);
                break;
            }
            default: {
                this.textField.setText(String.valueOf(this.option.getDefault()));
            }
        }
    }

    public IBasicOption changedOption() {
        return new BasicOption(this.option.getName(), this.getValue());
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.dialogOptionListener.showDescFor(this.option);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.dialogOptionListener.optionClicked(this, this.option, this.checkbox.isSelected());
    }

    private static class BasicOption
    implements IBasicOption,
    Serializable {
        private static final long serialVersionUID = -1888895390718831758L;
        private String name;
        private Object value;

        BasicOption(String string, Object object) {
            this.name = string;
            this.value = object;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

