/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.common.ManeuverType;

public class ManeuverChoiceDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 3093043054221558221L;
    private boolean confirm;
    private JPanel panButtons = new JPanel();
    private JButton butOK = new JButton(Messages.getString("Okay"));
    private JButton butCancel = new JButton(Messages.getString("Cancel"));
    private AbstractButton[] checkboxes;

    private void initialize(JFrame jFrame, String string, String[] stringArray) {
        Serializable serializable;
        super.setResizable(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        if (stringArray != null && stringArray.length > 0) {
            serializable = new JPanel(new GridLayout(0, 1));
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(0, 10, 0, 10);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 10;
            if (stringArray.length > 10) {
                int n = gridBagConstraints.fill;
                gridBagConstraints.fill = 2;
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.add((Component)serializable, gridBagConstraints2);
                JScrollPane jScrollPane = new JScrollPane(jPanel);
                this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
                gridBagConstraints.fill = n;
            } else {
                this.getContentPane().add((Component)serializable, gridBagConstraints);
            }
            this.checkboxes = new JRadioButton[stringArray.length];
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i = 0; i < stringArray.length; ++i) {
                this.checkboxes[i] = new JRadioButton(stringArray[i], i == 0);
                buttonGroup.add(this.checkboxes[i]);
                ((Container)serializable).add(this.checkboxes[i]);
            }
        }
        this.setupButtons();
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.getContentPane().add((Component)this.panButtons, gridBagConstraints);
        this.butOK.requestFocus();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ManeuverChoiceDialog.this.setVisible(false);
            }
        });
        this.pack();
        serializable = this.getSize();
        boolean bl = false;
        if (((Dimension)serializable).width < GUIPreferences.getInstance().getMinimumSizeWidth()) {
            ((Dimension)serializable).width = GUIPreferences.getInstance().getMinimumSizeWidth();
        }
        if (((Dimension)serializable).height < GUIPreferences.getInstance().getMinimumSizeHeight()) {
            ((Dimension)serializable).height = GUIPreferences.getInstance().getMinimumSizeHeight();
        }
        if (bl) {
            this.setSize((Dimension)serializable);
            serializable = this.getSize();
        }
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - ((Dimension)serializable).width / 2, jFrame.getLocation().y + jFrame.getSize().height / 2 - ((Dimension)serializable).height / 2);
    }

    private void setupButtons() {
        this.butOK.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butOK, gridBagConstraints);
        this.panButtons.add(this.butOK);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    public ManeuverChoiceDialog(JFrame jFrame, String string, String string2) {
        super(jFrame, string, true);
        String[] stringArray = new String[ManeuverType.MAN_SIZE];
        for (int i = 0; i < ManeuverType.MAN_SIZE; ++i) {
            stringArray[i] = ManeuverType.getTypeName(i);
        }
        this.initialize(jFrame, string2, stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.checkboxes == null) {
            this.confirm = false;
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this.butOK)) {
            this.confirm = true;
            this.setVisible(false);
        } else {
            this.confirm = false;
            this.setVisible(false);
        }
    }

    public boolean getAnswer() {
        return -1 != this.getChoice();
    }

    public int getChoice() {
        int[] nArray = null;
        if (this.checkboxes != null && this.confirm) {
            int[] nArray2 = new int[this.checkboxes.length];
            int n = 0;
            for (int i = 0; i < this.checkboxes.length; ++i) {
                if (!this.checkboxes[i].isSelected()) continue;
                nArray2[n] = i;
                ++n;
            }
            if (this.checkboxes.length == n) {
                nArray = nArray2;
            } else if (n > 0) {
                nArray = new int[n];
                System.arraycopy(nArray2, 0, nArray, 0, n);
            }
        }
        return (int)nArray[0];
    }

    public void checkPerformability(int n, int n2, int n3, boolean bl, int n4) {
        for (int i = 0; i < ManeuverType.MAN_SIZE; ++i) {
            this.checkboxes[i].setEnabled(ManeuverType.canPerform(i, n, n2, n3, bl, n4));
        }
    }
}

