/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.common.Entity;
import megamek.common.Mounted;

public class MineLayingDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1067865530113792340L;
    private JButton butOkay = new JButton(Messages.getString("Okay"));
    private JButton butCancel = new JButton(Messages.getString("Cancel"));
    private JLabel labMessage;
    private boolean okay = true;
    private Entity entity;
    private JComboBox chMines = new JComboBox();
    private ArrayList<Mounted> vMines = new ArrayList();

    public MineLayingDialog(JFrame jFrame, Entity entity) {
        super(jFrame, Messages.getString("MineLayingDialog.title"), true);
        Serializable serializable;
        this.entity = entity;
        this.labMessage = new JLabel(Messages.getString("MineLayingDialog.selectMineToLay", new Object[]{entity.getDisplayName()}));
        for (Mounted serializable22 : entity.getMisc()) {
            if (!serializable22.getType().hasFlag(131072L) || !serializable22.canFire()) continue;
            serializable = new StringBuffer();
            serializable.append(entity.getLocationName(serializable22.getLocation())).append(' ').append(serializable22.getDesc());
            this.chMines.addItem(serializable.toString());
            this.vMines.add(serializable22);
        }
        this.butOkay.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labMessage, gridBagConstraints);
        this.getContentPane().add(this.labMessage);
        gridBagLayout.setConstraints(this.chMines, gridBagConstraints);
        this.getContentPane().add(this.chMines);
        this.getContentPane().add(this.butOkay);
        this.getContentPane().add(this.butCancel);
        this.butOkay.requestFocus();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MineLayingDialog.this.setVisible(false);
            }
        });
        this.pack();
        serializable = this.getSize();
        boolean bl = false;
        if (((Dimension)serializable).width < GUIPreferences.getInstance().getMinimumSizeWidth()) {
            ((Dimension)serializable).width = GUIPreferences.getInstance().getMinimumSizeWidth();
        }
        if (((Dimension)serializable).height < GUIPreferences.getInstance().getMinimumSizeHeight()) {
            ((Dimension)serializable).height = GUIPreferences.getInstance().getMinimumSizeHeight();
        }
        if (bl) {
            this.setSize((Dimension)serializable);
            serializable = this.getSize();
        }
        this.setResizable(false);
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - ((Dimension)serializable).width / 2, jFrame.getLocation().y + jFrame.getSize().height / 2 - ((Dimension)serializable).height / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.butCancel)) {
            this.okay = false;
        }
        this.setVisible(false);
    }

    public boolean getAnswer() {
        return this.okay;
    }

    public int getMine() {
        Mounted mounted = this.vMines.get(this.chMines.getSelectedIndex());
        return this.entity.getEquipmentNum(mounted);
    }
}

