/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import megamek.client.Client;
import megamek.client.ui.swing.DoneButtoned;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.StatusBarPhaseDisplay;
import megamek.common.IGame;
import megamek.common.event.GamePhaseChangeEvent;

public class ReportDisplay
extends StatusBarPhaseDisplay
implements ActionListener,
KeyListener,
DoneButtoned {
    private static final long serialVersionUID = 6185643976857892270L;
    public Client client;
    private JTabbedPane tabs;
    private JButton readyB;
    private JButton rerollInitiativeB;
    private boolean rerolled;

    public ReportDisplay(Client client) {
        this.client = client;
        client.game.addGameListener(this);
        this.tabs = new JTabbedPane();
        Font font = new Font("Dialog", 1, GUIPreferences.getInstance().getInt("AdvancedChatLoungeTabFontSize"));
        this.tabs.setFont(font);
        this.resetTabs();
        this.setupStatusBar("");
        this.readyB = new JButton(Messages.getString("ReportDisplay.Done"));
        this.readyB.setActionCommand("ready");
        this.readyB.addActionListener(this);
        this.rerollInitiativeB = new JButton(Messages.getString("ReportDisplay.Reroll"));
        this.rerollInitiativeB.setActionCommand("reroll_initiative");
        this.rerollInitiativeB.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.tabs, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 8));
        jPanel.add(this.rerollInitiativeB);
        for (int i = 0; i < 6; ++i) {
            jPanel.add(new JLabel(""));
        }
        this.addBag(jPanel, gridBagLayout, gridBagConstraints);
        this.addKeyListener(this);
    }

    private void addBag(JComponent jComponent, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
        jComponent.addKeyListener(this);
    }

    public void showRerollButton(boolean bl) {
        this.rerollInitiativeB.setVisible(bl);
    }

    public void ready() {
        this.rerollInitiativeB.setEnabled(false);
        this.readyB.setEnabled(false);
        this.client.sendDone(true);
    }

    public void rerollInitiative() {
        this.rerolled = true;
        this.rerollInitiativeB.setEnabled(false);
        this.readyB.setEnabled(false);
        this.client.sendRerollInitiativeRequest();
    }

    public boolean hasRerolled() {
        return this.rerolled;
    }

    public void resetButtons() {
        this.resetReadyButton();
        if (this.client.game.getPhase() == IGame.Phase.PHASE_INITIATIVE_REPORT && this.client.game.hasTacticalGenius(this.client.getLocalPlayer())) {
            this.showRerollButton(true);
        } else {
            this.showRerollButton(false);
        }
        this.rerollInitiativeB.setEnabled(true);
    }

    public void resetReadyButton() {
        this.readyB.setEnabled(true);
    }

    public void resetRerollButton() {
        this.rerollInitiativeB.setEnabled(true);
    }

    public void setReportTab(int n, String string, String string2) {
        if (n == 0) {
            n = 1;
        }
        if (this.tabs.indexOfTab("Round " + n) == -1) {
            JTextArea jTextArea;
            int n2 = this.tabs.indexOfTab("Phase");
            if (n2 >= 0) {
                this.tabs.removeTabAt(n2);
            }
            if (n2 == -1) {
                ++n2;
            }
            for (int i = n2 + 1; i <= n; ++i) {
                if (this.tabs.indexOfTab("Round " + i) != -1) {
                    ((JTextArea)((JScrollPane)this.tabs.getComponentAt(this.tabs.indexOfTab("Round " + i))).getViewport().getView()).setText(this.client.receiveReport(this.client.game.getReports(i)));
                    continue;
                }
                String string3 = string;
                if (i != n) {
                    string3 = this.client.receiveReport(this.client.game.getReports(i));
                }
                jTextArea = new JTextArea(string3, 40, 25);
                jTextArea.setEditable(false);
                this.tabs.add("Round " + i, new JScrollPane(jTextArea));
            }
            jTextArea = new JTextArea(string2, 40, 25);
            jTextArea.setEditable(false);
            jTextArea.setOpaque(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            this.tabs.add("Phase", jScrollPane);
            this.tabs.setSelectedComponent(jScrollPane);
        } else {
            ((JTextArea)((JScrollPane)this.tabs.getComponentAt(this.tabs.indexOfTab("Round " + n))).getViewport().getView()).setText(string);
            ((JTextArea)((JScrollPane)this.tabs.getComponentAt(this.tabs.indexOfTab("Phase"))).getViewport().getView()).setText(string2);
        }
    }

    public void appendReportTab(String string) {
        int n = this.tabs.indexOfTab("Phase");
        if (n > 0) {
            ((JTextArea)((JScrollPane)this.tabs.getComponentAt(n - 1)).getViewport().getView()).append(string);
        }
        ((JTextArea)((JScrollPane)this.tabs.getComponentAt(n)).getViewport().getView()).append(string);
    }

    public void resetTabs() {
        this.tabs.removeAll();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase("ready")) {
            this.ready();
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase("reroll_initiative")) {
            this.rerollInitiative();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            // empty if block
        }
        if (keyEvent.getKeyCode() == 10 && keyEvent.isControlDown()) {
            this.ready();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.isIgnoringEvents()) {
            return;
        }
        this.setReportTab(this.client.game.getRoundCount(), this.client.roundReport, this.client.phaseReport);
        this.resetButtons();
        this.rerolled = false;
    }

    public void removeAllListeners() {
        this.client.game.removeGameListener(this);
    }

    public JButton getDoneButton() {
        return this.readyB;
    }

    public JComponent getSecondaryDisplay() {
        return this.panStatus;
    }
}

