/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import javax.swing.JComponent;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.widget.BackGroundDrawer;
import megamek.client.ui.swing.widget.DisplayMapSet;
import megamek.client.ui.swing.widget.PMAreasGroup;
import megamek.client.ui.swing.widget.PMPicArea;
import megamek.client.ui.swing.widget.PMUtil;
import megamek.client.ui.swing.widget.PMValueLabel;
import megamek.common.BattleArmor;
import megamek.common.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BattleArmorMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private Image battleArmorImage;
    private Image[] armorImage = new Image[6];
    private JComponent comp;
    private PMPicArea[] unitAreas = new PMPicArea[6];
    private PMPicArea[] armorAreas = new PMPicArea[6];
    private PMValueLabel[] armorLabels = new PMValueLabel[6];
    private PMAreasGroup content = new PMAreasGroup();
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private int stepY = 53;
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));

    public BattleArmorMapSet(JComponent jComponent) {
        this.comp = jComponent;
        this.setAreas();
        this.setBackGround();
    }

    private void setAreas() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.battleArmorImage = this.comp.getToolkit().getImage("data/images/widgets/battle_armor.gif");
        PMUtil.setImage(this.battleArmorImage, this.comp);
        for (int i = 0; i < 6; ++i) {
            int n = i * this.stepY;
            this.unitAreas[i] = new PMPicArea(this.battleArmorImage);
            this.unitAreas[i].translate(0, n);
            this.content.addArea(this.unitAreas[i]);
            this.armorImage[i] = this.comp.createImage(105, 12);
            this.armorAreas[i] = new PMPicArea(this.armorImage[i]);
            this.armorAreas[i].translate(45, n + 12);
            this.content.addArea(this.armorAreas[i]);
            this.armorLabels[i] = new PMValueLabel(fontMetrics, Color.red.brighter());
            this.armorLabels[i].moveTo(160, n + 24);
            this.content.addArea(this.armorLabels[i]);
        }
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        int n;
        BattleArmor battleArmor = (BattleArmor)entity;
        int n2 = 0;
        int n3 = 0;
        int n4 = Math.round(battleArmor.getWeight());
        for (n = 0; n < n4; ++n) {
            this.armorAreas[n].setVisible(true);
            this.armorLabels[n].setVisible(true);
            this.unitAreas[n].setVisible(true);
        }
        for (n = n4; n < 6; ++n) {
            this.armorAreas[n].setVisible(false);
            this.armorLabels[n].setVisible(false);
            this.unitAreas[n].setVisible(false);
        }
        for (n = 0; n < n4; ++n) {
            n2 = battleArmor.getArmor(n + 1, false) < 0 ? 0 : battleArmor.getArmor(n + 1, false);
            int n5 = n3 = battleArmor.getInternal(n + 1) < 0 ? 0 : battleArmor.getInternal(n + 1);
            if (n2 + n3 == 0) {
                this.armorAreas[n].setVisible(false);
                this.armorLabels[n].setValue(Messages.getString("BattleArmorMapSet.Killed"));
                continue;
            }
            this.drawArmorImage(this.armorImage[n], n2 + n3);
            this.armorLabels[n].setValue(Integer.toString(n2 + n3));
            this.armorAreas[n].setVisible(true);
        }
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }

    private void drawArmorImage(Image image, int n) {
        int n2 = 0;
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n3, n4);
        for (int i = 0; i < n; ++i) {
            n2 = i * 7;
            graphics.setColor(Color.green.darker());
            graphics.fillRect(n2, 0, 5, 12);
        }
    }
}

