/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BombType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Dropship;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.LocationFullException;
import megamek.common.ManeuverType;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Report;
import megamek.common.Team;
import megamek.common.UnitType;
import megamek.common.WeaponType;
import megamek.common.weapons.EnergyWeapon;
import megamek.common.weapons.GaussWeapon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aero
extends Entity
implements Serializable {
    private static final long serialVersionUID = 7196307097459255187L;
    private boolean m_bImmobile = false;
    private boolean m_bImmobileHit = false;
    protected int movementDamage = 0;
    public static final int LOC_NOSE = 0;
    public static final int LOC_LWING = 1;
    public static final int LOC_RWING = 2;
    public static final int LOC_AFT = 3;
    public static final int LOC_WINGS = 4;
    public static final int RAM_TOWARD_DIR = 0;
    public static final int RAM_TOWARD_OBL = 1;
    public static final int RAM_AWAY_OBL = 2;
    public static final int RAM_AWAY_DIR = 3;
    public static final int HEAT_SINGLE = 0;
    public static final int HEAT_DOUBLE = 1;
    public static final int COCKPIT_STANDARD = 0;
    public static final int COCKPIT_SMALL = 1;
    public static final int COCKPIT_COMMAND_CONSOLE = 2;
    public static final String[] COCKPIT_STRING = new String[]{"Standard Cockpit", "Small Cockpit", "Command Console"};
    public static final String[] COCKPIT_SHORT_STRING = new String[]{"Standard", "Small", "Command Console"};
    public static final int CRIT_NONE = -1;
    public static final int CRIT_CREW = 0;
    public static final int CRIT_FCS = 1;
    public static final int CRIT_WEAPON = 2;
    public static final int CRIT_CONTROL = 3;
    public static final int CRIT_SENSOR = 4;
    public static final int CRIT_BOMB = 5;
    public static final int CRIT_ENGINE = 6;
    public static final int CRIT_FUEL_TANK = 7;
    public static final int CRIT_AVIONICS = 8;
    public static final int CRIT_GEAR = 9;
    public static final int CRIT_HEATSINK = 10;
    public static final int CRIT_CARGO = 11;
    public static final int CRIT_DOCK_COLLAR = 12;
    public static final int CRIT_DOOR = 13;
    public static final int CRIT_KF_BOOM = 14;
    public static final int CRIT_LIFE_SUPPORT = 15;
    public static final int CRIT_LEFT_THRUSTER = 16;
    public static final int CRIT_RIGHT_THRUSTER = 17;
    public static final int CRIT_CIC = 18;
    public static final int CRIT_KF_DRIVE = 19;
    public static final int CRIT_GRAV_DECK = 20;
    public static final int CRIT_WEAPON_BROAD = 21;
    private static final int[] NUM_OF_SLOTS = new int[]{100, 100, 100, 100, 100, 100};
    protected static String[] LOCATION_ABBRS = new String[]{"NOS", "LWG", "RWG", "AFT", "WNG"};
    protected static String[] LOCATION_NAMES = new String[]{"Nose", "Left Wing", "Right Wing", "Aft", "Wings"};
    private int structureType = 0;
    private int sensorHits = 0;
    private int fcsHits = 0;
    private int engineHits = 0;
    private int avionicsHits = 0;
    private int cicHits = 0;
    private boolean gearHit = false;
    private int structIntegrity;
    private int orig_structIntegrity;
    private int[] damThresh = new int[]{0, 0, 0, 0, 0};
    private int potCrit = -1;
    private int[] standard_damage = new int[]{0, 0, 0, 0, 0};
    private int ignoredCrewHits = 0;
    private int cockpitType = 0;
    private int straightMoves = 0;
    private boolean spheroid = false;
    private int heatSinks;
    private int heatType = 0;
    public static final String SPACE_BOMB_ATTACK = "SpaceBombAttack";
    private int maxBombPoints = 0;
    private int[] bombChoices = new int[15];
    private int fuel = 0;
    private boolean lifeSupport = true;
    private int leftThrustHits = 0;
    private int rightThrustHits = 0;
    private boolean outControl = false;
    private boolean outCtrlHeat = false;
    private boolean randomMove = false;
    private int currentVelocity;
    private int nextVelocity = this.currentVelocity = 0;
    private boolean accLast = false;
    private boolean rolled = false;
    private boolean failedManeuver = false;
    private boolean accDecNow = false;
    boolean critThresh = false;
    boolean vstol = false;
    private int capitalArmor = 0;
    private int capitalArmor_orig = 0;
    private int fatalThresh = 2;
    private int currentDamage = 0;
    private boolean wingsHit = false;
    Map<String, Integer> weaponGroups = new HashMap<String, Integer>();
    private int whoFirst = 0;
    private int eccmRoll = 0;

    @Override
    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    @Override
    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    @Override
    public int getWalkMP(boolean bl, boolean bl2) {
        int n;
        int n2 = this.getOriginalWalkMP();
        n2 = Math.max(0, n2 - this.getCargoMpReduction());
        if (null != this.game && (n = this.game.getPlanetaryConditions().getMovementMods(this)) != 0) {
            n2 = Math.max(n2 + n, 0);
        }
        n2 = Math.max(0, n2 - (int)Math.ceil((double)this.getBombPoints() / 5.0));
        if (this.hasModularArmor()) {
            --n2;
        }
        return n2;
    }

    @Override
    public int locations() {
        return 5;
    }

    @Override
    public boolean canChangeSecondaryFacing() {
        return false;
    }

    @Override
    public boolean isValidSecondaryFacing(int n) {
        return false;
    }

    @Override
    public int clipSecondaryFacing(int n) {
        return n;
    }

    public boolean isOutControlTotal() {
        return this.outControl || this.shutDown || this.crew.isUnconscious();
    }

    public boolean isOutControl() {
        return this.outControl;
    }

    public boolean isOutCtrlHeat() {
        return this.outCtrlHeat;
    }

    public boolean isRandomMove() {
        return this.randomMove;
    }

    public boolean didAccLast() {
        return this.accLast;
    }

    public boolean hasLifeSupport() {
        return this.lifeSupport;
    }

    public void setLifeSupport(boolean bl) {
        this.lifeSupport = bl;
    }

    public boolean isRolled() {
        return this.rolled;
    }

    public void setOutControl(boolean bl) {
        this.outControl = bl;
    }

    public void setOutCtrlHeat(boolean bl) {
        this.outCtrlHeat = bl;
    }

    public void setRandomMove(boolean bl) {
        this.randomMove = bl;
    }

    public void setRolled(boolean bl) {
        this.rolled = bl;
    }

    public void setAccLast(boolean bl) {
        this.accLast = bl;
    }

    public int getBombPoints() {
        int n = 0;
        for (Mounted mounted : this.getBombs()) {
            if (mounted.getShotsLeft() <= 0) continue;
            n += BombType.getBombCost(((BombType)mounted.getType()).getBombType());
        }
        return n;
    }

    public int getMaxBombPoints() {
        return this.maxBombPoints;
    }

    public void autoSetMaxBombPoints() {
        this.maxBombPoints = Math.round(this.getWeight() / 5.0f);
    }

    public int[] getBombChoices() {
        return (int[])this.bombChoices.clone();
    }

    public void setBombChoices(int[] nArray) {
        if (nArray.length == this.bombChoices.length) {
            this.bombChoices = nArray;
        }
    }

    public void setWhoFirst() {
        this.whoFirst = Compute.randomInt(500);
    }

    public int getWhoFirst() {
        return this.whoFirst;
    }

    public int getCurrentVelocity() {
        if (this.game.useVectorMove()) {
            return this.getVelocity();
        }
        return this.currentVelocity;
    }

    public void setCurrentVelocity(int n) {
        this.currentVelocity = n;
    }

    public int getNextVelocity() {
        return this.nextVelocity;
    }

    public void setNextVelocity(int n) {
        this.nextVelocity = n;
    }

    public int getCurrentVelocityActual() {
        return this.currentVelocity;
    }

    public int getPotCrit() {
        return this.potCrit;
    }

    public void setPotCrit(int n) {
        this.potCrit = n;
    }

    public int getSI() {
        return this.structIntegrity;
    }

    public int get0SI() {
        return this.orig_structIntegrity;
    }

    public int getCapArmor() {
        return this.capitalArmor;
    }

    public void setCapArmor(int n) {
        this.capitalArmor = n;
    }

    public int getCap0Armor() {
        return this.capitalArmor_orig;
    }

    public int getFatalThresh() {
        return this.fatalThresh;
    }

    public int getCurrentDamage() {
        return this.currentDamage;
    }

    public void setCurrentDamage(int n) {
        this.currentDamage = n;
    }

    public void set0SI(int n) {
        this.orig_structIntegrity = n;
        this.structIntegrity = n;
    }

    public void autoSetSI() {
        int n = (int)Math.floor((double)this.weight / 10.0);
        int n2 = this.getOriginalWalkMP();
        this.initializeSI(Math.max(n, n2));
    }

    public void autoSetCapArmor() {
        this.capitalArmor_orig = (int)Math.round((double)this.getTotalOArmor() / 10.0);
        this.capitalArmor = (int)Math.round((double)this.getTotalArmor() / 10.0);
    }

    public void autoSetFatalThresh() {
        this.fatalThresh = Math.max(2, (int)Math.ceil((double)this.capitalArmor / 4.0));
    }

    public void initializeSI(int n) {
        this.orig_structIntegrity = n;
        this.setSI(n);
    }

    public void setSI(int n) {
        this.structIntegrity = n;
    }

    public int getSensorHits() {
        return this.sensorHits;
    }

    public void setSensorHits(int n) {
        if (n > 3) {
            n = 3;
        }
        this.sensorHits = n;
    }

    public int getFCSHits() {
        return this.fcsHits;
    }

    public void setFCSHits(int n) {
        if (n > 3) {
            n = 3;
        }
        this.fcsHits = n;
    }

    public void setCICHits(int n) {
        this.cicHits = n;
    }

    public int getCICHits() {
        return this.cicHits;
    }

    public void setIgnoredCrewHits(int n) {
        this.ignoredCrewHits = n;
    }

    public int getIgnoredCrewHits() {
        return this.ignoredCrewHits;
    }

    public int getEngineHits() {
        return this.engineHits;
    }

    public void setEngineHits(int n) {
        this.engineHits = n;
    }

    public int getAvionicsHits() {
        return this.avionicsHits;
    }

    public void setAvionicsHits(int n) {
        this.avionicsHits = n;
    }

    public boolean isGearHit() {
        return this.gearHit;
    }

    public void setGearHit(boolean bl) {
        this.gearHit = bl;
    }

    public void setHeatSinks(int n) {
        this.heatSinks = n;
    }

    public int getHeatSinks() {
        return this.heatSinks;
    }

    public void setHeatType(int n) {
        this.heatType = n;
    }

    public void setLeftThrustHits(int n) {
        this.leftThrustHits = n;
    }

    public int getLeftThrustHits() {
        return this.leftThrustHits;
    }

    public void setRightThrustHits(int n) {
        this.rightThrustHits = n;
    }

    public int getRightThrustHits() {
        return this.rightThrustHits;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int n) {
        this.fuel = n;
    }

    public int getHeatType() {
        return this.heatType;
    }

    public boolean wasCritThresh() {
        return this.critThresh;
    }

    public void setCritThresh(boolean bl) {
        this.critThresh = bl;
    }

    public void immobilize() {
        this.m_bImmobileHit = true;
        this.setOriginalWalkMP(0);
    }

    @Override
    public boolean isImmobile() {
        return false;
    }

    @Override
    public void applyDamage() {
        this.m_bImmobile |= this.m_bImmobileHit;
    }

    @Override
    public void newRound(int n) {
        super.newRound(n);
        this.setCritThresh(false);
        this.setFailedManeuver(false);
        this.setAccDecNow(false);
        this.updateBays();
        if (this.getRecoveryTurn() > 0) {
            this.setRecoveryTurn(this.getRecoveryTurn() - 1);
        }
        if (this.game.getBoard().inAtmosphere() && this.isDeployed() && n > 0) {
            this.setNextVelocity((int)Math.floor((double)this.getNextVelocity() / 2.0));
        }
        this.setCurrentVelocity(this.getNextVelocity());
        if (this.game.getOptions().booleanOption("variable_damage_thresh")) {
            this.autoSetThresh();
        }
        if (this.isOutCtrlHeat()) {
            this.setOutControl(true);
            this.setOutCtrlHeat(false);
        }
        this.setECCMRoll(Compute.d6(2));
        this.setWhoFirst();
    }

    @Override
    public String getMovementString(int n) {
        switch (n) {
            case -2: {
                return "Skidded";
            }
            case 0: {
                return "None";
            }
            case 1: {
                return "Cruised";
            }
            case 2: {
                return "Flanked";
            }
            case 3: {
                return "Jumped";
            }
            case 9: {
                return "Safe Thrust";
            }
            case 10: {
                return "Over Thrust";
            }
        }
        return "Unknown!";
    }

    @Override
    public String getMovementAbbr(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 9: {
                return "S";
            }
            case 10: {
                return "O";
            }
        }
        return "?";
    }

    @Override
    public boolean hasRearArmor(int n) {
        return false;
    }

    @Override
    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.getType().hasFlag(0x10000000000L)) {
            return 0;
        }
        int n2 = 11;
        switch (mounted.getLocation()) {
            case 0: {
                n2 = 11;
                break;
            }
            case 2: {
                if (mounted.isRearMounted()) {
                    n2 = 15;
                    break;
                }
                n2 = 13;
                break;
            }
            case 1: {
                if (mounted.isRearMounted()) {
                    n2 = 14;
                    break;
                }
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 22;
                break;
            }
            case 4: {
                n2 = 11;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return this.rollArcs(n2);
    }

    public int rollArcs(int n) {
        if (this.isRolled()) {
            if (n == 12) {
                return 13;
            }
            if (n == 13) {
                return 12;
            }
            if (n == 14) {
                return 15;
            }
            if (n == 15) {
                return 14;
            }
            if (n == 16) {
                return 17;
            }
            if (n == 17) {
                return 16;
            }
            if (n == 18) {
                return 19;
            }
            if (n == 19) {
                return 18;
            }
            if (n == 20) {
                return 21;
            }
            if (n == 21) {
                return 20;
            }
        }
        return n;
    }

    @Override
    public boolean isSecondaryArcWeapon(int n) {
        return true;
    }

    @Override
    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        return this.rollHitLocation(n, n2);
    }

    @Override
    public HitData rollHitLocation(int n, int n2) {
        int n3 = Compute.d6(2);
        if (n == 4 || n == 5) {
            int n4 = 2;
            int n5 = Compute.d6(1);
            if (n5 > 3) {
                n4 = 1;
            }
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(9);
                    return new HitData(n4, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(0);
                    return new HitData(0, false, 0);
                }
                case 6: {
                    this.setPotCrit(2);
                    return new HitData(n4, false, 0);
                }
                case 7: {
                    this.setPotCrit(8);
                    return new HitData(0, false, 0);
                }
                case 8: {
                    this.setPotCrit(2);
                    return new HitData(n4, false, 0);
                }
                case 9: {
                    this.setPotCrit(3);
                    return new HitData(3, false, 0);
                }
                case 10: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(9);
                    return new HitData(n4, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        }
        if (n2 == 0) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 4: {
                    this.setPotCrit(10);
                    return new HitData(2, false, 0);
                }
                case 5: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 6: {
                    this.setPotCrit(8);
                    return new HitData(0, false, 0);
                }
                case 7: {
                    this.setPotCrit(3);
                    return new HitData(0, false, 0);
                }
                case 8: {
                    this.setPotCrit(1);
                    return new HitData(0, false, 0);
                }
                case 9: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 10: {
                    this.setPotCrit(10);
                    return new HitData(1, false, 0);
                }
                case 11: {
                    this.setPotCrit(9);
                    return new HitData(0, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
            }
        } else if (n2 == 2) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(9);
                    return new HitData(1, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(0);
                    return new HitData(0, false, 0);
                }
                case 6: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 7: {
                    this.setPotCrit(8);
                    return new HitData(1, false, 0);
                }
                case 8: {
                    this.setPotCrit(5);
                    return new HitData(1, false, 0);
                }
                case 9: {
                    this.setPotCrit(3);
                    return new HitData(3, false, 0);
                }
                case 10: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(9);
                    return new HitData(1, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        } else if (n2 == 3) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(9);
                    return new HitData(2, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(0);
                    return new HitData(0, false, 0);
                }
                case 6: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 7: {
                    this.setPotCrit(8);
                    return new HitData(2, false, 0);
                }
                case 8: {
                    this.setPotCrit(5);
                    return new HitData(2, false, 0);
                }
                case 9: {
                    this.setPotCrit(3);
                    return new HitData(3, false, 0);
                }
                case 10: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(9);
                    return new HitData(2, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        } else if (n2 == 1) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
                case 3: {
                    this.setPotCrit(10);
                    return new HitData(3, false, 0);
                }
                case 4: {
                    this.setPotCrit(7);
                    return new HitData(2, false, 0);
                }
                case 5: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 6: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 7: {
                    this.setPotCrit(3);
                    return new HitData(3, false, 0);
                }
                case 8: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 9: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 10: {
                    this.setPotCrit(7);
                    return new HitData(1, false, 0);
                }
                case 11: {
                    this.setPotCrit(10);
                    return new HitData(3, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        }
        return new HitData(0, false, 0);
    }

    @Override
    public HitData getTransferLocation(HitData hitData) {
        return new HitData(-2);
    }

    @Override
    public int getDependentLocation(int n) {
        return -1;
    }

    @Override
    public int calculateBattleValue() {
        return this.calculateBattleValue(false, false);
    }

    @Override
    public int calculateBattleValue(boolean bl, boolean bl2) {
        int n;
        double d;
        double d2;
        Object object2;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = 0;
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(0x200000000000L)) continue;
            n2 += mounted.getBaseDamageCapacity() - mounted.getDamageTaken();
        }
        d3 += (double)(this.getTotalArmor() + n2) * 2.5;
        d3 += (double)this.getSI() * 2.0;
        double d5 = 0.0;
        for (Mounted mounted : this.getEquipment()) {
            object2 = mounted.getType();
            if (mounted.isDestroyed() || !(object2 instanceof WeaponType && ((EquipmentType)object2).hasFlag(0x800000L) || object2 instanceof AmmoType && ((AmmoType)object2).getAmmoType() == 14 || object2 instanceof AmmoType && ((AmmoType)object2).getAmmoType() == 62) && (!(object2 instanceof WeaponType) || ((WeaponType)object2).getAtClass() != 21)) continue;
            d5 += ((EquipmentType)object2).getBV(this);
        }
        d3 += d5;
        double d6 = 0.0;
        object2 = new HashMap();
        for (Mounted serializable2 : this.getEquipment()) {
            int d7 = serializable2.getLocation();
            int n3 = 15;
            EquipmentType d8 = serializable2.getType();
            if (!d8.isExplosive() || this.hasCASEII(d7) || this.isClan()) continue;
            if (d8 instanceof GaussWeapon) {
                n3 = 1;
            }
            if (null != object2.get(d8.getName()) && ((Boolean)object2.get(d8.getName())).booleanValue() || !(d8 instanceof AmmoType) || d8 instanceof AmmoType && serializable2.getShotsLeft() == 0) continue;
            d6 += (double)n3;
            if (!(d8 instanceof AmmoType)) continue;
            object2.put(d8.getName(), true);
        }
        d3 = Math.max(1.0, d3 - d6);
        d3 *= this.getBVTypeModifier();
        int n5 = 6 + this.getHeatCapacity();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        double d7 = 0.0;
        for (Mounted mounted : this.getTotalWeaponList()) {
            WeaponType bl3 = (WeaponType)mounted.getType();
            d2 = bl3.getHeat();
            if (mounted.isMissing() || mounted.isHit() || mounted.isDestroyed() || mounted.isBreached() || mounted.isWeaponGroup()) continue;
            if (bl3.getAmmoType() == 29 || bl3.hasFlag(16384L)) {
                d2 *= 0.25;
            }
            if (bl3.getAmmoType() == 20 || bl3.getAmmoType() == 33) {
                d2 *= 2.0;
            }
            if (bl3.getAmmoType() == 23) {
                d2 *= 6.0;
            }
            if (bl3.getAmmoType() == 11 || bl3.getAmmoType() == 42 || bl3.getAmmoType() == 31) {
                d2 *= 0.5;
            }
            d7 += d2;
            if (bl3.hasFlag(131072L) && bl3.getAmmoType() != 46 || bl3.hasFlag(16384L) || bl3.hasFlag(2048L) || bl3.getAmmoType() == -1) continue;
            String d9 = bl3.getAmmoType() + ":" + bl3.getRackSize();
            if (!hashMap.containsKey(d9)) {
                hashMap.put(d9, bl3.getBV(this));
                continue;
            }
            hashMap.put(d9, bl3.getBV(this) + (Double)hashMap.get(d9));
        }
        double d8 = 0.0;
        boolean bl3 = this.hasTargComp();
        d2 = 0.0;
        double d9 = 0.0;
        ArrayList<Mounted> arrayList = this.getTotalWeaponList();
        for (Mounted d15 : arrayList) {
            WeaponType weaponType = (WeaponType)d15.getType();
            double d10 = weaponType.getBV(this);
            if (d15.isDestroyed() || weaponType.hasFlag(0x800000L) || weaponType.getAtClass() == 21 || d15.isWeaponGroup()) continue;
            if (weaponType.hasFlag(0x100000000L)) {
                double d11 = 0.0;
                for (Mounted mounted : this.getTotalWeaponList()) {
                    if (!mounted.getType().hasFlag(512L) || mounted.getLocation() != d15.getLocation()) continue;
                    d11 += mounted.getType().getBV(this);
                }
                d10 = d11 * 0.67;
            }
            if (d15.isRearMounted()) {
                d9 += d10;
                continue;
            }
            d2 += d10;
        }
        boolean bl4 = true;
        if (d2 <= d9) {
            bl4 = false;
        }
        if (d7 <= (double)n5) {
            for (Mounted mounted : this.getTotalWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                double d12 = weaponType.getBV(this);
                if (mounted.isDestroyed() || weaponType.hasFlag(0x800000L) || weaponType.getAtClass() == 21 || mounted.isWeaponGroup()) continue;
                if (weaponType.hasFlag(0x100000000L)) {
                    d = 0.0;
                    for (Mounted mounted2 : this.getTotalWeaponList()) {
                        if (!mounted2.getType().hasFlag(512L) || mounted2.getLocation() != mounted.getLocation()) continue;
                        d += mounted2.getType().getBV(this);
                    }
                    d12 = d * 0.67;
                }
                if (this.hasFunctionalArmAES(mounted.getLocation())) {
                    d12 *= 1.5;
                }
                if (weaponType.hasFlag(1L) && bl3) {
                    d12 *= 1.25;
                }
                if (mounted.getLinkedBy() != null) {
                    Mounted mounted3 = mounted.getLinkedBy();
                    if (mounted3.getType() instanceof MiscType && mounted3.getType().hasFlag(512L)) {
                        d12 *= 1.2;
                    }
                    if (mounted3.getType() instanceof MiscType && mounted3.getType().hasFlag(0x1000000000000L)) {
                        d12 *= 1.15;
                    }
                }
                if (mounted.isRearMounted() && bl4 || !mounted.isRearMounted() && !bl4) {
                    d12 /= 2.0;
                }
                d8 += d12;
            }
        } else {
            ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            for (Mounted mounted : arrayList) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                d = weaponType.getBV(this);
                if (mounted.isDestroyed() || weaponType.hasFlag(0x800000L) || weaponType.getAtClass() == 21) continue;
                if (weaponType.hasFlag(0x100000000L)) {
                    double d13 = 0.0;
                    for (Mounted mounted4 : this.getTotalWeaponList()) {
                        if (!mounted4.getType().hasFlag(512L) || mounted4.getLocation() != mounted.getLocation()) continue;
                        d13 += mounted4.getType().getBV(this);
                    }
                    d = d13 * 0.67;
                }
                if (this.hasFunctionalArmAES(mounted.getLocation())) {
                    d *= 1.5;
                }
                if (weaponType.hasFlag(1L) && bl3) {
                    d *= 1.25;
                }
                if (mounted.getLinkedBy() != null) {
                    Mounted mounted5 = mounted.getLinkedBy();
                    if (mounted5.getType() instanceof MiscType && mounted5.getType().hasFlag(512L)) {
                        d *= 1.2;
                    }
                    if (mounted5.getType() instanceof MiscType && mounted5.getType().hasFlag(0x1000000000000L)) {
                        d *= 1.15;
                    }
                }
                if (mounted.isRearMounted() && bl4 || !mounted.isRearMounted() && !bl4) {
                    d /= 2.0;
                }
                int n4 = ((WeaponType)mounted.getType()).getHeat();
                double[] dArray = new double[]{d, n4};
                if (n4 > 0) {
                    dArray[0] = d;
                    dArray[1] = n4;
                    arrayList2.add(dArray);
                    continue;
                }
                arrayList3.add(d);
            }
            Collections.sort(arrayList2, new Comparator<double[]>(){

                @Override
                public int compare(double[] dArray, double[] dArray2) {
                    if (dArray[0] == dArray2[0]) {
                        return new Double(dArray[1] - dArray2[1]).intValue();
                    }
                    return new Double(dArray2[1] - dArray[1]).intValue();
                }
            });
            Iterator<Mounted> iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                double d14 = (Double)((Object)iterator.next());
                d8 += d14;
            }
            int n6 = 0;
            for (double[] dArray : arrayList2) {
                d = dArray[0];
                if (n6 >= n5) {
                    d /= 2.0;
                }
                n6 = (int)((double)n6 + dArray[1]);
                d8 += d;
            }
        }
        double d15 = 0.0;
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (mounted.isDestroyed() || miscType.hasFlag(0x80000000000L) || miscType.hasFlag(0x100000000000L) || miscType.hasFlag(0x800000L) || miscType.hasFlag(1024L)) continue;
            d = miscType.getBV(this);
            d15 += d;
            if (!miscType.hasFlag(0x20000000L)) continue;
            if (this.getArmor(mounted.getLocation(), false) != -3) {
                d15 += (double)this.getArmor(mounted.getLocation());
            }
            if (!this.hasRearArmor(mounted.getLocation()) || this.getArmor(mounted.getLocation(), true) == -3) continue;
            d15 += (double)this.getArmor(mounted.getLocation(), true);
        }
        d8 += d15;
        double d16 = 0.0;
        double d17 = 0.0;
        HashMap hashMap2 = new HashMap();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        for (Mounted mounted : this.getAmmo()) {
            Object object;
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || ammoType.getAmmoType() == 62 || mounted.getLocation() == -1) continue;
            if ((ammoType.getMunitionType() == 524288L || ammoType.getMunitionType() == 0x2000000000L) && (object = this.getOwner()) != null) {
                if (((Player)object).hasTAG()) {
                    d17 += ammoType.getBV(this);
                } else if (((Player)object).getTeam() != 0 && this.game != null) {
                    Enumeration<Team> enumeration = this.game.getTeams();
                    while (enumeration.hasMoreElements()) {
                        Team team = enumeration.nextElement();
                        if (team.getId() != ((Player)object).getTeam()) continue;
                        if (!team.hasTAG(this.game)) break;
                        d17 += ammoType.getBV(this);
                        break;
                    }
                }
            }
            if (!arrayList4.contains(object = ammoType.getAmmoType() + ":" + ammoType.getRackSize())) {
                arrayList4.add(object);
            }
            if (!hashMap2.containsKey(object)) {
                hashMap2.put(object, ammoType.getBV(this));
                continue;
            }
            hashMap2.put(object, ammoType.getBV(this) + (Double)hashMap2.get(object));
        }
        for (String string : arrayList4) {
            if (hashMap.get(string) == null) continue;
            if ((Double)hashMap2.get(string) > (Double)hashMap.get(string)) {
                d16 += ((Double)hashMap.get(string)).doubleValue();
                continue;
            }
            d16 += ((Double)hashMap2.get(string)).doubleValue();
        }
        double d18 = this.getRunMP();
        double d19 = d18 > 25.0 ? Math.pow(1.0 + ((double)this.getRunMP() - 5.0) / 10.0, 1.2) : Math.pow(1.0 + (d18 - 5.0) / 10.0, 1.2);
        d19 = (double)Math.round(d19 * 100.0) / 100.0;
        d4 = (d8 += d16) * d19;
        double d20 = 0.0;
        d20 += d17;
        if ((this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5) && !bl && this.game != null) {
            n = 0;
            n += this.calculateBattleValue(true, true);
            for (Entity entity : this.game.getC3NetworkMembers(this)) {
                if (this.equals(entity) || !this.onSameC3NetworkAs(entity)) continue;
                n += entity.calculateBattleValue(true, true);
            }
            n = (int)((double)n * 0.05);
            d20 += (double)n;
        }
        n = (int)Math.round(d3 + d4 + d20);
        if (this.getCockpitType() == 1) {
            n = (int)((double)n * 0.95);
        }
        double d21 = 1.0;
        if (!bl2) {
            d21 = this.crew.getBVSkillMultiplier();
        }
        int n7 = (int)Math.round((double)n * d21);
        if (bl) {
            return n;
        }
        return n7;
    }

    public double getBVTypeModifier() {
        return 1.2;
    }

    @Override
    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        int n;
        int n2;
        int n3 = this.getAvionicsHits();
        int n4 = this.getCrew().getHits();
        if (n3 > 0 && n3 < 3) {
            pilotingRollData.addModifier(n3, "Avionics Damage");
        }
        if (n3 >= 3) {
            pilotingRollData.addModifier(5, "Avionics Destroyed");
        }
        if (n4 > 0) {
            pilotingRollData.addModifier(n4, "Pilot Hits");
        }
        if (this.moved == 10) {
            pilotingRollData.addModifier(1, "Used more than safe thrust");
        }
        if ((n2 = (n = this.getCurrentVelocity()) - 2 * this.getWalkMP()) > 0) {
            pilotingRollData.addModifier(n2, "Velocity greater than 2x safe thrust");
        }
        if (this.game.getBoard().inAtmosphere()) {
            pilotingRollData.addModifier(2, "Atmospheric operations");
            if (this instanceof Dropship) {
                if (this.isSpheroid()) {
                    pilotingRollData.addModifier(-1, "spheroid dropship");
                } else {
                    pilotingRollData.addModifier(0, "aerodyne dropship");
                }
            } else {
                pilotingRollData.addModifier(-1, "fighter/small craft");
            }
        }
        if (!this.hasLifeSupport()) {
            pilotingRollData.addModifier(2, "No life support");
        }
        if (this.hasModularArmor()) {
            pilotingRollData.addModifier(1, "Modular Armor");
        }
        if (this.getCrew().getOptions().booleanOption("vdni") && !this.getCrew().getOptions().booleanOption("bvdni")) {
            pilotingRollData.addModifier(-1, "VDNI");
        }
        if (this.getCockpitType() == 1 && !this.getCrew().getOptions().booleanOption("bvdni")) {
            pilotingRollData.addModifier(1, "Small Cockpit");
        }
        return pilotingRollData;
    }

    @Override
    public Vector<Report> victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7035);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        vector.addAll(this.crew.getDescVector(false));
        report = new Report(7070, 0);
        report.add(this.getKillNumber());
        vector.addElement(report);
        if (this.isDestroyed()) {
            Entity entity = this.game.getEntity(this.killerId);
            if (entity == null) {
                entity = this.game.getOutOfGameEntity(this.killerId);
            }
            if (entity != null) {
                report = new Report(7072, 0);
                report.addDesc(entity);
            } else {
                report = new Report(7073, 0);
            }
            vector.addElement(report);
        }
        report.newlines = 2;
        return vector;
    }

    @Override
    public int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    @Override
    public int getRunMPwithoutMASC(boolean bl, boolean bl2) {
        return this.getRunMP(bl, bl2);
    }

    @Override
    public int getHeatCapacity() {
        return this.getHeatSinks() * (this.getHeatType() + 1);
    }

    @Override
    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    @Override
    public int getEngineCritHeat() {
        return 0;
    }

    @Override
    public void autoSetInternal() {
        int n = (int)Math.ceil((double)this.weight / 10.0);
        n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            this.initializeInternal(n, i);
        }
    }

    public void autoSetThresh() {
        for (int i = 0; i < this.locations(); ++i) {
            this.initializeThresh(i);
        }
    }

    public void setThresh(int n, int n2) {
        this.damThresh[n2] = n;
    }

    public void initializeThresh(int n) {
        int n2 = (int)Math.ceil((double)this.getArmor(n) / 10.0);
        this.setThresh(n2, n);
    }

    public int getThresh(int n) {
        return this.damThresh[n];
    }

    @Override
    public boolean isRepairable() {
        return true;
    }

    @Override
    public void restore() {
        super.restore();
    }

    @Override
    public boolean canCharge() {
        return false;
    }

    @Override
    public boolean canDFA() {
        return false;
    }

    @Override
    public boolean canRam() {
        return !this.isImmobile() && this.getWalkMP() > 0;
    }

    @Override
    public int getArmorType() {
        return this.armorType;
    }

    @Override
    public void setArmorType(int n) {
        this.armorType = n;
    }

    @Override
    public int getStructureType() {
        return this.structureType;
    }

    @Override
    public void setStructureType(int n) {
        this.structureType = n;
    }

    public int getSuspensionFactor() {
        return 0;
    }

    @Override
    public double getCost() {
        double d = 0.0;
        d += (double)(250000.0f + 2000.0f * this.weight);
        d += (double)(50000 * this.getSI());
        d += (double)(25000.0f + 10.0f * this.getWeight());
        Engine engine = this.getEngine();
        d += (double)((float)(engine.getBaseCost() * engine.getRating()) * this.weight) / 75.0;
        d += (double)(200 * this.getFuel()) / 80.0;
        d += this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        int n = 2000 + 4000 * this.getHeatType();
        d += (double)(n * this.getHeatSinks());
        d += (double)this.getWeaponsAndEquipmentCost();
        double d2 = 1.0;
        if (this.isOmni()) {
            d2 = 1.25;
        }
        double d3 = 1.0f + this.weight / 200.0f;
        return Math.round(d * d2 * d3);
    }

    @Override
    public boolean doomedInVacuum() {
        return false;
    }

    @Override
    public boolean doomedOnGround() {
        return true;
    }

    @Override
    public boolean doomedInAtmosphere() {
        return false;
    }

    @Override
    public boolean doomedInSpace() {
        return false;
    }

    @Override
    public boolean canGoHullDown() {
        return false;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
        if (engine.engineValid) {
            this.setOriginalWalkMP(this.calculateWalk());
        }
    }

    @Override
    public double getInternalRemainingPercent() {
        return (double)this.getSI() / (double)this.get0SI();
    }

    protected int calculateWalk() {
        return this.getEngine().getRating() / (int)this.weight + 2;
    }

    @Override
    public boolean isNuclearHardened() {
        return true;
    }

    @Override
    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        super.addEquipment(mounted, n, bl);
        this.addCritical(n, new CriticalSlot(1, this.getEquipmentNum(mounted), true));
    }

    public int getCriticalEffect(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        int n3 = this.getPotCrit();
        return n3;
    }

    public PilotingRollData checkThrustSI(int n, int n2) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n2);
        if (n > this.getSI()) {
            pilotingRollData.append(new PilotingRollData(this.getId(), n - this.getSI(), "Thrust exceeds current SI in a single hex"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not exceeding SI");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkThrustSITotal(int n, int n2) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n2);
        if (n > this.getSI()) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "Thrust spent this turn exceeds current SI"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not exceeding SI");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkVelocityDouble(int n, int n2) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n2);
        if (n > 2 * this.getWalkMP() && this.game.getBoard().inAtmosphere()) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "Velocity greater than 2x safe thrust"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not exceeding 2x safe thrust");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkDown(int n, int n2) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n2);
        if (n > 2) {
            pilotingRollData.append(new PilotingRollData(this.getId(), n, "lost more than two altitudes"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: entity did not drop more than two altitudes");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkHover(MovePath movePath) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(movePath.getLastStepMovementType());
        if (movePath.contains(47)) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "hovering"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: entity did not hover");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkStall(int n, int n2) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n2);
        if (n == 0) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "stalled out"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: entity not stalled out");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkRolls(MoveStep moveStep, int n) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n);
        if ((moveStep.getType() == 38 || moveStep.getType() == 42) && moveStep.getNRolls() > 1) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "More than one roll in the same turn"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not rolling more than once");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkManeuver(MoveStep moveStep, int n) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n);
        if (moveStep == null || moveStep.getType() != 48) {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not attempting to get up.");
            return pilotingRollData;
        }
        pilotingRollData.append(new PilotingRollData(this.getId(), ManeuverType.getMod(moveStep.getManeuverType(), this.isVSTOL()), ManeuverType.getTypeName(moveStep.getManeuverType()) + " maneuver"));
        return pilotingRollData;
    }

    @Override
    public void setOmni(boolean bl) {
        super.setOmni(bl);
    }

    public void addClanCase() {
        boolean bl = false;
        EquipmentType equipmentType = EquipmentType.get("CLCASE");
        for (int i = 0; i < this.locations(); ++i) {
            bl = false;
            for (Mounted mounted : this.getEquipment()) {
                if (!mounted.getType().isExplosive() || mounted.getLocation() != i) continue;
                bl = true;
            }
            if (!bl) continue;
            try {
                this.addEquipment(new Mounted(this, equipmentType), i, false);
                continue;
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
        }
    }

    public boolean hasCase() {
        boolean bl = false;
        for (int i = 0; i < this.locations(); ++i) {
            if (bl) continue;
            bl = this.locationHasCase(i);
        }
        return bl;
    }

    public int sideTableRam(Coords coords) {
        int n;
        int n2 = this.sideTableRam(coords, this.facing);
        if (this.game.useVectorMove() && (n = this.chooseSideRam(coords)) != -1) {
            n2 = n;
        }
        return n2;
    }

    public int sideTableRam(Coords coords, int n) {
        int n2 = (this.getPosition().degree(coords) + (6 - n) * 60) % 360;
        if (n2 > 30 && n2 <= 90 || n2 < 330 && n2 >= 270) {
            return 1;
        }
        if (n2 > 150 && n2 < 210) {
            return 3;
        }
        if (n2 > 90 && n2 <= 150 || n2 < 270 && n2 >= 210) {
            return 2;
        }
        return 0;
    }

    public int chooseSideRam(Coords coords) {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < 6; ++i) {
            int n4;
            n = this.getVector(i);
            if (n == 0) continue;
            if (n > n2) {
                n2 = n;
                n3 = this.sideTableRam(coords, i);
            }
            if (n != n2 || (n4 = this.sideTableRam(coords, i)) <= n3) continue;
            n4 = n3;
        }
        return n3;
    }

    public int getStandardDamage(int n) {
        return this.standard_damage[n];
    }

    public void resetStandardDamage() {
        for (int i = 0; i < this.locations(); ++i) {
            this.standard_damage[i] = 0;
        }
    }

    public void addStandardDamage(int n, HitData hitData) {
        this.standard_damage[hitData.getLocation()] = this.standard_damage[hitData.getLocation()] + n;
    }

    public int getMaxEngineHits() {
        return 3;
    }

    @Override
    public int getMaxElevationChange() {
        return 999;
    }

    @Override
    public boolean isHexProhibited(IHex iHex) {
        return iHex.containsTerrain(33);
    }

    public boolean isSpheroid() {
        return this.spheroid;
    }

    public void setSpheroid(boolean bl) {
        this.spheroid = bl;
    }

    @Override
    public int height() {
        return 0;
    }

    @Override
    public boolean canUnjamRAC() {
        for (Mounted mounted : this.getTotalWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() != 23 || !mounted.isJammed() || mounted.isDestroyed()) continue;
            return true;
        }
        return false;
    }

    public void applyBombs() {
        int n = 0;
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < this.bombChoices[i]; ++j) {
                if (i == 14 && !this.game.getOptions().booleanOption("at2_nukes") || i > 4 && !this.game.getOptions().booleanOption("allow_level_3_ammo")) continue;
                if (null != BombType.getBombWeaponName(i) && i != 8 && i != 9) {
                    try {
                        this.addBomb(EquipmentType.get(BombType.getBombWeaponName(i)), n);
                    }
                    catch (LocationFullException locationFullException) {
                        // empty catch block
                    }
                }
                if (i == 4) continue;
                try {
                    this.addEquipment(EquipmentType.get(BombType.getBombInternalName(i)), n, false);
                    continue;
                }
                catch (LocationFullException locationFullException) {
                    // empty catch block
                }
            }
        }
        if (this.game.getOptions().booleanOption("stratops_space_bomb") && this.getSpaceBombs().size() > 0) {
            try {
                this.addEquipment(EquipmentType.get(SPACE_BOMB_ATTACK), 0, false);
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
        }
        this.updateWeaponGroups();
        this.loadAllWeapons();
    }

    public Vector<Mounted> getSpaceBombs() {
        Vector<Mounted> vector = new Vector<Mounted>();
        for (Mounted mounted : this.getBombs()) {
            BombType bombType = (BombType)mounted.getType();
            if (mounted.isInoperable() || mounted.getShotsLeft() <= 0 || bombType.getBombType() != 0 && bombType.getBombType() != 1 && bombType.getBombType() != 2 && bombType.getBombType() != 8) continue;
            vector.add(mounted);
        }
        return vector;
    }

    @Override
    public int getExtremeRangeModifier() {
        return 6;
    }

    public int getStraightMoves() {
        return this.straightMoves;
    }

    public void setStraightMoves(int n) {
        this.straightMoves = n;
    }

    public boolean isVSTOL() {
        return this.vstol;
    }

    public void setVSTOL(boolean bl) {
        this.vstol = bl;
    }

    public int getFuelUsed(int n) {
        int n2 = Math.max(n - this.getWalkMP(), 0);
        int n3 = n - n2;
        int n4 = n3 + 2 * n2;
        return n4;
    }

    public boolean didFailManeuver() {
        return this.failedManeuver;
    }

    public void setFailedManeuver(boolean bl) {
        this.failedManeuver = bl;
    }

    public void setAccDecNow(boolean bl) {
        this.accDecNow = bl;
    }

    public boolean didAccDecNow() {
        return this.accDecNow;
    }

    @Override
    public void setGameOptions() {
        super.setGameOptions();
        for (Mounted mounted : this.getWeaponList()) {
            if (!(mounted.getType() instanceof EnergyWeapon) || ((WeaponType)mounted.getType()).getAmmoType() != -1 || this.game == null || !this.game.getOptions().booleanOption("tacops_energy_weapons")) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = new String[]{};
            int n = ((WeaponType)mounted.getType()).getDamage();
            if (n == -3) {
                n = ((WeaponType)mounted.getType()).damageShort;
            }
            while (n >= 0) {
                arrayList.add("Damage " + n);
                --n;
            }
            if (((WeaponType)mounted.getType()).hasFlag(2L)) {
                arrayList.add("Heat");
            }
            ((WeaponType)mounted.getType()).setModes(arrayList.toArray(stringArray));
        }
    }

    @Override
    public boolean hasModularArmor() {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.isDestroyed() || !(mounted.getType() instanceof MiscType) || !((MiscType)mounted.getType()).hasFlag(0x200000000000L)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasModularArmor(int n) {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.getLocation() != n || !(mounted.getType() instanceof MiscType) || !((MiscType)mounted.getType()).hasFlag(0x200000000000L)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getTotalCommGearTons() {
        return 1 + this.getExtraCommGearTons();
    }

    @Override
    public int getBadCriticals(int n, int n2, int n3) {
        return 0;
    }

    public int getCockpitType() {
        return this.cockpitType;
    }

    public void setCockpitType(int n) {
        this.cockpitType = n;
    }

    public String getCockpitTypeString() {
        return Aero.getCockpitTypeString(this.getCockpitType());
    }

    public static String getCockpitTypeString(int n) {
        if (n < 0 || n >= COCKPIT_STRING.length) {
            return "Unknown";
        }
        return COCKPIT_STRING[n];
    }

    @Override
    public double getArmorRemainingPercent() {
        int n = this.getTotalOArmor();
        int n2 = this.getTotalArmor();
        if (this.isCapitalFighter()) {
            n = this.getCap0Armor();
            n2 = this.getCapArmor();
        }
        if (n == 0) {
            return -1.0;
        }
        return (double)n2 / (double)n;
    }

    public boolean areWingsHit() {
        return this.wingsHit;
    }

    public void setWingsHit(boolean bl) {
        this.wingsHit = bl;
    }

    public int getOppositeLocation(int n) {
        switch (n) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    public int getClusterMods() {
        return -1 * (this.getFCSHits() + this.getSensorHits());
    }

    @Override
    public int getECMRange() {
        if (!this.game.getOptions().booleanOption("stratops_ecm") || !this.game.getBoard().inSpace()) {
            return super.getECMRange();
        }
        return Math.min(super.getECMRange(), 0);
    }

    @Override
    public double getECCMStrength() {
        if (!this.game.getOptions().booleanOption("stratops_ecm") || !this.game.getBoard().inSpace()) {
            return super.getECCMStrength();
        }
        if (this.hasActiveECCM()) {
            return 1.0;
        }
        return 0.0;
    }

    public void setECCMRoll(int n) {
        this.eccmRoll = n;
    }

    public int getECCMRoll() {
        return this.eccmRoll;
    }

    public int getECCMTarget() {
        return this.crew.getPiloting() + this.getSensorHits() + this.getCICHits() + this.getFCSHits();
    }

    public int getECCMBonus() {
        return Math.max(0, this.eccmRoll - this.getECCMTarget());
    }

    public boolean isCrewProtected() {
        return true;
    }

    public int getGravSecondaryThreshold() {
        int n = 6;
        if (this.isCrewProtected()) {
            n = 12;
        }
        return n;
    }

    public int getGravPrimaryThreshold() {
        int n = 12;
        if (this.isCrewProtected()) {
            n = 22;
        }
        return n;
    }

    @Override
    public boolean canLoad(Entity entity) {
        return !entity.isEnemyOf(this) && entity.isCapitalFighter() && this.isCapitalFighter() && this.getId() != entity.getId() && this.game.getPhase() != IGame.Phase.PHASE_DEPLOYMENT;
    }

    public void useFuel(int n) {
        this.setFuel(Math.max(0, this.getFuel() - n));
    }

    public void updateWeaponGroups() {
        String string;
        Set<String> set = this.weaponGroups.keySet();
        for (String object22 : set) {
            this.getEquipment(this.weaponGroups.get(object22)).setNWeapons(0);
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (Mounted mounted : this.getTotalWeaponList()) {
            int string2 = mounted.getLocation();
            if (string2 == 2 || string2 == 1) {
                string2 = 4;
            }
            if (mounted.isRearMounted()) {
                string2 = 3;
            }
            if (null == hashMap.get(string = mounted.getType().getInternalName() + ":" + string2)) {
                hashMap.put(string, mounted.getNWeapons());
                continue;
            }
            hashMap.put(string, (Integer)hashMap.get(string) + mounted.getNWeapons());
        }
        Set set2 = hashMap.keySet();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (null != this.weaponGroups.get(string2)) {
                this.getEquipment(this.weaponGroups.get(string2)).setNWeapons((Integer)hashMap.get(string2));
                continue;
            }
            string = string2.split(":")[0];
            int n = Integer.parseInt(string2.split(":")[1]);
            EquipmentType equipmentType = EquipmentType.get(string);
            if (equipmentType != null) {
                try {
                    Mounted mounted = this.addWeaponGroup(equipmentType, n);
                    mounted.setNWeapons((Integer)hashMap.get(string2));
                    this.weaponGroups.put(string2, this.getEquipmentNum(mounted));
                    continue;
                }
                catch (LocationFullException locationFullException) {
                    System.out.println("Unable to compile weapon groups");
                    locationFullException.printStackTrace();
                    return;
                }
            }
            if (string == "0") continue;
            this.addFailedEquipment(string);
        }
    }

    public boolean shouldMoveBackHex(Aero aero) {
        if (null == this.getPosition()) {
            return false;
        }
        if (null == aero.getPosition()) {
            return false;
        }
        if (!this.getPosition().equals(aero.getPosition())) {
            return false;
        }
        int n = UnitType.determineUnitTypeCode(this);
        int n2 = UnitType.determineUnitTypeCode(aero);
        int n3 = this.getCurrentVelocity();
        int n4 = aero.getCurrentVelocity();
        if (n > n2) {
            return false;
        }
        if (n < n2) {
            return true;
        }
        if (n3 < n4) {
            return false;
        }
        if (n3 > n4) {
            return true;
        }
        return this.getWhoFirst() >= aero.getWhoFirst();
    }
}

