/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.LocationFullException;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;
import megamek.common.Transporter;
import megamek.common.WeaponType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FighterSquadron
extends Aero
implements Transporter,
Serializable {
    private static final long serialVersionUID = 3491212296982370726L;
    public static int MAX_SIZE = 6;
    public Vector<Aero> fighters = new Vector();
    private int heatcap = 0;

    public FighterSquadron() {
        this.setChassis("Squadron");
        this.setModel("");
    }

    public FighterSquadron(String string) {
        this.setChassis(string.trim() + " Squadron");
        this.setModel("");
    }

    @Override
    public double getCost() {
        double d = 0.0;
        for (Aero aero : this.fighters) {
            d += aero.getCost();
        }
        return d;
    }

    @Override
    public boolean isCapitalFighter() {
        return true;
    }

    public int getN0Fighters() {
        return this.fighters.size();
    }

    public int getNFighters() {
        int n = 0;
        for (Aero aero : this.fighters) {
            if (aero.isDestroyed() || aero.isDoomed()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int get0SI() {
        if (this.fighters.size() < 1) {
            return 0;
        }
        int n = Integer.MAX_VALUE;
        for (Aero aero : this.fighters) {
            if (aero.isDestroyed() || aero.isDoomed() || aero.getSI() >= n) continue;
            n = aero.getSI();
        }
        return n;
    }

    @Override
    public int getSI() {
        if (this.fighters.size() < 1) {
            return 0;
        }
        int n = Integer.MAX_VALUE;
        for (Aero aero : this.fighters) {
            if (aero.isDestroyed() || aero.isDoomed() || aero.getSI() >= n) continue;
            n = aero.getSI();
        }
        return n;
    }

    public Aero getFighter(int n) {
        if (n > this.fighters.size()) {
            return this.fighters.firstElement();
        }
        return this.fighters.get(n);
    }

    public Vector<Aero> getFighters() {
        return this.fighters;
    }

    @Override
    public int getTotalArmor() {
        int n = 0;
        for (Aero aero : this.fighters) {
            n += aero.getCapArmor();
        }
        return n;
    }

    @Override
    public int getTotalOArmor() {
        int n = 0;
        for (Aero aero : this.fighters) {
            n += aero.getCap0Armor();
        }
        return n;
    }

    @Override
    public double getArmorRemainingPercent() {
        if (this.getTotalOArmor() == 0) {
            return -1.0;
        }
        return (double)this.getTotalArmor() / (double)this.getTotalOArmor();
    }

    @Override
    public int getWalkMP(boolean bl, boolean bl2) {
        if (this.fighters.size() < 1) {
            return 0;
        }
        int n = Integer.MAX_VALUE;
        for (Aero aero : this.fighters) {
            if (aero.isDestroyed() || aero.isDoomed() || aero.getWalkMP(bl, bl2) >= n) continue;
            n = aero.getWalkMP(bl, bl2);
        }
        return n;
    }

    @Override
    public int getFuel() {
        if (this.fighters.size() < 1) {
            return 0;
        }
        int n = Integer.MAX_VALUE;
        for (Aero aero : this.fighters) {
            if (aero.isDestroyed() || aero.isDoomed() || aero.getFuel() >= n) continue;
            n = aero.getFuel();
        }
        return n;
    }

    @Override
    public double getInternalRemainingPercent() {
        return (double)this.getNFighters() / (double)MAX_SIZE;
    }

    @Override
    public boolean hasTargComp() {
        int n = 0;
        for (Aero aero : this.fighters) {
            if (!aero.hasTargComp() || aero.isDestroyed() || aero.isDoomed()) continue;
            ++n;
        }
        double d = (double)n / (double)this.getNFighters();
        return d >= 0.5;
    }

    @Override
    public boolean hasActiveECM() {
        if (!this.game.getOptions().booleanOption("stratops_ecm") || !this.game.getBoard().inSpace()) {
            return super.hasActiveECM();
        }
        return this.getECMRange() > -1;
    }

    @Override
    public boolean loadedUnitsHaveActiveECM() {
        return true;
    }

    @Override
    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        int n;
        int n2;
        if (this.moved == 10) {
            pilotingRollData.addModifier(1, "Used more than safe thrust");
        }
        if ((n2 = (n = this.getCurrentVelocity()) - 2 * this.getWalkMP()) > 0) {
            pilotingRollData.addModifier(n2, "Velocity greater than 2x safe thrust");
        }
        if (this.game.getBoard().inAtmosphere()) {
            pilotingRollData.addModifier(2, "Atmospheric operations");
            pilotingRollData.addModifier(-1, "fighter/small craft");
        }
        for (Aero aero : this.fighters) {
            if (aero.isDestroyed() || aero.isDoomed()) continue;
            int n3 = aero.getAvionicsHits();
            if (n3 > 0 && n3 < 3) {
                pilotingRollData.addModifier(n3, "Avionics Damage");
            }
            if (n3 >= 3) {
                pilotingRollData.addModifier(5, "Avionics Destroyed");
            }
            if (!this.hasLifeSupport()) {
                pilotingRollData.addModifier(2, "No life support");
            }
            if (!this.hasModularArmor()) continue;
            pilotingRollData.addModifier(1, "Modular Armor");
        }
        return pilotingRollData;
    }

    @Override
    public int getClusterMods() {
        int n = 0;
        for (Aero aero : this.fighters) {
            if (aero.isDestroyed() || aero.isDoomed() || aero.getFCSHits() > 2) continue;
            n += aero.getClusterMods();
        }
        return n;
    }

    @Override
    public int calculateBattleValue(boolean bl, boolean bl2) {
        int n = 0;
        return n;
    }

    @Override
    public int calculateBattleValue() {
        return this.calculateBattleValue(false, false);
    }

    @Override
    public int getHeatSinks() {
        int n = 0;
        for (Aero aero : this.fighters) {
            if (aero.isDestroyed() || aero.isDoomed()) continue;
            n += aero.getHeatSinks();
        }
        return n;
    }

    @Override
    public int getHeatCapacity() {
        return this.heatcap;
    }

    public void resetHeatCapacity() {
        int n = 0;
        for (Aero aero : this.fighters) {
            if (aero.isDestroyed() || aero.isDoomed()) continue;
            n += aero.getHeatCapacity();
        }
        this.heatcap = n;
    }

    @Override
    public float getWeight() {
        float f = 0.0f;
        for (Aero aero : this.fighters) {
            if (aero.isDestroyed() || aero.isDoomed()) continue;
            f += aero.getWeight();
        }
        return f;
    }

    public double getAveWeight() {
        return this.getWeight() / (float)this.getNFighters();
    }

    @Override
    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        if (this.isDoomed() || this.getNFighters() < 2) {
            return new HitData(0);
        }
        int n5 = Compute.randomInt(this.getN0Fighters());
        while (this.getFighter(n5).isDestroyed() || this.getFighter(n5).isDoomed()) {
            n5 = Compute.randomInt(this.getN0Fighters());
        }
        return new HitData(n5);
    }

    @Override
    public HitData rollHitLocation(int n, int n2) {
        return this.rollHitLocation(n, n2, -1, 0);
    }

    @Override
    public void newRound(int n) {
        super.newRound(n);
        this.updateWeaponGroups();
        this.loadAllWeapons();
        this.updateSkills();
        this.resetHeatCapacity();
    }

    @Override
    public void updateWeaponGroups() {
        Object object;
        int n;
        Object object322;
        Set set = this.weaponGroups.keySet();
        for (Object object322 : set) {
            this.getEquipment((Integer)this.weaponGroups.get(object322)).setNWeapons(0);
        }
        object322 = new HashMap();
        for (Aero object22 : this.fighters) {
            if (object22.getFCSHits() > 2) continue;
            for (Mounted mounted : object22.getWeaponGroupList()) {
                n = mounted.getLocation();
                object = mounted.getType().getInternalName() + ":" + n;
                if (null == object322.get(object)) {
                    object322.put(object, mounted.getNWeapons());
                    continue;
                }
                if (mounted.getType().hasFlag(0x10000000000L)) continue;
                object322.put(object, (Integer)object322.get(object) + mounted.getNWeapons());
            }
        }
        Set set2 = object322.keySet();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (null != this.weaponGroups.get(string)) {
                this.getEquipment((Integer)this.weaponGroups.get(string)).setNWeapons((Integer)object322.get(string));
                continue;
            }
            String string2 = string.split(":")[0];
            n = Integer.parseInt(string.split(":")[1]);
            object = EquipmentType.get(string2);
            if (object != null) {
                try {
                    Mounted mounted = this.addWeaponGroup((EquipmentType)object, n);
                    mounted.setNWeapons((Integer)object322.get(string));
                    this.weaponGroups.put(string, this.getEquipmentNum(mounted));
                    continue;
                }
                catch (LocationFullException locationFullException) {
                    System.out.println("Unable to compile weapon groups");
                    locationFullException.printStackTrace();
                    return;
                }
            }
            if (string2 == "0") continue;
            this.addFailedEquipment(string2);
        }
    }

    private void reloadAllWeapons() {
        for (Mounted mounted : this.getTotalWeaponList()) {
            if (((WeaponType)mounted.getType()).getAmmoType() == -1 || null == mounted.getLinked() || !(mounted.getLinked().getType() instanceof AmmoType)) continue;
            mounted.unlink();
        }
    }

    public void updateSkills() {
        if (this.getN0Fighters() == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (Aero aero : this.fighters) {
            if (aero.isDestroyed() || aero.isDoomed()) continue;
            n += aero.crew.getPiloting();
            n2 += aero.crew.getGunnery();
            n3 += aero.crew.getGunneryL();
            n4 += aero.crew.getGunneryM();
            n5 += aero.crew.getGunneryB();
        }
        this.crew.setPiloting(n / this.getN0Fighters());
        this.crew.setGunnery(n2 / this.getN0Fighters());
        this.crew.setGunneryL(n2 / this.getN0Fighters());
        this.crew.setGunneryM(n2 / this.getN0Fighters());
        this.crew.setGunneryB(n2 / this.getN0Fighters());
    }

    @Override
    public ArrayList<Mounted> getAmmo() {
        ArrayList<Mounted> arrayList = new ArrayList<Mounted>();
        for (Aero aero : this.fighters) {
            arrayList.addAll(aero.getAmmo());
        }
        return arrayList;
    }

    @Override
    public void useFuel(int n) {
        for (Aero aero : this.fighters) {
            aero.useFuel(n);
        }
    }

    @Override
    public ArrayList<Mounted> getBombs() {
        ArrayList<Mounted> arrayList = new ArrayList<Mounted>();
        for (Aero aero : this.fighters) {
            arrayList.addAll(aero.getBombs());
        }
        return arrayList;
    }

    @Override
    public boolean canLoad(Entity entity) {
        if (!entity.isEnemyOf(this) && entity.isFighter() && this.fighters.size() < MAX_SIZE) {
            return true;
        }
        return entity instanceof FighterSquadron && !entity.isEnemyOf(this) && this.getId() != entity.getId() && ((FighterSquadron)entity).getN0Fighters() > 0 && this.fighters.size() + ((FighterSquadron)entity).getN0Fighters() <= MAX_SIZE;
    }

    @Override
    public void load(Entity entity) throws IllegalArgumentException {
        if (!this.canLoad(entity)) {
            throw new IllegalArgumentException("Can not load " + entity.getShortName() + " into this squadron. ");
        }
        if (entity instanceof FighterSquadron) {
            this.fighters.addAll(((FighterSquadron)entity).getFighters());
        } else {
            this.fighters.addElement((Aero)entity);
        }
        this.updateWeaponGroups();
        this.loadAllWeapons();
        this.updateSkills();
    }

    @Override
    public boolean unload(Entity entity) {
        boolean bl = this.fighters.removeElement(entity);
        this.updateWeaponGroups();
        this.reloadAllWeapons();
        this.updateSkills();
        return bl;
    }

    @Override
    public Vector<Entity> getLoadedUnits() {
        return (Vector)this.fighters.clone();
    }

    @Override
    public String getUnusedString() {
        return " - " + (MAX_SIZE - this.fighters.size()) + " units";
    }

    @Override
    public boolean isWeaponBlockedAt(int n, boolean bl) {
        return false;
    }

    @Override
    public Entity getExteriorUnitAt(int n, boolean bl) {
        return null;
    }

    @Override
    public int getCargoMpReduction() {
        return 0;
    }
}

