/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.Flare;
import megamek.common.GameTurn;
import megamek.common.IBoard;
import megamek.common.Minefield;
import megamek.common.PilotingRollData;
import megamek.common.PlanetaryConditions;
import megamek.common.Player;
import megamek.common.Report;
import megamek.common.TagInfo;
import megamek.common.Targetable;
import megamek.common.Team;
import megamek.common.UnitLocation;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.LayMinefieldAction;
import megamek.common.event.GameEvent;
import megamek.common.event.GameListener;
import megamek.common.options.GameOptions;
import megamek.common.weapons.AttackHandler;
import megamek.server.SmokeCloud;
import megamek.server.victory.Victory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IGame {
    public int getExternalGameId();

    public void setExternalGameId(int var1);

    public HashMap<String, Object> getVictoryContext();

    public void setVictoryContext(HashMap<String, Object> var1);

    public void addGameListener(GameListener var1);

    public void removeGameListener(GameListener var1);

    public void processGameEvent(GameEvent var1);

    public boolean containsMinefield(Coords var1);

    public Vector<Minefield> getMinefields(Coords var1);

    public int getNbrMinefields(Coords var1);

    public Enumeration<Coords> getMinedCoords();

    public void addMinefield(Minefield var1);

    public void addMinefields(Vector<Minefield> var1);

    public void setMinefields(Vector<Minefield> var1);

    public void resetMinefieldDensity(Vector<Minefield> var1);

    public void removeMinefield(Minefield var1);

    public void clearMinefields();

    public Vector<Minefield> getVibrabombs();

    public void addVibrabomb(Minefield var1);

    public void removeVibrabomb(Minefield var1);

    public boolean containsVibrabomb(Minefield var1);

    public GameOptions getOptions();

    public void setOptions(GameOptions var1);

    public IBoard getBoard();

    public void setBoard(IBoard var1);

    public Enumeration<Team> getTeams();

    public int getNoOfTeams();

    public Vector<Team> getTeamsVector();

    public Team getTeamForPlayer(Player var1);

    public void setupTeams();

    public Enumeration<Player> getPlayers();

    public Vector<Player> getPlayersVector();

    public int getNoOfPlayers();

    public Player getPlayer(int var1);

    public void addPlayer(int var1, Player var2);

    public void setPlayer(int var1, Player var2);

    public void removePlayer(int var1);

    public int getEntitiesOwnedBy(Player var1);

    public int getAllEntitiesOwnedBy(Player var1);

    public int getLiveEntitiesOwnedBy(Player var1);

    public int getLiveDeployedEntitiesOwnedBy(Player var1);

    public int getLiveCommandersOwnedBy(Player var1);

    public boolean hasTacticalGenius(Player var1);

    public Vector<Entity> getValidTargets(Entity var1);

    public boolean phaseHasTurns(Phase var1);

    public boolean isPhaseSimultaneous();

    public GameTurn getTurn();

    public GameTurn getTurnForPlayer(int var1);

    public GameTurn changeToNextTurn();

    public void resetTurnIndex();

    public boolean hasMoreTurns();

    public void insertNextTurn(GameTurn var1);

    public Enumeration<GameTurn> getTurns();

    public int getTurnIndex();

    public void setTurnIndex(int var1);

    public Vector<GameTurn> getTurnVector();

    public void setTurnVector(Vector<GameTurn> var1);

    public Phase getPhase();

    public void setPhase(Phase var1);

    public Phase getLastPhase();

    public void setLastPhase(Phase var1);

    public void setDeploymentComplete(boolean var1);

    public boolean isDeploymentComplete();

    public void setupRoundDeployment();

    public void checkForCompleteDeployment();

    public boolean shouldDeployThisRound();

    public boolean shouldDeployForRound(int var1);

    public void clearDeploymentThisRound();

    public Vector<Entity> getUndeployedEntities();

    public Enumeration<Entity> getEntities();

    public Vector<Entity> getEntitiesVector();

    public void setEntitiesVector(Vector<Entity> var1);

    public Vector<Entity> getOutOfGameEntitiesVector();

    public Entity getOutOfGameEntity(int var1);

    public void setOutOfGameEntitiesVector(Vector<Entity> var1);

    public Vector<Entity> getC3NetworkMembers(Entity var1);

    public Vector<Entity> getC3SubNetworkMembers(Entity var1);

    public Hashtable<Coords, Vector<Entity>> getPositionMap();

    public Enumeration<Entity> getGraveyardEntities();

    public Enumeration<Entity> getWreckedEntities();

    public Enumeration<Entity> getRetreatedEntities();

    public Enumeration<Entity> getDevastatedEntities();

    public int getNoOfEntities();

    public Targetable getTarget(int var1, int var2);

    public Entity getEntity(int var1);

    public void addEntity(int var1, Entity var2);

    public void setEntity(int var1, Entity var2);

    public void setEntity(int var1, Entity var2, Vector<UnitLocation> var3);

    public int getNextEntityId();

    public boolean hasEntity(int var1);

    public void removeEntity(int var1, int var2);

    public void reset();

    public void addSmokeCloud(SmokeCloud var1);

    public List<SmokeCloud> getSmokeCloudList();

    public Entity getFirstEntity(Coords var1);

    public Entity getFirstEnemyEntity(Coords var1, Entity var2);

    public Enumeration<Entity> getEntities(Coords var1);

    public Vector<Entity> getEntitiesVector(Coords var1);

    public Entity getAffaTarget(Coords var1, Entity var2);

    public Enumeration<Entity> getEnemyEntities(Coords var1, Entity var2);

    public Enumeration<Entity> getFriendlyEntities(Coords var1, Entity var2);

    public void moveToGraveyard(int var1);

    public boolean isOutOfGame(int var1);

    public boolean isOutOfGame(Entity var1);

    public Entity getFirstEntity();

    public Entity getFirstEntity(GameTurn var1);

    public int getFirstEntityNum();

    public int getFirstEntityNum(GameTurn var1);

    public Entity getNextEntity(int var1);

    public int getNextEntityNum(int var1);

    public int getNextEntityNum(GameTurn var1, int var2);

    public int getFirstDeployableEntityNum();

    public int getFirstDeployableEntityNum(GameTurn var1);

    public int getNextDeployableEntityNum(int var1);

    public int getNextDeployableEntityNum(GameTurn var1, int var2);

    public ArrayList<Entity> getPlayerEntities(Player var1, boolean var2);

    public boolean isEntityStranded(Entity var1);

    public int getInfantryLeft(int var1);

    public int getProtomechsLeft(int var1);

    public int getVehiclesLeft(int var1);

    public void removeTurnFor(Entity var1);

    public GameTurn removeFirstTurnFor(Entity var1);

    public boolean checkForMagneticClamp();

    public void addAction(EntityAction var1);

    public void addAttack(AttackHandler var1);

    public void removeAttack(AttackHandler var1);

    public Enumeration<AttackHandler> getAttacks();

    public Vector<AttackHandler> getAttacksVector();

    public void resetAttacks();

    public int getArtillerySize();

    public void setArtilleryVector(Vector<ArtilleryAttackAction> var1);

    public Enumeration<ArtilleryAttackAction> getArtilleryAttacks();

    public void setAttacksVector(Vector<AttackHandler> var1);

    public Enumeration<EntityAction> getActions();

    public void resetActions();

    public void removeActionsFor(int var1);

    public void removeAction(Object var1);

    public int actionsSize();

    public Vector<EntityAction> getActionsVector();

    public void addInitiativeRerollRequest(Team var1);

    public void rollInitAndResolveTies();

    public int getNoOfInitiativeRerollRequests();

    public void addCharge(AttackAction var1);

    public Enumeration<AttackAction> getCharges();

    public void resetCharges();

    public Vector<AttackAction> getChargesVector();

    public void addRam(AttackAction var1);

    public Enumeration<AttackAction> getRams();

    public void resetRams();

    public Vector<AttackAction> getRamsVector();

    public void addTeleMissileAttack(AttackAction var1);

    public Enumeration<AttackAction> getTeleMissileAttacks();

    public void resetTeleMissileAttacks();

    public Vector<AttackAction> getTeleMissileAttacksVector();

    public void addLayMinefieldAction(LayMinefieldAction var1);

    public Enumeration<LayMinefieldAction> getLayMinefieldActions();

    public void resetLayMinefieldActions();

    public Vector<LayMinefieldAction> getLayMinefieldActionsVector();

    public void addPSR(PilotingRollData var1);

    public Enumeration<PilotingRollData> getPSRs();

    public void addExtremeGravityPSR(PilotingRollData var1);

    public Enumeration<PilotingRollData> getExtremeGravityPSRs();

    public void resetPSRs(Entity var1);

    public void resetExtremeGravityPSRs();

    public void resetExtremeGravityPSRs(Entity var1);

    public void resetPSRs();

    public int getRoundCount();

    public void setRoundCount(int var1);

    public void incrementRoundCount();

    public boolean isForceVictory();

    public void setForceVictory(boolean var1);

    public void addReports(Vector<Report> var1);

    public Vector<Report> getReports(int var1);

    public Vector<Vector<Report>> getAllReports();

    public void setAllReports(Vector<Vector<Report>> var1);

    public void clearAllReports();

    public void end(int var1, int var2);

    public int getVictoryPlayerId();

    public void setVictoryPlayerId(int var1);

    public int getVictoryTeam();

    public void setVictoryTeam(int var1);

    public boolean isPlayerVictor(Player var1);

    public boolean isPlayerVictor(int var1);

    public Enumeration<Entity> getSelectedEntities(EntitySelector var1);

    public int getSelectedEntityCount(EntitySelector var1);

    public Enumeration<Entity> getSelectedOutOfGameEntities(EntitySelector var1);

    public int getSelectedOutOfGameEntityCount(EntitySelector var1);

    public boolean checkForValidNonInfantryAndOrProtomechs(int var1);

    public Enumeration<Entity> getNemesisTargets(Entity var1, Coords var2);

    public Entity getPreviousEntityFromList(Entity var1);

    public Entity getNextEntityFromList(Entity var1);

    public Vector<TagInfo> getTagInfo();

    public void addTagInfo(TagInfo var1);

    public void updateTagInfo(TagInfo var1, int var2);

    public void clearTagInfoShots(Entity var1, Coords var2);

    public void resetTagInfo();

    public Vector<Flare> getFlares();

    public void setFlares(Vector<Flare> var1);

    public void addFlare(Flare var1);

    public boolean isPositionIlluminated(Coords var1);

    public Vector<Report> ageFlares();

    public boolean gameTimerIsExpired();

    public void createVictoryConditions();

    public Victory getVictory();

    public boolean useVectorMove();

    public void addControlRoll(PilotingRollData var1);

    public Enumeration<PilotingRollData> getControlRolls();

    public void resetControlRolls(Entity var1);

    public void resetControlRolls();

    public boolean checkForValidSpaceStations(int var1);

    public boolean checkForValidJumpships(int var1);

    public boolean checkForValidWarships(int var1);

    public boolean checkForValidDropships(int var1);

    public boolean checkForValidSmallCraft(int var1);

    public PlanetaryConditions getPlanetaryConditions();

    public void setPlanetaryConditions(PlanetaryConditions var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Phase {
        PHASE_UNKNOWN,
        PHASE_LOUNGE,
        PHASE_SELECTION,
        PHASE_EXCHANGE,
        PHASE_DEPLOYMENT,
        PHASE_INITIATIVE,
        PHASE_INITIATIVE_REPORT,
        PHASE_TARGETING,
        PHASE_TARGETING_REPORT,
        PHASE_MOVEMENT,
        PHASE_MOVEMENT_REPORT,
        PHASE_OFFBOARD,
        PHASE_OFFBOARD_REPORT,
        PHASE_FIRING,
        PHASE_FIRING_REPORT,
        PHASE_PHYSICAL,
        PHASE_PHYSICAL_REPORT,
        PHASE_END,
        PHASE_END_REPORT,
        PHASE_VICTORY,
        PHASE_DEPLOY_MINEFIELDS,
        PHASE_STARTING_SCENARIO,
        PHASE_SET_ARTYAUTOHITHEXES;


        public boolean isDuringOrAfter(Phase phase) {
            return this.compareTo(phase) >= 0;
        }

        public boolean isBefore(Phase phase) {
            return this.compareTo(phase) < 0;
        }
    }
}

