/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.ArrayList;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Targetable;
import megamek.common.ToHitData;

public class LosEffects {
    public static final int COVER_NONE = 0;
    public static final int COVER_LOWLEFT = 1;
    public static final int COVER_LOWRIGHT = 2;
    public static final int COVER_LEFT = 4;
    public static final int COVER_RIGHT = 8;
    public static final int COVER_HORIZONTAL = 3;
    public static final int COVER_UPPER = 12;
    public static final int COVER_FULL = 15;
    public static final int COVER_75LEFT = 7;
    public static final int COVER_75RIGHT = 11;
    boolean blocked = false;
    boolean infProtected = false;
    boolean hasLoS = true;
    int plantedFields = 0;
    int heavyIndustrial = 0;
    int lightWoods = 0;
    int heavyWoods = 0;
    int ultraWoods = 0;
    int lightSmoke = 0;
    int heavySmoke = 0;
    int screen = 0;
    int softBuildings = 0;
    int hardBuildings = 0;
    int buildingLevelsOrHexes = 0;
    boolean blockedByHill = false;
    boolean blockedByWater = false;
    int targetCover = 0;
    int attackerCover = 0;
    Building thruBldg = null;
    int minimumWaterDepth = -1;
    boolean arcedShot = false;

    public int getMinimumWaterDepth() {
        return this.minimumWaterDepth;
    }

    public void setMinimumWaterDepth(int n) {
        this.minimumWaterDepth = n;
    }

    public void add(LosEffects losEffects) {
        this.blocked |= losEffects.blocked;
        this.infProtected |= losEffects.infProtected;
        this.plantedFields += losEffects.plantedFields;
        this.heavyIndustrial += losEffects.heavyIndustrial;
        this.lightWoods += losEffects.lightWoods;
        this.heavyWoods += losEffects.heavyWoods;
        this.ultraWoods += losEffects.ultraWoods;
        this.lightSmoke += losEffects.lightSmoke;
        this.heavySmoke += losEffects.heavySmoke;
        this.buildingLevelsOrHexes += losEffects.buildingLevelsOrHexes;
        this.screen += losEffects.screen;
        this.softBuildings += losEffects.softBuildings;
        this.hardBuildings += losEffects.hardBuildings;
        this.blockedByHill |= losEffects.blockedByHill;
        this.blockedByWater |= losEffects.blockedByWater;
        this.targetCover |= losEffects.targetCover;
        this.attackerCover |= losEffects.attackerCover;
        if (null != this.thruBldg && !this.thruBldg.equals(losEffects.thruBldg)) {
            this.thruBldg = null;
        }
    }

    public int getPlantedFields() {
        return this.plantedFields;
    }

    public int getHeavyIndustrial() {
        return this.heavyIndustrial;
    }

    public int getLightWoods() {
        return this.lightWoods;
    }

    public int getHeavyWoods() {
        return this.heavyWoods;
    }

    public int getUltraWoods() {
        return this.ultraWoods;
    }

    public int getLightSmoke() {
        return this.lightSmoke;
    }

    public int getHeavySmoke() {
        return this.heavySmoke;
    }

    public int getScreen() {
        return this.screen;
    }

    public int getSoftBuildings() {
        return this.softBuildings;
    }

    public int getHardBuildings() {
        return this.hardBuildings;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isBlockedByHill() {
        return this.blockedByHill;
    }

    public boolean isBlockedByWater() {
        return this.blockedByWater;
    }

    public boolean isTargetCover() {
        return this.targetCover >= 3;
    }

    public int getTargetCover() {
        return this.targetCover;
    }

    public void setTargetCover(int n) {
        this.targetCover = n;
    }

    public boolean isAttackerCover() {
        return this.attackerCover >= 3;
    }

    public int getAttackerCover() {
        return this.attackerCover;
    }

    public void setAttackerCover(int n) {
        this.attackerCover = n;
    }

    public Building getThruBldg() {
        return this.thruBldg;
    }

    public void setThruBldg(Building building) {
        this.thruBldg = building;
    }

    public boolean canSee() {
        return this.hasLoS;
    }

    public static LosEffects calculateLos(IGame iGame, int n, Targetable targetable) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        Entity entity = iGame.getEntity(n);
        if (null == entity.getPosition() || null == targetable.getPosition() || entity.isOffBoard()) {
            LosEffects losEffects = new LosEffects();
            losEffects.blocked = true;
            losEffects.hasLoS = false;
            return losEffects;
        }
        AttackInfo attackInfo = new AttackInfo();
        attackInfo.attackPos = entity.getPosition();
        attackInfo.targetPos = targetable.getPosition();
        attackInfo.targetEntity = targetable.getTargetType() == 0;
        attackInfo.targetInfantry = targetable instanceof Infantry;
        attackInfo.attackHeight = entity.getHeight();
        attackInfo.targetHeight = targetable.getHeight();
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        int n2 = entity.absHeight() + iHex.getElevation();
        int n3 = targetable.getTargetType() == 0 || targetable.getTargetType() == 15 || targetable.getTargetType() == 16 || targetable.getTargetType() == 3 || targetable.getTargetType() == 4 ? targetable.absHeight() + iHex2.getElevation() : iGame.getBoard().getHex(targetable.getPosition()).surface();
        attackInfo.attackAbsHeight = n2;
        attackInfo.targetAbsHeight = n3;
        boolean bl8 = entity.isOffBoard();
        if (bl8) {
            bl7 = true;
            bl6 = false;
            bl5 = true;
        } else {
            bl7 = iHex.containsTerrain(2) && iHex.depth() > 0 && n2 < iHex.surface();
            bl6 = iHex.containsTerrain(2) && iHex.depth() > 0 && n2 == iHex.surface();
            bl5 = !bl7 && !bl6;
        }
        boolean bl9 = bl4 = !iGame.getBoard().contains(targetable.getPosition());
        if (bl4) {
            bl3 = true;
            bl2 = false;
            bl = true;
        } else {
            bl3 = iHex2.containsTerrain(2) && iHex2.depth() > 0 && n3 < iHex2.surface();
            bl2 = iHex2.containsTerrain(2) && iHex2.depth() > 0 && n3 == iHex2.surface();
            bl = !bl3 && !bl2;
        }
        boolean bl10 = bl3 || bl7;
        attackInfo.attUnderWater = bl7;
        attackInfo.attInWater = bl6;
        attackInfo.attOnLand = bl5;
        attackInfo.targetUnderWater = bl3;
        attackInfo.targetInWater = bl2;
        attackInfo.targetOnLand = bl;
        attackInfo.underWaterCombat = bl10;
        attackInfo.attOffBoard = bl8;
        if (attackInfo.attOnLand || attackInfo.targetOnLand) {
            attackInfo.minimumWaterDepth = 0;
        } else if (attackInfo.attInWater || attackInfo.targetInWater) {
            attackInfo.minimumWaterDepth = 1;
        } else if (attackInfo.attUnderWater || attackInfo.targetUnderWater) {
            attackInfo.minimumWaterDepth = Math.min(iHex.terrainLevel(2), iHex2.terrainLevel(2));
        }
        LosEffects losEffects = LosEffects.calculateLos(iGame, attackInfo);
        losEffects.setMinimumWaterDepth(attackInfo.minimumWaterDepth);
        losEffects.hasLoS = !losEffects.blocked && losEffects.screen < 1 && losEffects.plantedFields < 6 && losEffects.heavyIndustrial < 3 && losEffects.lightWoods + losEffects.lightSmoke + (losEffects.heavyWoods + losEffects.heavySmoke) * 2 + losEffects.ultraWoods * 3 < 3;
        return losEffects;
    }

    public static LosEffects calculateLos(IGame iGame, AttackInfo attackInfo) {
        if (attackInfo.attOffBoard) {
            LosEffects losEffects = new LosEffects();
            losEffects.blocked = true;
            losEffects.hasLoS = false;
            return losEffects;
        }
        if (attackInfo.attOnLand && attackInfo.targetUnderWater || attackInfo.attUnderWater && attackInfo.targetOnLand) {
            LosEffects losEffects = new LosEffects();
            losEffects.blocked = true;
            losEffects.hasLoS = false;
            losEffects.blockedByWater = true;
            return losEffects;
        }
        double d = attackInfo.attackPos.degree(attackInfo.targetPos);
        if (d % 60.0 == 30.0) {
            return LosEffects.losDivided(iGame, attackInfo);
        }
        return LosEffects.losStraight(iGame, attackInfo);
    }

    public ToHitData losModifiers(IGame iGame) {
        return this.losModifiers(iGame, 0);
    }

    public ToHitData losModifiers(IGame iGame, int n) {
        ToHitData toHitData = new ToHitData();
        if (this.arcedShot) {
            return toHitData;
        }
        if (this.blocked) {
            return new ToHitData(Integer.MAX_VALUE, "LOS blocked by terrain.");
        }
        if (this.infProtected) {
            return new ToHitData(Integer.MAX_VALUE, "Infantry protected by building.");
        }
        if (this.buildingLevelsOrHexes > 2) {
            return new ToHitData(Integer.MAX_VALUE, "LOS blocked by buildin hexes or levels.");
        }
        if (this.ultraWoods >= 1 || this.lightWoods + this.heavyWoods * 2 > 2) {
            return new ToHitData(Integer.MAX_VALUE, "LOS blocked by woods.");
        }
        if (this.lightSmoke + this.heavySmoke * 2 > 2) {
            return new ToHitData(Integer.MAX_VALUE, "LOS blocked by smoke.");
        }
        if (this.plantedFields > 5) {
            return new ToHitData(Integer.MAX_VALUE, "LOS blocked by planted fields.");
        }
        if (this.heavyIndustrial > 2) {
            return new ToHitData(Integer.MAX_VALUE, "LOS blocked by heavy industrial zones.");
        }
        if (this.screen > 0) {
            return new ToHitData(Integer.MAX_VALUE, "LOS blocked by screen.");
        }
        if (this.lightSmoke + this.heavySmoke * 2 + this.lightWoods + this.heavyWoods * 2 > 2) {
            return new ToHitData(Integer.MAX_VALUE, "LOS blocked by smoke and woods.");
        }
        if (this.plantedFields > 0) {
            toHitData.addModifier((int)Math.floor((double)this.plantedFields / 2.0), this.plantedFields + " intervening planted fields");
        }
        if (this.heavyIndustrial > 0) {
            toHitData.addModifier(this.heavyIndustrial, this.heavyIndustrial + " intervening heavy industrial zones");
        }
        if (this.lightWoods > 0) {
            if (n > 0) {
                toHitData.addModifier(1, "firing through light woods with EI system");
            } else {
                toHitData.addModifier(this.lightWoods, this.lightWoods + " intervening light woods");
            }
        }
        if (this.buildingLevelsOrHexes > 0) {
            if (n > 0) {
                toHitData.addModifier(1, "firing through building hex/level with EI system");
            } else {
                toHitData.addModifier(this.buildingLevelsOrHexes, this.buildingLevelsOrHexes + " intervening building levels or hexes");
            }
        }
        if (this.heavyWoods > 0) {
            if (n > 0) {
                toHitData.addModifier(this.heavyWoods, this.heavyWoods + " intervening heavy woods");
            } else {
                toHitData.addModifier(this.heavyWoods * 2, this.heavyWoods + " intervening heavy woods");
            }
        }
        if (this.lightSmoke > 0) {
            toHitData.addModifier(this.lightSmoke, this.lightSmoke + " intervening light smoke");
        }
        if (this.heavySmoke > 0) {
            StringBuffer stringBuffer = new StringBuffer(this.heavySmoke);
            stringBuffer.append(" intervening");
            stringBuffer.append(" heavy");
            stringBuffer.append(" smoke");
            if (n > 0) {
                toHitData.addModifier(this.heavySmoke, stringBuffer.toString());
            } else {
                toHitData.addModifier(this.heavySmoke * 2, stringBuffer.toString());
            }
        }
        if (this.targetCover != 0) {
            if (iGame.getOptions().booleanOption("tacops_partial_cover")) {
                if (this.targetCover == 7 || this.targetCover == 11) {
                    toHitData.addModifier(1, "target has 75% cover");
                } else if (this.targetCover >= 3) {
                    toHitData.addModifier(1, "target has 50% cover");
                } else {
                    toHitData.addModifier(0, "target has 25% cover");
                }
            } else {
                toHitData.addModifier(1, "target has partial cover");
                toHitData.setHitTable(6);
            }
        }
        return toHitData;
    }

    private static LosEffects losStraight(IGame iGame, AttackInfo attackInfo) {
        ArrayList<Coords> arrayList = Coords.intervening(attackInfo.attackPos, attackInfo.targetPos);
        LosEffects losEffects = new LosEffects();
        boolean bl = false;
        if (attackInfo.targetEntity) {
            bl = Compute.isInBuilding(iGame, attackInfo.targetAbsHeight - iGame.getBoard().getHex(attackInfo.targetPos).surface(), attackInfo.targetPos);
        }
        if (bl && Compute.isInBuilding(iGame, attackInfo.attackAbsHeight - iGame.getBoard().getHex(attackInfo.attackPos).surface(), attackInfo.attackPos)) {
            losEffects.setThruBldg(iGame.getBoard().getBuildingAt(arrayList.get(0)));
        }
        for (Coords coords : arrayList) {
            losEffects.add(LosEffects.losForCoords(iGame, attackInfo, coords, losEffects.getThruBldg()));
        }
        if (attackInfo.minimumWaterDepth < 1 && attackInfo.underWaterCombat) {
            losEffects.blocked = true;
        }
        if (attackInfo.targetInfantry && bl && null == losEffects.getThruBldg()) {
            losEffects.infProtected = true;
        }
        if (null != losEffects.getThruBldg() && attackInfo.attackAbsHeight != attackInfo.targetAbsHeight) {
            losEffects.setTargetCover(3);
        }
        return losEffects;
    }

    private static LosEffects losDivided(IGame iGame, AttackInfo attackInfo) {
        int n;
        ArrayList<Coords> arrayList = Coords.intervening(attackInfo.attackPos, attackInfo.targetPos, true);
        LosEffects losEffects = new LosEffects();
        boolean bl = false;
        if (attackInfo.targetEntity) {
            bl = Compute.isInBuilding(iGame, attackInfo.targetAbsHeight - iGame.getBoard().getHex(attackInfo.targetPos).surface(), attackInfo.targetPos);
        }
        if (bl && Compute.isInBuilding(iGame, attackInfo.attackAbsHeight - iGame.getBoard().getHex(attackInfo.attackPos).surface(), attackInfo.attackPos)) {
            losEffects.setThruBldg(iGame.getBoard().getBuildingAt(arrayList.get(0)));
        }
        for (n = 3; n < arrayList.size() - 2; n += 3) {
            losEffects.add(LosEffects.losForCoords(iGame, attackInfo, arrayList.get(n), losEffects.getThruBldg()));
        }
        if (attackInfo.minimumWaterDepth < 1 && attackInfo.underWaterCombat) {
            losEffects.blocked = true;
        }
        if (losEffects.losModifiers(iGame).getValue() == Integer.MAX_VALUE) {
            return losEffects;
        }
        for (n = 1; n < arrayList.size() - 2; n += 3) {
            int n2;
            int n3;
            boolean bl2;
            LosEffects losEffects2 = LosEffects.losForCoords(iGame, attackInfo, arrayList.get(n), losEffects.getThruBldg());
            LosEffects losEffects3 = LosEffects.losForCoords(iGame, attackInfo, arrayList.get(n + 1), losEffects.getThruBldg());
            boolean bl3 = bl2 = attackInfo.attackAbsHeight != attackInfo.targetAbsHeight;
            if (attackInfo.minimumWaterDepth < 1 && attackInfo.underWaterCombat) {
                losEffects.blocked = true;
            }
            if (bl && bl2) {
                if (null != losEffects2.getThruBldg()) {
                    losEffects2.setTargetCover(3);
                }
                if (null != losEffects3.getThruBldg()) {
                    losEffects3.setTargetCover(3);
                }
            }
            losEffects2.add(losEffects);
            losEffects3.add(losEffects);
            if (attackInfo.targetInfantry && bl) {
                if (null == losEffects2.getThruBldg()) {
                    losEffects2.infProtected = true;
                } else if (null == losEffects3.getThruBldg()) {
                    losEffects3.infProtected = true;
                }
            }
            losEffects = (n3 = losEffects2.losModifiers(iGame).getValue()) > (n2 = losEffects3.losModifiers(iGame).getValue()) || n3 == n2 && losEffects2.isAttackerCover() ? losEffects2 : losEffects3;
            if (!iGame.getOptions().booleanOption("tacops_partial_cover")) continue;
            int n4 = losEffects2.targetCover & 5 | losEffects3.targetCover & 0xA;
            if (!(n4 >= 15 || losEffects2.blocked && losEffects3.blocked)) {
                losEffects.blocked = false;
                losEffects.targetCover = n4;
            }
            if ((n4 = losEffects2.attackerCover & 5 | losEffects3.attackerCover & 0xA) >= 15 || losEffects2.blocked && losEffects3.blocked) continue;
            losEffects.blocked = false;
            losEffects.attackerCover = n4;
        }
        return losEffects;
    }

    private static LosEffects losForCoords(IGame iGame, AttackInfo attackInfo, Coords coords, Building building) {
        int n;
        LosEffects losEffects = new LosEffects();
        if (!iGame.getBoard().contains(coords)) {
            return losEffects;
        }
        Building building2 = iGame.getBoard().getBuildingAt(coords);
        if (building2 != null && building2.equals(building)) {
            losEffects.setThruBldg(building);
        }
        if (coords.equals(attackInfo.attackPos) || coords.equals(attackInfo.targetPos)) {
            if (losEffects.getThruBldg() != null && attackInfo.attackPos.equals(attackInfo.targetPos) && attackInfo.targetEntity) {
                losEffects.buildingLevelsOrHexes += Math.abs(attackInfo.attackHeight - attackInfo.targetHeight);
            }
            return losEffects;
        }
        if (iGame.getBoard().getBuildingAt(attackInfo.attackPos) != null && iGame.getBoard().getBuildingAt(attackInfo.targetPos) != null && building != null && iGame.getBoard().getBuildingAt(attackInfo.attackPos).equals(iGame.getBoard().getBuildingAt(attackInfo.targetPos)) && attackInfo.targetEntity && building.equals(iGame.getBoard().getBuildingAt(attackInfo.attackPos))) {
            ++losEffects.buildingLevelsOrHexes;
        }
        IHex iHex = iGame.getBoard().getHex(coords);
        int n2 = n = attackInfo.underWaterCombat ? iHex.floor() : iHex.surface();
        if (!iHex.containsTerrain(2)) {
            attackInfo.minimumWaterDepth = 0;
        } else if (iHex.terrainLevel(2) >= 0 && (attackInfo.minimumWaterDepth == -1 || iHex.terrainLevel(2) < attackInfo.minimumWaterDepth)) {
            attackInfo.minimumWaterDepth = iHex.terrainLevel(2);
        }
        int n3 = 0;
        if (null == losEffects.getThruBldg() && iHex.containsTerrain(24)) {
            n3 = iHex.terrainLevel(24);
        }
        if (iGame.getOptions().booleanOption("tacops_LOS1") && n + n3 > (attackInfo.targetAbsHeight * attackInfo.attackPos.distance(coords) + attackInfo.attackAbsHeight * attackInfo.targetPos.distance(coords)) / (attackInfo.targetPos.distance(coords) + attackInfo.attackPos.distance(coords))) {
            losEffects.blocked = true;
            if (iHex.terrainLevel(23) > 90) {
                ++losEffects.hardBuildings;
            } else if (n3 > 0) {
                ++losEffects.softBuildings;
            } else {
                losEffects.blockedByHill = true;
            }
        }
        if (n + n3 > attackInfo.attackAbsHeight && n + n3 > attackInfo.targetAbsHeight || n + n3 > attackInfo.attackAbsHeight && attackInfo.attackPos.distance(coords) == 1 || n + n3 > attackInfo.targetAbsHeight && attackInfo.targetPos.distance(coords) == 1) {
            losEffects.blocked = true;
            if (iHex.terrainLevel(23) > 90) {
                ++losEffects.hardBuildings;
            } else if (n3 > 0) {
                ++losEffects.softBuildings;
            } else {
                losEffects.blockedByHill = true;
            }
        }
        if (attackInfo.underWaterCombat && iHex.terrainLevel(2) == Integer.MIN_VALUE && (n + n3 > attackInfo.attackAbsHeight || n + n3 > attackInfo.targetAbsHeight)) {
            losEffects.blocked = true;
        }
        if (!attackInfo.underWaterCombat) {
            if (iHex.containsTerrain(36)) {
                ++losEffects.screen;
            }
            for (int i = 1; i < 11; ++i) {
                if (!(n + i > attackInfo.attackAbsHeight && n + i > attackInfo.targetAbsHeight || n + i > attackInfo.attackAbsHeight && attackInfo.attackPos.distance(coords) == 1) && (n + i <= attackInfo.targetAbsHeight || attackInfo.targetPos.distance(coords) != 1) || iHex.terrainLevel(10) != i) continue;
                ++losEffects.heavyIndustrial;
            }
            if ((n + 1 > attackInfo.attackAbsHeight && n + 2 > attackInfo.targetAbsHeight || n + 1 > attackInfo.attackAbsHeight && attackInfo.attackPos.distance(coords) == 1 || n + 1 > attackInfo.targetAbsHeight && attackInfo.targetPos.distance(coords) == 1) && iHex.containsTerrain(9)) {
                ++losEffects.plantedFields;
            }
            if (n + 2 > attackInfo.attackAbsHeight && n + 2 > attackInfo.targetAbsHeight || n + 2 > attackInfo.attackAbsHeight && attackInfo.attackPos.distance(coords) == 1 || n + 2 > attackInfo.targetAbsHeight && attackInfo.targetPos.distance(coords) == 1) {
                if (iHex.containsTerrain(20)) {
                    if (iHex.terrainLevel(20) == 1) {
                        ++losEffects.lightSmoke;
                    } else if (iHex.terrainLevel(20) > 1) {
                        ++losEffects.heavySmoke;
                    }
                }
                if (iHex.terrainLevel(1) == 1 || iHex.terrainLevel(5) == 1) {
                    ++losEffects.lightWoods;
                } else if (iHex.terrainLevel(1) == 2 || iHex.terrainLevel(5) == 2) {
                    ++losEffects.heavyWoods;
                }
            }
            if ((n + 3 > attackInfo.attackAbsHeight && n + 3 > attackInfo.targetAbsHeight || n + 3 > attackInfo.attackAbsHeight && attackInfo.attackPos.distance(coords) == 1 || n + 3 > attackInfo.targetAbsHeight && attackInfo.targetPos.distance(coords) == 1) && (iHex.terrainLevel(1) == 3 || iHex.terrainLevel(5) == 3)) {
                ++losEffects.ultraWoods;
            }
        }
        if (attackInfo.targetPos.distance(coords) == 1) {
            if (losEffects.blocked && iGame.getOptions().booleanOption("tacops_partial_cover")) {
                losEffects.targetCover = 15;
            } else if (n + n3 == attackInfo.targetAbsHeight && attackInfo.attackAbsHeight <= attackInfo.targetAbsHeight && attackInfo.targetHeight > 0) {
                losEffects.targetCover |= 3;
            }
        }
        if (attackInfo.attackPos.distance(coords) == 1) {
            if (losEffects.blocked && iGame.getOptions().booleanOption("tacops_partial_cover")) {
                losEffects.attackerCover = 15;
            } else if (n + n3 == attackInfo.attackAbsHeight && attackInfo.attackAbsHeight >= attackInfo.targetAbsHeight && attackInfo.attackHeight > 0) {
                losEffects.attackerCover |= 3;
            }
        }
        return losEffects;
    }

    public static boolean hasFireBetween(Coords coords, Coords coords2, IGame iGame) {
        ArrayList<Coords> arrayList = Coords.intervening(coords, coords2);
        for (Coords coords3 : arrayList) {
            if (!iGame.getBoard().getHex(coords3).containsTerrain(19)) continue;
            return true;
        }
        return false;
    }

    public void setArcedAttack(boolean bl) {
        this.arcedShot = bl;
    }

    public static class AttackInfo {
        public boolean attUnderWater;
        public boolean attInWater;
        public boolean attOnLand;
        public boolean targetUnderWater;
        public boolean targetInWater;
        public boolean targetOnLand;
        public boolean underWaterCombat;
        public boolean targetEntity = true;
        public boolean targetInfantry;
        public boolean attOffBoard;
        public Coords attackPos;
        public Coords targetPos;
        public int attackAbsHeight;
        public int targetAbsHeight;
        public int attackHeight;
        public int targetHeight;
        int minimumWaterDepth = -1;
    }
}

