/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.zip.ZipFile;
import megamek.common.Aero;
import megamek.common.BipedMech;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LargeSupportTank;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.Sensor;
import megamek.common.SupportTank;
import megamek.common.Tank;
import megamek.common.VTOL;
import megamek.common.WeaponType;
import megamek.common.loaders.BLKAeroFile;
import megamek.common.loaders.BLKBattleArmorFile;
import megamek.common.loaders.BLKConvFighterFile;
import megamek.common.loaders.BLKDropshipFile;
import megamek.common.loaders.BLKGunEmplacementFile;
import megamek.common.loaders.BLKInfantryFile;
import megamek.common.loaders.BLKJumpshipFile;
import megamek.common.loaders.BLKLargeSupportTankFile;
import megamek.common.loaders.BLKMechFile;
import megamek.common.loaders.BLKProtoFile;
import megamek.common.loaders.BLKSmallCraftFile;
import megamek.common.loaders.BLKSpaceStationFile;
import megamek.common.loaders.BLKSupportTankFile;
import megamek.common.loaders.BLKSupportVTOLFile;
import megamek.common.loaders.BLKTankFile;
import megamek.common.loaders.BLKVTOLFile;
import megamek.common.loaders.BLKWarshipFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.HmpFile;
import megamek.common.loaders.HmvFile;
import megamek.common.loaders.MepFile;
import megamek.common.loaders.MtfFile;
import megamek.common.loaders.TdbFile;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.BuildingBlock;
import megamek.common.weapons.ISERPPC;
import megamek.common.weapons.ISHeavyPPC;
import megamek.common.weapons.ISLightPPC;
import megamek.common.weapons.ISPPC;
import megamek.common.weapons.ISSnubNosePPC;

public class MechFileParser {
    private Entity m_entity = null;
    private static Vector<String> canonUnitNames = null;
    private static final File ROOT = new File(PreferenceManager.getClientPreferences().getMechDirectory());
    private static final File OFFICIALUNITS = new File(ROOT, "OfficialUnitList.txt");

    public MechFileParser(File file) throws EntityLoadingException {
        this(file, null);
    }

    public MechFileParser(File file, String string) throws EntityLoadingException {
        if (string == null) {
            try {
                this.parse(new FileInputStream(file), file.getName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (exception instanceof EntityLoadingException) {
                    throw new EntityLoadingException("While parsing file " + file.getName() + ", " + exception.getMessage());
                }
                throw new EntityLoadingException("Exception from " + exception.getClass() + ": " + exception.getMessage());
            }
        }
        try {
            ZipFile zipFile = new ZipFile(file);
            this.parse(zipFile.getInputStream(zipFile.getEntry(string)), string);
        }
        catch (EntityLoadingException entityLoadingException) {
            throw new EntityLoadingException(entityLoadingException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EntityLoadingException("Exception from " + exception.getClass() + ": " + exception.getMessage());
        }
    }

    public MechFileParser(InputStream inputStream, String string) throws EntityLoadingException {
        try {
            this.parse(inputStream, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof EntityLoadingException) {
                throw new EntityLoadingException(exception.getMessage());
            }
            throw new EntityLoadingException("Exception from " + exception.getClass() + ": " + exception.getMessage());
        }
    }

    public Entity getEntity() {
        return this.m_entity;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(InputStream inputStream, String string) throws EntityLoadingException {
        void var4_29;
        String string2 = string.toLowerCase();
        if (string2.endsWith(".mep")) {
            MepFile mepFile = new MepFile(inputStream);
        } else if (string2.endsWith(".mtf")) {
            MtfFile mtfFile = new MtfFile(inputStream);
        } else if (string2.endsWith(".hmp")) {
            HmpFile hmpFile = new HmpFile(inputStream);
        } else if (string2.endsWith(".hmv")) {
            HmvFile hmvFile = new HmvFile(inputStream);
        } else if (string2.endsWith(".xml")) {
            TdbFile tdbFile = new TdbFile(inputStream);
        } else if (string2.endsWith(".blk")) {
            BuildingBlock buildingBlock = new BuildingBlock(inputStream);
            if (buildingBlock.exists("UnitType")) {
                String string3 = buildingBlock.getDataAsString("UnitType")[0];
                if (string3.equals("Tank") || string3.equals("Naval") || string3.equals("Surface") || string3.equals("Hydrofoil")) {
                    BLKTankFile bLKTankFile = new BLKTankFile(buildingBlock);
                } else if (string3.equals("Infantry")) {
                    BLKInfantryFile bLKInfantryFile = new BLKInfantryFile(buildingBlock);
                } else if (string3.equals("BattleArmor")) {
                    BLKBattleArmorFile bLKBattleArmorFile = new BLKBattleArmorFile(buildingBlock);
                } else if (string3.equals("ProtoMech")) {
                    BLKProtoFile bLKProtoFile = new BLKProtoFile(buildingBlock);
                } else if (string3.equals("Mech")) {
                    BLKMechFile bLKMechFile = new BLKMechFile(buildingBlock);
                } else if (string3.equals("VTOL")) {
                    BLKVTOLFile bLKVTOLFile = new BLKVTOLFile(buildingBlock);
                } else if (string3.equals("GunEmplacement")) {
                    BLKGunEmplacementFile bLKGunEmplacementFile = new BLKGunEmplacementFile(buildingBlock);
                } else if (string3.equals("SupportTank")) {
                    BLKSupportTankFile bLKSupportTankFile = new BLKSupportTankFile(buildingBlock);
                } else if (string3.equals("LargeSupportTank")) {
                    BLKLargeSupportTankFile bLKLargeSupportTankFile = new BLKLargeSupportTankFile(buildingBlock);
                } else if (string3.equals("SupportVTOL")) {
                    BLKSupportVTOLFile bLKSupportVTOLFile = new BLKSupportVTOLFile(buildingBlock);
                } else if (string3.equals("Aero")) {
                    BLKAeroFile bLKAeroFile = new BLKAeroFile(buildingBlock);
                } else if (string3.equals("ConvFighter")) {
                    BLKConvFighterFile bLKConvFighterFile = new BLKConvFighterFile(buildingBlock);
                } else if (string3.equals("SmallCraft")) {
                    BLKSmallCraftFile bLKSmallCraftFile = new BLKSmallCraftFile(buildingBlock);
                } else if (string3.equals("Dropship")) {
                    BLKDropshipFile bLKDropshipFile = new BLKDropshipFile(buildingBlock);
                } else if (string3.equals("Jumpship")) {
                    BLKJumpshipFile bLKJumpshipFile = new BLKJumpshipFile(buildingBlock);
                } else if (string3.equals("Warship")) {
                    BLKWarshipFile bLKWarshipFile = new BLKWarshipFile(buildingBlock);
                } else {
                    if (!string3.equals("SpaceStation")) throw new EntityLoadingException("Unknown UnitType: " + string3);
                    BLKSpaceStationFile bLKSpaceStationFile = new BLKSpaceStationFile(buildingBlock);
                }
            } else {
                BLKMechFile bLKMechFile = new BLKMechFile(buildingBlock);
            }
        } else {
            if (!string2.endsWith(".dbm")) throw new EntityLoadingException("Unsupported file suffix");
            throw new EntityLoadingException("In order to use mechs from The Drawing Board with MegaMek, you must save your mech as an XML file (look in the 'File' menu of TDB.)  Then use the resulting '.xml' file instead of the '.dbm' file.  Note that only version 2.0.23 or later of TDB is compatible with MegaMek.");
        }
        this.m_entity = var4_29.getEntity();
        this.postLoadInit(this.m_entity);
    }

    private void postLoadInit(Entity entity) throws EntityLoadingException {
        Object object;
        block54: {
            if (entity instanceof Mech) {
                entity.getSensors().add(new Sensor(0));
                entity.getSensors().add(new Sensor(7));
                entity.getSensors().add(new Sensor(9));
                entity.getSensors().add(new Sensor(13));
                entity.setNextSensor(entity.getSensors().firstElement());
            } else if (entity instanceof VTOL) {
                entity.getSensors().add(new Sensor(1));
                entity.getSensors().add(new Sensor(8));
                entity.getSensors().add(new Sensor(10));
                entity.setNextSensor(entity.getSensors().firstElement());
            } else if (entity instanceof Tank) {
                entity.getSensors().add(new Sensor(1));
                entity.getSensors().add(new Sensor(8));
                entity.getSensors().add(new Sensor(10));
                entity.getSensors().add(new Sensor(14));
                entity.setNextSensor(entity.getSensors().firstElement());
            }
            for (Mounted object22 : entity.getMisc()) {
                EquipmentType equipmentType;
                if (object22.getType().hasFlag(512L) && object22.getLinked() == null) {
                    for (Mounted mounted : entity.getTotalWeaponList()) {
                        equipmentType = (WeaponType)mounted.getType();
                        if (((WeaponType)equipmentType).getAmmoType() != 7 && ((WeaponType)equipmentType).getAmmoType() != 45 && ((WeaponType)equipmentType).getAmmoType() != 9 || mounted.getLinkedBy() != null) continue;
                        if (mounted.getLocation() == object22.getLocation()) {
                            object22.setLinked(mounted);
                            break;
                        }
                        if (!(entity instanceof Mech) || object22.getLocation() != 0 || mounted.getLocation() != 1) continue;
                        object22.setLinked(mounted);
                        break;
                    }
                    if (object22.getLinked() == null) {
                        throw new EntityLoadingException("Unable to match Artemis to launcher");
                    }
                } else if ((object22.getType().hasFlag(65536L) || object22.getType().hasFlag(0x8000000000000L)) && object22.getLinked() == null && entity instanceof Mech) {
                    for (Mounted mounted : entity.getMisc()) {
                        equipmentType = (MiscType)mounted.getType();
                        if (!equipmentType.hasFlag(0x80000000000L)) continue;
                        object22.setLinked(mounted);
                        break;
                    }
                    if (object22.getLinked() == null) {
                        throw new EntityLoadingException("Unable to find an ECM Suite.  Mechs with Stealth Armor or Void-Signature-System must also be equipped with an ECM Suite.");
                    }
                } else if (object22.getType().hasFlag(0x400000000L) && object22.getLinked() == null) {
                    for (Mounted mounted : entity.getWeaponList()) {
                        equipmentType = (WeaponType)mounted.getType();
                        if (!equipmentType.hasFlag(8L) || mounted.getLinkedBy() != null || mounted.getLocation() != object22.getLocation() || !(mounted.getType() instanceof ISPPC) && !(mounted.getType() instanceof ISLightPPC) && !(mounted.getType() instanceof ISHeavyPPC) && !(mounted.getType() instanceof ISERPPC) && !(mounted.getType() instanceof ISSnubNosePPC)) continue;
                        object22.setLinked(mounted);
                        break;
                    }
                    if (object22.getLinked() == null) {
                        throw new EntityLoadingException("Unable to match Capacitor to PPC");
                    }
                } else if (object22.getType().hasFlag(0x1000000000000L) && object22.getLinked() == null) {
                    for (Mounted mounted : entity.getTotalWeaponList()) {
                        equipmentType = (WeaponType)mounted.getType();
                        if (((WeaponType)equipmentType).getAmmoType() != 12 || mounted.getLinkedBy() != null || mounted.getLocation() != object22.getLocation()) continue;
                        object22.setLinked(mounted);
                        break;
                    }
                    if (object22.getLinked() == null) {
                        throw new EntityLoadingException("Unable to match Apollo to launcher");
                    }
                }
                if (object22.getType().hasFlag(0x100000000000L)) {
                    if (object22.getType().getInternalName().equals("BeagleActiveProbe")) {
                        entity.getSensors().add(new Sensor(2));
                        entity.setNextSensor(entity.getSensors().lastElement());
                    } else if (object22.getType().getInternalName().equals("BloodhoundActiveProbe")) {
                        entity.getSensors().add(new Sensor(4));
                        entity.setNextSensor(entity.getSensors().lastElement());
                    } else if (object22.getType().getInternalName().equals("WatchdogECMSuite")) {
                        entity.getSensors().add(new Sensor(5));
                        entity.setNextSensor(entity.getSensors().lastElement());
                    } else if (object22.getType().getInternalName().equals("CLActiveProbe")) {
                        entity.getSensors().add(new Sensor(3));
                        entity.setNextSensor(entity.getSensors().lastElement());
                    } else if (object22.getType().getInternalName().equals("CLLightActiveProbe")) {
                        entity.getSensors().add(new Sensor(6));
                        entity.setNextSensor(entity.getSensors().lastElement());
                    } else if (object22.getType().getInternalName().equals("CLImprovedSensors")) {
                        entity.getSensors().add(new Sensor(12));
                        entity.setNextSensor(entity.getSensors().lastElement());
                    } else if (object22.getType().getInternalName().equals("ISImprovedSensors")) {
                        entity.getSensors().add(new Sensor(12));
                        entity.setNextSensor(entity.getSensors().lastElement());
                    }
                }
                if (entity instanceof Mech && (object22.getType().hasFlag(8L) || object22.getType().hasFlag(0x2000000000L))) {
                    ((Mech)entity).setAutoEject(false);
                }
                if (entity instanceof Mech && object22.getType().hasFlag(0x40000000000L)) {
                    if (entity.hasTargComp() || ((Mech)entity).hasTSM() || ((Mech)entity).hasMASC() && !entity.hasWorkingMisc(16L, 1L)) {
                        throw new EntityLoadingException("Unable to load AES due to incompatible systems");
                    }
                    if (object22.getLocation() != 5 && object22.getLocation() != 7 && object22.getLocation() != 4 && object22.getLocation() != 6) {
                        throw new EntityLoadingException("Unable to load AES due to incompatible location");
                    }
                }
                if (object22.getType().hasFlag(0x20000000L) && object22.getLocation() == 0) {
                    throw new EntityLoadingException("Unable to load harjel in head.");
                }
                if (object22.getType().hasFlag(0x200000000000L) && (entity instanceof Mech && object22.getLocation() == 0 || entity instanceof VTOL && object22.getLocation() == 5)) {
                    throw new EntityLoadingException("Unable to load Modular Armor in Rotor/Head location");
                }
                if (!object22.getType().hasFlag(0x400000000000L)) continue;
                if (entity instanceof BipedMech) {
                    if (object22.getLocation() != 7 && object22.getLocation() != 6) {
                        throw new EntityLoadingException("Talons are only legal in the Legs");
                    }
                    if (entity.hasWorkingMisc(0x400000000000L, -1, 6) && entity.hasWorkingMisc(0x400000000000L, -1, 7)) continue;
                    throw new EntityLoadingException("Talons must be in all legs");
                }
                if (entity instanceof QuadMech) {
                    if (object22.getLocation() != 7 && object22.getLocation() != 6 && object22.getLocation() != 5 && object22.getLocation() != 4) {
                        throw new EntityLoadingException("Talons are only legal in the Legs");
                    }
                    if (entity.hasWorkingMisc(0x400000000000L, -1, 6) && entity.hasWorkingMisc(0x400000000000L, -1, 7) && entity.hasWorkingMisc(0x400000000000L, -1, 5) && entity.hasWorkingMisc(0x400000000000L, -1, 5)) continue;
                    throw new EntityLoadingException("Talons must be in all legs");
                }
                throw new EntityLoadingException("Unable to load talons in non-Mek entity");
            }
            if (entity.usesWeaponBays()) {
                entity.loadAllWeapons();
            }
            if (entity instanceof Aero) {
                entity.setRapidFire();
                entity.setElevation(10);
            }
            entity.setCanon(false);
            try {
                if (canonUnitNames != null) break block54;
                canonUnitNames = new Vector();
                object = null;
                try {
                    String string;
                    object = new BufferedReader(new FileReader(OFFICIALUNITS));
                    while ((string = ((BufferedReader)object).readLine()) != null) {
                        int n = string.indexOf(124);
                        String string2 = string.substring(0, n);
                        canonUnitNames.addElement(string2);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = canonUnitNames.elements();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            if (!string.equals(entity.getShortNameRaw())) continue;
            entity.setCanon(true);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Files in a supported MegaMek file format can be specified on");
            System.out.println("the command line.  Multiple files may be processed at once.");
            System.out.println("The supported formats are:");
            System.out.println("\t.mtf    The native MegaMek format that your file will be converted into");
            System.out.println("\t.blk    Another native MegaMek format");
            System.out.println("\t.hmp    Heavy Metal Pro (c)RCW Enterprises");
            System.out.println("\t.mep    MechEngineer Pro (c)Howling Moon SoftWorks");
            System.out.println("\t.xml    The Drawing Board (c)Blackstone Interactive");
            System.out.println("Note: If you are using the MtfConvert utility, you may also drag and drop files onto it for conversion.");
            MechFileParser.getResponse("Press <enter> to exit...");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file = new File(string);
            String string2 = string.substring(0, string.lastIndexOf("."));
            BufferedWriter bufferedWriter = null;
            try {
                MechFileParser mechFileParser = new MechFileParser(file);
                Entity entity = mechFileParser.getEntity();
                if (entity instanceof Mech) {
                    File file2 = new File(string2 = string2 + ".mtf");
                    if (file2.exists() && !MechFileParser.getResponse("File already exists, overwrite? ")) {
                        return;
                    }
                    bufferedWriter = new BufferedWriter(new FileWriter(file2));
                    bufferedWriter.write(((Mech)entity).getMtf());
                    continue;
                }
                if (!(entity instanceof Tank)) continue;
                string2 = string2 + ".blk";
                if (entity instanceof SupportTank) {
                    if (entity instanceof LargeSupportTank) {
                        BLKLargeSupportTankFile.encode(string2, (LargeSupportTank)entity);
                        continue;
                    }
                    BLKSupportTankFile.encode(string2, (SupportTank)entity);
                    continue;
                }
                BLKTankFile.encode(string2, (Tank)entity);
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                MechFileParser.getResponse("Press <enter> to exit...");
                continue;
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static boolean getResponse(String string) {
        String string2 = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(string);
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2 != null && string2.toLowerCase().indexOf("y") == 0;
    }

    public static void dispose() {
        canonUnitNames = null;
    }
}

