/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.Vector;
import megamek.common.Aero;
import megamek.common.BipedMech;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.ConvFighter;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.ManeuverType;
import megamek.common.Mech;
import megamek.common.Minefield;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.SmallCraft;
import megamek.common.SpaceStation;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.VTOL;
import megamek.common.Warship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveStep
implements Serializable {
    private static final long serialVersionUID = -6075640793056182285L;
    private int type = 0;
    private int targetId = -1;
    private int targetType = 0;
    private Coords position;
    private int facing;
    private int mp;
    private int mpUsed;
    private int heat;
    private int totalHeat;
    private int distance;
    private int elevation = -999;
    private int mineToLay = -1;
    private int movementType;
    private boolean isProne;
    private boolean isFlying;
    private boolean isHullDown;
    private boolean climbMode;
    private boolean danger;
    private boolean pastDanger;
    private boolean isUsingMASC;
    private int targetNumberMASC;
    private boolean firstStep;
    private boolean isTurning;
    private boolean isUnloaded;
    private boolean hasEverUnloaded;
    private boolean prevStepOnPavement;
    private boolean hasJustStood;
    private boolean thisStepBackwards;
    private boolean onlyPavement;
    private boolean isPavementStep;
    private boolean isRunProhibited = false;
    private boolean isStackingViolation = false;
    private boolean isDiggingIn = false;
    private MovePath parent = null;
    private int velocity = -999;
    private int velocityN = -999;
    private int velocityLeft = 0;
    private int nTurns = 0;
    private int nRolls = 0;
    private boolean freeTurn = false;
    private int nStraight = 0;
    private int nDown = 0;
    private boolean offBoard = false;
    private int[] mv;
    private int recoveryUnit = -1;
    TreeMap<Integer, Vector<Integer>> launched = new TreeMap();
    private boolean isEvading = false;
    private boolean isRolled = false;
    private int maneuverType = 0;
    private boolean noCost = false;
    private boolean maneuver = false;
    private Minefield mf;
    private boolean terrainInvalid = false;
    private boolean isEndPos = true;

    public MoveStep(MovePath movePath, int n) {
        this.type = n;
        this.parent = movePath;
        this.hasEverUnloaded = n == 17 || n == 40;
    }

    public MoveStep(MovePath movePath, int n, Targetable targetable) {
        this(movePath, n);
        this.targetId = targetable.getTargetId();
        this.targetType = targetable.getTargetType();
        this.hasEverUnloaded = n == 17 || n == 40;
    }

    public MoveStep(MovePath movePath, int n, int n2) {
        this(movePath, n);
        this.mineToLay = n2;
    }

    public MoveStep(MovePath movePath, int n, TreeMap<Integer, Vector<Integer>> treeMap) {
        this(movePath, n);
        this.launched = treeMap;
        this.hasEverUnloaded = n == 17 || n == 40;
    }

    public MoveStep(MovePath movePath, int n, int n2, int n3) {
        this(movePath, n);
        this.recoveryUnit = n2;
        this.mineToLay = n3;
    }

    public MoveStep(MovePath movePath, int n, boolean bl) {
        this(movePath, n);
        this.noCost = bl;
    }

    public MoveStep(MovePath movePath, int n, boolean bl, boolean bl2) {
        this(movePath, n);
        this.noCost = bl;
        this.maneuver = bl2;
    }

    public MoveStep(MovePath movePath, int n, int n2, int n3, int n4) {
        this(movePath, n);
        this.recoveryUnit = n2;
        this.mineToLay = n3;
        this.maneuverType = n4;
    }

    public MoveStep(MovePath movePath, int n, Minefield minefield) {
        this(movePath, n);
        this.mf = minefield;
    }

    void setParent(MovePath movePath) {
        this.parent = movePath;
    }

    public String toString() {
        switch (this.type) {
            case 2: {
                return "B";
            }
            case 8: {
                return "Ch";
            }
            case 9: {
                return "DFA";
            }
            case 1: {
                return "F";
            }
            case 5: 
            case 50: {
                return "Up";
            }
            case 6: {
                return "Prone";
            }
            case 7: {
                return "StrJump";
            }
            case 3: {
                return "L";
            }
            case 4: {
                return "R";
            }
            case 11: {
                return "ShL";
            }
            case 12: {
                return "ShR";
            }
            case 13: {
                return "ShLB";
            }
            case 14: {
                return "ShRB";
            }
            case 15: {
                return "Unjam";
            }
            case 22: {
                return "SLight";
            }
            case 16: {
                return "Load";
            }
            case 17: {
                return "Unload";
            }
            case 18: {
                return "Eject";
            }
            case 20: {
                return "U";
            }
            case 21: {
                return "D";
            }
            case 24: {
                return "HullDown";
            }
            case 25: {
                return "CM+";
            }
            case 26: {
                return "CM-";
            }
            case 31: {
                return "Takeoff";
            }
            case 32: {
                return "Landing";
            }
        }
        return "???";
    }

    public int getType() {
        return this.type;
    }

    public MovePath getParent() {
        return this.parent;
    }

    public MovePath getParentUpToThisStep() {
        Vector<MoveStep> vector = new Vector<MoveStep>();
        MovePath movePath = new MovePath(this.parent.game, this.parent.getEntity());
        Enumeration<MoveStep> enumeration = this.parent.getSteps();
        while (true) {
            MoveStep moveStep = enumeration.nextElement();
            vector.add(moveStep);
            if (moveStep.equals(this)) break;
            enumeration.hasMoreElements();
        }
        movePath.steps = vector;
        return movePath;
    }

    public void setTarget(Targetable targetable) {
        if (targetable == null) {
            this.targetId = -1;
            this.targetType = 0;
        } else {
            this.targetId = targetable.getTargetId();
            this.targetType = targetable.getTargetType();
        }
    }

    public Targetable getTarget(IGame iGame) {
        if (this.targetId == -1) {
            return null;
        }
        return iGame.getTarget(this.targetType, this.targetId);
    }

    public TreeMap<Integer, Vector<Integer>> getLaunched() {
        return this.launched;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compileMove(IGame iGame, Entity entity, MoveStep moveStep) {
        Object object;
        IHex iHex = iGame.getBoard().getHex(this.getPosition());
        if (Compute.canMoveOnPavement(iGame, moveStep.getPosition(), this.getPosition(), this.getParentUpToThisStep())) {
            this.setPavementStep(true);
        } else {
            this.setPavementStep(false);
            this.setOnlyPavement(false);
        }
        this.setHasJustStood(false);
        if (moveStep.isThisStepBackwards() != this.isThisStepBackwards()) {
            this.setDistance(0);
        }
        this.addDistance(1);
        if (!(!(entity instanceof Aero) || iGame.useVectorMove() || entity.getMovementMode() == 17 && iGame.getBoard().inAtmosphere())) {
            this.setVelocityLeft(this.getVelocityLeft() - 1);
            this.setNTurns(0);
        }
        if (entity instanceof Aero && iGame.getBoard().inAtmosphere()) {
            this.setNStraight(this.getNStraight() + 1);
            if (!this.hasFreeTurn() && this.dueFreeTurn(entity, this.getNStraight(), this.getVelocity())) {
                this.setFreeTurn(true);
            }
        }
        if (this.getType() == 9) {
            object = iGame.getBoard().getHex(this.getPosition());
            this.setElevation(Math.max(0, object.terrainLevel(24)));
            int n = 0;
            IHex iHex2 = iGame.getBoard().getHex(moveStep.getPosition());
            n = Math.max(0, iHex2.terrainLevel(24));
            if (n > this.getElevation()) {
                this.setElevation(n);
            }
            this.setElevation(this.getElevation() + 1);
        } else if (this.parent.isJumping()) {
            object = iGame.getBoard().getHex(this.getPosition());
            int n = entity.getJumpMP() + entity.getElevation() + iGame.getBoard().getHex(entity.getPosition()).surface() - object.surface();
            int n2 = object.terrainLevel(24);
            int n3 = -object.depth();
            if (object.containsTerrain(17) && object.containsTerrain(2)) {
                n3 = 0;
            }
            if (entity instanceof Infantry) {
                this.setElevation(Math.max(n3, Math.min(n2, n)));
            } else {
                this.setElevation(Math.max(n3, n2));
            }
            if (this.climbMode() && n >= object.terrainLevel(28)) {
                this.setElevation(Math.max(this.getElevation(), object.terrainLevel(28)));
            }
        } else {
            object = iGame.getBoard().getBuildingAt(this.getPosition());
            if (object != null) {
                IHex iHex3 = iGame.getBoard().getHex(this.getPosition());
                int n = entity.getElevation() + iGame.getBoard().getHex(entity.getPosition()).surface() - iHex3.surface();
                n = entity instanceof Mech ? (n += 2) : ++n;
                if (((Building)object).getType() == 5) {
                    if (n < iHex3.terrainLevel(24)) return;
                    this.setElevation(Math.max(this.getElevation(), iHex3.terrainLevel(24)));
                } else {
                    this.setElevation(entity.calcElevation(iGame.getBoard().getHex(moveStep.getPosition()), iGame.getBoard().getHex(this.getPosition()), this.elevation, this.climbMode(), entity.getMovementMode() == 15 && moveStep.getType() == 26));
                }
            } else {
                this.setElevation(entity.calcElevation(iGame.getBoard().getHex(moveStep.getPosition()), iGame.getBoard().getHex(this.getPosition()), this.elevation, this.climbMode(), entity.getMovementMode() == 15 && moveStep.getType() == 26));
            }
        }
        if (entity instanceof Aero) {
            this.setMp(0);
            if (iGame.getBoard().inAtmosphere() && (((Aero)entity).isSpheroid() || iGame.getPlanetaryConditions().isVacuum())) {
                this.setMp(2);
            }
        } else {
            this.calcMovementCostFor(iGame, moveStep.getPosition(), moveStep.getElevation());
        }
        if (!(this.isPavementStep() || iHex.terrainLevel(2) <= 0 || iHex.containsTerrain(17) && this.elevation >= 0 || iHex.terrainLevel(28) == this.elevation || entity.getMovementMode() == 5 || entity.getMovementMode() == 7 || entity.getMovementMode() == 8 || entity.getMovementMode() == 18 || this.elevation == 0 && entity.getMovementMode() == 9 || entity.getMovementMode() == 6 || entity.getMovementMode() == 15)) {
            this.setRunProhibited(true);
        }
        int n = iHex.terrainLevel(8);
        if (this.elevation > 0) {
            n = 0;
        }
        if (iHex.containsTerrain(19) || n == 1) {
            this.heat = 2;
            this.totalHeat += 2;
            return;
        } else {
            if (n != 2) return;
            this.heat = 5;
            this.totalHeat += 5;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void compile(IGame var1_1, Entity var2_2, MoveStep var3_3) {
        var4_4 = var2_2 instanceof Infantry;
        this.copy(var1_1, var3_3);
        if (var3_3 == null) {
            var3_3 = new MoveStep(this.parent, 1);
            var3_3.setFromEntity(var2_2, var1_1);
            this.setFirstStep(var3_3.mpUsed == 0);
        }
        switch (this.getType()) {
            case 17: {
                this.hasEverUnloaded = true;
                this.setMp(1);
                break;
            }
            case 16: {
                this.setMp(1);
                break;
            }
            case 3: 
            case 4: {
                if (Compute.canMoveOnPavement(var1_1, var3_3.getPosition(), this.getPosition(), this.getParentUpToThisStep())) {
                    this.setPavementStep(true);
                } else {
                    this.setPavementStep(false);
                    this.setOnlyPavement(false);
                }
                this.setMp(this.parent.isJumping() != false || this.isHasJustStood() != false || var4_4 != false ? 0 : 1);
                if (var2_2 instanceof Aero) {
                    this.setMp(this.asfTurnCost(var1_1, this.getType(), var2_2));
                    this.setNTurns(this.getNTurns() + 1);
                    if (var1_1.getBoard().inAtmosphere()) {
                        this.setNStraight(0);
                        this.setFreeTurn(false);
                    }
                }
                this.adjustFacing(this.getType());
                break;
            }
            case 2: {
                this.moveInDir((this.getFacing() + 3) % 6);
                this.setThisStepBackwards(true);
                this.setRunProhibited(true);
                this.compileMove(var1_1, var2_2, var3_3);
                break;
            }
            case 1: 
            case 9: 
            case 27: {
                this.moveInDir(this.getFacing());
                this.setThisStepBackwards(false);
                this.compileMove(var1_1, var2_2, var3_3);
                break;
            }
            case 8: {
                if (var2_2 instanceof Aero && var1_1.useVectorMove()) break;
                this.moveInDir(this.getFacing());
                this.setThisStepBackwards(false);
                this.compileMove(var1_1, var2_2, var3_3);
                break;
            }
            case 13: 
            case 14: {
                this.moveInDir((MovePath.getAdjustedFacing(this.getFacing(), MovePath.turnForLateralShift(this.getType())) + 3) % 6);
                this.setThisStepBackwards(true);
                this.setRunProhibited(true);
                this.compileMove(var1_1, var2_2, var3_3);
                if (var2_2 instanceof Aero) {
                    this.setMp(0);
                    break;
                }
                this.setMp(this.getMp() + 1);
                break;
            }
            case 11: 
            case 12: {
                this.moveInDir(MovePath.getAdjustedFacing(this.getFacing(), MovePath.turnForLateralShift(this.getType())));
                this.setThisStepBackwards(false);
                this.compileMove(var1_1, var2_2, var3_3);
                if (var2_2 instanceof Aero) {
                    this.setMp(0);
                    break;
                }
                this.setMp(this.getMp() + 1);
                break;
            }
            case 5: {
                this.setMp(var2_2.getRunMP() == 1 ? 1 : 2);
                this.setHasJustStood(true);
                break;
            }
            case 50: {
                if (var2_2.getWalkMP() <= 2) {
                    var2_2.setCarefulStand(false);
                    this.setMp(var2_2.getRunMP() == 1 ? 1 : 2);
                } else {
                    this.setMp(var2_2.getWalkMP());
                }
                this.setHasJustStood(true);
                break;
            }
            case 6: {
                if (var2_2.isHullDown()) break;
                this.setMp(1);
                break;
            }
            case 7: {
                break;
            }
            case 20: {
                this.setElevation(this.elevation + 1);
                if (var2_2 instanceof Aero) {
                    this.setMp(2);
                } else {
                    this.setMp(this.parent.isJumping() != false ? 0 : 1);
                }
                if (var2_2.getMovementMode() != 15) break;
                this.setMp(5);
                break;
            }
            case 21: {
                this.setElevation(this.elevation - 1);
                if (var2_2 instanceof Aero) {
                    this.setMp(0);
                    this.setNDown(this.getNDown() + 1);
                } else {
                    this.setMp(this.parent.isJumping() != false ? 0 : 1);
                }
                if (var2_2.getMovementMode() != 15) break;
                this.setMp(0);
                break;
            }
            case 24: {
                if (!this.isProne() || !(var2_2 instanceof Mech)) ** GOTO lbl126
                var5_5 = 1;
                if (!(var2_2 instanceof BipedMech)) ** GOTO lbl116
                for (var6_7 = 6; var6_7 <= 7; ++var6_7) {
                    if (!var2_2.isLocationBad(var6_7)) ** GOTO lbl111
                    var5_5 += 99;
                    ** GOTO lbl124
lbl111:
                    // 1 sources

                    var5_5 += ((Mech)var2_2).countLegActuatorCrits(var6_7);
                    if (!((Mech)var2_2).legHasHipCrit(var6_7)) continue;
                    ++var5_5;
                }
                ** GOTO lbl124
lbl116:
                // 3 sources

                for (var6_8 = 4; var6_8 <= 7; ++var6_8) {
                    if (!var2_2.isLocationBad(var6_8)) ** GOTO lbl120
                    var5_5 += 99;
                    break;
lbl120:
                    // 1 sources

                    var5_5 += ((QuadMech)var2_2).countLegActuatorCrits(var6_8);
                    if (!((QuadMech)var2_2).legHasHipCrit(var6_8)) continue;
                    ++var5_5;
                }
lbl124:
                // 4 sources

                this.setMp(var5_5);
                break;
lbl126:
                // 1 sources

                this.setMp(2);
                break;
            }
            case 25: {
                this.setClimbMode(true);
                break;
            }
            case 26: {
                this.setClimbMode(false);
                break;
            }
            case 30: {
                this.setMp(var2_2.getRunMP() - var2_2.getWalkMP());
                break;
            }
            case 31: {
                this.setMp(2);
                break;
            }
            case 32: {
                this.setMp(2);
                break;
            }
            case 36: {
                this.setVelocityN(this.getVelocityN() + 1);
                this.setMp(1);
                break;
            }
            case 37: {
                this.setVelocityN(this.getVelocityN() - 1);
                this.setMp(1);
                break;
            }
            case 33: {
                this.setVelocity(this.getVelocity() + 1);
                this.setVelocityLeft(this.getVelocityLeft() + 1);
                this.setMp(1);
                break;
            }
            case 34: {
                this.setVelocity(this.getVelocity() - 1);
                this.setVelocityLeft(this.getVelocityLeft() - 1);
                this.setMp(1);
                break;
            }
            case 35: {
                this.setEvading(true);
                if (!(var2_2 instanceof Aero)) break;
                this.setMp(2);
                break;
            }
            case 38: {
                this.isRolled = var3_3.isRolled == false;
                if (var3_3.getType() != 42) {
                    this.setMp(1);
                    this.setNRolls(this.getNRolls() + 1);
                    break;
                }
                this.setMp(0);
                break;
            }
            case 40: {
                this.hasEverUnloaded = true;
                this.setMp(0);
                break;
            }
            case 45: {
                this.setMp(0);
                break;
            }
            case 51: {
                this.setMp(0);
                break;
            }
            case 41: {
                this.setVectors(Compute.changeVectors(this.getVectors(), this.getFacing()));
                this.setMp(1);
                break;
            }
            case 42: {
                this.setNRolls(this.getNRolls() + 1);
                this.reverseFacing();
                this.setMp(2);
                break;
            }
            case 44: {
                this.setElevation(this.getElevation() - 1);
                this.setMp(0);
                break;
            }
            case 47: {
                this.setMp(2);
                break;
            }
            case 48: {
                this.setMp(ManeuverType.getCost(this.getManeuverType(), this.getVelocity()));
                break;
            }
            case 49: {
                this.setVelocityLeft(this.getVelocityLeft() - 4);
                this.setMp(0);
            }
            default: {
                this.setMp(0);
            }
        }
        if (this.noCost) {
            this.setMp(0);
        }
        this.addMpUsed(this.getMp());
        var5_6 = Compute.stackingViolation(var1_1, var2_2.getId(), this.getPosition());
        if (var5_6 != null && this.getType() != 8 && this.getType() != 9) {
            this.setStackingViolation(true);
        }
        this.compileIllegal(var1_1, var2_2, var3_3);
    }

    boolean oppositeTurn(MoveStep moveStep) {
        switch (this.type) {
            case 3: {
                return moveStep.getType() == 4;
            }
            case 4: {
                return moveStep.getType() == 3;
            }
        }
        return false;
    }

    public void setElevation(int n) {
        this.elevation = n;
    }

    public void copy(IGame iGame, MoveStep moveStep) {
        if (moveStep == null) {
            this.setFromEntity(this.parent.getEntity(), iGame);
            return;
        }
        this.hasJustStood = moveStep.hasJustStood;
        this.facing = moveStep.getFacing();
        this.position = moveStep.getPosition();
        this.distance = moveStep.getDistance();
        this.mpUsed = moveStep.mpUsed;
        this.totalHeat = moveStep.totalHeat;
        this.isPavementStep = moveStep.isPavementStep;
        this.onlyPavement = moveStep.onlyPavement;
        this.thisStepBackwards = moveStep.thisStepBackwards;
        this.isProne = moveStep.isProne;
        this.isFlying = moveStep.isFlying;
        this.isHullDown = moveStep.isHullDown;
        this.climbMode = moveStep.climbMode;
        this.isRunProhibited = moveStep.isRunProhibited;
        this.hasEverUnloaded = moveStep.hasEverUnloaded;
        this.elevation = moveStep.elevation;
        this.elevation = moveStep.elevation;
        this.velocity = moveStep.velocity;
        this.velocityN = moveStep.velocityN;
        this.velocityLeft = moveStep.velocityLeft;
        this.nTurns = moveStep.nTurns;
        this.isEvading = moveStep.isEvading;
        this.nRolls = moveStep.nRolls;
        this.isRolled = moveStep.isRolled;
        this.mv = moveStep.mv;
        this.freeTurn = moveStep.freeTurn;
        this.nStraight = moveStep.nStraight;
        this.nDown = moveStep.nDown;
    }

    public void setFromEntity(Entity entity, IGame iGame) {
        int n;
        this.position = entity.getPosition();
        this.facing = entity.getFacing();
        this.mpUsed = entity.mpUsed;
        this.distance = entity.delta_distance;
        this.isProne = entity.isProne();
        this.isFlying = entity.isFlying();
        this.isHullDown = entity.isHullDown();
        this.climbMode = entity.climbMode();
        this.thisStepBackwards = entity.inReverse;
        this.elevation = entity.getElevation();
        this.movementType = entity.moved;
        this.isRolled = false;
        this.freeTurn = false;
        this.nStraight = 0;
        this.nDown = 0;
        int[] nArray = entity.getVectors();
        this.mv = new int[]{0, 0, 0, 0, 0, 0};
        for (n = 0; n < 6; ++n) {
            this.mv[n] = nArray[n];
        }
        if (entity instanceof Aero) {
            Aero aero = (Aero)entity;
            this.velocity = aero.getCurrentVelocity();
            this.velocityN = aero.getNextVelocity();
            this.velocityLeft = aero.getCurrentVelocity() - aero.delta_distance;
            this.isRolled = false;
            this.nStraight = aero.getStraightMoves();
        }
        n = entity.getMovementMode();
        if (entity instanceof Tank && ((Tank)entity).getStunnedTurns() > 0) {
            this.isRunProhibited = true;
        }
        if (this.position != null) {
            IHex iHex = iGame.getBoard().getHex(this.position);
            if (iHex.hasPavement()) {
                this.onlyPavement = true;
                this.isPavementStep = true;
                if (!entity.gotPavementBonus && entity.delta_distance > 0) {
                    this.onlyPavement = false;
                }
            }
            if (iHex.containsTerrain(2) && entity.getElevation() < 0 && this.distance > 0 && n != 7 && n != 8 && n != 9 && n != 18) {
                this.isRunProhibited = true;
            }
        }
    }

    public void adjustFacing(int n) {
        this.facing = MovePath.getAdjustedFacing(this.facing, n);
    }

    public void reverseFacing() {
        this.facing = MovePath.getAdjustedFacing(this.facing, 4);
        this.facing = MovePath.getAdjustedFacing(this.facing, 4);
        this.facing = MovePath.getAdjustedFacing(this.facing, 4);
    }

    public void moveInDir(int n) {
        this.position = this.position.translated(n);
        if (!this.parent.game.getBoard().contains(this.position)) {
            throw new RuntimeException("Coordinate off the board.");
        }
    }

    public void addDistance(int n) {
        this.distance += n;
    }

    public void addMpUsed(int n) {
        this.mpUsed += n;
    }

    public boolean isDanger() {
        return this.danger;
    }

    public int getDistance() {
        return this.distance;
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean isFirstStep() {
        return this.firstStep;
    }

    public boolean isHasJustStood() {
        return this.hasJustStood;
    }

    public boolean isPavementStep() {
        return this.isPavementStep;
    }

    public boolean isProne() {
        return this.isProne;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public boolean isHullDown() {
        return this.isHullDown;
    }

    public boolean climbMode() {
        return this.climbMode;
    }

    public boolean isTurning() {
        return this.isTurning;
    }

    public boolean isUnloaded() {
        return this.isUnloaded;
    }

    public boolean isUsingMASC() {
        return this.isUsingMASC;
    }

    public boolean isEvading() {
        return this.isEvading;
    }

    public boolean isRolled() {
        return this.isRolled;
    }

    public boolean isLegal() {
        return this.movementType != -1 && (this.isLegalEndPos() || !this.isEndPos);
    }

    public int getMovementType() {
        int n = this.movementType;
        if (!this.isLegalEndPos() && this.isEndPos) {
            n = -1;
        }
        return n;
    }

    public boolean isLegalEndPos() {
        boolean bl = true;
        if (this.isStackingViolation) {
            bl = false;
        } else if (this.terrainInvalid) {
            bl = false;
        } else if (this.parent.isJumping() && this.distance == 0) {
            bl = false;
        } else if (this.hasEverUnloaded && this.type != 17 && this.type != 40) {
            bl = false;
        }
        return bl;
    }

    public boolean setEndPos(boolean bl) {
        if (-1 == this.movementType) {
            bl = true;
        }
        boolean bl2 = this.isEndPos != bl;
        this.isEndPos = bl;
        return bl2;
    }

    public int getMpUsed() {
        return this.mpUsed;
    }

    public boolean isOnlyPavement() {
        return this.onlyPavement;
    }

    public boolean isPastDanger() {
        return this.pastDanger;
    }

    public Coords getPosition() {
        return this.position;
    }

    public boolean isPrevStepOnPavement() {
        return this.prevStepOnPavement;
    }

    public int getTargetNumberMASC() {
        return this.targetNumberMASC;
    }

    public boolean isThisStepBackwards() {
        return this.thisStepBackwards;
    }

    public void setDanger(boolean bl) {
        this.danger = bl;
    }

    public void setDistance(int n) {
        this.distance = n;
    }

    public void setFacing(int n) {
        this.facing = n;
    }

    public void setFirstStep(boolean bl) {
        this.firstStep = bl;
    }

    public void setHasJustStood(boolean bl) {
        this.hasJustStood = bl;
    }

    public void setPavementStep(boolean bl) {
        this.isPavementStep = bl;
    }

    public void setProne(boolean bl) {
        this.isProne = bl;
    }

    public void setFlying(boolean bl) {
        this.isFlying = bl;
    }

    public void setHullDown(boolean bl) {
        this.isHullDown = bl;
    }

    public void setClimbMode(boolean bl) {
        this.climbMode = bl;
    }

    public void setTurning(boolean bl) {
        this.isTurning = bl;
    }

    public void setUnloaded(boolean bl) {
        this.isUnloaded = bl;
        if (bl) {
            this.hasEverUnloaded = true;
        }
    }

    public void setUsingMASC(boolean bl) {
        this.isUsingMASC = bl;
    }

    public void setMovementType(int n) {
        this.movementType = n;
    }

    public void setEvading(boolean bl) {
        this.isEvading = bl;
    }

    public void setOnlyPavement(boolean bl) {
        this.onlyPavement = bl;
    }

    public void setTargetNumberMASC(int n) {
        this.targetNumberMASC = n;
    }

    public void setThisStepBackwards(boolean bl) {
        this.thisStepBackwards = bl;
    }

    public int getMp() {
        return this.mp;
    }

    public void setMp(int n) {
        this.mp = n;
    }

    void setRunProhibited(boolean bl) {
        this.isRunProhibited = bl;
    }

    boolean isRunProhibited() {
        return this.isRunProhibited;
    }

    void setStackingViolation(boolean bl) {
        this.isStackingViolation = bl;
    }

    boolean isStackingViolation() {
        return this.isStackingViolation;
    }

    private void compileIllegal(IGame iGame, Entity entity, MoveStep moveStep) {
        Targetable targetable;
        int n = this.getType();
        boolean bl = entity instanceof Infantry;
        Coords coords = this.getPosition();
        Coords coords2 = moveStep.getPosition();
        boolean bl2 = entity.isUnjammingRAC();
        this.prevStepOnPavement = moveStep.isPavementStep();
        this.isTurning = moveStep.isTurning();
        this.isUnloaded = moveStep.isUnloaded();
        if (bl && this.getMpUsed() - this.getMp() == 0) {
            this.setFirstStep(true);
        }
        this.movementType = -1;
        if (entity instanceof Aero) {
            IHex iHex;
            int n2;
            int n3 = entity.getWalkMP();
            Aero aero = (Aero)entity;
            if (aero.isImmobile()) {
                return;
            }
            if (!this.isFirstStep() && moveStep.getMovementType() == -1) {
                return;
            }
            if (iGame.getOptions().booleanOption("fuel_consumption") && (n2 = this.mpUsed + Math.max(this.mpUsed - aero.getWalkMP(), 0)) > aero.getFuel()) {
                return;
            }
            if (entity instanceof Jumpship && !(entity instanceof Warship) && !this.isFirstStep() && (moveStep.getParent().contains(3) || moveStep.getParent().contains(4))) {
                return;
            }
            if (entity instanceof SpaceStation && this.type != 3 && this.type != 4) {
                return;
            }
            if (!(iGame.useVectorMove() || this.isManeuver() || iGame.getBoard().inAtmosphere() && (aero.isSpheroid() || iGame.getPlanetaryConditions().isVacuum()) || this.distance != 0 || this.velocity == 0 || this.type != 3 && this.type != 4)) {
                return;
            }
            if (!(!iGame.getBoard().inAtmosphere() || this.distance != 0 || this.isManeuver() || iGame.getBoard().inAtmosphere() && (aero.isSpheroid() || iGame.getPlanetaryConditions().isVacuum()) || this.type != 3 && this.type != 4)) {
                return;
            }
            if (!(iGame.useVectorMove() || this.isManeuver() || iGame.getBoard().inAtmosphere() && (aero.isSpheroid() || iGame.getPlanetaryConditions().isVacuum()) || !(aero instanceof SmallCraft) || this.velocity == 0 || this.getNTurns() <= 2)) {
                return;
            }
            if (!iGame.useVectorMove() && aero instanceof Jumpship && this.velocity != 0 && this.getNTurns() > 1) {
                return;
            }
            if (!(!iGame.getBoard().inAtmosphere() || this.getNTurns() <= 1 || this.isManeuver() || iGame.getBoard().inAtmosphere() && (aero.isSpheroid() || iGame.getPlanetaryConditions().isVacuum()))) {
                return;
            }
            if (aero instanceof ConvFighter && (this.type == 3 || this.type == 4) && !moveStep.hasFreeTurn()) {
                return;
            }
            if (this.type == 1 && iGame.getBoard().inAtmosphere() && !aero.isOutControl() && this.elevation <= (iHex = iGame.getBoard().getHex(this.getPosition())).ceiling()) {
                return;
            }
            if (!(this.type != 3 || aero.getRightThrustHits() <= 2 || iGame.getBoard().inAtmosphere() && (aero.isSpheroid() || iGame.getPlanetaryConditions().isVacuum()))) {
                return;
            }
            if (!(this.type != 4 || aero.getLeftThrustHits() <= 2 || iGame.getBoard().inAtmosphere() && (aero.isSpheroid() || iGame.getPlanetaryConditions().isVacuum()))) {
                return;
            }
            if (!this.isFirstStep() && moveStep.getType() == 40) {
                return;
            }
            if (!this.isFirstStep() && moveStep.getType() == 45) {
                return;
            }
            if (!this.isFirstStep() && moveStep.getType() == 51) {
                return;
            }
            n2 = 0;
            for (Mounted mounted : entity.getAmmo()) {
                if (!mounted.isDumping()) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0 && this.getMpUsed() > n3 && !aero.isRandomMove()) {
                return;
            }
            if (this.getVelocityLeft() >= 0 || iGame.getBoard().inAtmosphere() && (aero.isSpheroid() || iGame.getPlanetaryConditions().isVacuum())) {
                if (this.getMpUsed() <= n3) {
                    this.movementType = 9;
                } else if (this.getMpUsed() <= entity.getRunMPwithoutMASC()) {
                    this.movementType = 10;
                } else if (aero.isRandomMove()) {
                    this.movementType = 10;
                }
            }
            return;
        }
        if (moveStep.isDiggingIn) {
            this.isDiggingIn = true;
            if (this.type != 3 && this.type != 4) {
                return;
            }
            this.movementType = 0;
        } else if (this.type == 28 || this.type == 29) {
            if (!bl || !this.isFirstStep()) {
                return;
            }
            Infantry infantry = (Infantry)entity;
            if (infantry.getDugIn() != 0 && infantry.getDugIn() != 2) {
                return;
            }
            if (iGame.getBoard().getHex(coords).containsTerrain(35)) {
                return;
            }
            this.isDiggingIn = true;
            this.movementType = 0;
        }
        if (this.isFirstStep() && this.type == 20 && entity.getMovementMode() == 15) {
            this.movementType = 1;
        }
        if (this.type == 10 && entity.canFlee()) {
            this.movementType = -3;
        }
        if (this.type == 23 && entity.canLayMine()) {
            this.movementType = moveStep.movementType;
        }
        if (this.type == 25 || this.type == 26) {
            this.movementType = moveStep.movementType;
        }
        if (this.type == 18) {
            this.movementType = 0;
        }
        if (this.type == 22) {
            this.movementType = moveStep.movementType;
        }
        if (this.type == 15) {
            this.movementType = 0;
        }
        if (this.type == 19 && entity instanceof Infantry) {
            this.movementType = 0;
        }
        if (this.type == 35) {
            if (entity.hasHipCrit()) {
                this.movementType = -1;
                return;
            }
            this.movementType = moveStep.movementType;
        }
        if (!(!this.parent.isJumping() || this.getMpUsed() > entity.getJumpMPWithTerrain() || this.isProne() || this.isHullDown() || entity instanceof Protomech && entity.getInternal(4) == -3 || entity.isStuck() && !entity.canUnstickByJumping())) {
            this.movementType = 3;
        }
        if (this.isFirstStep() && entity instanceof Protomech && entity.getInternal(4) == -3 && (n == 3 || n == 4) && !entity.isStuck()) {
            this.movementType = 1;
        }
        if (bl && (n == 3 || n == 4) && this.isFirstStep()) {
            this.movementType = this.parent.isJumping() ? 3 : 1;
        }
        int n4 = entity.getWalkMP();
        if (this.parent.getEntity().getMovementMode() == 13 || this.parent.getEntity().getMovementMode() == 14) {
            n4 = entity.getActiveUMUCount();
        }
        if (this.parent.getEntity().getMovementMode() == 6 && this.getElevation() != 0 && !(this.parent.getEntity() instanceof VTOL)) {
            n4 = entity.getJumpMP();
        }
        if (!this.parent.isJumping() && !entity.isStuck() && n4 > 0 && this.getMp() > 0) {
            if (n != 3 && n != 4 && n != 5 && n != 17 && n != 16 && n != 50 && n != 24 && n != 6 && (this.isProne() || this.isHullDown())) {
                this.movementType = -1;
                return;
            }
            if (!this.isFirstStep() && entity.getMovementMode() == 15 && this.getElevation() == 0) {
                this.movementType = -1;
                return;
            }
            if (this.getMpUsed() <= n4) {
                this.movementType = this.parent.getEntity().getMovementMode() == 6 && this.getElevation() > 0 ? 4 : 1;
            } else if (entity instanceof Tank && !(entity instanceof VTOL) && this.isOnlyPavement() && this.getMpUsed() == n4 + 1) {
                this.movementType = 1;
                entity.gotPavementBonus = true;
            } else if ((this.getMpUsed() <= entity.getRunMPwithoutMASC() || this.getMpUsed() <= entity.getRunMP() && entity instanceof Mech && ((Mech)entity).isMASCUsed()) && !this.isRunProhibited()) {
                this.movementType = this.parent.getEntity().getMovementMode() == 6 ? 5 : 2;
            } else if (this.getMpUsed() <= entity.getRunMP() && !this.isRunProhibited() && !this.isEvading()) {
                this.setUsingMASC(true);
                targetable = (Mech)entity;
                this.setTargetNumberMASC(targetable.getMASCTarget());
                this.movementType = 2;
            } else if (entity instanceof Tank && !(entity instanceof VTOL) && this.isOnlyPavement() && this.getMpUsed() <= entity.getRunMP() + 1 && !this.isRunProhibited()) {
                this.movementType = 2;
                entity.gotPavementBonus = true;
            }
        }
        if (bl && this.parent.getEntity().getWalkMP() == 0 && this.parent.getEntity().getPosition().equals(moveStep.getPosition()) && this.parent.getEntity().getPosition().distance(this.getPosition()) == 1) {
            this.movementType = 1;
        }
        if ((n == 3 || n == 4) && this.getMp() == 0) {
            this.movementType = moveStep.movementType;
        }
        if (this.getMp() == 0 && n == 6 && this.isHullDown()) {
            this.movementType = moveStep.movementType;
        }
        if (this.movementType == 1 && moveStep.movementType == 2) {
            this.movementType = 2;
        } else if (this.movementType == 4 && moveStep.movementType == 5) {
            this.movementType = 5;
        }
        if (entity.getBadCriticals(0, 4, 1) > 1 && !this.isFirstStep()) {
            this.movementType = -1;
        }
        if (5 == n && 1 == entity.getRunMP() && entity.mpUsed < 1 && !entity.isStuck()) {
            this.movementType = 2;
        }
        if (50 == n && entity.mpUsed > 1) {
            this.movementType = -1;
        }
        if (entity instanceof VTOL && this.movementType == 5 && ((VTOL)entity).isStabiliserHit(5)) {
            this.movementType = -1;
        }
        if (entity.getMovementMode() == 18 && !iGame.getBoard().getHex(coords).containsTerrain(2) && this.movementType == 2) {
            this.movementType = -1;
        }
        if (this.isFirstStep() && this.movementType == -1 && entity.getWalkMP() > 0 && !entity.isProne() && !entity.isHullDown() && !entity.isStuck() && n == 1) {
            this.movementType = 2;
        }
        if (n == 17) {
            if (this.isFirstStep() && this.getMpUsed() <= entity.getRunMP()) {
                this.movementType = 2;
                if (this.getMpUsed() <= entity.getWalkMP()) {
                    this.movementType = 1;
                }
            }
            if (this.getMpUsed() <= entity.getRunMP() && (entity.isProne() || entity.isHullDown()) && this.movementType == -1) {
                this.movementType = 2;
                if (this.getMpUsed() <= entity.getWalkMP()) {
                    this.movementType = 1;
                }
            }
            if ((targetable = this.getTarget(iGame)) instanceof Entity) {
                Entity entity2 = targetable;
                if (null != Compute.stackingViolation(iGame, entity2, coords, entity) || entity2.isHexProhibited(iGame.getBoard().getHex(coords))) {
                    this.movementType = -1;
                }
            } else {
                this.movementType = -1;
            }
        }
        if (n == 30) {
            this.movementType = this.getMp() == 0 || !(entity instanceof Tank) ? -1 : (entity.getMovementMode() == 6 ? 5 : 2);
        }
        if (bl2 && (this.movementType == 2 || this.movementType == 5 || this.parent.isJumping())) {
            this.movementType = -1;
        }
        if (n == 6 && (this.isProne() || !(entity instanceof Mech) || entity.isStuck())) {
            this.movementType = -1;
        }
        if (n == 24) {
            if (this.isHullDown() || !(entity instanceof Mech) && !(entity instanceof Tank) || entity.isStuck()) {
                this.movementType = -1;
            }
            if (entity instanceof Tank && !iGame.getBoard().getHex(coords).containsTerrain(35)) {
                this.movementType = -1;
            }
        }
        if ((n == 8 || n == 9) && entity.isProne()) {
            this.movementType = -1;
        }
        if (!this.isMovementPossible(iGame, coords2, moveStep.getElevation()) || this.isUnloaded) {
            this.movementType = -1;
        }
        if (-1 == moveStep.movementType) {
            this.movementType = -1;
        }
        if (this.movementType == -1) {
            return;
        }
        int n5 = moveStep.getElevation();
        this.danger |= Compute.isPilotingSkillNeeded(iGame, entity.getId(), coords2, coords, this.movementType, this.isTurning, this.prevStepOnPavement, n5, this.getElevation(), this.getParentUpToThisStep());
        if (n == 5) {
            this.danger = true;
        }
        this.pastDanger |= this.danger;
        switch (n) {
            case 3: 
            case 4: {
                this.setTurning(true);
                break;
            }
            case 17: {
                this.setUnloaded(true);
                break;
            }
            default: {
                this.setTurning(false);
            }
        }
        if (n == 6) {
            this.setProne(true);
            this.setHullDown(false);
        } else if (n == 5) {
            this.setProne(false);
            this.setHullDown(false);
        } else if (n == 24) {
            this.setProne(false);
            this.setHullDown(true);
        }
        if (n == 31) {
            this.movementType = 8;
            if (!this.isFirstStep() || this.isFlying || this.isProne) {
                this.movementType = -1;
            }
        } else if (n == 32) {
            if (!this.isFlying || this.getElevation() == 0) {
                this.movementType = -1;
            } else {
                this.movementType = 8;
                this.danger = true;
            }
        }
        if (entity.isCarefulStand()) {
            this.movementType = 11;
        }
        if (iGame.getPlanetaryConditions().getWindStrength() == 6 && this.movementType != 1) {
            this.movementType = -1;
            return;
        }
    }

    public int getTotalHeat() {
        return this.totalHeat;
    }

    public int getHeat() {
        return this.heat;
    }

    protected void calcMovementCostFor(IGame iGame, Coords coords, int n) {
        int n2 = this.parent.getEntity().getMovementMode();
        IHex iHex = iGame.getBoard().getHex(coords);
        IHex iHex2 = iGame.getBoard().getHex(this.getPosition());
        boolean bl = this.parent.getEntity() instanceof Infantry;
        boolean bl2 = bl && ((Infantry)this.parent.getEntity()).isMechanized();
        boolean bl3 = this.parent.getEntity() instanceof Protomech;
        int n3 = iHex.getElevation() + n;
        int n4 = iHex2.getElevation() + this.elevation;
        this.mp = 1;
        if (this.parent.isJumping()) {
            return;
        }
        if (bl && this.parent.getEntity().getWalkMP() == 0 && this.parent.getEntity().getPosition().equals(coords) && this.parent.getEntity().getPosition().distance(this.getPosition()) == 1) {
            this.mp = 0;
            return;
        }
        if (iGame.getPlanetaryConditions().getFog() == 1 && !iGame.getBoard().inSpace() && this.parent.isCareful()) {
            ++this.mp;
        } else if (iGame.getPlanetaryConditions().getFog() == 2 && !iGame.getBoard().inSpace() && this.parent.isCareful()) {
            this.mp += 2;
        }
        if (iGame.getPlanetaryConditions().getLight() == 2 && !iGame.getBoard().inSpace() && this.parent.isCareful()) {
            ++this.mp;
        } else if (iGame.getPlanetaryConditions().getLight() == 3 && !iGame.getBoard().inSpace() && this.parent.isCareful()) {
            this.mp += 2;
        } else if (iGame.getPlanetaryConditions().getLight() == 4 && !iGame.getBoard().inSpace() && this.parent.isCareful()) {
            this.mp += 3;
        }
        if (n2 == 6) {
            return;
        }
        if (!this.isPavementStep) {
            if (n2 != 13 && n2 != 14 && (n2 != 15 || this.getElevation() <= 0)) {
                this.mp += iHex2.movementCost(n2);
            }
            if (n2 != 5 && n2 != 7 && n2 != 8 && n2 != 9 && n2 != 18 && n2 != 6 && n2 != 13 && n2 != 14 && n2 != 15) {
                if (!iHex2.containsTerrain(17) || n4 < iHex2.surface()) {
                    if (iHex2.terrainLevel(2) == 1) {
                        ++this.mp;
                    } else if (iHex2.terrainLevel(2) > 1) {
                        this.mp += 3;
                    }
                }
                if (iHex2.containsTerrain(17) && !this.parent.isCareful() && n4 == iHex2.surface()) {
                    --this.mp;
                }
            }
        }
        if (n3 != n4 && n2 != 15) {
            int n5 = Math.abs(n3 - n4);
            if (bl && n2 != 4 && n2 != 5 || n2 == 3 || n2 == 4 || n2 == 5) {
                n5 *= 2;
            }
            this.mp += n5;
        }
        if (n2 == 15 && this.climbMode && this.elevation > 0) {
            this.mp += 2;
        }
        if (n4 < iHex2.terrainLevel(24)) {
            if (!bl) {
                if (!bl3) {
                    Building building = iGame.getBoard().getBuildingAt(this.getPosition());
                    this.mp += building.getType();
                } else {
                    ++this.mp;
                }
            } else if (bl2) {
                ++this.mp;
            }
        }
        if (bl && iHex2.containsTerrain(1) && !bl2) {
            --this.mp;
        }
    }

    public boolean isMovementPossible(IGame iGame, Coords coords, int n) {
        int n2;
        IHex iHex = iGame.getBoard().getHex(coords);
        Coords coords2 = this.getPosition();
        IHex iHex2 = iGame.getBoard().getHex(coords2);
        Entity entity = this.parent.getEntity();
        if (null == coords2) {
            throw new IllegalStateException("Step has no position.");
        }
        if (coords.distance(coords2) > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Coordinates ").append(coords.toString()).append(" and ").append(coords2.toString()).append(" are not adjacent.");
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        if (entity instanceof Tank && !entity.getCrew().isUnconscious() && (this.type == 15 || this.type == 18 || this.type == 22)) {
            return true;
        }
        if (entity.isImmobile()) {
            return false;
        }
        if (!iGame.getBoard().contains(coords2)) {
            return false;
        }
        if (iHex2.containsTerrain(33)) {
            return false;
        }
        Building building = iGame.getBoard().getBuildingAt(coords2);
        if (building != null) {
            IHex iHex3 = iGame.getBoard().getHex(this.getPosition());
            n2 = 2 + entity.getElevation() + iGame.getBoard().getHex(entity.getPosition()).surface() - iHex3.surface();
            if (building.getType() == 5 && n2 < iHex3.terrainLevel(24)) {
                return false;
            }
        }
        int n3 = n + iHex.getElevation();
        n2 = this.elevation + iHex2.getElevation();
        if (!(entity instanceof VTOL) && this.isThisStepBackwards() && (n2 != n3 && !iGame.getOptions().booleanOption("tacops_walk_backwards") || iGame.getOptions().booleanOption("tacops_walk_backwards") && Math.abs(n2 - n3) > 1)) {
            return false;
        }
        if (-1 != entity.getSwarmTargetId()) {
            return false;
        }
        if (this.type == 16) {
            if (!this.firstStep) {
                return false;
            }
            Entity entity2 = null;
            Enumeration<Entity> enumeration = iGame.getEntities(coords);
            while (enumeration.hasMoreElements()) {
                entity2 = (Entity)enumeration.nextElement();
                if (!entity.getOwner().isEnemyOf(entity2.getOwner()) && !entity.equals(entity2)) {
                    if (!entity.canLoad(entity2)) {
                        return false;
                    }
                    if (entity2.isLoadableThisTurn()) break;
                    return false;
                }
                entity2 = null;
            }
            if (entity2 == null) {
                return false;
            }
        }
        boolean bl = false;
        for (Mounted mounted : entity.getAmmo()) {
            if (!mounted.isDumping()) continue;
            bl = true;
            break;
        }
        if (bl && (this.movementType == 2 || this.movementType == 5 || this.movementType == 3)) {
            return false;
        }
        int n4 = entity.getMovementMode();
        if (this.movementType == 3 && n4 == 6) {
            return false;
        }
        if (this.movementType != 3 && n4 != 6 && (n3 - n2 > 0 && n3 - n2 > entity.getMaxElevationDown() || n2 - n3 > 0 && n2 - n3 > entity.getMaxElevationChange())) {
            return false;
        }
        if (!(this.type != 2 && this.type != 13 && this.type != 14 || n2 == n3 || entity instanceof VTOL)) {
            if (iGame.getOptions().booleanOption("tacops_walk_backwards") && Math.abs(n2 - n3) > 1) {
                return false;
            }
            if (!iGame.getOptions().booleanOption("tacops_walk_backwards") && n2 != n3) {
                return false;
            }
        }
        if (this.type == 2 && n4 == 15) {
            return false;
        }
        if (!(this.movementType != 2 && this.movementType != 5 || n4 == 5 || n4 == 7 || n4 == 8 || n4 == 9 || n4 == 18 || n4 == 6 || n4 == 15 || iHex2.terrainLevel(2) <= 0 || iHex2.containsTerrain(17) && this.elevation >= 0 || coords2.equals(entity.getPosition()) || this.firstStep || this.isPavementStep)) {
            return false;
        }
        if (!this.parent.isJumping() && this.type != 8 && this.type != 9) {
            if (entity instanceof Mech && Compute.isEnemyIn(iGame, entity, coords2, true, true, this.getElevation())) {
                return false;
            }
            if (Compute.isEnemyIn(iGame, entity, coords, false, entity instanceof Mech, this.getElevation()) && !coords.equals(entity.getPosition()) && this.type != 3 && this.type != 4 && this.type != 17 && this.type != 6) {
                return false;
            }
        }
        if (this.movementType == 3 && n2 > entity.getElevation() + entity.game.getBoard().getHex(entity.getPosition()).getElevation() + entity.getJumpMPWithTerrain() + (this.type == 9 ? 1 : 0)) {
            return false;
        }
        if (entity.isHexProhibited(iHex2) && (!this.isPavementStep() || n4 == 7 || n4 == 8 || n4 == 9) && this.movementType != 4 && this.movementType != 5) {
            if (this.parent.isJumping()) {
                this.terrainInvalid = true;
            } else {
                return false;
            }
        }
        if (!coords.equals(coords2) && coords != entity.getPosition() && (this.parent.isJumping() || entity.getMovementMode() == 6) && n < iHex.terrainLevel(24)) {
            return false;
        }
        if (this.movementType != 3 && this.movementType != 4 && this.movementType != 5 && entity.isHexProhibited(iHex) && !this.isPavementStep) {
            return false;
        }
        if (this.type == 20 && !entity.canGoUp(this.elevation - 1, this.getPosition())) {
            return false;
        }
        if (this.type == 21 && !entity.canGoDown(this.elevation + 1, this.getPosition())) {
            return false;
        }
        if (entity instanceof VTOL && (this.type == 2 || this.type == 1 || this.type == 11 || this.type == 13 || this.type == 12 || this.type == 14 || this.type == 3 || this.type == 4) && this.elevation == 0) {
            return false;
        }
        if (entity instanceof VTOL && (this.type == 2 || this.type == 1) && this.elevation <= iHex2.ceiling() - iHex2.surface()) {
            return false;
        }
        if (this.type != 9 && !entity.isElevationValid(this.elevation, iHex2)) {
            if (this.parent.isJumping()) {
                this.terrainInvalid = true;
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean canReuseSprite(MoveStep moveStep) {
        boolean bl = false;
        if (this.type == moveStep.type && this.facing == moveStep.facing && this.mpUsed == moveStep.mpUsed && this.movementType == moveStep.movementType && this.isProne == moveStep.isProne && this.isFlying == moveStep.isFlying && this.isHullDown == moveStep.isHullDown && this.danger == moveStep.danger && this.pastDanger == moveStep.pastDanger && this.isUsingMASC == moveStep.isUsingMASC && this.targetNumberMASC == moveStep.targetNumberMASC && this.isPavementStep == moveStep.isPavementStep && this.elevation == moveStep.elevation && this.isLegalEndPos() && moveStep.isLegalEndPos()) {
            bl = true;
        }
        return bl;
    }

    public int getElevation() {
        return this.elevation;
    }

    public int getMineToLay() {
        return this.mineToLay;
    }

    public void setMineToLay(int n) {
        this.mineToLay = n;
    }

    public void setVelocity(int n) {
        this.velocity = n;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setVelocityN(int n) {
        this.velocityN = n;
    }

    public int getVelocityN() {
        return this.velocityN;
    }

    public void setVelocityLeft(int n) {
        this.velocityLeft = n;
    }

    public int getVelocityLeft() {
        return this.velocityLeft;
    }

    private int asfTurnCost(IGame iGame, int n, Entity entity) {
        if (entity instanceof Jumpship && !(entity instanceof Warship) && !(entity instanceof SpaceStation)) {
            return 0;
        }
        if (iGame.getBoard().inAtmosphere()) {
            if (iGame.getBoard().inAtmosphere() && entity.getMovementMode() == 17) {
                return 0;
            }
            if (this.hasFreeTurn()) {
                return 0;
            }
            return (int)Math.ceil((double)this.getVelocity() / 2.0);
        }
        Aero aero = (Aero)entity;
        int n2 = 0;
        if (n == 3) {
            n2 = aero.getLeftThrustHits();
        }
        if (n == 4) {
            n2 = aero.getRightThrustHits();
        }
        if (iGame.useVectorMove()) {
            return 1 + n2;
        }
        if (this.velocity < 3) {
            return 1 + n2;
        }
        if (this.velocity > 2 && this.velocity < 6) {
            return 2 + n2;
        }
        if (this.velocity > 5 && this.velocity < 8) {
            return 3 + n2;
        }
        if (this.velocity > 7 && this.velocity < 10) {
            return 4 + n2;
        }
        if (this.velocity == 10) {
            return 5 + n2;
        }
        if (this.velocity == 11) {
            return 6 + n2;
        }
        return 6 + this.velocity - 11 + n2;
    }

    public void setNTurns(int n) {
        this.nTurns = n;
    }

    public int getNTurns() {
        return this.nTurns;
    }

    public void setNRolls(int n) {
        this.nRolls = n;
    }

    public int getNRolls() {
        return this.nRolls;
    }

    public void setOffBoard(boolean bl) {
        this.offBoard = bl;
    }

    public boolean isOffBoard() {
        return this.offBoard;
    }

    public int[] getVectors() {
        return this.mv;
    }

    public void setVectors(int[] nArray) {
        if (nArray.length != 6) {
            return;
        }
        this.mv = nArray;
    }

    public boolean hasFreeTurn() {
        return this.freeTurn;
    }

    public void setFreeTurn(boolean bl) {
        this.freeTurn = bl;
    }

    public int getNStraight() {
        return this.nStraight;
    }

    public void setNStraight(int n) {
        this.nStraight = n;
    }

    public boolean dueFreeTurn(Entity entity, int n, int n2) {
        int n3 = 99;
        n3 = entity instanceof SmallCraft ? (n2 > 15 ? 6 : (n2 > 12 ? 5 : (n2 > 9 ? 4 : (n2 > 6 ? 3 : (n2 > 3 ? 2 : 1))))) : (entity instanceof ConvFighter ? (n2 > 15 ? 4 : (n2 > 12 ? 3 : (n2 > 9 ? 2 : 1))) : (n2 > 15 ? 5 : (n2 > 12 ? 4 : (n2 > 9 ? 3 : (n2 > 6 ? 2 : 1)))));
        return n >= n3;
    }

    public void setNDown(int n) {
        this.nDown = n;
    }

    public int getNDown() {
        return this.nDown;
    }

    public int getRecoveryUnit() {
        return this.recoveryUnit;
    }

    public void setRecoveryUnit(int n) {
        this.recoveryUnit = n;
    }

    public int getManeuverType() {
        return this.maneuverType;
    }

    public boolean hasNoCost() {
        return this.noCost;
    }

    public boolean isManeuver() {
        return this.maneuver;
    }

    public Minefield getMinefield() {
        return this.mf;
    }
}

