/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.Aero;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.PilotingRollData;

public class TeleMissile
extends Aero
implements Serializable {
    private static final long serialVersionUID = -5932720323745597199L;
    public static final int LOC_BODY = 0;
    protected static String[] LOCATION_ABBRS = new String[]{"BODY"};
    protected static String[] LOCATION_NAMES = new String[]{"Body"};
    private int originalRideId;
    private int originalRideExternalId;
    private int[] damThresh = new int[]{0};
    private int critMod = 0;
    private boolean outContact = false;
    int damageValue = 0;

    public TeleMissile(Entity entity, int n, float f, int n2, int n3) {
        int n4 = 0;
        String string = "T-Op Missile";
        switch (n2) {
            case 60: {
                n4 = 25;
                string = "Kraken-T Missile";
                break;
            }
            case 58: {
                n4 = 40;
                string = "White Shark-T Missile";
                break;
            }
            case 57: {
                n4 = 30;
                string = "Killer Whale-T Missile";
                break;
            }
            case 59: {
                n4 = 30;
                string = "Barracuda-T Missile";
                break;
            }
            default: {
                n4 = 30;
            }
        }
        this.setCritMod(n3);
        this.setFuel(n4);
        this.setOriginalWalkMP(n4);
        this.setChassis(string);
        this.setModel("");
        this.setWeight(f);
        this.setDamageValue(n);
        this.initializeArmor(n * 10, 0);
        this.autoSetInternal();
        this.initializeSI(0);
        this.setOwner(entity.getOwner());
        this.initializeInternal(1, 0);
        this.setOriginalRideId(entity.getId());
        this.setOriginalRideExternalId(entity.getExternalId());
    }

    public HitData rollHitLocation(int n, int n2) {
        return new HitData(0, false, 0);
    }

    public void setDamageValue(int n) {
        this.damageValue = n;
    }

    public int getDamageValue() {
        return this.damageValue;
    }

    public int getOriginalRideId() {
        return this.originalRideId;
    }

    public void setOriginalRideId(int n) {
        this.originalRideId = n;
    }

    public int getOriginalRideExternalId() {
        return this.originalRideExternalId;
    }

    public void setOriginalRideExternalId(int n) {
        this.originalRideExternalId = n;
    }

    public void setThresh(int n, int n2) {
        this.damThresh[n2] = n;
    }

    public int getThresh(int n) {
        return this.damThresh[n];
    }

    public void autoSetThresh() {
        for (int i = 0; i < this.locations(); ++i) {
            this.initializeThresh(i);
        }
    }

    public void initializeThresh(int n) {
        int n2 = (int)Math.ceil((double)this.getArmor(n) / 10.0);
        this.setThresh(n2, n);
    }

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public int calculateBattleValue() {
        return 0;
    }

    public PilotingRollData checkThrustSI(int n, int n2) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n2);
        pilotingRollData.addModifier(-2147483647, "Check false: Entity is not exceeding SI");
        return pilotingRollData;
    }

    public PilotingRollData checkThrustSITotal(int n, int n2) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll(n2);
        pilotingRollData.addModifier(-2147483647, "Check false: Entity is not exceeding SI");
        return pilotingRollData;
    }

    public boolean isOutContact() {
        return this.outContact;
    }

    public void setOutContact(boolean bl) {
        this.outContact = bl;
    }

    public boolean isOutControlTotal() {
        return this.isOutControl() || this.outContact || this.shutDown || this.crew.isUnconscious();
    }

    public void setCritMod(int n) {
        this.critMod = n;
    }

    public int getCritMod() {
        return this.critMod;
    }

    public int locations() {
        return 1;
    }
}

