/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.Compute;
import megamek.common.TargetRoll;

public class ToHitData
extends TargetRoll {
    private static final long serialVersionUID = 737321999301910678L;
    public static final int HIT_NORMAL = 0;
    public static final int HIT_PUNCH = 1;
    public static final int HIT_KICK = 2;
    public static final int HIT_SWARM = 3;
    public static final int HIT_ABOVE = 4;
    public static final int HIT_BELOW = 5;
    public static final int HIT_PARTIAL_COVER = 6;
    public static final int HIT_SWARM_CONVENTIONAL = 7;
    public static final int SIDE_FRONT = 0;
    public static final int SIDE_REAR = 1;
    public static final int SIDE_LEFT = 2;
    public static final int SIDE_RIGHT = 3;
    public static final int SIDE_RANDOM = 4;
    public static final int SIDE_FRONTLEFT = 5;
    public static final int SIDE_FRONTRIGHT = 6;
    public static final int SIDE_REARLEFT = 7;
    public static final int SIDE_REARRIGHT = 8;
    private int hitTable = 0;
    private int sideTable = 0;
    private int cover = 0;
    private int margineOfSuccess = 0;

    public ToHitData() {
    }

    public ToHitData(int n, String string) {
        this(n, string, 0, 0);
    }

    public ToHitData(int n, String string, int n2, int n3) {
        super(n, string);
        this.hitTable = n2;
        this.sideTable = n3;
    }

    public int getHitTable() {
        return this.hitTable;
    }

    public void setHitTable(int n) {
        this.hitTable = n;
    }

    public int getSideTable() {
        int n = this.sideTable;
        if (n == 4) {
            n = Compute.randomInt(4);
        }
        return n;
    }

    public void setSideTable(int n) {
        this.sideTable = n;
    }

    public String getTableDesc() {
        if (this.sideTable != 0 || this.hitTable != 0) {
            String string = new String();
            switch (this.sideTable) {
                case 4: {
                    string = string + "Random Side ";
                    break;
                }
                case 3: {
                    string = string + "Right Side ";
                    break;
                }
                case 2: {
                    string = string + "Left Side ";
                    break;
                }
                case 1: {
                    string = string + "Rear ";
                }
            }
            switch (this.hitTable) {
                case 1: {
                    string = string + "Punch ";
                    break;
                }
                case 2: {
                    string = string + "Kick ";
                    break;
                }
                case 3: 
                case 7: {
                    string = string + "Swarm ";
                    break;
                }
                case 4: {
                    string = string + "Above ";
                    break;
                }
                case 5: {
                    string = string + "Below ";
                    break;
                }
                case 6: {
                    string = string + "Partial cover ";
                }
            }
            return " (using " + string + "table)";
        }
        return "";
    }

    public int getCover() {
        return this.cover;
    }

    public void setCover(int n) {
        this.cover = n;
    }

    public int getMoS() {
        return this.margineOfSuccess;
    }

    public void setMoS(int n) {
        this.margineOfSuccess = n;
    }
}

