/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import gd.xml.ParseException;
import gd.xml.XMLParser;
import gd.xml.XMLResponder;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Jumpship;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.loaders.EntityLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamParser
implements XMLResponder {
    private StringBuffer warning = new StringBuffer();
    private Vector<Entity> entities = new Vector();
    private XMLParser parser = new XMLParser();
    private InputStream inStream = null;
    private Entity entity = null;
    private int loc = -1;
    private boolean locDestroyed = false;
    private int locAmmoCount = 0;
    public static final String UNIT = "unit";
    public static final String TEMPLATE = "template";
    public static final String ENTITY = "entity";
    public static final String FLUFF = "fluff";
    public static final String PILOT = "pilot";
    public static final String LOCATION = "location";
    public static final String ARMOR = "armor";
    public static final String SLOT = "slot";
    public static final String MOVEMENT = "movement";
    public static final String TURRETLOCK = "turretlock";
    public static final String SI = "structural";
    public static final String HEAT = "Heat";
    public static final String FUEL = "fuel";
    public static final String KF = "KF";
    public static final String SAIL = "sail";
    public static final String AEROCRIT = "acriticals";
    public static final String CHASSIS = "chassis";
    public static final String MODEL = "model";
    public static final String NAME = "name";
    public static final String GUNNERY = "gunnery";
    public static final String GUNNERYL = "gunneryL";
    public static final String GUNNERYM = "gunneryM";
    public static final String GUNNERYB = "gunneryB";
    public static final String PILOTING = "piloting";
    public static final String INITB = "initB";
    public static final String COMMANDB = "commandB";
    public static final String HITS = "hits";
    public static final String ADVS = "advantages";
    public static final String IMPLANTS = "implants";
    public static final String AUTOEJECT = "autoeject";
    public static final String INDEX = "index";
    public static final String IS_DESTROYED = "isDestroyed";
    public static final String POINTS = "points";
    public static final String TYPE = "type";
    public static final String IS_REAR = "isRear";
    public static final String SHOTS = "shots";
    public static final String IS_HIT = "isHit";
    public static final String MUNITION = "munition";
    public static final String SPEED = "speed";
    public static final String DIRECTION = "direction";
    public static final String INTEGRITY = "integrity";
    public static final String SINK = "sinks";
    public static final String LEFT = "left";
    public static final String AVIONICS = "avionics";
    public static final String SENSORS = "sensors";
    public static final String ENGINE = "engine";
    public static final String FCS = "fcs";
    public static final String CIC = "cic";
    public static final String LEFT_THRUST = "leftThrust";
    public static final String RIGHT_THRUST = "rightThrust";
    public static final String LIFE_SUPPORT = "lifeSupport";
    public static final String GEAR = "gear";
    public static final String DEAD = "Dead";
    public static final String NA = "N/A";
    public static final String DESTROYED = "Destroyed";
    public static final String FRONT = "Front";
    public static final String REAR = "Rear";
    public static final String INTERNAL = "Internal";
    public static final String EMPTY = "Empty";
    public static final String SYSTEM = "System";

    private void destroyLocation(Entity entity, int n) {
        entity.setArmor(-3, n, false);
        entity.setInternal(-3, n);
        if (entity.hasRearArmor(n)) {
            entity.setArmor(-3, n, true);
        }
        for (Mounted serializable : entity.getEquipment()) {
            if (serializable.getLocation() != n) continue;
            serializable.setDestroyed(true);
        }
        for (int i = 0; i < entity.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot = entity.getCritical(n, i);
            if (criticalSlot == null) continue;
            criticalSlot.setDestroyed(true);
        }
        if (entity.getDependentLocation(n) != -1) {
            this.destroyLocation(entity, entity.getDependentLocation(n));
        }
    }

    public XMLStreamParser() {
    }

    public void parse(InputStream inputStream) throws ParseException {
        this.warning = new StringBuffer();
        this.entities.removeAllElements();
        this.inStream = inputStream;
        this.parser.parseXML((XMLResponder)this);
    }

    public XMLStreamParser(InputStream inputStream) throws ParseException {
        this.parse(inputStream);
    }

    public boolean hasWarningMessage() {
        return this.warning.length() > 0;
    }

    public String getWarningMessage() {
        if (this.warning.length() > 0) {
            return this.warning.toString();
        }
        return null;
    }

    public Vector<Entity> getEntities() {
        return this.entities;
    }

    public void recordNotationDeclaration(String string, String string2, String string3) throws ParseException {
    }

    public void recordEntityDeclaration(String string, String string2, String string3, String string4, String string5) throws ParseException {
    }

    public void recordElementDeclaration(String string, String string2) throws ParseException {
    }

    public void recordAttlistDeclaration(String string, String string2, boolean bl, String string3, String string4, String string5) throws ParseException {
    }

    public void recordDoctypeDeclaration(String string, String string2, String string3) throws ParseException {
    }

    public void recordDocStart() {
    }

    public void recordDocEnd() {
    }

    public void recordElementStart(String string, Hashtable hashtable) throws ParseException {
        if (string.equals(UNIT)) {
            if (this.entity != null) {
                this.warning.append("Found a unit while parsing an Entity.\n");
            } else if (!this.entities.isEmpty()) {
                this.warning.append("Found a second unit.  Clearing first unit.\n");
                this.entities.removeAllElements();
            }
        } else if (!string.equals(TEMPLATE)) {
            if (string.equals(ENTITY)) {
                if (this.entity != null) {
                    this.warning.append("Found another Entity while parsing an Entity.\n");
                } else if (this.loc != -1) {
                    this.warning.append("Found another Entity while parsing a location.\n");
                } else {
                    String string2 = (String)hashtable.get(CHASSIS);
                    String string3 = (String)hashtable.get(MODEL);
                    if (string2 == null || string2.length() == 0) {
                        this.warning.append("Could not find chassis for Entity.\n");
                    } else {
                        MechSummary mechSummary = null;
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        mechSummary = MechSummaryCache.getInstance().getMech(stringBuffer.toString());
                        if (string3 != null && string3.length() > 0) {
                            stringBuffer.append(" ").append(string3);
                            mechSummary = MechSummaryCache.getInstance().getMech(stringBuffer.toString());
                            if (mechSummary == null) {
                                stringBuffer = new StringBuffer(string3);
                                stringBuffer.append(" ").append(string2);
                                mechSummary = MechSummaryCache.getInstance().getMech(stringBuffer.toString());
                            }
                        }
                        if (mechSummary == null) {
                            this.warning.append("Could not find Entity with chassis: ");
                            this.warning.append(string2);
                            if (string3 != null && string3.length() > 0) {
                                this.warning.append(", and model: ");
                                this.warning.append(string3);
                            }
                            this.warning.append(".\n");
                        } else {
                            try {
                                this.entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                            }
                            catch (EntityLoadingException entityLoadingException) {
                                entityLoadingException.printStackTrace(System.err);
                                this.warning.append("Unable to load mech: ").append(mechSummary.getSourceFile()).append(": ").append(mechSummary.getEntryName()).append(": ").append(entityLoadingException.getMessage());
                            }
                        }
                    }
                }
            } else if (!string.equals(FLUFF)) {
                if (string.equals(PILOT)) {
                    if (this.entity == null) {
                        this.warning.append("Found a pilot outside of an Entity.\n");
                    } else if (this.loc != -1) {
                        this.warning.append("Found a pilot while parsing a location.\n");
                    } else {
                        String string4 = (String)hashtable.get(NAME);
                        String string5 = (String)hashtable.get(GUNNERY);
                        String string6 = (String)hashtable.get(GUNNERYL);
                        String string7 = (String)hashtable.get(GUNNERYM);
                        String string8 = (String)hashtable.get(GUNNERYB);
                        String string9 = (String)hashtable.get(PILOTING);
                        String string10 = (String)hashtable.get(INITB);
                        String string11 = (String)hashtable.get(COMMANDB);
                        String string12 = (String)hashtable.get(HITS);
                        String string13 = (String)hashtable.get(ADVS);
                        String string14 = (String)hashtable.get(IMPLANTS);
                        String string15 = (String)hashtable.get(AUTOEJECT);
                        if (string5 == null || string5.length() == 0) {
                            this.warning.append("Could not find gunnery for pilot.\n");
                        } else if (string9 == null || string9.length() == 0) {
                            this.warning.append("Could not find piloting for pilot.\n");
                        } else {
                            Object object;
                            String string16;
                            String string17;
                            StringTokenizer stringTokenizer;
                            int n = -1;
                            try {
                                n = Integer.parseInt(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n < 0 || n > 7) {
                                this.warning.append("Found invalid gunnery value: ").append(string5).append(".\n");
                                return;
                            }
                            int n2 = -1;
                            try {
                                n2 = Integer.parseInt(string9);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n2 < 0 || n2 > 7) {
                                this.warning.append("Found invalid piloting value: ").append(string9).append(".\n");
                                return;
                            }
                            int n3 = 0;
                            if (null != string10 && string10.length() > 0) {
                                try {
                                    n3 = Integer.parseInt(string10);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            int n4 = 0;
                            if (null != string11 && string11.length() > 0) {
                                try {
                                    n4 = Integer.parseInt(string11);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            int n5 = n;
                            int n6 = n;
                            int n7 = n;
                            if (null != string6 && string6.length() > 0) {
                                try {
                                    n5 = Integer.parseInt(string6);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (n5 < 0 || n5 > 7) {
                                    this.warning.append("Found invalid piloting value: ").append(string6).append(".\n");
                                    return;
                                }
                            }
                            if (null != string7 && string7.length() > 0) {
                                try {
                                    n6 = Integer.parseInt(string7);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (n6 < 0 || n6 > 7) {
                                    this.warning.append("Found invalid piloting value: ").append(string7).append(".\n");
                                    return;
                                }
                            }
                            if (null != string8 && string8.length() > 0) {
                                try {
                                    n7 = Integer.parseInt(string8);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (n7 < 0 || n7 > 7) {
                                    this.warning.append("Found invalid piloting value: ").append(string8).append(".\n");
                                    return;
                                }
                            }
                            Pilot pilot = this.entity.getCrew();
                            if (null == string4 || string4.length() == 0) {
                                string4 = pilot.getName();
                            }
                            pilot = new Pilot(string4, n5, n6, n7, n2);
                            pilot.setInitBonus(n3);
                            pilot.setCommandBonus(n4);
                            if (null != string13 && string13.trim().length() > 0) {
                                stringTokenizer = new StringTokenizer(string13, "::");
                                while (stringTokenizer.hasMoreTokens()) {
                                    string17 = stringTokenizer.nextToken();
                                    string16 = Pilot.parseAdvantageName(string17);
                                    object = Pilot.parseAdvantageValue(string17);
                                    try {
                                        pilot.getOptions().getOption(string16).setValue(object);
                                    }
                                    catch (Exception exception) {
                                        this.warning.append("Error restoring advantage: ").append(string17).append(".\n");
                                    }
                                }
                            }
                            if (null != string14 && string14.trim().length() > 0) {
                                stringTokenizer = new StringTokenizer(string14, "::");
                                while (stringTokenizer.hasMoreTokens()) {
                                    string17 = stringTokenizer.nextToken();
                                    string16 = Pilot.parseAdvantageName(string17);
                                    object = Pilot.parseAdvantageValue(string17);
                                    try {
                                        pilot.getOptions().getOption(string16).setValue(object);
                                    }
                                    catch (Exception exception) {
                                        this.warning.append("Error restoring advantage: ").append(string17).append(".\n");
                                    }
                                }
                            }
                            if (string12 != null) {
                                int n8 = -1;
                                try {
                                    n8 = Integer.parseInt(string12);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (string12.equals(DEAD)) {
                                    pilot.setDead(true);
                                    this.warning.append("The pilot, ").append(string4).append(", is dead.\n");
                                } else if (n8 < 0 || n8 > 5) {
                                    this.warning.append("Found invalid hits value: ").append(string12).append(".\n");
                                } else {
                                    pilot.setHits(n8);
                                }
                            }
                            this.entity.setCrew(pilot);
                            if (string15 != null) {
                                if (string15.equals("true")) {
                                    ((Mech)this.entity).setAutoEject(true);
                                } else {
                                    ((Mech)this.entity).setAutoEject(false);
                                }
                            }
                        }
                    }
                } else if (string.equals(LOCATION)) {
                    if (this.entity == null) {
                        this.warning.append("Found a location outside of an Entity.\n");
                    } else if (this.loc != -1) {
                        this.warning.append("Found a location while parsing a location.\n");
                    } else {
                        String string18 = (String)hashtable.get(INDEX);
                        String string19 = (String)hashtable.get(IS_DESTROYED);
                        if (string18 == null || string18.length() == 0) {
                            this.warning.append("Could not find index for location.\n");
                        } else {
                            int n = -1;
                            try {
                                n = Integer.parseInt(string18);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n < 0 || n > 7) {
                                this.warning.append("Found invalid index value for location: ").append(string18).append(".\n");
                                return;
                            }
                            if (n >= this.entity.locations()) {
                                this.warning.append("The entity, ").append(this.entity.getShortName()).append(" does not have a location at index: ").append(n).append(".\n");
                                return;
                            }
                            this.loc = n;
                            this.locAmmoCount = 0;
                            this.locDestroyed = false;
                            try {
                                if (string19 != null) {
                                    this.locDestroyed = string19.equals("true");
                                }
                            }
                            catch (Throwable throwable) {
                                this.warning.append("Found invalid isDestroyed value: ").append(string19).append(".\n");
                            }
                        }
                    }
                } else if (string.equals(TURRETLOCK)) {
                    if (this.entity == null) {
                        this.warning.append("Found turret lock outside of an Entity.\n");
                    } else if (!(this.entity instanceof Tank)) {
                        this.warning.append("Turret crit record found outside a Tank.\n");
                    }
                    String string20 = (String)hashtable.get(DIRECTION);
                    try {
                        int n = Integer.parseInt(string20);
                        ((Tank)this.entity).setSecondaryFacing(n);
                        ((Tank)this.entity).lockTurret();
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                        exception.printStackTrace();
                        this.warning.append("Invalid turret lock direction value in movement tag.\n");
                    }
                } else if (string.equals(MOVEMENT)) {
                    if (this.entity == null) {
                        this.warning.append("Found movement crit outside of an Entity.\n");
                    } else if (!(this.entity instanceof Tank)) {
                        this.warning.append("Movement crit record found outside a Tank.\n");
                    }
                    String string21 = (String)hashtable.get(SPEED);
                    if (string21.equals("immobile")) {
                        ((Tank)this.entity).immobilize();
                    } else {
                        try {
                            int n = Integer.parseInt(string21);
                            this.entity.setOriginalWalkMP(n);
                        }
                        catch (Exception exception) {
                            this.warning.append("Invalid speed value in movement tag.\n");
                        }
                    }
                } else if (string.equals(ARMOR)) {
                    if (this.entity == null) {
                        this.warning.append("Found armor outside of an Entity.\n");
                    } else if (this.loc == -1) {
                        this.warning.append("Found armor while outside of a location.\n");
                    } else {
                        String string22 = (String)hashtable.get(POINTS);
                        String string23 = (String)hashtable.get(TYPE);
                        if (string22 == null || string22.length() == 0) {
                            this.warning.append("Could not find points for armor.\n");
                        } else {
                            int n = -1;
                            try {
                                n = Integer.parseInt(string22);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (string22.equals(NA)) {
                                n = -1;
                            } else if (string22.equals(DESTROYED)) {
                                n = -3;
                            } else if (n < 0 || n > 2000) {
                                this.warning.append("Found invalid points value: ").append(string22).append(".\n");
                                return;
                            }
                            if (string23 == null || string23.equals(FRONT)) {
                                if (this.entity.getOArmor(this.loc) < n) {
                                    this.warning.append("The entity, ").append(this.entity.getShortName()).append(" does not start with ").append(n).append(" points of armor for location: ").append(this.loc).append(".\n");
                                } else {
                                    this.entity.setArmor(n, this.loc);
                                }
                            } else if (string23.equals(INTERNAL)) {
                                if (this.entity.getOInternal(this.loc) < n) {
                                    this.warning.append("The entity, ").append(this.entity.getShortName()).append(" does not start with ").append(n).append(" points of internal structure for location: ").append(this.loc).append(".\n");
                                } else {
                                    this.entity.setInternal(n, this.loc);
                                }
                            } else if (string23.equals(REAR)) {
                                if (!this.entity.hasRearArmor(this.loc)) {
                                    this.warning.append("The entity, ").append(this.entity.getShortName()).append(" has no rear armor for location: ").append(this.loc).append(".\n");
                                } else if (this.entity.getOArmor(this.loc, true) < n) {
                                    this.warning.append("The entity, ").append(this.entity.getShortName()).append(" does not start with ").append(n).append(" points of rear armor for location: ").append(this.loc).append(".\n");
                                } else {
                                    this.entity.setArmor(n, this.loc, true);
                                }
                            }
                        }
                    }
                } else if (string.equals(SI)) {
                    if (this.entity == null) {
                        this.warning.append("Found structural integrity outside of an Entity.\n");
                    } else if (!(this.entity instanceof Aero)) {
                        this.warning.append("structural integrity record found outside an Aero.\n");
                    }
                    String string24 = (String)hashtable.get(INTEGRITY);
                    try {
                        int n = Integer.parseInt(string24);
                        ((Aero)this.entity).setSI(n);
                    }
                    catch (Exception exception) {
                        this.warning.append("Invalid SI value in structural integrity tag.\n");
                    }
                } else if (string.equals(HEAT)) {
                    if (this.entity == null) {
                        this.warning.append("Found heat sink outside of an Entity.\n");
                    } else if (!(this.entity instanceof Aero)) {
                        this.warning.append("heat sink record found outside an Aero.\n");
                    }
                    String string25 = (String)hashtable.get(SINK);
                    try {
                        int n = Integer.parseInt(string25);
                        ((Aero)this.entity).setHeatSinks(n);
                    }
                    catch (Exception exception) {
                        this.warning.append("Invalid heat sink value in heat sink tag.\n");
                    }
                } else if (string.equals(FUEL)) {
                    if (this.entity == null) {
                        this.warning.append("Found fuel outside of an Entity.\n");
                    } else if (!(this.entity instanceof Aero)) {
                        this.warning.append("fuel record found outside an Aero.\n");
                    }
                    String string26 = (String)hashtable.get(LEFT);
                    try {
                        int n = Integer.parseInt(string26);
                        ((Aero)this.entity).setFuel(n);
                    }
                    catch (Exception exception) {
                        this.warning.append("Invalid fuel value in fuel tag.\n");
                    }
                } else if (string.equals(KF)) {
                    if (this.entity == null) {
                        this.warning.append("Found KF integrity outside of an Entity.\n");
                    } else if (!(this.entity instanceof Jumpship)) {
                        this.warning.append("KF integrity record found outside a Jumpship.\n");
                    }
                    String string27 = (String)hashtable.get(INTEGRITY);
                    try {
                        int n = Integer.parseInt(string27);
                        ((Jumpship)this.entity).setKFIntegrity(n);
                    }
                    catch (Exception exception) {
                        this.warning.append("Invalid KF integrity value in KF integrity tag.\n");
                    }
                } else if (string.equals(SAIL)) {
                    if (this.entity == null) {
                        this.warning.append("Found sail integrity outside of an Entity.\n");
                    } else if (!(this.entity instanceof Jumpship)) {
                        this.warning.append("sail integrity record found outside a Jumpship.\n");
                    }
                    String string28 = (String)hashtable.get(INTEGRITY);
                    try {
                        int n = Integer.parseInt(string28);
                        ((Jumpship)this.entity).setSailIntegrity(n);
                    }
                    catch (Exception exception) {
                        this.warning.append("Invalid sail integrity value in sail integrity tag.\n");
                    }
                } else if (string.equals(AEROCRIT)) {
                    if (this.entity == null) {
                        this.warning.append("Found aero crits outside of an Entity.\n");
                    } else if (!(this.entity instanceof Aero)) {
                        this.warning.append("Found aero crits outside of an Aero.\n");
                    } else {
                        String string29 = (String)hashtable.get(AVIONICS);
                        String string30 = (String)hashtable.get(SENSORS);
                        String string31 = (String)hashtable.get(ENGINE);
                        String string32 = (String)hashtable.get(FCS);
                        String string33 = (String)hashtable.get(CIC);
                        String string34 = (String)hashtable.get(LEFT_THRUST);
                        String string35 = (String)hashtable.get(RIGHT_THRUST);
                        String string36 = (String)hashtable.get(LIFE_SUPPORT);
                        String string37 = (String)hashtable.get(GEAR);
                        Aero aero = (Aero)this.entity;
                        if (string29 != null) {
                            aero.setAvionicsHits(Integer.parseInt(string29));
                        }
                        if (string30 != null) {
                            aero.setSensorHits(Integer.parseInt(string30));
                        }
                        if (string31 != null) {
                            aero.setEngineHits(Integer.parseInt(string31));
                        }
                        if (string32 != null) {
                            aero.setFCSHits(Integer.parseInt(string32));
                        }
                        if (string33 != null) {
                            aero.setCICHits(Integer.parseInt(string33));
                        }
                        if (string34 != null) {
                            aero.setLeftThrustHits(Integer.parseInt(string34));
                        }
                        if (string35 != null) {
                            aero.setRightThrustHits(Integer.parseInt(string35));
                        }
                        if (string36 != null) {
                            aero.setLifeSupport(false);
                        }
                        if (string37 != null) {
                            aero.setGearHit(true);
                        }
                    }
                } else if (string.equals(SLOT)) {
                    if (this.entity == null) {
                        this.warning.append("Found a slot outside of an Entity.\n");
                    } else if (this.loc == -1) {
                        this.warning.append("Found a slot while outside of a location.\n");
                    } else {
                        String string38 = (String)hashtable.get(INDEX);
                        String string39 = (String)hashtable.get(TYPE);
                        String string40 = (String)hashtable.get(SHOTS);
                        String string41 = (String)hashtable.get(IS_HIT);
                        String string42 = (String)hashtable.get(IS_DESTROYED);
                        String string43 = (String)hashtable.get(MUNITION);
                        if (string38 == null || string38.length() == 0) {
                            this.warning.append("Could not find index for slot.\n");
                        } else if (string39 == null || string39.length() == 0) {
                            this.warning.append("Could not find type for slot.\n");
                        } else {
                            int n = -1;
                            try {
                                n = Integer.parseInt(string38);
                                --n;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (string38.equals(NA)) {
                                n = -1;
                                if (this.entity instanceof Tank || this.entity instanceof Protomech) {
                                    EquipmentType equipmentType = EquipmentType.get(string39);
                                    if (equipmentType instanceof AmmoType) {
                                        int n9 = -1;
                                        Iterator<Mounted> iterator = this.entity.getAmmo().iterator();
                                        while (iterator.hasNext() && n9 < this.locAmmoCount) {
                                            Mounted mounted = iterator.next();
                                            if (mounted.getLocation() != this.loc || ++n9 != this.locAmmoCount) continue;
                                            ++this.locAmmoCount;
                                            mounted.restore();
                                            int n10 = -1;
                                            try {
                                                n10 = Integer.parseInt(string40);
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                // empty catch block
                                            }
                                            if (string40.equals(NA)) {
                                                n10 = -1;
                                                this.warning.append("Expected to find number of shots for ").append(string39).append(", but found ").append(string40).append(" instead.\n");
                                            } else if (n10 < 0 || n10 > 200) {
                                                this.warning.append("Found invalid shots value for slot: ").append(string40).append(".\n");
                                            } else {
                                                mounted.changeAmmoType((AmmoType)equipmentType);
                                                mounted.setShotsLeft(n10);
                                            }
                                            break;
                                        }
                                    } else {
                                        this.warning.append("XML file lists ").append(string39).append(" equipment at location ").append(this.loc).append(".  XML parser expected ammo.\n");
                                    }
                                }
                                return;
                            }
                            if (n < 0 || n > 12) {
                                this.warning.append("Found invalid index value for slot: ").append(string38).append(".\n");
                                return;
                            }
                            if (n > this.entity.getNumberOfCriticals(this.loc)) {
                                this.warning.append("The entity, ").append(this.entity.getShortName()).append(" does not have ").append(string38).append(" slots in location ").append(this.loc).append(".\n");
                                return;
                            }
                            boolean bl = false;
                            try {
                                if (string41 != null) {
                                    bl = string41.equals("true");
                                }
                            }
                            catch (Throwable throwable) {
                                this.warning.append("Found invalid isHit value: ").append(string41).append(".\n");
                            }
                            boolean bl2 = false;
                            try {
                                if (string42 != null) {
                                    bl2 = string42.equals("true");
                                }
                            }
                            catch (Throwable throwable) {
                                this.warning.append("Found invalid isDestroyed value: ").append(string42).append(".\n");
                            }
                            CriticalSlot criticalSlot = this.entity.getCritical(this.loc, n);
                            if (criticalSlot == null) {
                                if (!string39.equals(EMPTY)) {
                                    this.warning.append("Could not find the ").append(string39).append(" equipment that was expected at index ").append(n).append(" of location ").append(this.loc).append(".\n");
                                }
                                return;
                            }
                            if (criticalSlot.getType() == 0) {
                                if (!string39.equals(SYSTEM)) {
                                    this.warning.append("XML file expects to find ").append(string39).append(" equipment at index ").append(n).append(" of location ").append(this.loc).append(", but Entity has a system.\n");
                                }
                            } else {
                                EquipmentType equipmentType;
                                Mounted mounted = this.entity.getEquipment(criticalSlot.getIndex());
                                mounted.restore();
                                mounted.setDestroyed(bl || bl2);
                                if (mounted.getType() instanceof AmmoType) {
                                    equipmentType = EquipmentType.get(string39);
                                    if (equipmentType instanceof AmmoType) {
                                        int n11 = -1;
                                        try {
                                            n11 = Integer.parseInt(string40);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        if (string40.equals(NA)) {
                                            n11 = -1;
                                            this.warning.append("Expected to find number of shots for ").append(string39).append(", but found ").append(string40).append(" instead.\n");
                                        } else if (n11 < 0 || n11 > 200) {
                                            this.warning.append("Found invalid shots value for slot: ").append(string40).append(".\n");
                                        } else {
                                            mounted.changeAmmoType((AmmoType)equipmentType);
                                            mounted.setShotsLeft(n11);
                                        }
                                    } else {
                                        this.warning.append("XML file expects ").append(string39).append(" equipment at index ").append(n).append(" of location ").append(this.loc).append(", but Entity has ").append(mounted.getType().getInternalName()).append("there .\n");
                                    }
                                } else if (!mounted.getType().getInternalName().equals(string39)) {
                                    this.warning.append("XML file expects ").append(string39).append(" equipment at index ").append(n).append(" of location ").append(this.loc).append(", but Entity has ").append(mounted.getType().getInternalName()).append("there .\n");
                                }
                                if (string43 != null) {
                                    equipmentType = EquipmentType.get(string43);
                                    if (equipmentType instanceof AmmoType) {
                                        mounted.getLinked().changeAmmoType((AmmoType)equipmentType);
                                    } else {
                                        this.warning.append("XML file expects ").append(" ammo for munition argument of ").append(" slot tag.\n");
                                    }
                                }
                            }
                            criticalSlot.setHit(bl);
                            criticalSlot.setDestroyed(bl2);
                        }
                    }
                }
            }
        }
    }

    public void recordElementEnd(String string) throws ParseException {
        if (string.equals(UNIT)) {
            if (this.entity != null) {
                this.warning.append("End of unit while parsing an Entity.\n");
                if (this.loc != -1) {
                    this.warning.append("Found end of unit while parsing a location.\n");
                    if (this.locDestroyed) {
                        this.destroyLocation(this.entity, this.loc);
                    }
                    this.loc = -1;
                }
                this.entities.addElement(this.entity);
                this.entity = null;
            } else if (this.entities.isEmpty()) {
                this.warning.append("Found an empty unit.\n");
            }
        } else if (!string.equals(TEMPLATE)) {
            if (string.equals(ENTITY)) {
                if (this.entity == null) {
                    this.warning.append("Found end of Entity, but not parsing an Entity.\n");
                } else {
                    if (this.loc != -1) {
                        this.warning.append("Found end of Entity while parsing a location.\n");
                        if (this.locDestroyed) {
                            this.destroyLocation(this.entity, this.loc);
                        }
                        this.loc = -1;
                    }
                    this.entities.addElement(this.entity);
                    this.entity = null;
                }
            } else if (!string.equals(FLUFF) && !string.equals(PILOT)) {
                if (string.equals(LOCATION)) {
                    if (this.entity == null) {
                        this.warning.append("Found end of location, but not parsing an Entity.\n");
                    } else if (this.loc == -1) {
                        this.warning.append("Found end of location, but not parsing a location.\n");
                    } else {
                        if (this.locDestroyed) {
                            this.destroyLocation(this.entity, this.loc);
                        }
                        this.loc = -1;
                    }
                } else if (string.equals(ARMOR) || string.equals(SLOT)) {
                    // empty if block
                }
            }
        }
    }

    public void recordPI(String string, String string2) {
    }

    public void recordCharData(String string) {
    }

    public void recordComment(String string) {
    }

    public InputStream getDocumentStream() throws ParseException {
        if (this.inStream == null) {
            throw new ParseException("Input document stream not defined.");
        }
        return this.inStream;
    }

    public InputStream resolveExternalEntity(String string, String string2, String string3) throws ParseException {
        return null;
    }

    public InputStream resolveDTDEntity(String string, String string2, String string3) throws ParseException {
        return null;
    }
}

