/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.BipedMech;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Dropship;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.GunEmplacement;
import megamek.common.HexTarget;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.LandAirMech;
import megamek.common.LosEffects;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.MinefieldTarget;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.PlanetaryConditions;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.RangeType;
import megamek.common.RoundUpdated;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.VTOL;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.EntityAction;
import megamek.common.weapons.GaussWeapon;
import megamek.common.weapons.ISBombastLaser;
import megamek.common.weapons.ISHGaussRifle;
import megamek.common.weapons.MekMortarWeapon;
import megamek.common.weapons.ScreenLauncherBayWeapon;
import megamek.common.weapons.VariableSpeedPulseLaserWeapon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaponAttackAction
extends AbstractAttackAction
implements Serializable {
    private static final long serialVersionUID = -9096603813317359351L;
    private int weaponId;
    private int ammoId = -1;
    private int aimedLocation = -1;
    private int aimMode = 0;
    private int otherAttackInfo = -1;
    private boolean nemesisConfused;
    private boolean swarmingMissiles;
    private int oldTargetId = -1;
    private int swarmMissiles = 0;
    private int[] bombPayload = new int[15];
    private transient ArrayList<Mounted> vCounterEquipment;

    public WeaponAttackAction(int n, int n2, int n3) {
        super(n, n2);
        this.weaponId = n3;
    }

    public WeaponAttackAction(int n, int n2, int n3, int n4) {
        super(n, n2, n3);
        this.weaponId = n4;
    }

    public int getWeaponId() {
        return this.weaponId;
    }

    public int getAmmoId() {
        return this.ammoId;
    }

    public int getAimedLocation() {
        return this.aimedLocation;
    }

    public int getAimingMode() {
        return this.aimMode;
    }

    public ArrayList<Mounted> getCounterEquipment() {
        return this.vCounterEquipment;
    }

    public void setWeaponId(int n) {
        this.weaponId = n;
    }

    public void setAmmoId(int n) {
        this.ammoId = n;
    }

    public void setAimedLocation(int n) {
        this.aimedLocation = n;
    }

    public void setAimingMode(int n) {
        this.aimMode = n;
    }

    public void addCounterEquipment(Mounted mounted) {
        if (this.vCounterEquipment == null) {
            this.vCounterEquipment = new ArrayList();
        }
        this.vCounterEquipment.add(mounted);
    }

    public void setOtherAttackInfo(int n) {
        this.otherAttackInfo = n;
    }

    public int getOtherAttackInfo() {
        return this.otherAttackInfo;
    }

    public ToHitData toHit(IGame iGame) {
        return WeaponAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this.getWeaponId(), this.getAimedLocation(), this.getAimingMode(), this.nemesisConfused, this.swarmingMissiles, iGame.getEntity(this.oldTargetId));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2) {
        return WeaponAttackAction.toHit(iGame, n, targetable, n2, -1, 0, false, false, null);
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2, int n3, int n4) {
        return WeaponAttackAction.toHit(iGame, n, targetable, n2, n3, n4, false, false, null);
    }

    private static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2, int n3, int n4, boolean bl, boolean bl2, Entity entity) {
        int n5;
        LandAirMech landAirMech;
        LandAirMech landAirMech2;
        int n6;
        int n7;
        Object object;
        Object object2;
        int n8;
        int n9;
        Object object3;
        ToHitData toHitData;
        LosEffects losEffects;
        boolean bl3;
        Targetable targetable2;
        Entity entity2 = iGame.getEntity(n);
        Mounted mounted = entity2.getEquipment(n2);
        WeaponType weaponType = (WeaponType)mounted.getType();
        if (bl2) {
            if (RangeType.rangeBracket(entity2.getPosition().distance(targetable.getPosition()), weaponType.getRanges(mounted), iGame.getOptions().booleanOption("tacops_range")) == Integer.MAX_VALUE) {
                return new ToHitData(0x7FFFFFFE, "swarm target out of range");
            }
            targetable2 = targetable;
            targetable = entity;
            entity = targetable2;
        }
        targetable2 = null;
        if (targetable.getTargetType() == 0) {
            targetable2 = (Entity)targetable;
        }
        boolean bl4 = entity2 instanceof Infantry;
        boolean bl5 = weaponType.hasFlag(2048L);
        boolean bl6 = weaponType.getAmmoType() != -1 && !bl5;
        Mounted mounted2 = bl6 ? mounted.getLinked() : null;
        AmmoType ammoType = mounted2 == null ? null : (AmmoType)mounted2.getType();
        boolean bl7 = Compute.isInBuilding(iGame, (Entity)targetable2);
        boolean bl8 = weaponType.hasModes() && mounted.curMode().equals("Indirect");
        boolean bl9 = ammoType != null && (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 45) && ammoType.getMunitionType() == 0x20000000L || bl5 && weaponType.hasFlag(1024L);
        boolean bl10 = weaponType.hasFlag(32768L) && iGame.getPhase() == IGame.Phase.PHASE_FIRING;
        boolean bl11 = weaponType.hasFlag(32768L) && (iGame.getPhase() == IGame.Phase.PHASE_TARGETING || iGame.getPhase() == IGame.Phase.PHASE_OFFBOARD);
        boolean bl12 = bl10 && targetable.getTargetType() == 0 && ((Entity)targetable2).getMovementMode() == 6 && ((Entity)targetable2).getElevation() > 0 && bl6 && ammoType.getMunitionType() == 0L;
        boolean bl13 = entity2.isINarcedWith(4L);
        boolean bl14 = false;
        boolean bl15 = Compute.isAffectedByECM(entity2, entity2.getPosition(), targetable.getPosition());
        boolean bl16 = Compute.isAffectedByECM(entity2, targetable.getPosition(), targetable.getPosition());
        boolean bl17 = weaponType.hasFlag(0x4000000L);
        boolean bl18 = false;
        boolean bl19 = ammoType != null && (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 45 || ammoType.getAmmoType() == 7) && ammoType.getMunitionType() == 32768L;
        boolean bl20 = ammoType != null && (ammoType.getAmmoType() == 45 || ammoType.getAmmoType() == 7) && ammoType.getMunitionType() == 0x8000000L;
        Mounted mounted3 = mounted.getLinkedBy();
        boolean bl21 = mounted3 != null && mounted3.getType() instanceof MiscType && !mounted3.isDestroyed() && !mounted3.isMissing() && !mounted3.isBreached() && mounted3.getType().hasFlag(0x1000000000000L) && ammoType.getAmmoType() == 12;
        boolean bl22 = bl3 = targetable2 != null && iGame.getBoard().getBuildingAt(entity2.getPosition()) != null && iGame.getBoard().getBuildingAt(entity2.getPosition()).equals(iGame.getBoard().getBuildingAt(((Entity)targetable2).getPosition()));
        if (targetable2 != null && !bl16 && ((Entity)targetable2).isINarcedBy(entity2.getOwner().getTeam()) && ammoType != null && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45 || ammoType.getAmmoType() == 9) && ammoType.getMunitionType() == 4096L) {
            bl14 = true;
        }
        int n10 = 0;
        int n11 = targetable.getTargetType();
        ToHitData toHitData2 = null;
        String string = null;
        string = WeaponAttackAction.toHitIsImpossible(iGame, entity2, targetable, mounted, ammoType, weaponType, n11, bl2, bl6, (Entity)targetable2, bl17, bl9, bl4, bl8, n, n2, bl11, mounted2, bl12, bl7, bl10, bl16);
        if (string != null) {
            return new ToHitData(Integer.MAX_VALUE, string);
        }
        if (weaponType.hasFlag(0x10000000000L)) {
            toHitData2 = Compute.getSpaceBombBaseToHit(entity2, (Entity)targetable2, iGame);
            return toHitData2;
        }
        if (weaponType.hasFlag(0x1000000000L) && targetable instanceof Infantry && targetable.getPosition().equals(entity2.getPosition())) {
            return new ToHitData(Integer.MIN_VALUE, "B-Pod firing at infantry");
        }
        long l = 0L;
        if (ammoType != null) {
            l = ammoType.getMunitionType();
        }
        if (l == 0x2000000000L) {
            bl18 = true;
        }
        int n12 = targetable2 == null ? iGame.getBoard().getHex(targetable.getPosition()).floor() : ((Entity)targetable2).absHeight();
        Targetable targetable3 = null;
        boolean bl23 = false;
        if (bl8) {
            if (targetable instanceof Entity && !bl16 && targetable2 != null && ammoType != null && bl6 && ammoType.getMunitionType() == 4096L && (((Entity)targetable2).isNarcedBy(entity2.getOwner().getTeam()) || ((Entity)targetable2).isINarcedBy(entity2.getOwner().getTeam()))) {
                targetable3 = targetable2;
                bl23 = true;
            } else {
                targetable3 = Compute.findSpotter(iGame, entity2, targetable);
            }
        }
        int n13 = 0;
        boolean bl24 = false;
        if (bl6 && weaponType.getAmmoType() == 7 && ammoType != null && ammoType.getMunitionType() == 0x10000000L && entity2.getElevation() == -1 && entity2.getLocationStatus(mounted.getLocation()) == 2) {
            bl24 = true;
            entity2.setElevation(0);
        }
        if (!bl8 || bl8 && targetable3 == null) {
            losEffects = LosEffects.calculateLos(iGame, n, targetable);
            if (entity2.hasActiveEiCockpit()) {
                n13 = losEffects.getLightWoods() > 0 ? 2 : 1;
            }
            if (weaponType instanceof MekMortarWeapon && bl8) {
                losEffects.setArcedAttack(true);
            }
            toHitData = losEffects.losModifiers(iGame, n13);
            if (ammoType != null && (ammoType.getAmmoType() == 8 || ammoType.getAmmoType() == 10 || (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 12 || ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45) && l == 0x80000000L) && losEffects.getMinimumWaterDepth() < 1) {
                return new ToHitData(Integer.MAX_VALUE, "Torpedos must follow water their entire LOS");
            }
        } else {
            losEffects = LosEffects.calculateLos(iGame, ((Entity)targetable3).getId(), targetable);
            losEffects.setAttackerCover(0);
            if (!bl23 && ((Entity)targetable3).hasActiveEiCockpit()) {
                n13 = losEffects.getLightWoods() > 0 ? 2 : 1;
            }
            if (weaponType instanceof MekMortarWeapon) {
                losEffects.setArcedAttack(true);
            }
            toHitData = losEffects.losModifiers(iGame);
        }
        if (bl24) {
            entity2.setElevation(-1);
        }
        if ("LegAttack".equals(weaponType.getInternalName())) {
            toHitData2 = Compute.getLegAttackBaseToHit(entity2, (Entity)targetable2);
            if (toHitData2.getValue() == Integer.MAX_VALUE) {
                return toHitData2;
            }
            for (RoundUpdated roundUpdated : entity2.getMisc()) {
                object3 = roundUpdated.getType();
                if (!"BA-Assault Claws".equals(((EquipmentType)object3).getInternalName())) continue;
                toHitData2.addModifier(-1, "attacker has assault claws");
                break;
            }
        } else if ("SwarmMek".equals(weaponType.getInternalName())) {
            toHitData2 = Compute.getSwarmMekBaseToHit(entity2, (Entity)targetable2);
            if (toHitData2.getValue() == Integer.MAX_VALUE) {
                return toHitData2;
            }
            if (targetable2 instanceof Tank) {
                toHitData2.addModifier(-2, "target is vehicle");
            }
            for (RoundUpdated roundUpdated : entity2.getMisc()) {
                object3 = roundUpdated.getType();
                if (!"BA-Assault Claws".equals(((EquipmentType)object3).getInternalName())) continue;
                toHitData2.addModifier(-1, "attacker has assault claws");
                break;
            }
            for (RoundUpdated roundUpdated : ((Entity)targetable2).getExternalUnits()) {
                if (!(roundUpdated instanceof BattleArmor)) continue;
                object3 = (BattleArmor)roundUpdated;
                n9 = ((BattleArmor)object3).getShootingStrength();
                int n14 = ((Infantry)entity2).getShootingStrength();
                if (!(entity2 instanceof BattleArmor)) {
                    n14 = n14 >= 28 ? 5 : (n14 >= 24 ? 4 : (n14 >= 21 ? 3 : (n14 >= 18 ? 2 : 1)));
                }
                if ((n9 = n9 + 2 - n14) <= 0) continue;
                toHitData2.addModifier(n9, "Defending mechanized BA");
            }
        } else {
            if ("StopSwarm".equals(weaponType.getInternalName())) {
                return new ToHitData(Integer.MIN_VALUE, "End swarm attack.");
            }
            if ("BAMineLauncher".equals(weaponType.getInternalName())) {
                toHitData2 = new ToHitData(8, "magnetic mine attack");
            } else {
                if (ammoType != null && ammoType.getAmmoType() == 25) {
                    return new ToHitData(entity2.getCrew().getPiloting(), "anti-mech skill");
                }
                if (targetable2 != null && entity2.getSwarmTargetId() == ((Entity)targetable2).getId()) {
                    int n15;
                    int n16 = n15 = targetable2 instanceof Tank ? 4 : 0;
                    if (entity2 instanceof BattleArmor) {
                        return new ToHitData(Integer.MIN_VALUE, "Attack during swarm.", 3, n15);
                    }
                    return new ToHitData(Integer.MIN_VALUE, "Attack during swarm.", 7, n15);
                }
                if (bl12) {
                    toHitData2 = new ToHitData(9, "artillery FLAK");
                } else {
                    toHitData2 = new ToHitData(entity2.crew.getGunnery(), "gunnery skill");
                    if (iGame.getOptions().booleanOption("rpg_gunnery")) {
                        if (weaponType.hasFlag(131072L)) {
                            toHitData2 = new ToHitData(entity2.crew.getGunneryL(), "gunnery (L) skill");
                        }
                        if (weaponType.hasFlag(262144L)) {
                            toHitData2 = new ToHitData(entity2.crew.getGunneryM(), "gunnery (M) skill");
                        }
                        if (weaponType.hasFlag(65536L)) {
                            toHitData2 = new ToHitData(entity2.crew.getGunneryB(), "gunnery (B) skill");
                        }
                    }
                    if (entity2.getTaserFeedBackRounds() > 0) {
                        toHitData2.addModifier(1, "Taser feedback");
                    }
                }
            }
        }
        if (weaponType.hasFlag(0x20000000L)) {
            toHitData2 = new ToHitData(8, "fire extinguisher");
            if (targetable instanceof Entity && ((Entity)targetable).infernos.isStillBurning() || targetable instanceof Tank && ((Tank)targetable).isInfernoFire()) {
                toHitData2.addModifier(2, "inferno fire");
            }
            if (8 == targetable.getTargetType() && iGame.getBoard().isInfernoBurning(targetable.getPosition())) {
                toHitData2.addModifier(2, "inferno fire");
            }
            return toHitData2;
        }
        if (entity2.isSpotting()) {
            toHitData2.addModifier(1, "attacker is spotting for indirect LRM fire");
        }
        if (iGame.getOptions().booleanOption("tacops_fatigue") && entity2.crew.isGunneryFatigued(iGame.getRoundCount())) {
            toHitData2.addModifier(1, "fatigue");
        }
        if (entity2.isSufferingEMI()) {
            toHitData2.addModifier(2, "electromagnetic interference");
        }
        if (targetable.getTargetType() == 0 && ((Entity)targetable2).isEvading()) {
            toHitData2.addModifier(((Entity)targetable2).getEvasionBonus(), "target is evading");
        }
        if (iGame.getOptions().booleanOption("tacops_ghost_target") && (n8 = Compute.getGhostTargetNumber(entity2, entity2.getPosition(), targetable.getPosition())) > -1 && (!(entity2 instanceof Infantry) || entity2 instanceof BattleArmor)) {
            int n17 = 0;
            if (entity2.hasBAP()) {
                n17 = 1;
            }
            int n18 = 0;
            if (entity2.hasTargComp() && weaponType.hasFlag(1L) && (!bl6 || ammoType.getAmmoType() != 19 && ammoType.getAmmoType() != 32 || ammoType.getMunitionType() != 1L)) {
                n18 = 2;
            }
            if ((n9 = entity2.getCrew().getSensorOps() + n8 - (entity2.getGhostTargetOverride() + n17 + n18)) > 0) {
                toHitData2.addModifier(Math.min(4, n9 / 2), "ghost targets");
            }
        }
        if (iGame.getBoard().inSpace() && iGame.getOptions().booleanOption("stratops_ecm")) {
            int n19 = Compute.getLargeCraftECM(entity2, entity2.getPosition(), targetable.getPosition());
            if (!entity2.isLargeCraft()) {
                n19 += Compute.getSmallCraftECM(entity2, entity2.getPosition(), targetable.getPosition());
            }
            n19 = Math.min(4, n19);
            int n20 = 0;
            if (entity2.isLargeCraft()) {
                n20 = ((Aero)entity2).getECCMBonus();
            }
            if (n19 > 0) {
                toHitData2.addModifier(n19, "ECM");
                if (n20 > 0) {
                    toHitData2.addModifier(-1 * Math.min(n19, n20), "ECCM");
                }
            }
        }
        if (entity2 instanceof Aero) {
            Jumpship jumpship;
            int n212;
            int n22;
            Aero aero = (Aero)entity2;
            int n23 = aero.getSensorHits();
            if (!aero.isCapitalFighter()) {
                if (n23 > 0 && n23 < 3) {
                    toHitData2.addModifier(n23, "sensor damage");
                }
                if (n23 > 2) {
                    toHitData2.addModifier(5, "sensors destroyed");
                }
            }
            if ((n22 = aero.getFCSHits()) > 0 && !aero.isCapitalFighter()) {
                toHitData2.addModifier(n22 * 2, "fcs damage");
            }
            if ((n9 = aero.getCrew().getHits()) > 0 && !aero.isCapitalFighter()) {
                toHitData2.addModifier(n9, "pilot hits");
            }
            if (aero.isOutControlTotal()) {
                toHitData2.addModifier(2, "out-of-control");
            }
            if (aero instanceof Jumpship && (n212 = (jumpship = (Jumpship)aero).getCICHits()) > 0) {
                toHitData2.addModifier(n212 * 2, "CIC damage");
            }
            if (aero.isEvading()) {
                toHitData2.addModifier(2, "attacker is evading");
            }
            if (mounted.getType() instanceof ISHGaussRifle && entity2 instanceof Aero && !(entity2 instanceof Dropship) && !(entity2 instanceof Jumpship)) {
                toHitData2.addModifier(1, "weapon to-hit modifier");
            }
            if (iGame.getBoard().inAtmosphere() && 1 == entity2.getElevation() - iGame.getBoard().getHex(entity2.getPosition()).ceiling()) {
                if (entity2.isOmni()) {
                    toHitData2.addModifier(1, "attacker is flying at NOE (omni)");
                } else {
                    toHitData2.addModifier(2, "attacker is flying at NOE");
                }
            }
            if (entity2.usesWeaponBays()) {
                Mounted mounted4;
                if (weaponType.getAtClass() == 1) {
                    for (int n212 : mounted.getBayWeapons()) {
                        Mounted mounted5 = entity2.getEquipment(n212);
                        object2 = (WeaponType)mounted5.getType();
                        if (((EquipmentType)object2).getInternalName().indexOf("Heavy") == -1 || ((EquipmentType)object2).getInternalName().indexOf("Laser") == -1) continue;
                        toHitData2.addModifier(1, "bay contains heavy laser");
                        break;
                    }
                } else if (weaponType.getAtClass() == 19) {
                    boolean bl25 = true;
                    n212 = 1;
                    for (int n24 : mounted.getBayWeapons()) {
                        mounted4 = entity2.getEquipment(n24);
                        object = mounted4.getLinked();
                        if (object == null) continue;
                        AmmoType ammoType2 = (AmmoType)((Mounted)object).getType();
                        if (ammoType2.getAmmoType() != 59) {
                            bl25 = false;
                        }
                        if (ammoType2.getAmmoType() == 74 || ammoType2.getAmmoType() == 59) continue;
                        n212 = 0;
                    }
                    if (bl25) {
                        toHitData2.addModifier(-2, "barracuda missile");
                    } else if (n212 != 0) {
                        toHitData2.addModifier(-1, "piranha missile");
                    }
                } else if (weaponType.getAtClass() == 20) {
                    boolean bl26 = true;
                    for (int n25 : mounted.getBayWeapons()) {
                        Mounted mounted6 = entity2.getEquipment(n25);
                        mounted4 = mounted6.getLinked();
                        if (mounted4 == null || ((EquipmentType)(object = (AmmoType)mounted4.getType())).hasFlag(256L)) continue;
                        bl26 = false;
                    }
                    if (bl26) {
                        toHitData2.addModifier(-2, "barracuda missile");
                    }
                } else if (weaponType.getAtClass() == 8) {
                    boolean bl27 = true;
                    for (int n26 : mounted.getBayWeapons()) {
                        Mounted mounted7 = entity2.getEquipment(n26);
                        mounted4 = mounted7.getLinked();
                        if (mounted4 == null || ((AmmoType)(object = (AmmoType)mounted4.getType())).getMunitionType() == 1L) continue;
                        bl27 = false;
                        break;
                    }
                    if (bl27) {
                        toHitData2.addModifier(-1, "cluster ammo");
                    }
                }
            }
        }
        if (weaponType.hasFlag(0x8000000000L) && targetable instanceof Entity && ((Entity)targetable2).getWeight() < 500.0f) {
            toHitData2.addModifier(4, "Anti-ship missile at a small target");
        }
        if (targetable instanceof Aero) {
            Aero aero = (Aero)targetable;
            if (aero.getCurrentVelocity() == 0) {
                toHitData2.addModifier(-2, "target is not moving");
            }
            if (weaponType.isCapital() && weaponType.getAtClass() != 19 && weaponType.getAtClass() != 20 && !((Entity)targetable2).isLargeCraft()) {
                int n27 = 0;
                if (weaponType.hasModes() && mounted.curMode().equals("AAA")) {
                    n27 = 2;
                }
                if (weaponType.isSubCapital()) {
                    toHitData2.addModifier(3 - n27, "sub-capital weapon at small target");
                } else {
                    toHitData2.addModifier(5 - n27, "capital weapon at small target");
                }
            }
            if (weaponType.hasModes() && mounted.curMode().equals("AAA") && ((Entity)targetable2).isLargeCraft()) {
                toHitData2.addModifier(1, "AAA mode at large craft");
            }
            if (weaponType.hasModes() && mounted.curMode().equals("Bracket 80%")) {
                toHitData2.addModifier(-1, "Bracketing 80%");
            }
            if (weaponType.hasModes() && mounted.curMode().equals("Bracket 60%")) {
                toHitData2.addModifier(-2, "Bracketing 60%");
            }
            if (weaponType.hasModes() && mounted.curMode().equals("Bracket 40%")) {
                toHitData2.addModifier(-3, "Bracketing 40%");
            }
            if (iGame.getOptions().booleanOption("stratops_sensor_shadow") && iGame.getBoard().inSpace()) {
                for (Entity entity3 : Compute.getAdjacentEntitiesAlongAttack(entity2.getPosition(), targetable.getPosition(), iGame)) {
                    if (entity3.isEnemyOf(aero) || !entity3.isLargeCraft() || !((double)(entity3.getWeight() - aero.getWeight()) >= -100000.0)) continue;
                    toHitData2.addModifier(1, "Sensor Shadow");
                    break;
                }
                Enumeration<Entity> enumeration = iGame.getEntities(targetable.getPosition());
                while (enumeration.hasMoreElements()) {
                    Entity entity4 = (Entity)enumeration.nextElement();
                    if (entity4.isEnemyOf(aero) || !entity4.isLargeCraft() || entity4.equals(aero) || !((double)(entity4.getWeight() - aero.getWeight()) >= -100000.0)) continue;
                    toHitData2.addModifier(1, "Sensor Shadow");
                    break;
                }
            }
        }
        if (entity2 instanceof Tank) {
            int n28;
            Tank tank = (Tank)entity2;
            if (tank.isCommanderHit()) {
                if (entity2 instanceof VTOL) {
                    toHitData2.addModifier(1, "copilot injured");
                } else {
                    toHitData2.addModifier(1, "commander injured");
                }
            }
            if ((n28 = tank.getSensorHits()) > 0) {
                toHitData2.addModifier(n28, "sensor damage");
            }
            if (tank.isStabiliserHit(mounted.getLocation())) {
                toHitData2.addModifier(Compute.getAttackerMovementModifier(iGame, tank.getId()).getValue(), "stabiliser damage");
            }
        }
        if (entity2.hasFunctionalArmAES(mounted.getLocation()) && !mounted.isSplit()) {
            toHitData2.addModifier(-1, "AES modifer");
        }
        if (entity2.hasShield()) {
            if (entity2.hasPassiveShield(mounted.getLocation(), mounted.isRearMounted())) {
                toHitData2.addModifier(2, "weapon hampered by passive shield");
            } else if (entity2.hasNoDefenseShield(mounted.getLocation())) {
                toHitData2.addModifier(1, "weapon hampered by shield");
            }
        }
        if (iGame.getOptions().booleanOption("tacops_bap") && !bl8 && targetable2 != null && entity2.hasBAP() && entity2.getBAPRange() >= Compute.effectiveDistance(iGame, entity2, targetable2) && !Compute.isAffectedByECM(entity2, entity2.getPosition(), ((Entity)targetable2).getPosition()) && (iGame.getBoard().getHex(((Entity)targetable2).getPosition()).containsTerrain(1) || iGame.getBoard().getHex(((Entity)targetable2).getPosition()).containsTerrain(5) || losEffects.getLightWoods() > 0 || losEffects.getHeavyWoods() > 0 || losEffects.getUltraWoods() > 0)) {
            toHitData2.addModifier(-1, "target in/behind woods and attacker has BAP");
        }
        if (entity2.crew.getOptions().stringOption("weapon_specialist").equals(weaponType.getName())) {
            toHitData2.addModifier(-2, "weapon specialist");
        }
        if (entity2.crew.getOptions().booleanOption("gunnery_laser") && weaponType.hasFlag(131072L)) {
            toHitData2.addModifier(-1, "Gunnery/Laser");
        }
        if (entity2.crew.getOptions().booleanOption("gunnery_ballistic") && weaponType.hasFlag(65536L)) {
            toHitData2.addModifier(-1, "Gunnery/Ballistic");
        }
        if (entity2.crew.getOptions().booleanOption("gunnery_missile") && weaponType.hasFlag(262144L)) {
            toHitData2.addModifier(-1, "Gunnery/Missile");
        }
        if (entity2.crew.getOptions().booleanOption("vdni") || entity2.crew.getOptions().booleanOption("bvdni")) {
            toHitData2.addModifier(-1, "VDNI");
        }
        if (entity2 instanceof Mech && ((Mech)entity2).getCockpitType() == 1 && (n7 = entity2.getBadCriticals(0, 1, 0)) == 2) {
            toHitData2.addModifier(4, "Head Sensors Destroyed for Torso-Mounted Cockpit");
        }
        if (!(bl15 || ammoType == null || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 45 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 1024L || targetable2 != null && ((Entity)targetable2).isClan())) {
            toHitData2.addModifier(-1, "Listen-Kill ammo");
        }
        int n29 = entity2.getElevation();
        int n30 = targetable.getElevation();
        int n31 = Compute.effectiveDistance(iGame, entity2, targetable);
        toHitData2.append(AbstractAttackAction.nightModifiers(iGame, targetable, ammoType, entity2, true));
        n9 = iGame.getPlanetaryConditions().getWeatherHitPenalty(entity2);
        if (n9 != 0 && !iGame.getBoard().inSpace()) {
            toHitData2.addModifier(n9, iGame.getPlanetaryConditions().getWeatherCurrentName());
        }
        if (!iGame.getBoard().inSpace()) {
            int n32 = iGame.getPlanetaryConditions().getWindStrength();
            if (n32 == 2) {
                if (weaponType.hasFlag(262144L)) {
                    toHitData2.addModifier(1, PlanetaryConditions.getWindDisplayableName(n32));
                }
            } else if (n32 == 3) {
                if (weaponType.hasFlag(65536L)) {
                    toHitData2.addModifier(1, PlanetaryConditions.getWindDisplayableName(n32));
                } else if (weaponType.hasFlag(262144L)) {
                    toHitData2.addModifier(2, PlanetaryConditions.getWindDisplayableName(n32));
                }
            } else if (n32 == 4) {
                if (weaponType.hasFlag(65536L)) {
                    toHitData2.addModifier(2, PlanetaryConditions.getWindDisplayableName(n32));
                } else if (weaponType.hasFlag(262144L)) {
                    toHitData2.addModifier(3, PlanetaryConditions.getWindDisplayableName(n32));
                }
            } else if (n32 == 5) {
                if (weaponType.hasFlag(131072L)) {
                    toHitData2.addModifier(2, PlanetaryConditions.getWindDisplayableName(n32));
                } else {
                    toHitData2.addModifier(3, PlanetaryConditions.getWindDisplayableName(n32));
                }
            } else if (n32 == 6) {
                toHitData2.addModifier(3, PlanetaryConditions.getWindDisplayableName(n32));
            }
        }
        if (weaponType.hasFlag(131072L) && !iGame.getBoard().inSpace() && iGame.getPlanetaryConditions().getFog() == 2) {
            toHitData2.addModifier(1, "heavy fog");
        }
        if (weaponType.hasFlag(131072L) && !iGame.getBoard().inSpace() && iGame.getPlanetaryConditions().isSandBlowing() && iGame.getPlanetaryConditions().getWindStrength() > 1) {
            toHitData2.addModifier(1, "blowing sand");
        }
        if (!iGame.getBoard().inSpace() && (n6 = (int)Math.ceil(Math.abs((iGame.getPlanetaryConditions().getGravity() - 1.0f) / 0.2f))) != 0 && (weaponType.hasFlag(65536L) || weaponType.hasFlag(262144L))) {
            toHitData2.addModifier(n6, "gravity");
        }
        if (iGame.getPlanetaryConditions().hasEMI() && (!(entity2 instanceof Infantry) || entity2 instanceof BattleArmor)) {
            toHitData2.addModifier(2, "EMI");
        }
        if (entity2 instanceof LandAirMech && (landAirMech2 = (LandAirMech)entity2).isInMode(2)) {
            toHitData2.addModifier(2, "Attacker is a Flying Airmek");
        }
        if (targetable instanceof LandAirMech && (landAirMech = (LandAirMech)targetable).isInMode(2) && landAirMech.isFlying()) {
            if (entity2.isFlying()) {
                toHitData2.addModifier(-1, "Target is a flying Airmek");
            } else {
                toHitData2.addModifier(4, "Target is a flying Airmek");
            }
        }
        if (bl10) {
            if (!bl12) {
                toHitData2.addModifier(5, "direct artillery modifer");
            }
            toHitData2.append(Compute.getAttackerMovementModifier(iGame, n));
            toHitData2.append(toHitData);
            toHitData2.append(Compute.getSecondaryTargetMod(iGame, entity2, targetable));
            toHitData2.append(Compute.getDamageWeaponMods(entity2, mounted));
            if (entity2.getHeatFiringModifier() != 0) {
                toHitData2.addModifier(entity2.getHeatFiringModifier(), "heat");
            }
            if (weaponType instanceof VariableSpeedPulseLaserWeapon) {
                int n33 = entity2.getPosition().distance(targetable.getPosition());
                int[] nArray = weaponType.getRanges(mounted);
                int n34 = weaponType.getToHitModifier();
                n34 = n33 <= nArray[1] ? --n34 : (n33 <= nArray[2] ? (n34 -= 2) : (n33 <= nArray[3] ? (n34 -= 3) : 0));
                toHitData2.addModifier(n34, "weapon to-hit modifier");
            } else if (weaponType instanceof ISBombastLaser) {
                int n35 = (int)Math.ceil((Compute.dialDownDamage(mounted, weaponType) - 7) / 2);
                if (n35 > 0) {
                    toHitData2.addModifier(n35, "weapon to-hit modifier");
                }
            } else if (weaponType.getToHitModifier() != 0) {
                toHitData2.addModifier(weaponType.getToHitModifier(), "weapon to-hit modifier");
            }
            if (bl6 && ammoType.getToHitModifier() != 0) {
                toHitData2.addModifier(ammoType.getToHitModifier(), "ammunition to-hit modifier");
            }
            if (bl18) {
                return new ToHitData(4, "Homing shot");
            }
            if (iGame.getEntity(n).getOwner().getArtyAutoHitHexes().contains(targetable.getPosition()) && !bl12) {
                return new ToHitData(Integer.MIN_VALUE, "Artillery firing at designated artillery target.");
            }
            return toHitData2;
        }
        if (bl11) {
            if (bl18) {
                return new ToHitData(4, "Homing shot (will miss if TAG misses)");
            }
            if (iGame.getEntity(n).getOwner().getArtyAutoHitHexes().contains(targetable.getPosition())) {
                return new ToHitData(Integer.MIN_VALUE, "Artillery firing at designated artillery target.");
            }
            toHitData2.addModifier(7, "indirect artillery modifier");
            int n36 = entity2.aTracker.getModifier(mounted, targetable.getPosition());
            if (n36 == Integer.MIN_VALUE) {
                return new ToHitData(Integer.MIN_VALUE, "Artillery firing at target that's been hit before.");
            }
            if (n36 != 0) {
                toHitData2.addModifier(n36, "adjusted fire");
            }
            return toHitData2;
        }
        if (n31 == 1 && (targetable.getTargetType() == 3 || targetable.getTargetType() == 4 || targetable.getTargetType() == 15 || targetable.getTargetType() == 16 || targetable instanceof GunEmplacement)) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        if (null != losEffects.getThruBldg() && (targetable.getTargetType() == 3 || targetable.getTargetType() == 4 || targetable.getTargetType() == 15 || targetable.getTargetType() == 16 || targetable instanceof GunEmplacement)) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting building from inside (are you SURE this is a good idea?).");
        }
        toHitData2.append(Compute.getRangeMods(iGame, entity2, n2, targetable));
        if (entity2.getTargSysType() == 5 && targetable instanceof Entity) {
            if (targetable instanceof VTOL) {
                toHitData2.addModifier(-2, "anti-air targetting system vs. VTOL");
            } else {
                toHitData2.addModifier(1, "anti-air targetting system vs. non-aerial unit");
            }
        }
        if (!bl4 && targetable2 != null && targetable2 instanceof BattleArmor) {
            toHitData2.addModifier(1, "battle armor target");
        }
        if (targetable2 != null && targetable2 instanceof MechWarrior) {
            toHitData2.addModifier(2, "ejected MechWarrior target");
        }
        if (bl8) {
            toHitData2.addModifier(1, "indirect fire");
        }
        if (weaponType instanceof MekMortarWeapon) {
            if (bl8) {
                if (targetable3 == null) {
                    toHitData2.addModifier(2, "no spotter");
                }
            } else {
                toHitData2.addModifier(3, "direct fire");
            }
        }
        toHitData2.append(Compute.getAttackerMovementModifier(iGame, n));
        if (targetable2 != null) {
            int n37;
            ToHitData toHitData3 = Compute.getTargetMovementModifier(iGame, targetable.getTargetId());
            toHitData2.append(toHitData3);
            n10 += toHitData3.getValue();
            if (ammoType != null && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45) && ammoType.getMunitionType() == 524288L && ((Entity)targetable2).getTaggedBy() != -1) {
                int n38 = toHitData3.getValue();
                if (n38 > 0) {
                    toHitData2.append(new ToHitData(-n38, "Semi-guided ammo vs tagged target"));
                }
            } else if (ammoType != null && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 34) && ammoType.getMunitionType() == 16L && (n37 = Math.min(2, toHitData3.getValue())) > 0) {
                toHitData2.append(new ToHitData(-n37, "Precision Ammo"));
            }
        }
        if (ammoType != null && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 34) && ammoType.getMunitionType() == 2L) {
            toHitData2.addModifier(1, "Armor-Piercing Ammo");
        }
        if (bl8) {
            if (ammoType != null && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45) && ammoType.getMunitionType() == 524288L && ((Entity)targetable2).getTaggedBy() != -1) {
                toHitData2.addModifier(-1, "semiguided ignores spotter movement & indirect fire penalties");
            } else if (!bl23 && targetable3 != null) {
                toHitData2.append(Compute.getSpotterMovementModifier(iGame, ((Entity)targetable3).getId()));
                if (((Entity)targetable3).isAttackingThisTurn()) {
                    toHitData2.addModifier(1, "spotter is making an attack this turn");
                }
            }
        }
        toHitData2.append(Compute.getAttackerTerrainModifier(iGame, n));
        if (targetable.getTargetType() != 6) {
            toHitData2.append(Compute.getTargetTerrainModifier(iGame, targetable, n13, bl3));
            n10 += Compute.getTargetTerrainModifier(iGame, targetable, n13, bl3).getValue();
        }
        IHex iHex = iGame.getBoard().getHex(targetable.getPosition());
        if (targetable.getTargetType() == 0 && iHex.containsTerrain(2) && iHex.terrainLevel(2) == 1 && n12 == 0 && ((Entity)targetable2).height() > 0) {
            losEffects.setTargetCover(losEffects.getTargetCover() | 3);
            toHitData = losEffects.losModifiers(iGame, n13);
        }
        if (targetable instanceof Infantry && !weaponType.hasFlag(2L) && (iHex.containsTerrain(35) || ((Infantry)targetable).getDugIn() == 2)) {
            toHitData2.addModifier(2, "infantry dug in");
        }
        toHitData2.append(toHitData);
        if (targetable2 != null && ((Entity)targetable2).isHullDown() && (targetable2 instanceof Mech && losEffects.getTargetCover() > 0 || targetable2 instanceof Tank && iHex.containsTerrain(35) && ((Entity)targetable2).sideTable(entity2.getPosition()) == 0)) {
            toHitData2.addModifier(2, "Hull down target");
        }
        if (!bl) {
            toHitData2.append(Compute.getSecondaryTargetMod(iGame, entity2, targetable, bl2));
        }
        if (entity2.getHeatFiringModifier() != 0) {
            toHitData2.addModifier(entity2.getHeatFiringModifier(), "heat");
        }
        toHitData2.append(Compute.getDamageWeaponMods(entity2, mounted));
        ToHitData toHitData4 = Compute.getImmobileMod(targetable, n3, n4);
        if (toHitData4 != null) {
            toHitData2.append(toHitData4);
            n10 += toHitData4.getValue();
        }
        toHitData2.append(Compute.getProneMods(iGame, entity2, n2));
        object2 = null;
        if (targetable2 != null && ((Entity)targetable2).isProne()) {
            object2 = n31 <= 1 ? new ToHitData(-2, "target prone and adjacent") : new ToHitData(1, "target prone and at range");
        }
        if (object2 != null) {
            toHitData2.append((TargetRoll)object2);
            n10 += ((TargetRoll)object2).getValue();
        }
        if (weaponType instanceof VariableSpeedPulseLaserWeapon) {
            int n39 = entity2.getPosition().distance(targetable.getPosition());
            object = weaponType.getRanges(mounted);
            int n40 = weaponType.getToHitModifier();
            n40 = n39 <= object[1] ? ++n40 : (n39 <= object[2] ? (n40 += 2) : (n39 <= object[3] ? (n40 += 3) : 0));
            toHitData2.addModifier(n40, "weapon to-hit modifier");
        } else if (weaponType instanceof ISBombastLaser) {
            double d = Compute.dialDownDamage(mounted, weaponType);
            if ((d = Math.ceil((d - 7.0) / 2.0)) > 0.0) {
                toHitData2.addModifier((int)d, "weapon to-hit modifier");
            }
        } else if (weaponType.getToHitModifier() != 0) {
            toHitData2.addModifier(weaponType.getToHitModifier(), "weapon to-hit modifier");
        }
        if (!(targetable2 == null || ((Entity)targetable2).getMovementMode() != 6 && ((Entity)targetable2).getMovementMode() != 16 && ((Entity)targetable2).getMovementMode() != 19 && ((Entity)targetable2).getMovementMode() != 20 && ((Entity)targetable2).getMovementMode() != 17 && ((Entity)targetable2).getMovementMode() != 15 || ammoType == null || (ammoType.getAmmoType() != 19 && ammoType.getAmmoType() != 32 && ammoType.getAmmoType() != 47 || ammoType.getMunitionType() != 1L) && ammoType.getMunitionType() != 64L && ammoType.getAmmoType() != 44 || ((Entity)targetable2).getElevation() <= 0 || ((Entity)targetable2).getElevation() <= iGame.getBoard().getHex(((Entity)targetable2).getPosition()).terrainLevel(24) || ((Entity)targetable2).getElevation() == iGame.getBoard().getHex(((Entity)targetable2).getPosition()).terrainLevel(28))) {
            toHitData2.addModifier(-2, "flak to-hit modifier");
        }
        if (bl6 && ammoType.getToHitModifier() != 0) {
            toHitData2.addModifier(ammoType.getToHitModifier(), "ammunition to-hit modifier");
        }
        if (bl14) {
            toHitData2.addModifier(-1, "iNarc homing pod");
        }
        if (bl13) {
            toHitData2.addModifier(1, "iNarc Haywire pod");
        }
        if (toHitData2.getValue() != Integer.MAX_VALUE && (weaponType.getAmmoType() == 62 || weaponType instanceof ScreenLauncherBayWeapon)) {
            return new ToHitData(Integer.MIN_VALUE, "Screen launchers always hit");
        }
        if (bl19) {
            if (targetable2 == null) {
                IHex iHex2;
                if ((targetable.getTargetType() == 3 || targetable.getTargetType() == 4 || targetable.getTargetType() == 15 || targetable.getTargetType() == 16 || targetable instanceof GunEmplacement) && (iHex2 = iGame.getBoard().getHex(targetable.getPosition())).containsTerrain(19)) {
                    toHitData2.addModifier(-2, "ammunition to-hit modifier");
                }
            } else if (targetable2 instanceof Aero && toHitData2.getSideTable() == 1) {
                toHitData2.addModifier(-2, "ammunition to-hit modifier");
            } else if (((Entity)targetable2).heat == 0) {
                toHitData2.addModifier(1, "ammunition to-hit modifier");
            } else {
                toHitData2.addModifier(-((Entity)targetable2).getHeatMPReduction(), "ammunition to-hit modifier");
            }
            if (!(entity2 instanceof Aero) && LosEffects.hasFireBetween(entity2.getPosition(), targetable.getPosition(), iGame)) {
                toHitData2.addModifier(2, "fire between target and attacker");
            }
        }
        if (bl20) {
            toHitData2.addModifier(2, "ammunition to-hit modifier");
        }
        if (bl21) {
            toHitData2.addModifier(-1, "Apollo FCS");
        }
        if (entity2 instanceof Infantry && entity2.hasWorkingMisc(262144L, 16L)) {
            toHitData2.addModifier(1, "Heavy Armor");
        }
        if (entity2.isVoidSigActive()) {
            toHitData2.addModifier(1, "Void signature active");
        }
        if (n4 == 2 && n3 != -1) {
            if (entity2.hasActiveEiCockpit()) {
                if (entity2.hasTargComp()) {
                    toHitData2.addModifier(2, "aiming with targeting computer & EI system");
                } else {
                    toHitData2.addModifier(6, "aiming with EI system");
                }
            } else {
                toHitData2.addModifier(3, "aiming with targeting computer");
            }
        } else if (entity2.hasTargComp() && weaponType.hasFlag(1L) && (!bl6 || ammoType.getAmmoType() != 19 && ammoType.getAmmoType() != 32 || ammoType.getMunitionType() != 1L)) {
            toHitData2.addModifier(-1, "targeting computer");
        }
        if (null != losEffects.getThruBldg() && n29 != n30) {
            if (targetable instanceof Tank) {
                toHitData2.setSideTable(4);
            } else if (targetable instanceof Mech) {
                if (n29 > n30) {
                    toHitData2.setHitTable(4);
                } else {
                    toHitData2.setHitTable(5);
                }
            }
        }
        if (entity2 instanceof Aero && targetable instanceof Aero && iGame.getBoard().inAtmosphere()) {
            if (n29 - n30 > 2) {
                toHitData2.setHitTable(4);
            } else if (n30 - n29 > 2) {
                toHitData2.setHitTable(5);
            }
        }
        if (losEffects.getTargetCover() != 0) {
            if (entity2.getLocationStatus(mounted.getLocation()) == 2 && iHex.containsTerrain(2) && n12 == 0 && ((Entity)targetable2).height() > 0) {
                toHitData2.setHitTable(6);
                toHitData2.setCover(12);
            } else if (iGame.getOptions().booleanOption("tacops_partial_cover")) {
                toHitData2.setHitTable(6);
                toHitData2.setCover(losEffects.getTargetCover());
            } else {
                toHitData2.setHitTable(6);
                toHitData2.setCover(3);
            }
        }
        if (bl4 && 0 == n31) {
            toHitData2.setSideTable(0);
        } else {
            toHitData2.setSideTable(Compute.targetSideTable(entity2, targetable));
        }
        if (targetable instanceof Aero) {
            if (((Aero)targetable).isSpheroid() && iGame.getBoard().inAtmosphere()) {
                if (toHitData2.getHitTable() == 4) {
                    toHitData2.setSideTable(0);
                    toHitData2.setHitTable(0);
                }
                if (toHitData2.getHitTable() == 5) {
                    toHitData2.setSideTable(1);
                    toHitData2.setHitTable(0);
                }
            } else {
                int n41 = toHitData2.getSideTable();
                if (targetable instanceof Aero && iGame.useVectorMove()) {
                    boolean bl28 = false;
                    Coords coords = entity2.getPosition();
                    if (iGame.getBoard().inSpace() && entity2.getPosition().equals(targetable.getPosition())) {
                        if (((Aero)entity2).shouldMoveBackHex((Aero)targetable)) {
                            coords = entity2.getPriorPosition();
                        }
                        bl28 = ((Aero)targetable).shouldMoveBackHex((Aero)entity2);
                    }
                    n41 = ((Entity)targetable).chooseSide(coords, bl28);
                }
                if (n41 == 0) {
                    toHitData2.addModifier(1, "attack against nose");
                }
                if (n41 == 2 || n41 == 3) {
                    toHitData2.addModifier(2, "attack against side");
                }
            }
        }
        if (targetable instanceof Entity && (n5 = ((Entity)targetable).getGrappled()) != -1) {
            if (n5 == entity2.getId() && ((Entity)targetable).getGrappleSide() == 0) {
                toHitData2.addModifier(-4, "target grappled");
            } else if (n5 == entity2.getId() && ((Entity)targetable).getGrappleSide() != 0) {
                toHitData2.addModifier(-2, "target grappled (Chain Whip)");
            } else if (!bl2) {
                toHitData2.addModifier(1, "CQC, possible friendly fire");
            } else {
                toHitData2.addModifier(-1, "friendly fire");
                return toHitData2;
            }
        }
        if (bl2) {
            toHitData2.addModifier(-n10, "original target mods");
            toHitData2.append(Compute.getImmobileMod(entity, n3, n4));
            toHitData2.append(Compute.getTargetMovementModifier(iGame, entity.getId()));
            toHitData2.append(Compute.getTargetTerrainModifier(iGame, iGame.getEntity(entity.getId()), n13, bl3));
            n31 = Compute.effectiveDistance(iGame, entity2, entity);
            if (entity.isProne()) {
                object2 = n31 <= 1 ? new ToHitData(-2, "target prone and adjacent") : new ToHitData(1, "target prone and at range");
            }
            toHitData2.append((TargetRoll)object2);
            if (!bl15 && ammoType != null && !entity.isEnemyOf(entity2) && entity.getBadCriticals(0, 1, 0) <= 0 && ammoType.getMunitionType() == 0x200000L) {
                toHitData2.addModifier(2, "Swarm-I at friendly unit with intact sensors");
            }
        }
        return toHitData2;
    }

    private static String toHitIsImpossible(IGame iGame, Entity entity, Targetable targetable, Mounted mounted, AmmoType ammoType, WeaponType weaponType, int n, boolean bl, boolean bl2, Entity entity2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, int n3, boolean bl7, Mounted mounted2, boolean bl8, boolean bl9, boolean bl10, boolean bl11) {
        ToHitData toHitData;
        int n4;
        int n5;
        Object object;
        Object object2;
        int n6;
        Object object3;
        int n7;
        int n8;
        boolean bl12 = false;
        ToHitData toHitData2 = null;
        if (weaponType.hasFlag(0x2000000000L)) {
            if (entity2 != null) {
                if (entity2.isFlying()) {
                    return "Tasers can't be fired at flying units.";
                }
            } else {
                return "Tasers can only fire at units.";
            }
        }
        if (weaponType.hasFlag(0x1000000000L)) {
            if (!(targetable instanceof Infantry)) {
                return "B-Pods can't target non-infantry";
            }
            if (entity instanceof BipedMech ? mounted.getLocation() != 7 && mounted.getLocation() != 6 : entity instanceof QuadMech && mounted.getLocation() != 7 && mounted.getLocation() != 6 && mounted.getLocation() != 5 && mounted.getLocation() != 4) {
                return "can fire only leg-mounted B-Pods";
            }
        }
        if (entity.hasShield() && entity.hasActiveShield(mounted.getLocation(), mounted.isRearMounted())) {
            return "Weapon blocked by active shield";
        }
        if (entity instanceof Mech && ((Mech)entity).getCockpitType() == 1 && (n8 = entity.getBadCriticals(0, 1, 0)) + (n7 = entity.getBadCriticals(0, 1, 1)) == 3) {
            return "Sensors Completely Destroyed for Torso-Mounted Cockpit";
        }
        if ("LegAttack".equals(weaponType.getInternalName())) {
            Enumeration<EntityAction> enumeration = iGame.getActions();
            while (enumeration.hasMoreElements()) {
                EntityAction entityAction = enumeration.nextElement();
                if (!(entityAction instanceof WeaponAttackAction) || ((AbstractAttackAction)(object3 = (WeaponAttackAction)entityAction)).getTargetType() != 0 || !(((AbstractAttackAction)object3).getTarget(iGame) instanceof Mech) || !((AbstractAttackAction)object3).getTarget(iGame).equals(targetable) || ((AbstractAttackAction)object3).getEntity(iGame) == entity || !((AbstractAttackAction)object3).getEntity(iGame).getEquipment(((WeaponAttackAction)object3).getWeaponId()).getType().getInternalName().equals("LegAttack")) continue;
                return "Target mech can only be targeted by one leg attack";
            }
            if (entity2.isMakingDfa()) {
                return "Target mech is in mid-DFA";
            }
        }
        if (bl6 && iGame.getOptions().booleanOption("indirect_fire") && !iGame.getOptions().booleanOption("indirect_always_possible") && LosEffects.calculateLos(iGame, entity.getId(), targetable).canSee()) {
            return new String("Indirect-fire LRM cannot be fired with direct LOS from attacker to target.");
        }
        if (entity.isLayingMines()) {
            return "Can't fire weapons when laying mines";
        }
        if (targetable.getTargetType() == 6 && !AmmoType.canDeliverMinefield(ammoType)) {
            return "Weapon can't deliver minefields";
        }
        if (targetable.getTargetType() == 13 && (!bl2 || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 45 || ammoType.getMunitionType() != 262144L)) {
            return "Weapon can't deliver flares";
        }
        if (iGame.getPhase() == IGame.Phase.PHASE_TARGETING && !bl7) {
            return "Only indirect artillery can be fired in the targeting phase";
        }
        if (iGame.getPhase() == IGame.Phase.PHASE_OFFBOARD && !bl3) {
            return "Only TAG can be fired in the offboard attack phase";
        }
        if (iGame.getPhase() != IGame.Phase.PHASE_OFFBOARD && bl3) {
            return "TAG can only be fired in the offboard attack phase";
        }
        if (bl10 && Compute.effectiveDistance(iGame, entity, targetable) <= 6) {
            return "Direct-Fire artillery attacks impossible at range <= 6";
        }
        if (!(ammoType == null || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 45 && ammoType.getAmmoType() != 67 || ammoType.getMunitionType() != 0x400000L && ammoType.getMunitionType() != 0x4000000L && ammoType.getMunitionType() != 0x1000000L && ammoType.getMunitionType() != 0x2000000L && ammoType.getMunitionType() != 0x800000L || targetable.getTargetType() == 6)) {
            return "Weapon can only deliver minefields";
        }
        if (ammoType != null && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45) && ammoType.getMunitionType() == 262144L && targetable.getTargetType() != 13) {
            return "Weapon can only deliver flares";
        }
        if (weaponType.hasFlag(0x8000000000L) && !iGame.getBoard().inSpace() && entity.getElevation() < 4) {
            return "Anti-ship missiles can only be used above elevation 3";
        }
        if (weaponType.hasFlag(0x2000000L) && (entity2 != null && !(entity2 instanceof Infantry) || targetable.getTargetType() != 0)) {
            return "Weapon can only be used against infantry";
        }
        if (targetable instanceof MinefieldTarget && !AmmoType.canClearMinefield(ammoType)) {
            return "Weapon can't clear minefields";
        }
        if (weaponType.hasFlag(32768L)) {
            long l = 0L;
            if (ammoType != null) {
                l = ammoType.getMunitionType();
            }
            if (l == 0x2000000000L) {
                bl12 = true;
            } else if (n != 7 && n != 5 && !bl8) {
                return "Weapon must make artillery attacks.";
            }
            if (entity.isFlying()) {
                if (bl10) {
                    return "Flying units can't make direct-fire artillery attacks";
                }
                if (bl7 && ammoType.getAmmoType() != 15) {
                    return "Flying units can't fire non-Arrow-IV artillery.";
                }
            }
        } else if (n == 7) {
            return "Weapon can't make artillery attacks.";
        }
        if (!bl) {
            if (!iGame.getOptions().booleanOption("friendly_fire") && targetable.getTargetType() == 0 && (((Entity)targetable).getOwnerId() == entity.getOwnerId() || ((Entity)targetable).getOwner().getTeam() != 0 && entity.getOwner().getTeam() != 0 && entity.getOwner().getTeam() == ((Entity)targetable).getOwner().getTeam())) {
                return "A friendly unit can never be the target of a direct attack.";
            }
            if (entity.equals(entity2)) {
                return "You can't target yourself";
            }
            if (entity.isShutDown() || !entity.getCrew().isActive()) {
                return "Attacker is in no condition to fire weapons.";
            }
            int n9 = entity.getBadCriticals(0, 1, 0);
            if (entity instanceof Mech && ((Mech)entity).getCockpitType() == 1 ? (n9 += entity.getBadCriticals(0, 1, 1)) > 2 : n9 > 1) {
                return "Attacker sensors destroyed.";
            }
            if (!mounted.canFire()) {
                return "Weapon is not in a state where it can be fired";
            }
            if (bl2 && (mounted2 == null || mounted2.getShotsLeft() == 0 || mounted2.isBreached())) {
                return "Weapon out of ammo.";
            }
            if (entity instanceof Aero && bl2 && mounted2 != null && entity.getTotalAmmoOfType(mounted2.getType()) < mounted.getCurrentShots()) {
                return "weapon does not have enough ammo.";
            }
            if (entity instanceof Tank) {
                n9 = ((Tank)entity).getSensorHits();
                if (n9 > 3) {
                    return "Attacker sensors destroyed.";
                }
                if (((Tank)entity).getStunnedTurns() > 0) {
                    return "Crew stunned";
                }
            }
        }
        if (bl2 && mounted2.isDumping()) {
            entity.loadWeaponWithSameAmmo(mounted);
            if (mounted2.getShotsLeft() == 0 || mounted2.isDumping()) {
                return "Dumping remaining ammo.";
            }
        }
        if (entity.isEvading() && !(entity instanceof Dropship) && !(entity instanceof Jumpship)) {
            return "Attacker is evading.";
        }
        if (entity instanceof Aero) {
            Aero aero = (Aero)entity;
            n7 = aero.getFCSHits();
            if (n7 > 2) {
                return "Fire control system destroyed.";
            }
            if (aero instanceof Jumpship && (n6 = ((Aero)(object3 = (Jumpship)aero)).getCICHits()) > 2) {
                return "CIC destroyed.";
            }
            object3 = iGame.getActions();
            while (object3.hasMoreElements()) {
                Object e = object3.nextElement();
                if (!(e instanceof WeaponAttackAction) || ((AbstractEntityAction)(object2 = (WeaponAttackAction)e)).getEntityId() != n2 || n3 == ((WeaponAttackAction)object2).getWeaponId() || !entity.getEquipment(((WeaponAttackAction)object2).getWeaponId()).getType().hasFlag(0x10000000000L)) continue;
                return "Already space bombing";
            }
        }
        if (weaponType.hasModes() && (mounted.curMode().equals("Bracket 80%") || mounted.curMode().equals("Bracket 60%") || mounted.curMode().equals("Bracket 40%")) && targetable instanceof Aero && !entity2.isLargeCraft() && RangeType.rangeBracket(entity.getPosition().distance(targetable.getPosition()), weaponType.getRanges(mounted), iGame.getOptions().booleanOption("tacops_range")) == 1) {
            return "small craft cannot be bracketed at short range";
        }
        if (weaponType.hasModes() && mounted.curMode().equals("Bracket 80%") && mounted.getBayWeapons().size() < 2) {
            return "not enough weapons to bracket at this level";
        }
        if (weaponType.hasModes() && mounted.curMode().equals("Bracket 60%") && mounted.getBayWeapons().size() < 3) {
            return "not enough weapons to bracket at this level";
        }
        if (weaponType.hasModes() && mounted.curMode().equals("Bracket 40%") && mounted.getBayWeapons().size() < 4) {
            return "not enough weapons to bracket at this level";
        }
        if (entity.isWeaponBlockedAt(mounted.getLocation(), mounted.isRearMounted())) {
            return "Weapon blocked by passenger.";
        }
        if (entity2 != null && -1 != entity2.getSwarmTargetId()) {
            return "Target is swarming a Mek.";
        }
        boolean bl13 = false;
        if (ammoType != null && weaponType.hasFlag(2L) && mounted.curMode().equals("Cool")) {
            bl13 = true;
            if (!entity.hasWorkingMisc(0x80000000L, -1L)) {
                return "Vehicle does not have a working coolant system";
            }
        }
        if (8 == targetable.getTargetType()) {
            if (!weaponType.hasFlag(0x20000000L) && !bl13) {
                return "Weapon can't put out fires";
            }
            IHex iHex = iGame.getBoard().getHex(targetable.getPosition());
            if (!iHex.containsTerrain(19)) {
                return "Target is not on fire.";
            }
        } else if (!(!weaponType.hasFlag(0x20000000L) || targetable instanceof Tank && ((Tank)targetable).isOnFire() || targetable instanceof Entity && ((Entity)targetable).infernos.getTurnsLeftToBurn() > 0)) {
            return "Target is not on fire.";
        }
        if (bl5 && 1 == targetable.getTargetType()) {
            return "Infantry can not clear woods.";
        }
        if (17 == targetable.getTargetType() && weaponType.getAmmoType() != 62 && !(weaponType instanceof ScreenLauncherBayWeapon)) {
            return "Only screen launchers may launch screens";
        }
        if (17 != targetable.getTargetType() && (weaponType.getAmmoType() == 62 || weaponType instanceof ScreenLauncherBayWeapon)) {
            return "Screen launchers may only target hexes";
        }
        if ((bl13 || weaponType.hasFlag(32L) && !bl4) && 2 == targetable.getTargetType()) {
            return "Weapon can not cause fires.";
        }
        if (!(targetable.getTargetType() != 2 || !iGame.getOptions().booleanOption("no_ignite_clear") || iGame.getBoard().getHex(((HexTarget)targetable).getPosition()).containsTerrain(1) || iGame.getBoard().getHex(((HexTarget)targetable).getPosition()).containsTerrain(5) || iGame.getBoard().getHex(((HexTarget)targetable).getPosition()).containsTerrain(29) || iGame.getBoard().getHex(((HexTarget)targetable).getPosition()).containsTerrain(22))) {
            return "Only woods and building hexes can be set on fire intentionally.";
        }
        if (bl4 && (entity2 instanceof Tank && iGame.getOptions().booleanOption("vehicles_safe_from_infernos") || entity2 instanceof Protomech && iGame.getOptions().booleanOption("protos_safe_from_infernos"))) {
            return "Can not target that unit type with Inferno rounds.";
        }
        if (bl3 && entity2 instanceof Infantry) {
            return "Can not target infantry with TAG.";
        }
        if (weaponType.hasFlag(2L) && weaponType.hasModes() && mounted.curMode().equals("Heat") && !(entity2 instanceof Mech)) {
            return "Can only raise the heat level of Meks.";
        }
        if (entity.isCapitalFighter()) {
            int n10 = 0;
            object3 = iGame.getActions();
            while (object3.hasMoreElements()) {
                EntityAction entityAction = object3.nextElement();
                if (!(entityAction instanceof WeaponAttackAction) || ((AbstractEntityAction)(object2 = (WeaponAttackAction)entityAction)).getEntityId() != n2 || n3 == ((WeaponAttackAction)object2).getWeaponId()) continue;
                object = entity.getEquipment(((WeaponAttackAction)object2).getWeaponId());
                n10 += ((Mounted)object).getCurrentHeat();
            }
            if (n10 + mounted.getCurrentHeat() > entity.getHeatCapacity()) {
                return "attack would exceed heat sink capacity";
            }
        }
        if (entity.usesWeaponBays() && mounted.getBayWeapons().size() > 0) {
            int n11;
            Object object4;
            int n12;
            boolean bl14 = false;
            object3 = mounted.getBayWeapons().iterator();
            while (object3.hasNext()) {
                n6 = (Integer)object3.next();
                object2 = entity.getEquipment(n6);
                object = (WeaponType)((Mounted)object2).getType();
                int n13 = n12 = ((WeaponType)object).getAmmoType() != -1 ? 1 : 0;
                if (!((Mounted)object2).canFire()) continue;
                if (n12 != 0) {
                    if (((Mounted)object2).getLinked() == null || ((Mounted)object2).getLinked().getShotsLeft() <= 0) continue;
                    bl14 = true;
                    break;
                }
                bl14 = true;
                break;
            }
            if (!bl14) {
                return "weapon bay out of ammo or otherwise unusable";
            }
            int n14 = 0;
            n6 = entity.getHeatCapacity();
            object2 = new boolean[entity.locations()];
            object = new boolean[entity.locations()];
            for (n12 = 0; n12 < entity.locations(); ++n12) {
                object2[n12] = false;
                object[n12] = false;
            }
            Enumeration<EntityAction> enumeration = iGame.getActions();
            while (enumeration.hasMoreElements()) {
                WeaponAttackAction weaponAttackAction;
                EntityAction entityAction = enumeration.nextElement();
                if (!(entityAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId() != n2 || n3 == weaponAttackAction.getWeaponId()) continue;
                object4 = entity.getEquipment(weaponAttackAction.getWeaponId());
                n11 = ((Mounted)object4).getLocation();
                boolean bl15 = ((Mounted)object4).isRearMounted();
                if (iGame.getOptions().booleanOption("heat_by_bay")) {
                    for (int n15 : ((Mounted)object4).getBayWeapons()) {
                        n14 += entity.getEquipment(n15).getCurrentHeat();
                    }
                    continue;
                }
                if (!bl15) {
                    if (object2[n11] != false) continue;
                    n14 += entity.getHeatInArc(n11, bl15);
                    object2[n11] = true;
                    continue;
                }
                if (object[n11] != false) continue;
                n14 += entity.getHeatInArc(n11, bl15);
                object[n11] = true;
            }
            int n16 = mounted.getLocation();
            n5 = mounted.isRearMounted();
            int n17 = entity.getHeatInArc(n16, n5 != 0);
            if (iGame.getOptions().booleanOption("heat_by_bay")) {
                n17 = 0;
                object4 = mounted.getBayWeapons().iterator();
                while (object4.hasNext()) {
                    n11 = (Integer)object4.next();
                    n17 += entity.getEquipment(n11).getCurrentHeat();
                }
            }
            boolean bl16 = true;
            for (n11 = 0; n11 < entity.locations(); ++n11) {
                if (n11 == n16 || object2[n11] == false && object[n11] == false) continue;
                bl16 = false;
                break;
            }
            if (iGame.getOptions().booleanOption("heat_by_bay") ? n14 + n17 > n6 : (n5 == 0 ? object2[n16] == false && n14 + n17 > n6 && !bl16 : object[n16] == false && n14 + n17 > n6 && !bl16)) {
                return "heat exceeds capacity";
            }
        }
        if (weaponType.hasFlag(0x100000000L) && weaponType.hasModes() && mounted.curMode().equals("Off")) {
            return "MG Array is disabled";
        }
        if (weaponType.hasFlag(512L) && entity.hasLinkedMGA(mounted)) {
            return "Machine gun is slaved to array equipment";
        }
        if (weaponType.hasFlag(128L)) {
            Enumeration<EntityAction> enumeration = iGame.getActions();
            while (enumeration.hasMoreElements()) {
                WeaponAttackAction weaponAttackAction;
                EntityAction entityAction = enumeration.nextElement();
                if (!(entityAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId() != n2 || n3 == weaponAttackAction.getWeaponId()) continue;
                return "Other weapon attacks declared.";
            }
        } else if (bl5 && !(entity instanceof BattleArmor)) {
            if (entity.getMovementMode() == 10 && entity.getWalkMP() == 0 && entity.moved != 0) {
                return "Foot platoons with 0 MP can move or shoot, not both";
            }
            if (!weaponType.hasFlag(2048L) && entity.moved != 0) {
                return "Can't fire field guns in same turn as moving";
            }
            Enumeration<EntityAction> enumeration = iGame.getActions();
            while (enumeration.hasMoreElements()) {
                WeaponAttackAction weaponAttackAction;
                EntityAction entityAction = enumeration.nextElement();
                if (!(entityAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId() != n2 || ((Mounted)(object2 = entity.getEquipment(weaponAttackAction.getWeaponId()))).getType().hasFlag(2048L) == weaponType.hasFlag(2048L)) continue;
                return "Can't fire field guns and small arms at the same time.";
            }
            if (weaponType.getName().equals("Compact Narc")) {
                enumeration = iGame.getActions();
                while (enumeration.hasMoreElements()) {
                    WeaponAttackAction weaponAttackAction;
                    EntityAction entityAction = enumeration.nextElement();
                    if (!(entityAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId() != n2 || !((Mounted)(object2 = entity.getEquipment(weaponAttackAction.getWeaponId()))).getType().getName().equals("Compact Narc") || weaponAttackAction.getTargetId() == targetable.getTargetId()) continue;
                    return "Can fire multiple compact narcs only at one target.";
                }
            }
        }
        if ((n4 = iGame.getPlanetaryConditions().getWindStrength()) == 5 && weaponType.hasFlag(262144L) && !iGame.getBoard().inSpace()) {
            return "No missile fire in a tornado";
        }
        if (n4 == 6 && !iGame.getBoard().inSpace() && (weaponType.hasFlag(262144L) || weaponType.hasFlag(65536L))) {
            return "No missile or ballistic fire in an F4 tornado";
        }
        if (bl6 && !iGame.getOptions().booleanOption("indirect_fire")) {
            return "Indirect fire option not enabled";
        }
        if (bl6 && iGame.getOptions().booleanOption("indirect_fire") && !iGame.getOptions().booleanOption("indirect_always_possible") && LosEffects.calculateLos(iGame, n2, targetable).canSee()) {
            return "Indirect fire impossible with direct LOS";
        }
        if (bl6 && bl2 && ammoType.getAmmoType() == 45 && !ammoType.hasFlag(32L)) {
            return "only LRM ammo can be fired indirectly";
        }
        if (entity instanceof Tank && entity.isHullDown() && mounted.getLocation() == 1) {
            return "Nearby terrain blocks front weapons.";
        }
        if (ammoType != null && ammoType.getAmmoType() == 25) {
            if (!entity.isFlying()) {
                return "attacker must be at least at elevation 1";
            }
            if (targetable.getTargetType() != 14) {
                return "must target hex with bombs";
            }
        }
        if (!(targetable.getTargetType() != 14 || bl2 && ammoType.getAmmoType() == 25)) {
            return "Weapon can't deliver bombs";
        }
        Entity entity3 = null;
        if (bl6 && (entity3 = targetable instanceof Entity && !bl11 && bl2 && ammoType.getMunitionType() == 4096L && entity2.isNarcedBy(entity.getOwner().getTeam()) ? entity2 : Compute.findSpotter(iGame, entity, targetable)) == null && !(weaponType instanceof MekMortarWeapon)) {
            return "No available spotter";
        }
        n6 = 0;
        boolean bl17 = false;
        if (bl2 && weaponType.getAmmoType() == 7 && ammoType.getMunitionType() == 0x10000000L && entity.getElevation() == -1 && entity.getLocationStatus(mounted.getLocation()) == 2) {
            bl17 = true;
            entity.setElevation(0);
        }
        if (!bl6 || bl6 && entity3 == null) {
            object = LosEffects.calculateLos(iGame, n2, targetable);
            if (entity.hasActiveEiCockpit()) {
                n6 = ((LosEffects)object).getLightWoods() > 0 ? 2 : 1;
            }
            if (weaponType instanceof MekMortarWeapon && bl6) {
                ((LosEffects)object).setArcedAttack(true);
            }
            toHitData = ((LosEffects)object).losModifiers(iGame, n6);
        } else {
            object = LosEffects.calculateLos(iGame, entity3.getId(), targetable);
            ((LosEffects)object).setAttackerCover(0);
            if (entity3.hasActiveEiCockpit()) {
                n6 = ((LosEffects)object).getLightWoods() > 0 ? 2 : 1;
            }
            if (weaponType instanceof MekMortarWeapon && bl6) {
                ((LosEffects)object).setArcedAttack(true);
            }
            toHitData = ((LosEffects)object).losModifiers(iGame);
        }
        if (bl17) {
            entity.setElevation(-1);
        }
        if (toHitData.getValue() == Integer.MAX_VALUE && !bl7) {
            return toHitData.getDesc();
        }
        if (!Compute.isInArc(iGame, n2, n3, targetable)) {
            return "Target not in arc.";
        }
        if (entity instanceof Aero && ((Aero)entity).isSpheroid() && iGame.getBoard().inAtmosphere()) {
            n5 = entity.getElevation() - targetable.getElevation();
            if (mounted.getLocation() == 0 && n5 > -3) {
                return "Target is too low";
            }
            if (mounted.getLocation() == 3 && n5 < 3) {
                return "Target is too high";
            }
        }
        if (bl9 && entity2 instanceof Infantry && null == ((LosEffects)object).getThruBldg()) {
            return "Attack on infantry crosses building exterior wall.";
        }
        if (weaponType.getAmmoType() == 13 || weaponType.getAmmoType() == 30) {
            if (bl9) {
                return "Narc pods cannot be fired into or inside buildings.";
            }
            if (targetable instanceof Infantry) {
                return "Narc pods cannot be used to attack infantry.";
            }
        }
        if (((LosEffects)object).isAttackerCover() && entity.locationIsLeg(mounted.getLocation()) && entity.getLocationStatus(mounted.getLocation()) != 2) {
            return "Nearby terrain blocks leg weapons.";
        }
        if (weaponType.hasFlag(0x10000000000L)) {
            Enumeration<EntityAction> enumeration = iGame.getActions();
            while (enumeration.hasMoreElements()) {
                WeaponAttackAction weaponAttackAction;
                EntityAction entityAction = enumeration.nextElement();
                if (!(entityAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId() != n2 || n3 == weaponAttackAction.getWeaponId()) continue;
                return "Other weapon attacks declared.";
            }
            toHitData2 = Compute.getSpaceBombBaseToHit(entity, entity2, iGame);
            if (Integer.MAX_VALUE == toHitData2.getValue()) {
                return toHitData2.getDesc();
            }
        }
        if ("LegAttack".equals(weaponType.getInternalName())) {
            toHitData2 = Compute.getLegAttackBaseToHit(entity, entity2);
            if (Integer.MAX_VALUE == toHitData2.getValue()) {
                return toHitData2.getDesc();
            }
        } else if ("SwarmMek".equals(weaponType.getInternalName())) {
            toHitData2 = Compute.getSwarmMekBaseToHit(entity, entity2);
            if (Integer.MAX_VALUE == toHitData2.getValue()) {
                return toHitData2.getDesc();
            }
        } else if ("StopSwarm".equals(weaponType.getInternalName())) {
            if (-1 == entity.getSwarmTargetId()) {
                return "Not swarming a Mek.";
            }
        } else if ("BAMineLauncher".equals(weaponType.getInternalName())) {
            if (entity2 instanceof Infantry) {
                return "Can not attack infantry.";
            }
        } else if (entity2 != null && entity.getSwarmTargetId() == entity2.getId()) {
            if (weaponType.getDamage() == 0) {
                return "Weapon causes no damage.";
            }
            if (weaponType.hasFlag(262144L)) {
                return "Missile weapons can't be used in swarm attack";
            }
            if (!mounted.isBodyMounted()) {
                return "non-body mounted weapons can't be used in swarm attack";
            }
        } else if (-1 != entity.getSwarmTargetId()) {
            return "Must target the Mek being swarmed.";
        }
        int n18 = Compute.effectiveDistance(iGame, entity, targetable);
        if (bl10) {
            if (weaponType.hasFlag(0x800000000L)) {
                return "Cruise Missiles can't be fired directly";
            }
            if (n18 > 17) {
                return "Direct artillery attack at range >17 hexes.";
            }
            if (bl12 && (entity2 == null || entity2.getTaggedBy() == -1)) {
                return "On board homing shot must target a unit tagged this turn";
            }
        }
        if (bl7) {
            int n19 = (int)Math.ceil((float)n18 / 17.0f);
            if (n19 > weaponType.getLongRange()) {
                return "Indirect artillery attack out of range";
            }
            if (n18 <= 17 && toHitData.getValue() != Integer.MAX_VALUE) {
                return "Cannot fire indirectly at range <=17 hexes unless no LOS.";
            }
            if (bl12 && n != 7) {
                return "Off board homing shot must target a map sheet";
            }
        }
        if (entity.getGrappled() != -1) {
            int n20 = entity.getGrappled();
            if (n20 != targetable.getTargetId()) {
                return "Can only attack grappled mech";
            }
            int n21 = mounted.getLocation();
            if (entity instanceof Mech && entity.getGrappleSide() == 0 && n21 != 1 && n21 != 3 && n21 != 2 && n21 != 0 || mounted.isRearMounted()) {
                return "Can only fire head and front torso weapons when grappled";
            }
            if (entity instanceof Mech && entity.getGrappleSide() == 2 && n21 == 5) {
                return "Cannot Fire Weapon, Snared by Chain Whip";
            }
            if (entity instanceof Mech && entity.getGrappleSide() == 1 && n21 == 4) {
                return "Cannot Fire Weapon, Snared by Chain Whip";
            }
        }
        if (entity.getMovementMode() == 15 && entity.getPosition() == targetable.getPosition()) {
            return "WiGE may not attack target in same hex";
        }
        if (weaponType instanceof GaussWeapon && weaponType.hasModes() && mounted.curMode().equals("Powered Down")) {
            return "Weapon is powered down";
        }
        return null;
    }

    public boolean isNemesisConfused() {
        return this.nemesisConfused;
    }

    public void setNemesisConfused(boolean bl) {
        this.nemesisConfused = bl;
    }

    public boolean isSwarmingMissiles() {
        return this.swarmingMissiles;
    }

    public void setSwarmingMissiles(boolean bl) {
        this.swarmingMissiles = bl;
    }

    public void setOldTargetId(int n) {
        this.oldTargetId = n;
    }

    public int getSwarmMissiles() {
        return this.swarmMissiles;
    }

    public void setSwarmMissiles(int n) {
        this.swarmMissiles = n;
    }

    public int[] getBombPayload() {
        return this.bombPayload;
    }

    public void setBombPayload(int[] nArray) {
        this.bombPayload = nArray;
    }
}

