/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.util.BuildingBlock;

public class BLKFile {
    BuildingBlock dataFile;
    public static final int FUSION = 0;
    public static final int ICE = 1;
    public static final int XL = 2;
    public static final int XXL = 3;
    public static final int LIGHT = 4;
    public static final int COMPACT = 5;

    protected void loadEquipment(Entity entity, String string, int n) throws EntityLoadingException {
        String[] stringArray = this.dataFile.getDataAsString(string + " Equipment");
        if (stringArray == null) {
            return;
        }
        String string2 = entity.getTechLevel() == 2 ? "Clan " : "IS ";
        if (stringArray[0] != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i].trim();
                EquipmentType equipmentType = EquipmentType.get(string3);
                if (equipmentType == null) {
                    equipmentType = EquipmentType.get(string2 + string3);
                }
                if (equipmentType != null) {
                    try {
                        entity.addEquipment(equipmentType, n);
                        continue;
                    }
                    catch (LocationFullException locationFullException) {
                        throw new EntityLoadingException(locationFullException.getMessage());
                    }
                }
                if (string3 == "0") continue;
                entity.addFailedEquipment(string3);
            }
        }
    }

    public boolean isMine() {
        return this.dataFile.exists("blockversion");
    }

    static int translateEngineCode(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 0;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 4) {
            return 3;
        }
        if (n == 3) {
            return 4;
        }
        if (n == 5) {
            return 5;
        }
        return -1;
    }

    public void setTechLevel(Entity entity) throws EntityLoadingException {
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find year block.");
        }
        entity.setYear(this.dataFile.getDataAsInt("year")[0]);
        if (!this.dataFile.exists("type")) {
            throw new EntityLoadingException("Could not find type block.");
        }
        if (this.dataFile.getDataAsString("type")[0].equals("IS")) {
            if (entity.getYear() == 3025) {
                entity.setTechLevel(0);
            } else {
                entity.setTechLevel(1);
            }
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 1")) {
            entity.setTechLevel(0);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 2")) {
            entity.setTechLevel(1);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 3")) {
            entity.setTechLevel(5);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 4")) {
            entity.setTechLevel(7);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 5")) {
            entity.setTechLevel(9);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan") || this.dataFile.getDataAsString("type")[0].equals("Clan Level 2")) {
            entity.setTechLevel(2);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan Level 3")) {
            entity.setTechLevel(6);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan Level 4")) {
            entity.setTechLevel(8);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan Level 5")) {
            entity.setTechLevel(10);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (IS Chassis)")) {
            entity.setTechLevel(5);
            entity.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (IS Chassis) Experimental")) {
            entity.setTechLevel(7);
            entity.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (IS Chassis) Unofficial")) {
            entity.setTechLevel(9);
            entity.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (Clan Chassis)")) {
            entity.setTechLevel(6);
            entity.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (Clan Chassis) Experimental")) {
            entity.setTechLevel(8);
            entity.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (Clan Chassis) Unofficial")) {
            entity.setTechLevel(10);
            entity.setMixedTech(true);
        } else {
            if (this.dataFile.getDataAsString("type")[0].equals("Mixed")) {
                throw new EntityLoadingException("Unsupported tech base: \"Mixed\" is no longer allowed by itself.  You must specify \"Mixed (IS Chassis)\" or \"Mixed (Clan Chassis)\".");
            }
            throw new EntityLoadingException("Unsupported tech level: " + this.dataFile.getDataAsString("type")[0]);
        }
    }
}

