/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.util.Vector;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.LargeSupportTank;
import megamek.common.Mounted;
import megamek.common.TroopSpace;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKLargeSupportTankFile
extends BLKFile
implements IMechLoader {
    protected static final String[] MOVES = new String[]{"", "", "", "Tracked", "Wheeled", "Hover", "", "Naval", "Hydrofoil", "Submarine", "", "", "", "", "", "WIGE"};

    public BLKLargeSupportTankFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        int n;
        int n2;
        LargeSupportTank largeSupportTank = new LargeSupportTank();
        if (!this.dataFile.exists("barrating")) {
            throw new EntityLoadingException("Could not find barrating block.");
        }
        largeSupportTank.setBARRating(this.dataFile.getDataAsInt("barrating")[0]);
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        largeSupportTank.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            largeSupportTank.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            largeSupportTank.setModel("");
        }
        this.setTechLevel(largeSupportTank);
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        largeSupportTank.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n3 = -1;
        for (n2 = 0; n2 < MOVES.length; ++n2) {
            if (!string.equals(MOVES[n2])) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            throw new EntityLoadingException("Invalid movment type: " + string);
        }
        largeSupportTank.setMovementMode(n3);
        if (this.dataFile.exists("transporters")) {
            String[] stringArray = this.dataFile.getDataAsString("transporters");
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].startsWith("TroopSpace:", 0)) continue;
                Double d = new Double(stringArray[n].substring(11));
                int n4 = d.intValue();
                largeSupportTank.addTransporter(new TroopSpace(n4));
            }
        }
        n2 = 0;
        if (this.dataFile.exists("engine_type")) {
            n2 = this.dataFile.getDataAsInt("engine_type")[0];
        }
        n = 2;
        if (largeSupportTank.isClan()) {
            n |= 1;
        }
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        int n5 = this.dataFile.getDataAsInt("cruiseMP")[0] * (int)largeSupportTank.getWeight() - largeSupportTank.getSuspensionFactor();
        largeSupportTank.setEngine(new Engine(n5, BLKFile.translateEngineCode(n2), n));
        if (this.dataFile.exists("armor_type")) {
            largeSupportTank.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (this.dataFile.exists("armor_tech")) {
            largeSupportTank.setArmorTechLevel(this.dataFile.getDataAsInt("armor_tech")[0]);
        }
        if (this.dataFile.exists("internal_type")) {
            largeSupportTank.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length < 6 || nArray.length > 7) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        largeSupportTank.setHasNoTurret(nArray.length == 6);
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = 0;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        for (int i = 0; i < nArray2.length; ++i) {
            largeSupportTank.initializeArmor(nArray2[i], i);
        }
        largeSupportTank.autoSetInternal();
        this.loadEquipment(largeSupportTank, "Front", 1);
        this.loadEquipment(largeSupportTank, "Front Right", 2);
        this.loadEquipment(largeSupportTank, "Front Left", 3);
        this.loadEquipment(largeSupportTank, "Rear Right", 4);
        this.loadEquipment(largeSupportTank, "Rear Left", 5);
        this.loadEquipment(largeSupportTank, "Rear", 6);
        if (!largeSupportTank.hasNoTurret()) {
            this.loadEquipment(largeSupportTank, "Turret", 5);
        }
        this.loadEquipment(largeSupportTank, "Body", 0);
        if (this.dataFile.exists("omni")) {
            largeSupportTank.setOmni(true);
        }
        return largeSupportTank;
    }

    public static void encode(String string, LargeSupportTank largeSupportTank) {
        String string2;
        BuildingBlock buildingBlock = new BuildingBlock();
        buildingBlock.createNewBlock();
        buildingBlock.writeBlockData("UnitType", "LargeSupportTank");
        buildingBlock.writeBlockData("blockversion", 1);
        buildingBlock.writeBlockData("Name", largeSupportTank.getChassis());
        buildingBlock.writeBlockData("Model", largeSupportTank.getModel());
        buildingBlock.writeBlockData("year", largeSupportTank.getYear());
        if (largeSupportTank.isMixedTech()) {
            string2 = !largeSupportTank.isClan() ? "Mixed (IS Chassis)" : "Mixed (Clan Chassis)";
        } else {
            switch (largeSupportTank.getTechLevel()) {
                case 0: {
                    string2 = "IS Level 1";
                    break;
                }
                case 1: {
                    string2 = "IS Level 2";
                    break;
                }
                default: {
                    string2 = "IS Level 3";
                    break;
                }
                case 2: {
                    string2 = "Clan Level 2";
                    break;
                }
                case 6: {
                    string2 = "Clan Level 3";
                }
            }
        }
        buildingBlock.writeBlockData("type", string2);
        buildingBlock.writeBlockData("tonnage", largeSupportTank.getWeight());
        buildingBlock.writeBlockData("motion_type", largeSupportTank.getMovementModeAsString());
        if (largeSupportTank.getTroopCarryingSpace() > 0) {
            buildingBlock.writeBlockData("transporters", "TroopSpace: " + largeSupportTank.getTroopCarryingSpace());
        }
        int n = 0;
        switch (largeSupportTank.getEngine().getEngineType()) {
            case 0: {
                n = 1;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
            }
        }
        buildingBlock.writeBlockData("engine_type", n);
        buildingBlock.writeBlockData("cruiseMP", largeSupportTank.getOriginalWalkMP());
        if (largeSupportTank.getArmorType() != 0) {
            buildingBlock.writeBlockData("armor_type", largeSupportTank.getArmorType());
            buildingBlock.writeBlockData("armor_tech", largeSupportTank.getArmorTechLevel());
        }
        if (largeSupportTank.getStructureType() != 0) {
            buildingBlock.writeBlockData("internal_type", largeSupportTank.getStructureType());
        }
        if (largeSupportTank.isOmni()) {
            buildingBlock.writeBlockData("omni", 1);
        }
        int[] nArray = new int[largeSupportTank.locations() - 1];
        for (int i = 1; i < largeSupportTank.locations(); ++i) {
            nArray[i - 1] = largeSupportTank.getOArmor(i);
        }
        buildingBlock.writeBlockData("armor", nArray);
        Vector vector = new Vector(largeSupportTank.locations());
        for (int i = 0; i < largeSupportTank.locations(); ++i) {
            vector.add(new Vector());
        }
        for (Mounted mounted : largeSupportTank.getEquipment()) {
            String string3 = mounted.getType().getInternalName();
            int n2 = mounted.getLocation();
            if (n2 == -1) continue;
            ((Vector)vector.get(n2)).add(string3);
        }
        for (int i = 0; i < largeSupportTank.locations(); ++i) {
            buildingBlock.writeBlockData(largeSupportTank.getLocationName(i) + " Equipment", (Vector)vector.get(i));
        }
        buildingBlock.writeBlockData("barrating", largeSupportTank.getBARRating());
        buildingBlock.writeBlockFile(string);
    }
}

