/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.BattleArmorBay;
import megamek.common.CargoBay;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.InfantryBay;
import megamek.common.LocationFullException;
import megamek.common.SmallCraft;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKSmallCraftFile
extends BLKFile
implements IMechLoader {
    public static final int NOSE = 0;
    public static final int RW = 1;
    public static final int LW = 2;
    public static final int AFT = 3;

    public BLKSmallCraftFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        SmallCraft smallCraft = new SmallCraft();
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        smallCraft.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            smallCraft.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            smallCraft.setModel("");
        }
        this.setTechLevel(smallCraft);
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        smallCraft.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("crew")) {
            throw new EntityLoadingException("Could not find crew block.");
        }
        smallCraft.setNCrew(this.dataFile.getDataAsInt("crew")[0]);
        if (!this.dataFile.exists("passengers")) {
            throw new EntityLoadingException("Could not find passenger block.");
        }
        smallCraft.setNPassenger(this.dataFile.getDataAsInt("passengers")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n = 16;
        if (string.equals("spheroid")) {
            n = 17;
            smallCraft.setSpheroid(true);
        }
        smallCraft.setMovementMode(n);
        if (!this.dataFile.exists("structural_integrity")) {
            throw new EntityLoadingException("Could not find structual integrity block.");
        }
        smallCraft.set0SI(this.dataFile.getDataAsInt("structural_integrity")[0]);
        if (!this.dataFile.exists("heatsinks")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        smallCraft.setHeatSinks(this.dataFile.getDataAsInt("heatsinks")[0]);
        if (!this.dataFile.exists("sink_type")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        smallCraft.setHeatType(this.dataFile.getDataAsInt("sink_type")[0]);
        if (!this.dataFile.exists("fuel")) {
            throw new EntityLoadingException("Could not find fuel block.");
        }
        smallCraft.setFuel(this.dataFile.getDataAsInt("fuel")[0]);
        if (!this.dataFile.exists("SafeThrust")) {
            throw new EntityLoadingException("Could not find Safe Thrust block.");
        }
        smallCraft.setOriginalWalkMP(this.dataFile.getDataAsInt("SafeThrust")[0]);
        smallCraft.setEngine(new Engine(400, 0, 0));
        if (this.dataFile.exists("armor_type")) {
            smallCraft.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (this.dataFile.exists("armor_tech")) {
            smallCraft.setArmorTechLevel(this.dataFile.getDataAsInt("armor_tech")[0]);
        }
        if (this.dataFile.exists("internal_type")) {
            smallCraft.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length != 4) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        smallCraft.initializeArmor(nArray[0], 0);
        smallCraft.initializeArmor(nArray[1], 2);
        smallCraft.initializeArmor(nArray[2], 1);
        smallCraft.initializeArmor(nArray[3], 3);
        smallCraft.autoSetInternal();
        smallCraft.autoSetThresh();
        this.loadEquipment(smallCraft, "Nose", 0);
        this.loadEquipment(smallCraft, "Right Side", 2);
        this.loadEquipment(smallCraft, "Left Side", 1);
        this.loadEquipment(smallCraft, "Aft", 3);
        if (this.dataFile.exists("transporters")) {
            String[] stringArray = this.dataFile.getDataAsString("transporters");
            for (int i = 0; i < stringArray.length; ++i) {
                int n2;
                int n3;
                String[] stringArray2;
                String string2;
                if (stringArray[i].startsWith("InfantryBay:", 0)) {
                    string2 = stringArray[i].substring(12);
                    stringArray2 = string2.split(":");
                    n3 = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    smallCraft.addTransporter(new InfantryBay(n3, n2));
                    continue;
                }
                if (stringArray[i].startsWith("BattleArmorBay:", 0)) {
                    string2 = stringArray[i].substring(15);
                    stringArray2 = string2.split(":");
                    n3 = Integer.parseInt(stringArray2[0]);
                    n2 = Integer.parseInt(stringArray2[1]);
                    smallCraft.addTransporter(new BattleArmorBay(n3, n2));
                    continue;
                }
                if (!stringArray[i].startsWith("CargoBay:", 0)) continue;
                string2 = stringArray[i].substring(9);
                stringArray2 = string2.split(":");
                n3 = Integer.parseInt(stringArray2[0]);
                n2 = Integer.parseInt(stringArray2[1]);
                smallCraft.addTransporter(new CargoBay(n3, n2));
            }
        }
        return smallCraft;
    }

    protected void loadEquipment(Entity entity, String string, int n) throws EntityLoadingException {
        String[] stringArray = this.dataFile.getDataAsString(string + " Equipment");
        if (stringArray == null) {
            return;
        }
        String string2 = entity.getTechLevel() == 2 ? "Clan " : "IS ";
        boolean bl = false;
        if (stringArray[0] != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                EquipmentType equipmentType;
                bl = false;
                String string3 = stringArray[i].trim();
                if (string3.startsWith("(R) ")) {
                    bl = true;
                    string3 = string3.substring(4);
                }
                if ((equipmentType = EquipmentType.get(string3)) == null) {
                    equipmentType = EquipmentType.get(string2 + string3);
                }
                if (equipmentType != null) {
                    try {
                        entity.addEquipment(equipmentType, n, bl);
                        continue;
                    }
                    catch (LocationFullException locationFullException) {
                        throw new EntityLoadingException(locationFullException.getMessage());
                    }
                }
                if (string3 == "0") continue;
                entity.addFailedEquipment(string3);
            }
        }
    }
}

