/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.TroopSpace;
import megamek.common.VTOL;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKVTOLFile
extends BLKFile
implements IMechLoader {
    private static final String[] MOVES = new String[]{"", "", "", "Tracked", "Wheeled", "Hover", "VTOL"};

    public BLKVTOLFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        int n;
        int n2;
        VTOL vTOL = new VTOL();
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        vTOL.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            vTOL.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            vTOL.setModel("");
        }
        this.setTechLevel(vTOL);
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        vTOL.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n3 = -1;
        for (n2 = 0; n2 < MOVES.length; ++n2) {
            if (!string.equals(MOVES[n2])) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            throw new EntityLoadingException("Invalid movment type: " + string);
        }
        vTOL.setMovementMode(n3);
        if (this.dataFile.exists("transporters")) {
            String[] stringArray = this.dataFile.getDataAsString("transporters");
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].startsWith("TroopSpace:", 0)) continue;
                Double d = new Double(stringArray[n].substring(11));
                vTOL.addTransporter(new TroopSpace(d));
            }
        }
        n2 = 0;
        if (this.dataFile.exists("engine_type")) {
            n2 = this.dataFile.getDataAsInt("engine_type")[0];
        }
        n = 2;
        if (vTOL.isClan()) {
            n |= 1;
        }
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        int n4 = this.dataFile.getDataAsInt("cruiseMP")[0] * (int)vTOL.getWeight() - vTOL.getSuspensionFactor();
        vTOL.setEngine(new Engine(n4, BLKFile.translateEngineCode(n2), n));
        if (this.dataFile.exists("armor_type")) {
            vTOL.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (this.dataFile.exists("armor_tech")) {
            vTOL.setArmorTechLevel(this.dataFile.getDataAsInt("armor_tech")[0]);
        }
        if (this.dataFile.exists("internal_type")) {
            vTOL.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length != 5) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = 0;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        for (int i = 0; i < nArray2.length; ++i) {
            vTOL.initializeArmor(nArray2[i], i);
        }
        vTOL.autoSetInternal();
        this.loadEquipment(vTOL, "Front", 1);
        this.loadEquipment(vTOL, "Right", 2);
        this.loadEquipment(vTOL, "Left", 3);
        this.loadEquipment(vTOL, "Rear", 4);
        this.loadEquipment(vTOL, "Body", 0);
        if (this.dataFile.exists("omni")) {
            vTOL.setOmni(true);
        }
        return vTOL;
    }
}

