/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import megamek.common.AmmoType;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mounted;
import megamek.common.Tank;
import megamek.common.TroopSpace;
import megamek.common.VTOL;
import megamek.common.WeaponType;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.HMVArmorType;
import megamek.common.loaders.HMVEngineType;
import megamek.common.loaders.HMVMovementType;
import megamek.common.loaders.HMVTechType;
import megamek.common.loaders.HMVWeaponLocation;
import megamek.common.loaders.IMechLoader;

public class HmvFile
implements IMechLoader {
    private String name;
    private String model;
    private HMVMovementType movementType;
    private int rulesLevel;
    private int year;
    private boolean isOmni = false;
    private HMVTechType techType;
    private HMVTechType engineTechType;
    private HMVTechType baseTechType;
    private HMVTechType targetingComputerTechType;
    private int engineRating;
    private HMVEngineType engineType;
    private int cruiseMP;
    private int jumpMP;
    private HMVArmorType armorType;
    private int roundedInternalStructure;
    private int turretArmor;
    private int frontArmor;
    private int leftArmor;
    private int rightArmor;
    private int rearArmor;
    private int artemisType;
    private Hashtable<HMVWeaponLocation, Hashtable<EquipmentType, Integer>> equipment = new Hashtable();
    private float troopSpace = 0.0f;
    private String fluff;
    private List<String> failedEquipment = new ArrayList<String>();
    private boolean hasTurret = false;
    private static final Hashtable<HMVTechType, Hashtable<Long, String>> EQUIPMENT = new Hashtable();
    private static final Hashtable<HMVTechType, Hashtable<Long, String>> AMMO = new Hashtable();

    public HmvFile(InputStream inputStream) throws EntityLoadingException {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[5];
            dataInputStream.read(byArray);
            dataInputStream.skipBytes(2);
            int n7 = this.readUnsignedShort(dataInputStream);
            this.movementType = HMVMovementType.getType(n7);
            if (null == this.movementType) {
                throw new EntityLoadingException("Could not locate movement type for " + n7 + ".");
            }
            dataInputStream.skipBytes(12);
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.name = new String(byArray);
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.model = new String(byArray);
            this.rulesLevel = this.readUnsignedShort(dataInputStream);
            this.year = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(32);
            int n8 = this.readUnsignedShort(dataInputStream);
            byte[] byArray2 = new byte[n8];
            dataInputStream.read(byArray2);
            this.isOmni = this.containsOmni(byArray2);
            this.techType = HMVTechType.getType(this.readUnsignedShort(dataInputStream));
            if (this.techType.equals(HMVTechType.MIXED)) {
                this.baseTechType = HMVTechType.getType(this.readUnsignedShort(dataInputStream));
                this.engineTechType = HMVTechType.getType(this.readUnsignedShort(dataInputStream));
                this.targetingComputerTechType = HMVTechType.getType(this.readUnsignedShort(dataInputStream));
                this.readUnsignedShort(dataInputStream);
            } else if (this.techType.equals(HMVTechType.CLAN)) {
                this.engineTechType = HMVTechType.CLAN;
                this.baseTechType = HMVTechType.CLAN;
                this.targetingComputerTechType = HMVTechType.CLAN;
            } else {
                this.engineTechType = HMVTechType.INNER_SPHERE;
                this.baseTechType = HMVTechType.INNER_SPHERE;
                this.targetingComputerTechType = HMVTechType.INNER_SPHERE;
            }
            dataInputStream.skipBytes(4);
            this.engineRating = this.readUnsignedShort(dataInputStream);
            this.engineType = HMVEngineType.getType(this.readUnsignedShort(dataInputStream));
            this.cruiseMP = this.readUnsignedShort(dataInputStream);
            this.jumpMP = this.readUnsignedShort(dataInputStream);
            this.readUnsignedShort(dataInputStream);
            this.armorType = HMVArmorType.getType(this.readUnsignedShort(dataInputStream));
            this.roundedInternalStructure = this.readUnsignedShort(dataInputStream);
            this.turretArmor = this.readUnsignedShort(dataInputStream);
            if (this.turretArmor > 0) {
                this.hasTurret = true;
            }
            dataInputStream.skipBytes(2);
            this.frontArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(2);
            this.leftArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(2);
            this.rightArmor = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(2);
            this.rearArmor = this.readUnsignedShort(dataInputStream);
            if (this.isOmni) {
                dataInputStream.skipBytes(12);
                n6 = this.readUnsignedShort(dataInputStream);
                if (n6 == 2) {
                    dataInputStream.skipBytes(12);
                }
            } else {
                dataInputStream.skipBytes(14);
            }
            n6 = this.readUnsignedShort(dataInputStream);
            for (n5 = 1; n5 <= n6; ++n5) {
                n4 = this.readUnsignedShort(dataInputStream);
                int n9 = this.readUnsignedShort(dataInputStream);
                dataInputStream.skipBytes(this.readUnsignedShort(dataInputStream));
                HMVWeaponLocation hMVWeaponLocation = HMVWeaponLocation.getType(this.readUnsignedShort(dataInputStream));
                if (hMVWeaponLocation == HMVWeaponLocation.TURRET) {
                    this.hasTurret = true;
                }
                n3 = this.readUnsignedShort(dataInputStream);
                EquipmentType equipmentType = this.getEquipmentType(n9, this.techType);
                if (equipmentType != null) {
                    AmmoType ammoType;
                    this.addEquipmentType(equipmentType, n4, hMVWeaponLocation);
                    if (n3 > 0 && (ammoType = this.getAmmoType(n9, this.techType)) != null) {
                        if (n3 < ammoType.getShots() || n3 % ammoType.getShots() > 0) {
                            switch (ammoType.getAmmoType()) {
                                case 3: {
                                    if (ammoType.getTechLevel() == 0) {
                                        ammoType = (AmmoType)EquipmentType.get("ISMG Ammo (100)");
                                        break;
                                    }
                                    ammoType = (AmmoType)EquipmentType.get("CLMG Ammo (100)");
                                    break;
                                }
                                case 5: {
                                    ammoType = (AmmoType)EquipmentType.get("CLLightMG Ammo (100)");
                                    break;
                                }
                                case 4: {
                                    ammoType = (AmmoType)EquipmentType.get("CLHeavyMG Ammo (50)");
                                    break;
                                }
                                default: {
                                    throw new EntityLoadingException(ammoType.getName() + " has " + ammoType.getShots() + " shots per ton, but " + this.name + " " + this.model + " wants " + n3 + " shots.");
                                }
                            }
                        }
                        this.addEquipmentType(ammoType, n3 / ammoType.getShots(), HMVWeaponLocation.BODY);
                    }
                }
                dataInputStream.skipBytes(4);
            }
            n5 = this.readUnsignedShort(dataInputStream);
            for (n4 = 0; n4 < n5; ++n4) {
                float f = this.readFloat(dataInputStream);
                dataInputStream.skipBytes(this.readUnsignedShort(dataInputStream));
                this.troopSpace += f;
            }
            dataInputStream.skipBytes(12);
            n4 = this.readUnsignedShort(dataInputStream);
            if (n4 == 65535) {
                if (this.techType.equals(HMVTechType.INNER_SPHERE)) {
                    this.addEquipmentType(EquipmentType.get("ISCASE"), 1, HMVWeaponLocation.REAR);
                } else {
                    this.addEquipmentType(EquipmentType.get("CLCASE"), 1, HMVWeaponLocation.REAR);
                }
            }
            if ((n2 = this.readUnsignedShort(dataInputStream)) == 1) {
                if (this.targetingComputerTechType.equals(HMVTechType.CLAN)) {
                    this.addEquipmentType(EquipmentType.get("CLTargeting Computer"), 1, HMVWeaponLocation.BODY);
                } else {
                    this.addEquipmentType(EquipmentType.get("ISTargeting Computer"), 1, HMVWeaponLocation.BODY);
                }
            }
            this.artemisType = this.readUnsignedShort(dataInputStream);
            dataInputStream.skipBytes(4);
            int n10 = this.readUnsignedShort(dataInputStream);
            n3 = n10 / 100;
            if (n3 == 1) {
                if (this.baseTechType.equals(HMVTechType.CLAN)) {
                    this.addEquipmentType(EquipmentType.get("CLActiveProbe"), 1, HMVWeaponLocation.TURRET);
                } else {
                    this.addEquipmentType(EquipmentType.get("BeagleActiveProbe"), 1, HMVWeaponLocation.TURRET);
                }
            } else if (n3 == 2) {
                if (this.baseTechType.equals(HMVTechType.CLAN)) {
                    this.addEquipmentType(EquipmentType.get("CLLightActiveProbe"), 1, HMVWeaponLocation.TURRET);
                } else {
                    this.addEquipmentType(EquipmentType.get("BloodhoundActiveProbe"), 1, HMVWeaponLocation.TURRET);
                }
            } else if (n3 == 3) {
                this.addEquipmentType(EquipmentType.get("ISC3SlaveUnit"), 1, HMVWeaponLocation.TURRET);
            }
            dataInputStream.skipBytes(4);
            int n11 = 0;
            this.fluff = "Overview:\n\r";
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.fluff = this.fluff + new String(byArray);
            n11 += new String(byArray).length();
            this.fluff = this.fluff + "\n\rCapability:\n\r";
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.fluff = this.fluff + new String(byArray);
            n11 += new String(byArray).length();
            this.fluff = this.fluff + "\n\rBattle History:\n\r";
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.fluff = this.fluff + new String(byArray);
            n11 += new String(byArray).length();
            this.fluff = this.fluff + "\n\rVariants:\n\r";
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.fluff = this.fluff + new String(byArray);
            n11 += new String(byArray).length();
            this.fluff = this.fluff + "\n\rFamous Vehicles and Pilots:\n\r";
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.fluff = this.fluff + new String(byArray);
            n11 += new String(byArray).length();
            this.fluff = this.fluff + "\n\rDeployment:\n\r";
            byArray = new byte[this.readUnsignedShort(dataInputStream)];
            dataInputStream.read(byArray);
            this.fluff = this.fluff + new String(byArray);
            dataInputStream.skipBytes(this.readUnsignedShort(dataInputStream));
            if ((n11 += new String(byArray).length()) <= 60) {
                this.fluff = null;
            }
            if ((n = this.readUnsignedShort(dataInputStream)) > 0) {
                this.addEquipmentType(EquipmentType.get("Supercharger"), 1, HMVWeaponLocation.BODY);
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new EntityLoadingException("I/O Error reading file");
        }
    }

    private short readUnsignedByte(DataInputStream dataInputStream) throws IOException {
        short s;
        s = (short)(s + ((s = (short)dataInputStream.readByte()) < 0 ? 256 : 0));
        return s;
    }

    private int readUnsignedShort(DataInputStream dataInputStream) throws IOException {
        short s = this.readUnsignedByte(dataInputStream);
        int n = this.readUnsignedByte(dataInputStream);
        return (n <<= 8) + s;
    }

    private float readFloat(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        n = (n & 0xFF000000) >> 24 | (n & 0xFF0000) >> 8 | (n & 0xFF00) << 8 | (n & 0xFF) << 24;
        return Float.intBitsToFloat(n);
    }

    private boolean containsOmni(byte[] byArray) {
        for (int i = byArray.length - 4; i >= 0; --i) {
            if (111 != byArray[i] || 109 != byArray[i + 1] || 110 != byArray[i + 2] || 105 != byArray[i + 3]) continue;
            return true;
        }
        return false;
    }

    public Entity getEntity() throws EntityLoadingException {
        try {
            Tank tank = null;
            if (this.movementType == HMVMovementType.TRACKED || this.movementType == HMVMovementType.WHEELED || this.movementType == HMVMovementType.HOVER || this.movementType == HMVMovementType.DISPLACEMENT_HULL || this.movementType == HMVMovementType.HYDROFOIL || this.movementType == HMVMovementType.SUBMARINE) {
                tank = new Tank();
            } else if (this.movementType == HMVMovementType.VTOL) {
                tank = new VTOL();
            } else {
                throw new EntityLoadingException("Unsupported vehicle movement type:" + this.movementType);
            }
            tank.setChassis(this.name);
            tank.setModel(this.model);
            tank.setYear(this.year);
            tank.setOmni(this.isOmni);
            tank.setFluff(this.fluff);
            int n = 5;
            if (this.rulesLevel == 1) {
                n = 0;
            } else if (this.rulesLevel == 2) {
                n = this.techType == HMVTechType.CLAN ? 2 : 1;
            } else if (this.techType == HMVTechType.CLAN) {
                n = 6;
            }
            tank.setTechLevel(n);
            if (tank instanceof VTOL) {
                tank.setMovementMode(6);
            } else {
                tank.setMovementMode(this.movementType == HMVMovementType.DISPLACEMENT_HULL ? 7 : (this.movementType == HMVMovementType.HYDROFOIL ? 8 : (this.movementType == HMVMovementType.HOVER ? 5 : (this.movementType == HMVMovementType.WHEELED ? 4 : (this.movementType == HMVMovementType.SUBMARINE ? 9 : 3)))));
            }
            tank.setWeight(this.roundedInternalStructure * 10);
            int n2 = tank.getSuspensionFactor();
            tank.setWeight((this.engineRating + n2) / this.cruiseMP);
            int n3 = 2;
            if (this.techType == HMVTechType.CLAN || this.engineTechType == HMVTechType.CLAN) {
                n3 |= 1;
            }
            tank.setEngine(new Engine(this.engineRating, Engine.getEngineTypeByString(this.engineType.toString()), n3));
            tank.setOriginalJumpMP(this.jumpMP);
            tank.setHasNoTurret(!this.hasTurret);
            tank.autoSetInternal();
            tank.setArmorType(this.armorType.toString());
            tank.initializeArmor(this.frontArmor, 1);
            tank.initializeArmor(this.leftArmor, 3);
            tank.initializeArmor(this.rightArmor, 2);
            tank.initializeArmor(this.rearArmor, 4);
            if (tank instanceof VTOL) {
                tank.initializeArmor(this.turretArmor, 5);
            } else if (!tank.hasNoTurret()) {
                tank.initializeArmor(this.turretArmor, 5);
            }
            this.addEquipment(tank, HMVWeaponLocation.FRONT, 1);
            this.addEquipment(tank, HMVWeaponLocation.LEFT, 3);
            this.addEquipment(tank, HMVWeaponLocation.RIGHT, 2);
            this.addEquipment(tank, HMVWeaponLocation.REAR, 4);
            if (!tank.hasNoTurret()) {
                this.addEquipment(tank, HMVWeaponLocation.TURRET, 5);
            }
            this.addEquipment(tank, HMVWeaponLocation.BODY, 0);
            int n4 = (int)Math.round(Math.floor(this.troopSpace));
            if (n4 > 0) {
                tank.addTransporter(new TroopSpace(n4));
            }
            this.addFailedEquipment(tank);
            return tank;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new EntityLoadingException(exception.getMessage());
        }
    }

    private void addEquipmentType(EquipmentType equipmentType, int n, HMVWeaponLocation hMVWeaponLocation) {
        Integer n2;
        Hashtable<EquipmentType, Integer> hashtable = this.equipment.get(hMVWeaponLocation);
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.equipment.put(hMVWeaponLocation, hashtable);
        }
        if (null != (n2 = hashtable.get(equipmentType))) {
            n += n2.intValue();
        }
        hashtable.put(equipmentType, new Integer(n));
    }

    private void addEquipment(Tank tank, HMVWeaponLocation hMVWeaponLocation, int n) throws Exception {
        Hashtable<EquipmentType, Integer> hashtable = this.equipment.get(hMVWeaponLocation);
        if (hashtable != null) {
            Enumeration<EquipmentType> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                EquipmentType equipmentType = enumeration.nextElement();
                Integer n2 = hashtable.get(equipmentType);
                for (int i = 0; i < n2; ++i) {
                    EquipmentType equipmentType2;
                    if (equipmentType.getTechLevel() > tank.getTechLevel() && tank.getTechLevel() >= 5) {
                        boolean bl = tank.isClan();
                        if (equipmentType.getTechLevel() == 7 || equipmentType.getTechLevel() == 8) {
                            tank.setTechLevel(bl ? 8 : 7);
                        } else if (equipmentType.getTechLevel() == 9 || equipmentType.getTechLevel() == 10) {
                            tank.setTechLevel(bl ? 10 : 9);
                        }
                    }
                    Mounted mounted = tank.addEquipment(equipmentType, n);
                    if (this.artemisType == 0 || !(equipmentType instanceof WeaponType)) continue;
                    String string = null;
                    int n3 = ((WeaponType)equipmentType).getAmmoType();
                    if (n3 == 7) {
                        if ((this.artemisType & 2) == 2) {
                            string = "ArtemisIV";
                        } else if ((this.artemisType & 8) == 8) {
                            string = "ArtemisV";
                        }
                    } else if (n3 == 9) {
                        if ((this.artemisType & 1) == 1) {
                            string = "ArtemisIV";
                        } else if ((this.artemisType & 4) == 4) {
                            string = "ArtemisV";
                        }
                    }
                    if (string == null || (equipmentType2 = equipmentType.getTechLevel() == 2 || equipmentType.getTechLevel() == 6 ? EquipmentType.get("CL" + string) : EquipmentType.get("IS" + string)) == null) continue;
                    Mounted mounted2 = tank.addEquipment(equipmentType2, n);
                    mounted2.setLinked(mounted);
                }
            }
        }
    }

    private void addFailedEquipment(Tank tank) {
        for (String string : this.failedEquipment) {
            tank.addFailedEquipment(string);
        }
    }

    private String getEquipmentName(long l, HMVTechType hMVTechType) {
        return this.getEquipmentName(new Long(l), hMVTechType);
    }

    private String getEquipmentName(Long l, HMVTechType hMVTechType) {
        Hashtable<Long, String> hashtable;
        if (l > 32767L) {
            l = new Long((long)(l & 0xFFFFL));
        }
        long l2 = l;
        String string = null;
        try {
            string = EQUIPMENT.get(hMVTechType).get(l);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string == null && (hashtable = EQUIPMENT.get(hMVTechType)) != null) {
            string = hashtable.get(l);
        }
        if (string == null && l2 != 0L && l2 != 7L && l2 != 8L && l2 != 15L) {
            System.out.print("unknown critical: 0x");
            System.out.print(Integer.toHexString(l.intValue()).toUpperCase());
            System.out.print(" (");
            System.out.print(hMVTechType);
            System.out.println(")");
        }
        return string;
    }

    private EquipmentType getEquipmentType(long l, HMVTechType hMVTechType) {
        EquipmentType equipmentType = null;
        String string = this.getEquipmentName(l, hMVTechType);
        if (string != null) {
            equipmentType = EquipmentType.get(string);
            if (equipmentType == null) {
                this.failedEquipment.add(string);
            }
        } else {
            this.failedEquipment.add("Unknown Equipment (" + Long.toHexString(l) + ")");
        }
        return equipmentType;
    }

    private String getAmmoName(long l, HMVTechType hMVTechType) {
        return this.getAmmoName(new Long(l), hMVTechType);
    }

    private String getAmmoName(Long l, HMVTechType hMVTechType) {
        Hashtable<Long, String> hashtable;
        if (l > 32767L) {
            l = new Long((long)(l & 0xFFFFL));
        }
        long l2 = l;
        String string = null;
        try {
            string = AMMO.get(hMVTechType).get(this.equipment);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string == null && (hashtable = AMMO.get(hMVTechType)) != null) {
            string = hashtable.get(l);
        }
        if (string == null && l2 != 0L) {
            System.out.print("unknown critical: 0x");
            System.out.print(Integer.toHexString(l.intValue()).toUpperCase());
            System.out.print(" (");
            System.out.print(hMVTechType);
            System.out.println(")");
        }
        return string;
    }

    private AmmoType getAmmoType(long l, HMVTechType hMVTechType) {
        AmmoType ammoType = null;
        String string = this.getAmmoName(l, hMVTechType);
        if (string != null) {
            ammoType = (AmmoType)EquipmentType.get(string);
        }
        return ammoType;
    }

    static {
        Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
        EQUIPMENT.put(HMVTechType.INNER_SPHERE, hashtable);
        hashtable.put(new Long(10L), "ISDouble Heat Sink");
        hashtable.put(new Long(11L), "Jump Jet");
        hashtable.put(new Long(18L), "ISTargeting Computer");
        hashtable.put(new Long(20L), "Endo Steel");
        hashtable.put(new Long(21L), "Ferro-Fibrous");
        hashtable.put(new Long(23L), "ISMASC");
        hashtable.put(new Long(24L), "ISArtemisIV");
        hashtable.put(new Long(25L), "ISCASE");
        hashtable.put(new Long(51L), "ISERLargeLaser");
        hashtable.put(new Long(52L), "ISERPPC");
        hashtable.put(new Long(53L), "ISFlamer");
        hashtable.put(new Long(54L), "ISLaserAMS");
        hashtable.put(new Long(55L), "ISLargeLaser");
        hashtable.put(new Long(56L), "ISMediumLaser");
        hashtable.put(new Long(57L), "ISSmallLaser");
        hashtable.put(new Long(58L), "ISPPC");
        hashtable.put(new Long(59L), "ISLargePulseLaser");
        hashtable.put(new Long(60L), "ISMediumPulseLaser");
        hashtable.put(new Long(61L), "ISSmallPulseLaser");
        hashtable.put(new Long(62L), "ISAC2");
        hashtable.put(new Long(63L), "ISAC5");
        hashtable.put(new Long(64L), "ISAC10");
        hashtable.put(new Long(65L), "ISAC20");
        hashtable.put(new Long(66L), "ISAntiMissileSystem");
        hashtable.put(new Long(67L), "Long Tom Cannon");
        hashtable.put(new Long(68L), "Sniper Cannon");
        hashtable.put(new Long(69L), "Thumper Cannon");
        hashtable.put(new Long(70L), "ISLightGaussRifle");
        hashtable.put(new Long(71L), "ISGaussRifle");
        hashtable.put(new Long(72L), "ISLargeXPulseLaser");
        hashtable.put(new Long(73L), "ISMediumXPulseLaser");
        hashtable.put(new Long(74L), "ISSmallXPulseLaser");
        hashtable.put(new Long(75L), "ISLBXAC2");
        hashtable.put(new Long(76L), "ISLBXAC5");
        hashtable.put(new Long(77L), "ISLBXAC10");
        hashtable.put(new Long(78L), "ISLBXAC20");
        hashtable.put(new Long(79L), "ISMachine Gun");
        hashtable.put(new Long(80L), "ISLAC2");
        hashtable.put(new Long(81L), "ISLAC5");
        hashtable.put(new Long(82L), "ISHeavyFlamer");
        hashtable.put(new Long(83L), "ISPPCCapacitor");
        hashtable.put(new Long(84L), "ISUltraAC2");
        hashtable.put(new Long(85L), "ISUltraAC5");
        hashtable.put(new Long(86L), "ISUltraAC10");
        hashtable.put(new Long(87L), "ISUltraAC20");
        hashtable.put(new Long(89L), "ISPPCCapacitor");
        hashtable.put(new Long(90L), "ISERMediumLaser");
        hashtable.put(new Long(91L), "ISERSmallLaser");
        hashtable.put(new Long(92L), "ISAntiPersonnelPod");
        hashtable.put(new Long(96L), "ISLRM5");
        hashtable.put(new Long(97L), "ISLRM10");
        hashtable.put(new Long(98L), "ISLRM15");
        hashtable.put(new Long(99L), "ISLRM20");
        hashtable.put(new Long(102L), "ISImprovedNarc");
        hashtable.put(new Long(103L), "ISSRM2");
        hashtable.put(new Long(104L), "ISSRM4");
        hashtable.put(new Long(105L), "ISSRM6");
        hashtable.put(new Long(106L), "ISStreakSRM2");
        hashtable.put(new Long(107L), "ISStreakSRM4");
        hashtable.put(new Long(108L), "ISStreakSRM6");
        hashtable.put(new Long(109L), "ISThunderbolt5");
        hashtable.put(new Long(110L), "ISThunderbolt10");
        hashtable.put(new Long(111L), "ISThunderbolt15");
        hashtable.put(new Long(112L), "ISThunderbolt20");
        hashtable.put(new Long(113L), "ISArrowIVSystem");
        hashtable.put(new Long(114L), "ISAngelECMSuite");
        hashtable.put(new Long(115L), "ISBeagleActiveProbe");
        hashtable.put(new Long(116L), "ISBloodhoundActiveProbe");
        hashtable.put(new Long(117L), "ISC3MasterComputer");
        hashtable.put(new Long(118L), "ISC3SlaveUnit");
        hashtable.put(new Long(119L), "ISImprovedC3CPU");
        hashtable.put(new Long(120L), "ISGuardianECM");
        hashtable.put(new Long(121L), "ISNarcBeacon");
        hashtable.put(new Long(122L), "ISTAG");
        hashtable.put(new Long(123L), "ISLRM5 (OS)");
        hashtable.put(new Long(124L), "ISLRM10 (OS)");
        hashtable.put(new Long(125L), "ISLRM15 (OS)");
        hashtable.put(new Long(126L), "ISLRM20 (OS)");
        hashtable.put(new Long(127L), "ISSRM2 (OS)");
        hashtable.put(new Long(128L), "ISSRM4 (OS)");
        hashtable.put(new Long(129L), "ISSRM6 (OS)");
        hashtable.put(new Long(130L), "ISStreakSRM2 (OS)");
        hashtable.put(new Long(131L), "ISStreakSRM4 (OS)");
        hashtable.put(new Long(132L), "ISStreakSRM6 (OS)");
        hashtable.put(new Long(133L), "ISVehicleFlamer");
        hashtable.put(new Long(134L), "ISLongTomArtillery");
        hashtable.put(new Long(135L), "ISSniperArtillery");
        hashtable.put(new Long(136L), "ISThumperArtillery");
        hashtable.put(new Long(137L), "ISMRM10");
        hashtable.put(new Long(138L), "ISMRM20");
        hashtable.put(new Long(139L), "ISMRM30");
        hashtable.put(new Long(140L), "ISMRM40");
        hashtable.put(new Long(142L), "ISMRM10 (OS)");
        hashtable.put(new Long(143L), "ISMRM20 (OS)");
        hashtable.put(new Long(144L), "ISMRM30 (OS)");
        hashtable.put(new Long(145L), "ISMRM40 (OS)");
        hashtable.put(new Long(146L), "ISLRTorpedo5");
        hashtable.put(new Long(147L), "ISLRTorpedo10");
        hashtable.put(new Long(148L), "ISLRTorpedo15");
        hashtable.put(new Long(149L), "ISLRTorpedo20");
        hashtable.put(new Long(150L), "ISSRT2");
        hashtable.put(new Long(151L), "ISSRT4");
        hashtable.put(new Long(152L), "ISSRT6");
        hashtable.put(new Long(153L), "ISLRM5 (I-OS)");
        hashtable.put(new Long(154L), "ISLRM10 (I-OS)");
        hashtable.put(new Long(155L), "ISLRM15 (I-OS)");
        hashtable.put(new Long(156L), "ISLRM20 (I-OS)");
        hashtable.put(new Long(157L), "ISSRM2 (I-OS)");
        hashtable.put(new Long(158L), "ISSRM4 (I-OS)");
        hashtable.put(new Long(159L), "ISSRM6 (I-OS)");
        hashtable.put(new Long(160L), "ISStreakSRM2 (I-OS)");
        hashtable.put(new Long(161L), "ISStreakSRM4 (I-OS)");
        hashtable.put(new Long(162L), "ISStreakSRM6 (I-OS)");
        hashtable.put(new Long(163L), "ISMRM10 (I-OS)");
        hashtable.put(new Long(164L), "ISMRM20 (I-OS)");
        hashtable.put(new Long(165L), "ISMRM30 (I-OS)");
        hashtable.put(new Long(166L), "ISMRM40 (I-OS)");
        hashtable.put(new Long(264L), "ISTHBLBXAC2");
        hashtable.put(new Long(265L), "ISTHBLBXAC5");
        hashtable.put(new Long(266L), "ISTHBLBXAC20");
        hashtable.put(new Long(267L), "ISUltraAC2 (THB)");
        hashtable.put(new Long(268L), "ISUltraAC10 (THB)");
        hashtable.put(new Long(269L), "ISUltraAC20 (THB)");
        hashtable.put(new Long(285L), "ISTHBAngelECMSuite");
        hashtable.put(new Long(286L), "ISTHBBloodhoundActiveProbe");
        hashtable.put(new Long(289L), "ISRotaryAC2");
        hashtable.put(new Long(290L), "ISRotaryAC5");
        hashtable.put(new Long(291L), "ISHeavyGaussRifle");
        hashtable.put(new Long(299L), "ISRocketLauncher10");
        hashtable.put(new Long(300L), "ISRocketLauncher15");
        hashtable.put(new Long(301L), "ISRocketLauncher20");
        Hashtable<Long, String> hashtable2 = new Hashtable<Long, String>();
        AMMO.put(HMVTechType.INNER_SPHERE, hashtable2);
        hashtable2.put(new Long(62L), "ISAC2 Ammo");
        hashtable2.put(new Long(63L), "ISAC5 Ammo");
        hashtable2.put(new Long(64L), "ISAC10 Ammo");
        hashtable2.put(new Long(65L), "ISAC20 Ammo");
        hashtable2.put(new Long(66L), "ISAMS Ammo");
        hashtable2.put(new Long(67L), "Long Tom Cannon Ammo");
        hashtable2.put(new Long(68L), "Sniper Cannon Ammo");
        hashtable2.put(new Long(69L), "Thumper Cannon Ammo");
        hashtable2.put(new Long(70L), "ISLightGauss Ammo");
        hashtable2.put(new Long(71L), "ISGauss Ammo");
        hashtable2.put(new Long(75L), "ISLBXAC2 Ammo");
        hashtable2.put(new Long(76L), "ISLBXAC5 Ammo");
        hashtable2.put(new Long(77L), "ISLBXAC10 Ammo");
        hashtable2.put(new Long(78L), "ISLBXAC20 Ammo");
        hashtable2.put(new Long(79L), "ISMG Ammo (200)");
        hashtable2.put(new Long(80L), "ISLAC2 Ammo");
        hashtable2.put(new Long(81L), "ISLAC5 Ammo");
        hashtable2.put(new Long(82L), "ISHeavyFlamer Ammo");
        hashtable2.put(new Long(84L), "ISUltraAC2 Ammo");
        hashtable2.put(new Long(85L), "ISUltraAC5 Ammo");
        hashtable2.put(new Long(86L), "ISUltraAC10 Ammo");
        hashtable2.put(new Long(87L), "ISUltraAC20 Ammo");
        hashtable2.put(new Long(96L), "ISLRM5 Ammo");
        hashtable2.put(new Long(97L), "ISLRM10 Ammo");
        hashtable2.put(new Long(98L), "ISLRM15 Ammo");
        hashtable2.put(new Long(99L), "ISLRM20 Ammo");
        hashtable2.put(new Long(102L), "ISiNarc Pods");
        hashtable2.put(new Long(103L), "ISSRM2 Ammo");
        hashtable2.put(new Long(104L), "ISSRM4 Ammo");
        hashtable2.put(new Long(105L), "ISSRM6 Ammo");
        hashtable2.put(new Long(106L), "ISStreakSRM2 Ammo");
        hashtable2.put(new Long(107L), "ISStreakSRM4 Ammo");
        hashtable2.put(new Long(108L), "ISStreakSRM6 Ammo");
        hashtable2.put(new Long(109L), "ISThunderbolt5 Ammo");
        hashtable2.put(new Long(110L), "ISThunderbolt10 Ammo");
        hashtable2.put(new Long(111L), "ISThunderbolt15 Ammo");
        hashtable2.put(new Long(112L), "ISThunderbolt20 Ammo");
        hashtable2.put(new Long(113L), "ISArrowIV Ammo");
        hashtable2.put(new Long(121L), "ISNarc Pods");
        hashtable2.put(new Long(133L), "ISVehicleFlamer Ammo");
        hashtable2.put(new Long(134L), "ISLongTom Ammo");
        hashtable2.put(new Long(135L), "ISSniper Ammo");
        hashtable2.put(new Long(136L), "ISThumper Ammo");
        hashtable2.put(new Long(137L), "ISMRM10 Ammo");
        hashtable2.put(new Long(138L), "ISMRM20 Ammo");
        hashtable2.put(new Long(139L), "ISMRM30 Ammo");
        hashtable2.put(new Long(140L), "ISMRM40 Ammo");
        hashtable2.put(new Long(146L), "ISLRTorpedo5 Ammo");
        hashtable2.put(new Long(147L), "ISLRTorpedo10 Ammo");
        hashtable2.put(new Long(148L), "ISLRTorpedo15 Ammo");
        hashtable2.put(new Long(149L), "ISLRTorpedo20 Ammo");
        hashtable2.put(new Long(150L), "ISSRT2 Ammo");
        hashtable2.put(new Long(151L), "ISSRT4 Ammo");
        hashtable2.put(new Long(152L), "ISSRT6 Ammo");
        hashtable2.put(new Long(264L), "ISTHBLBXAC2 Ammo");
        hashtable2.put(new Long(265L), "ISTHBLBXAC5 Ammo");
        hashtable2.put(new Long(266L), "ISTHBLBXAC20 Ammo");
        hashtable2.put(new Long(267L), "ISUltraAC2 (THB) Ammo");
        hashtable2.put(new Long(268L), "ISUltraAC10 (THB) Ammo");
        hashtable2.put(new Long(269L), "ISUltraAC20 (THB) Ammo");
        hashtable2.put(new Long(289L), "ISRotaryAC2 Ammo");
        hashtable2.put(new Long(290L), "ISRotaryAC5 Ammo");
        hashtable2.put(new Long(291L), "ISHeavyGauss Ammo");
        Hashtable<Long, String> hashtable3 = new Hashtable<Long, String>();
        EQUIPMENT.put(HMVTechType.CLAN, hashtable3);
        hashtable3.put(new Long(10L), "CLDouble Heat Sink");
        hashtable3.put(new Long(11L), "Jump Jet");
        hashtable3.put(new Long(18L), "CLTargeting Computer");
        hashtable3.put(new Long(20L), "Endo Steel");
        hashtable3.put(new Long(21L), "Ferro-Fibrous");
        hashtable3.put(new Long(23L), "CLMASC");
        hashtable3.put(new Long(24L), "CLArtemisIV");
        hashtable3.put(new Long(51L), "CLERLargeLaser");
        hashtable3.put(new Long(52L), "CLERMediumLaser");
        hashtable3.put(new Long(53L), "CLERSmallLaser");
        hashtable3.put(new Long(54L), "CLERPPC");
        hashtable3.put(new Long(57L), "CLSmallLaser");
        hashtable3.put(new Long(55L), "CLFlamer");
        hashtable3.put(new Long(56L), "CLMediumLaser");
        hashtable3.put(new Long(58L), "CLPPC");
        hashtable3.put(new Long(60L), "CLLargePulseLaser");
        hashtable3.put(new Long(61L), "CLMediumPulseLaser");
        hashtable3.put(new Long(62L), "CLSmallPulseLaser");
        hashtable3.put(new Long(63L), "CLAngelECMSuite");
        hashtable3.put(new Long(64L), "CLAntiMissileSystem");
        hashtable3.put(new Long(65L), "CLGaussRifle");
        hashtable3.put(new Long(66L), "CLLBXAC2");
        hashtable3.put(new Long(67L), "CLLBXAC5");
        hashtable3.put(new Long(68L), "CLLBXAC10");
        hashtable3.put(new Long(69L), "CLLBXAC20");
        hashtable3.put(new Long(70L), "CLMG");
        hashtable3.put(new Long(71L), "CLUltraAC2");
        hashtable3.put(new Long(72L), "CLUltraAC5");
        hashtable3.put(new Long(73L), "CLUltraAC10");
        hashtable3.put(new Long(74L), "CLUltraAC20");
        hashtable3.put(new Long(75L), "CLLRM5");
        hashtable3.put(new Long(76L), "CLLRM10");
        hashtable3.put(new Long(77L), "CLLRM15");
        hashtable3.put(new Long(78L), "CLLRM20");
        hashtable3.put(new Long(79L), "CLSRM2");
        hashtable3.put(new Long(80L), "CLSRM4");
        hashtable3.put(new Long(81L), "CLSRM6");
        hashtable3.put(new Long(82L), "CLStreakSRM2");
        hashtable3.put(new Long(83L), "CLStreakSRM4");
        hashtable3.put(new Long(84L), "CLStreakSRM6");
        hashtable3.put(new Long(85L), "CLArrowIVSystem");
        hashtable3.put(new Long(86L), "CLAntiPersonnelPod");
        hashtable3.put(new Long(87L), "CLActiveProbe");
        hashtable3.put(new Long(88L), "CLECMSuite");
        hashtable3.put(new Long(89L), "CLNarcBeacon");
        hashtable3.put(new Long(90L), "CLTAG");
        hashtable3.put(new Long(91L), "CLERMicroLaser");
        hashtable3.put(new Long(92L), "CLLRM5 (OS)");
        hashtable3.put(new Long(93L), "CLLRM10 (OS)");
        hashtable3.put(new Long(94L), "CLLRM15 (OS)");
        hashtable3.put(new Long(95L), "CLLRM20 (OS)");
        hashtable3.put(new Long(96L), "CLSRM2 (OS)");
        hashtable3.put(new Long(97L), "CLSRM4 (OS)");
        hashtable3.put(new Long(98L), "CLSRM6 (OS)");
        hashtable3.put(new Long(99L), "CLStreakSRM2 (OS)");
        hashtable3.put(new Long(100L), "CLStreakSRM4 (OS)");
        hashtable3.put(new Long(101L), "CLStreakSRM6 (OS)");
        hashtable3.put(new Long(102L), "CLVehicleFlamer");
        hashtable3.put(new Long(103L), "CLLongTomArtillery");
        hashtable3.put(new Long(104L), "CLSniperArtillery");
        hashtable3.put(new Long(105L), "CLThumperArtillery");
        hashtable3.put(new Long(106L), "CLLRTorpedo5");
        hashtable3.put(new Long(107L), "CLLRTorpedo10");
        hashtable3.put(new Long(108L), "CLLRTorpedo15");
        hashtable3.put(new Long(109L), "CLLRTorpedo20");
        hashtable3.put(new Long(110L), "CLSRT2");
        hashtable3.put(new Long(111L), "CLSRT4");
        hashtable3.put(new Long(112L), "CLSRT6");
        hashtable3.put(new Long(123L), "CLLRM5 (OS)");
        hashtable3.put(new Long(124L), "CLLRM10 (OS)");
        hashtable3.put(new Long(125L), "CLLRM15 (OS)");
        hashtable3.put(new Long(126L), "CLLRM20 (OS)");
        hashtable3.put(new Long(127L), "CLSRM2 (OS)");
        hashtable3.put(new Long(128L), "CLHeavyLargeLaser");
        hashtable3.put(new Long(129L), "CLHeavyMediumLaser");
        hashtable3.put(new Long(130L), "CLHeavySmallLaser");
        hashtable3.put(new Long(133L), "CLVehicleFlamer");
        hashtable3.put(new Long(146L), "CLLRTorpedo5");
        hashtable3.put(new Long(147L), "CLLRTorpedo10");
        hashtable3.put(new Long(148L), "CLLRTorpedo15");
        hashtable3.put(new Long(149L), "CLLRTorpedo20");
        hashtable3.put(new Long(150L), "CLSRT2");
        hashtable3.put(new Long(151L), "CLSRT4");
        hashtable3.put(new Long(152L), "CLSRT6");
        hashtable3.put(new Long(168L), "CLMicroPulseLaser");
        hashtable3.put(new Long(173L), "CLLightMG");
        hashtable3.put(new Long(174L), "CLHeavyMG");
        hashtable3.put(new Long(175L), "CLLightActiveProbe");
        hashtable3.put(new Long(180L), "CLLightTAG");
        hashtable3.put(new Long(252L), "CLATM3");
        hashtable3.put(new Long(253L), "CLATM6");
        hashtable3.put(new Long(254L), "CLATM9");
        hashtable3.put(new Long(255L), "CLATM12");
        Hashtable<Long, String> hashtable4 = new Hashtable<Long, String>();
        AMMO.put(HMVTechType.CLAN, hashtable4);
        hashtable4.put(new Long(64L), "CLAMS Ammo");
        hashtable4.put(new Long(65L), "CLGauss Ammo");
        hashtable4.put(new Long(66L), "CLLBXAC2 Ammo");
        hashtable4.put(new Long(67L), "CLLBXAC5 Ammo");
        hashtable4.put(new Long(68L), "CLLBXAC10 Ammo");
        hashtable4.put(new Long(69L), "CLLBXAC20 Ammo");
        hashtable4.put(new Long(70L), "CLMG Ammo (200)");
        hashtable4.put(new Long(71L), "CLUltraAC2 Ammo");
        hashtable4.put(new Long(72L), "CLUltraAC5 Ammo");
        hashtable4.put(new Long(73L), "CLUltraAC10 Ammo");
        hashtable4.put(new Long(74L), "CLUltraAC20 Ammo");
        hashtable4.put(new Long(75L), "CLLRM5 Ammo");
        hashtable4.put(new Long(76L), "CLLRM10 Ammo");
        hashtable4.put(new Long(77L), "CLLRM15 Ammo");
        hashtable4.put(new Long(78L), "CLLRM20 Ammo");
        hashtable4.put(new Long(79L), "CLSRM2 Ammo");
        hashtable4.put(new Long(80L), "CLSRM4 Ammo");
        hashtable4.put(new Long(81L), "CLSRM6 Ammo");
        hashtable4.put(new Long(82L), "CLStreakSRM2 Ammo");
        hashtable4.put(new Long(83L), "CLStreakSRM4 Ammo");
        hashtable4.put(new Long(84L), "CLStreakSRM6 Ammo");
        hashtable4.put(new Long(85L), "CLArrowIV Ammo");
        hashtable4.put(new Long(102L), "CLVehicleFlamer Ammo");
        hashtable4.put(new Long(103L), "CLLongTomArtillery Ammo");
        hashtable4.put(new Long(104L), "CLSniperArtillery Ammo");
        hashtable4.put(new Long(105L), "CLThumperArtillery Ammo");
        hashtable4.put(new Long(106L), "CLTorpedoLRM5 Ammo");
        hashtable4.put(new Long(107L), "CLTorpedoLRM10 Ammo");
        hashtable4.put(new Long(108L), "CLTorpedoLRM15 Ammo");
        hashtable4.put(new Long(109L), "CLTorpedoLRM20 Ammo");
        hashtable4.put(new Long(110L), "CLTorpedoSRM2 Ammo");
        hashtable4.put(new Long(111L), "CLTorpedoSRM4 Ammo");
        hashtable4.put(new Long(112L), "CLTorpedoSRM6 Ammo");
        hashtable4.put(new Long(133L), "CLVehicleFlamer Ammo");
        hashtable4.put(new Long(146L), "CLTorpedoLRM5 Ammo");
        hashtable4.put(new Long(147L), "CLTorpedoLRM10 Ammo");
        hashtable4.put(new Long(148L), "CLTorpedoLRM15 Ammo");
        hashtable4.put(new Long(149L), "CLTorpedoLRM20 Ammo");
        hashtable4.put(new Long(150L), "CLTorpedoSRM2 Ammo");
        hashtable4.put(new Long(151L), "CLTorpedoSRM4 Ammo");
        hashtable4.put(new Long(152L), "CLTorpedoSRM6 Ammo");
        hashtable4.put(new Long(173L), "CLLightMG Ammo (200)");
        hashtable4.put(new Long(174L), "CLHeavyMG Ammo (100)");
        hashtable4.put(new Long(252L), "CLATM3 Ammo");
        hashtable4.put(new Long(253L), "CLATM6 Ammo");
        hashtable4.put(new Long(254L), "CLATM9 Ammo");
        hashtable4.put(new Long(255L), "CLATM12 Ammo");
        Hashtable<Long, String> hashtable5 = new Hashtable<Long, String>(hashtable);
        EQUIPMENT.put(HMVTechType.MIXED, hashtable5);
        hashtable5.put(new Long(88L), "CLERMicroLaser");
        hashtable5.put(new Long(94L), "CLLightMG");
        hashtable5.put(new Long(95L), "CLHeavyMG");
        hashtable5.put(new Long(100L), "CLLightActiveProbe");
        hashtable5.put(new Long(101L), "CLLightTAG");
        hashtable5.put(new Long(167L), "CLERLargeLaser");
        hashtable5.put(new Long(168L), "CLERMediumLaser");
        hashtable5.put(new Long(169L), "CLERSmallLaser");
        hashtable5.put(new Long(170L), "CLERPPC");
        hashtable5.put(new Long(171L), "CLFlamer");
        hashtable5.put(new Long(176L), "CLLargePulseLaser");
        hashtable5.put(new Long(177L), "CLMediumPulseLaser");
        hashtable5.put(new Long(178L), "CLSmallPulseLaser");
        hashtable5.put(new Long(180L), "CLAntiMissileSystem");
        hashtable5.put(new Long(181L), "CLGaussRifle");
        hashtable5.put(new Long(182L), "CLLBXAC2");
        hashtable5.put(new Long(183L), "CLLBXAC5");
        hashtable5.put(new Long(184L), "CLLBXAC10");
        hashtable5.put(new Long(185L), "CLLBXAC20");
        hashtable5.put(new Long(186L), "CLMG");
        hashtable5.put(new Long(187L), "CLUltraAC2");
        hashtable5.put(new Long(188L), "CLUltraAC5");
        hashtable5.put(new Long(189L), "CLUltraAC10");
        hashtable5.put(new Long(190L), "CLUltraAC20");
        hashtable5.put(new Long(191L), "CLLRM5");
        hashtable5.put(new Long(192L), "CLLRM10");
        hashtable5.put(new Long(193L), "CLLRM15");
        hashtable5.put(new Long(194L), "CLLRM20");
        hashtable5.put(new Long(195L), "CLSRM2");
        hashtable5.put(new Long(196L), "CLSRM4");
        hashtable5.put(new Long(197L), "CLSRM6");
        hashtable5.put(new Long(198L), "CLStreakSRM2");
        hashtable5.put(new Long(199L), "CLStreakSRM4");
        hashtable5.put(new Long(200L), "CLStreakSRM6");
        hashtable5.put(new Long(201L), "CLArrowIVSystem");
        hashtable5.put(new Long(202L), "CLAntiPersonnelPod");
        hashtable5.put(new Long(203L), "CLActiveProbe");
        hashtable5.put(new Long(204L), "CLECMSuite");
        hashtable5.put(new Long(205L), "CLNarcBeacon");
        hashtable5.put(new Long(206L), "CLTAG");
        hashtable5.put(new Long(208L), "CLLRM5 (OS)");
        hashtable5.put(new Long(209L), "CLLRM10 (OS)");
        hashtable5.put(new Long(210L), "CLLRM15 (OS)");
        hashtable5.put(new Long(211L), "CLLRM20 (OS)");
        hashtable5.put(new Long(212L), "CLSRM2 (OS)");
        hashtable5.put(new Long(213L), "CLSRM2 (OS)");
        hashtable5.put(new Long(214L), "CLSRM2 (OS)");
        hashtable5.put(new Long(215L), "CLStreakSRM2 (OS)");
        hashtable5.put(new Long(216L), "CLStreakSRM4 (OS)");
        hashtable5.put(new Long(217L), "CLStreakSRM6 (OS)");
        hashtable5.put(new Long(218L), "CLVehicleFlamer");
        hashtable5.put(new Long(219L), "CLLongTomArtillery");
        hashtable5.put(new Long(220L), "CLSniperArtillery");
        hashtable5.put(new Long(221L), "CLThumperArtillery");
        hashtable5.put(new Long(222L), "CLLRTorpedo5");
        hashtable5.put(new Long(223L), "CLLRTorpedo10");
        hashtable5.put(new Long(224L), "CLLRTorpedo15");
        hashtable5.put(new Long(225L), "CLLRTorpedo20");
        hashtable5.put(new Long(226L), "CLSRT2");
        hashtable5.put(new Long(227L), "CLSRT4");
        hashtable5.put(new Long(228L), "CLSRT6");
        hashtable5.put(new Long(244L), "CLHeavyLargeLaser");
        hashtable5.put(new Long(245L), "CLHeavyMediumLaser");
        hashtable5.put(new Long(246L), "CLHeavySmallLaser");
        hashtable5.put(new Long(252L), "CLATM3");
        hashtable5.put(new Long(253L), "CLATM6");
        hashtable5.put(new Long(254L), "CLATM9");
        hashtable5.put(new Long(255L), "CLATM12");
        Hashtable<Long, String> hashtable6 = new Hashtable<Long, String>(hashtable2);
        AMMO.put(HMVTechType.MIXED, hashtable6);
        hashtable6.put(new Long(94L), "CLLightMG Ammo");
        hashtable6.put(new Long(95L), "CLHeavyMG Ammo");
        hashtable6.put(new Long(180L), "CLAntiMissileSystem Ammo");
        hashtable6.put(new Long(181L), "CLGaussRifle Ammo");
        hashtable6.put(new Long(182L), "CLLBXAC2 Ammo");
        hashtable6.put(new Long(183L), "CLLBXAC5 Ammo");
        hashtable6.put(new Long(184L), "CLLBXAC10 Ammo");
        hashtable6.put(new Long(185L), "CLLBXAC20 Ammo");
        hashtable6.put(new Long(186L), "CLMG Ammo");
        hashtable6.put(new Long(187L), "CLUltraAC2 Ammo");
        hashtable6.put(new Long(188L), "CLUltraAC5 Ammo");
        hashtable6.put(new Long(189L), "CLUltraAC10 Ammo");
        hashtable6.put(new Long(190L), "CLUltraAC20 Ammo");
        hashtable6.put(new Long(191L), "CLLRM5 Ammo");
        hashtable6.put(new Long(192L), "CLLRM10 Ammo");
        hashtable6.put(new Long(193L), "CLLRM15 Ammo");
        hashtable6.put(new Long(194L), "CLLRM20 Ammo");
        hashtable6.put(new Long(195L), "CLSRM2 Ammo");
        hashtable6.put(new Long(196L), "CLSRM4 Ammo");
        hashtable6.put(new Long(197L), "CLSRM6 Ammo");
        hashtable6.put(new Long(198L), "CLStreakSRM2 Ammo");
        hashtable6.put(new Long(199L), "CLStreakSRM4 Ammo");
        hashtable6.put(new Long(200L), "CLStreakSRM6 Ammo");
        hashtable6.put(new Long(201L), "CLArrowIVSystem Ammo");
        hashtable6.put(new Long(205L), "CLNarcBeacon Ammo");
        hashtable6.put(new Long(218L), "CLVehicleFlamer Ammo");
        hashtable6.put(new Long(219L), "CLLongTomArtillery Ammo");
        hashtable6.put(new Long(220L), "CLSniperArtillery Ammo");
        hashtable6.put(new Long(221L), "CLThumperArtillery Ammo");
        hashtable6.put(new Long(222L), "CLLRTorpedo5 Ammo");
        hashtable6.put(new Long(223L), "CLLRTorpedo10 Ammo");
        hashtable6.put(new Long(224L), "CLLRTorpedo15 Ammo");
        hashtable6.put(new Long(225L), "CLLRTorpedo20 Ammo");
        hashtable6.put(new Long(226L), "CLSRT2 Ammo");
        hashtable6.put(new Long(227L), "CLSRT4 Ammo");
        hashtable6.put(new Long(228L), "CLSRT6 Ammo");
    }
}

