/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.BipedMech;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LandAirMech;
import megamek.common.LocationFullException;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.WeaponType;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;

public class MtfFile
implements IMechLoader {
    String version;
    String name;
    String model;
    String chassisConfig;
    String techBase;
    String techYear;
    String rulesLevel;
    String tonnage;
    String engine;
    String internalType;
    String myomerType;
    String gyroType;
    String cockpitType;
    String heatSinks;
    String walkMP;
    String jumpMP;
    String armorType;
    String[] armorValues = new String[11];
    String weaponCount;
    String[] weaponData;
    String[][] critData;
    Hashtable<EquipmentType, Mounted> hSharedEquip = new Hashtable();
    Vector<Mounted> vSplitWeapons = new Vector();
    public static final int[] locationOrder = new int[]{5, 4, 3, 2, 1, 0, 7, 6};
    public static final int[] rearLocationOrder = new int[]{3, 2, 1};
    public static final String EMPTY = "-Empty-";

    public MtfFile(InputStream inputStream) throws EntityLoadingException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.version = bufferedReader.readLine();
            if (!this.version.trim().equalsIgnoreCase("Version:1.0") && !this.version.trim().equalsIgnoreCase("Version:1.1")) {
                throw new EntityLoadingException("Wrong MTF file version.");
            }
            this.name = bufferedReader.readLine();
            this.model = bufferedReader.readLine();
            this.critData = new String[8][12];
            this.readCrits(bufferedReader);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new EntityLoadingException("I/O Error reading file");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            stringIndexOutOfBoundsException.printStackTrace();
            throw new EntityLoadingException("StringIndexOutOfBoundsException reading file (format error)");
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new EntityLoadingException("NumberFormatException reading file (format error)");
        }
    }

    private void readCrits(BufferedReader bufferedReader) throws IOException {
        int n = 0;
        int n2 = 0;
        String string = "";
        int n3 = -1;
        int n4 = -1;
        while (bufferedReader.ready()) {
            string = bufferedReader.readLine();
            if (string.trim().length() < 1) continue;
            if (this.isValidLocation(string)) {
                n2 = this.getLocation(string);
                n = 0;
                continue;
            }
            if (this.isProcessedComponent(string)) continue;
            n3 = this.weaponsList(string);
            if (n3 > 0) {
                for (int i = 0; i < n3; ++i) {
                    bufferedReader.readLine();
                }
                continue;
            }
            n4 = this.getArmorLocation(string);
            if (n4 >= 0) {
                this.armorValues[n4] = string;
                continue;
            }
            this.critData[n2][n++] = string.trim();
        }
    }

    public Entity getEntity() throws EntityLoadingException {
        try {
            int n;
            Mech mech;
            block53: {
                block54: {
                    block52: {
                        int n2 = 0;
                        try {
                            n2 = Mech.getGyroTypeForString(this.gyroType.substring(5));
                            if (n2 == -1) {
                                n2 = 0;
                            }
                        }
                        catch (Exception exception) {
                            n2 = 0;
                        }
                        int n3 = 0;
                        try {
                            n3 = Mech.getCockpitTypeForString(this.cockpitType.substring(8));
                            if (n3 == -1) {
                                n3 = 0;
                            }
                        }
                        catch (Exception exception) {
                            n3 = 0;
                        }
                        mech = this.chassisConfig.indexOf("Quad") != -1 ? new QuadMech(n2, n3) : (this.chassisConfig.indexOf("LAM") != -1 ? new LandAirMech(n2, n3) : new BipedMech(n2, n3));
                        int n4 = this.name.indexOf("(");
                        if (n4 == -1) {
                            mech.setChassis(this.name.trim());
                        } else {
                            mech.setChassis(this.name.substring(0, n4 - 1).trim());
                        }
                        mech.setModel(this.model.trim());
                        mech.setYear(Integer.parseInt(this.techYear.substring(4).trim()));
                        if (this.chassisConfig.indexOf("Omni") != -1) {
                            mech.setOmni(true);
                        }
                        if (!this.techBase.substring(9).trim().equals("Inner Sphere")) break block52;
                        switch (Integer.parseInt(this.rulesLevel.substring(12).trim())) {
                            case 1: {
                                mech.setTechLevel(0);
                                break block53;
                            }
                            case 2: {
                                mech.setTechLevel(1);
                                break block53;
                            }
                            case 3: {
                                mech.setTechLevel(5);
                                break block53;
                            }
                            case 4: {
                                mech.setTechLevel(7);
                                break block53;
                            }
                            case 5: {
                                mech.setTechLevel(9);
                                break block53;
                            }
                            default: {
                                throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel.substring(12).trim());
                            }
                        }
                    }
                    if (!this.techBase.substring(9).trim().equals("Clan")) break block54;
                    switch (Integer.parseInt(this.rulesLevel.substring(12).trim())) {
                        case 2: {
                            mech.setTechLevel(2);
                            break block53;
                        }
                        case 3: {
                            mech.setTechLevel(6);
                            break block53;
                        }
                        case 4: {
                            mech.setTechLevel(8);
                            break block53;
                        }
                        case 5: {
                            mech.setTechLevel(10);
                            break block53;
                        }
                        default: {
                            throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel.substring(12).trim());
                        }
                    }
                }
                if (this.techBase.substring(9).trim().equals("Mixed (IS Chassis)")) {
                    switch (Integer.parseInt(this.rulesLevel.substring(12).trim())) {
                        case 3: {
                            mech.setTechLevel(5);
                            break;
                        }
                        case 4: {
                            mech.setTechLevel(7);
                            break;
                        }
                        case 5: {
                            mech.setTechLevel(9);
                            break;
                        }
                        default: {
                            throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel.substring(12).trim());
                        }
                    }
                    mech.setMixedTech(true);
                } else if (this.techBase.substring(9).trim().equals("Mixed (Clan Chassis)")) {
                    switch (Integer.parseInt(this.rulesLevel.substring(12).trim())) {
                        case 3: {
                            mech.setTechLevel(6);
                            break;
                        }
                        case 4: {
                            mech.setTechLevel(8);
                            break;
                        }
                        case 5: {
                            mech.setTechLevel(10);
                            break;
                        }
                        default: {
                            throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel.substring(12).trim());
                        }
                    }
                    mech.setMixedTech(true);
                } else {
                    if (this.techBase.substring(9).trim().equals("Mixed")) {
                        throw new EntityLoadingException("Unsupported tech base: \"Mixed\" is no longer allowed by itself.  You must specify \"Mixed (IS Chassis)\" or \"Mixed (Clan Chassis)\".");
                    }
                    throw new EntityLoadingException("Unsupported tech base: " + this.techBase.substring(9).trim());
                }
            }
            mech.setWeight(Integer.parseInt(this.tonnage.substring(5)));
            int n5 = 0;
            if (mech.isClan() && !mech.isMixedTech() || mech.isMixedTech() && mech.isClan() && !mech.itemOppositeTech(this.engine)) {
                n5 = 1;
            }
            int n6 = Integer.parseInt(this.engine.substring(this.engine.indexOf(":") + 1, this.engine.indexOf(" ")));
            mech.setEngine(new Engine(n6, Engine.getEngineTypeByString(this.engine), n5));
            mech.setOriginalJumpMP(Integer.parseInt(this.jumpMP.substring(8)));
            boolean bl = this.heatSinks.substring(14).equalsIgnoreCase("Double");
            boolean bl2 = this.heatSinks.substring(14).equalsIgnoreCase("Laser");
            int n7 = Integer.parseInt(this.heatSinks.substring(11, 14).trim());
            String string = this.internalType.substring(this.internalType.indexOf(58) + 1);
            if (string.length() > 0) {
                mech.setStructureType(string);
            } else {
                mech.setStructureType(0);
            }
            mech.autoSetInternal();
            String string2 = this.armorType.substring(this.armorType.indexOf(58) + 1);
            if (string2.length() > 0) {
                mech.setArmorType(string2);
            } else {
                mech.setArmorType(0);
            }
            for (n = 0; n < locationOrder.length; ++n) {
                mech.initializeArmor(Integer.parseInt(this.armorValues[n].substring(this.armorValues[n].indexOf(58) + 1)), locationOrder[n]);
            }
            for (n = 0; n < rearLocationOrder.length; ++n) {
                mech.initializeRearArmor(Integer.parseInt(this.armorValues[n + locationOrder.length].substring(10)), rearLocationOrder[n]);
            }
            this.compactCriticals(mech);
            for (n = mech.locations() - 1; n >= 0; --n) {
                this.parseCrits(mech, n);
            }
            if (mech.isClan()) {
                mech.addClanCase();
            }
            if (bl2) {
                mech.addEngineSinks(n7 - mech.heatSinks(), "CLLaser Heat Sink");
            } else {
                mech.addEngineSinks(n7 - mech.heatSinks(), bl);
            }
            return mech;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new EntityLoadingException("NumberFormatException parsing file");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw new EntityLoadingException("NullPointerException parsing file");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            stringIndexOutOfBoundsException.printStackTrace();
            throw new EntityLoadingException("StringIndexOutOfBoundsException parsing file");
        }
    }

    private void parseCrits(Mech mech, int n) throws EntityLoadingException {
        if (!(mech instanceof QuadMech || n != 5 && n != 4)) {
            if (!this.critData[n][3].equals("Hand Actuator")) {
                mech.setCritical(n, 3, null);
            }
            if (!this.critData[n][2].equals("Lower Arm Actuator")) {
                mech.setCritical(n, 2, null);
            }
        }
        for (int i = 0; i < mech.getNumberOfCriticals(n); ++i) {
            if (mech.getCritical(n, i) != null) continue;
            String string = this.critData[n][i];
            string.trim();
            boolean bl = false;
            if (string.equalsIgnoreCase("Fusion Engine") || string.equalsIgnoreCase("Engine")) {
                mech.setCritical(n, i, new CriticalSlot(0, 3));
                continue;
            }
            if (string.equalsIgnoreCase("Life Support")) {
                mech.setCritical(n, i, new CriticalSlot(0, 0));
                continue;
            }
            if (string.equalsIgnoreCase("Sensors")) {
                mech.setCritical(n, i, new CriticalSlot(0, 1));
                continue;
            }
            if (string.equalsIgnoreCase("Cockpit")) {
                mech.setCritical(n, i, new CriticalSlot(0, 2));
                continue;
            }
            if (string.equalsIgnoreCase("Gyro")) {
                mech.setCritical(n, i, new CriticalSlot(0, 4));
                continue;
            }
            if (string.toUpperCase().endsWith("(R)")) {
                bl = true;
                string = string.substring(0, string.length() - 3).trim();
            }
            if (string.toLowerCase().endsWith("(split)")) {
                string = string.substring(0, string.length() - 7).trim();
            }
            if (string.equalsIgnoreCase("Armored Cowl")) {
                mech.setCowl(5);
            }
            try {
                EquipmentType equipmentType = EquipmentType.get(string);
                if (equipmentType != null) {
                    Mounted mounted;
                    if (equipmentType.isSpreadable()) {
                        mounted = this.hSharedEquip.get(equipmentType);
                        if (mounted != null) {
                            mech.addCritical(n, new CriticalSlot(1, mech.getEquipmentNum(mounted), equipmentType.isHittable()));
                            continue;
                        }
                        mounted = mech.addEquipment(equipmentType, n, bl);
                        this.hSharedEquip.put(equipmentType, mounted);
                        continue;
                    }
                    if (equipmentType instanceof WeaponType && equipmentType.hasFlag(256L)) {
                        int n2;
                        mounted = null;
                        boolean bl2 = false;
                        int n3 = this.vSplitWeapons.size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            mounted = this.vSplitWeapons.elementAt(n2);
                            int n4 = mounted.getLocation();
                            if (n4 != n && n != Mech.getInnerLocation(n4) || mounted.getType() != equipmentType) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2 && mounted != null) {
                            mounted.setFoundCrits(mounted.getFoundCrits() + 1);
                            if (mounted.getFoundCrits() >= equipmentType.getCriticals(mech)) {
                                this.vSplitWeapons.removeElement(mounted);
                            }
                            if (n != mounted.getLocation()) {
                                mounted.setSplit(true);
                            }
                            n2 = mounted.getLocation();
                            mounted.setLocation(Mech.mostRestrictiveLoc(n, n2));
                            if (n != n2) {
                                mounted.setSecondLocation(Mech.leastRestrictiveLoc(n, n2));
                            }
                        } else {
                            mounted = new Mounted(mech, equipmentType);
                            mounted.setFoundCrits(1);
                            this.vSplitWeapons.addElement(mounted);
                        }
                        mech.addEquipment(mounted, n, bl);
                        continue;
                    }
                    mech.addEquipment(equipmentType, n, bl);
                    continue;
                }
                if (string.equals(EMPTY)) continue;
                mech.addFailedEquipment(string);
                this.critData[n][i] = EMPTY;
                this.compactCriticals(mech, n);
                --i;
                continue;
            }
            catch (LocationFullException locationFullException) {
                throw new EntityLoadingException(locationFullException.getMessage());
            }
        }
    }

    private void compactCriticals(Mech mech) {
        for (int i = 0; i < mech.locations(); ++i) {
            this.compactCriticals(mech, i);
        }
    }

    private void compactCriticals(Mech mech, int n) {
        if (n == 0) {
            return;
        }
        int n2 = -1;
        for (int i = 0; i < mech.getNumberOfCriticals(n); ++i) {
            if (this.critData[n][i] == null) {
                this.critData[n][i] = EMPTY;
            }
            if (this.critData[n][i].equals(EMPTY)) {
                n2 = i;
            }
            if (n2 == -1 || this.critData[n][i].equals(EMPTY)) continue;
            this.critData[n][n2] = this.critData[n][i];
            this.critData[n][i] = EMPTY;
            i = n2;
            n2 = -1;
        }
    }

    private int getLocation(String string) {
        if (string.trim().equalsIgnoreCase("Left Arm:") || string.trim().equalsIgnoreCase("Front Left Leg:")) {
            return 5;
        }
        if (string.trim().equalsIgnoreCase("Right Arm:") || string.trim().equalsIgnoreCase("Front Right Leg:")) {
            return 4;
        }
        if (string.equalsIgnoreCase("Left Leg:") || string.equalsIgnoreCase("Rear Left Leg:")) {
            return 7;
        }
        if (string.trim().equalsIgnoreCase("Right Leg:") || string.trim().equalsIgnoreCase("Rear Right Leg:")) {
            return 6;
        }
        if (string.trim().equalsIgnoreCase("Left Torso:")) {
            return 3;
        }
        if (string.trim().equalsIgnoreCase("Right Torso:")) {
            return 2;
        }
        if (string.trim().equalsIgnoreCase("Center Torso:")) {
            return 1;
        }
        return 0;
    }

    private int getArmorLocation(String string) {
        int n = -1;
        boolean bl = false;
        if (string.trim().toLowerCase().startsWith("la armor:") || string.trim().toLowerCase().startsWith("fll armor:")) {
            n = 5;
        } else if (string.trim().toLowerCase().startsWith("ra armor:") || string.trim().toLowerCase().startsWith("frl armor:")) {
            n = 4;
        } else if (string.trim().toLowerCase().startsWith("lt armor:")) {
            n = 3;
        } else if (string.trim().toLowerCase().startsWith("rt armor:")) {
            n = 2;
        } else if (string.trim().toLowerCase().startsWith("ct armor:")) {
            n = 1;
        } else if (string.trim().toLowerCase().startsWith("hd armor:")) {
            n = 0;
        } else if (string.trim().toLowerCase().startsWith("ll armor:") || string.trim().toLowerCase().startsWith("rll armor:")) {
            n = 7;
        } else if (string.trim().toLowerCase().startsWith("rl armor:") || string.trim().toLowerCase().startsWith("rrl armor:")) {
            n = 6;
        } else if (string.trim().toLowerCase().startsWith("rtl armor:")) {
            n = 3;
            bl = true;
        } else if (string.trim().toLowerCase().startsWith("rtr armor:")) {
            n = 2;
            bl = true;
        } else if (string.trim().toLowerCase().startsWith("rtc armor:")) {
            n = 1;
            bl = true;
        }
        if (!bl) {
            for (int i = 0; i < locationOrder.length; ++i) {
                if (locationOrder[i] != n) continue;
                n = i;
                break;
            }
        } else {
            for (int i = 0; i < rearLocationOrder.length; ++i) {
                if (rearLocationOrder[i] != n) continue;
                n = i + locationOrder.length;
                break;
            }
        }
        return n;
    }

    private boolean isValidLocation(String string) {
        return string.trim().equalsIgnoreCase("Left Arm:") || string.trim().equalsIgnoreCase("Right Arm:") || string.equalsIgnoreCase("Left Leg:") || string.trim().equalsIgnoreCase("Right Leg:") || string.trim().equalsIgnoreCase("Front Left Leg:") || string.trim().equalsIgnoreCase("Front Right Leg:") || string.trim().equalsIgnoreCase("Rear Left Leg:") || string.trim().equalsIgnoreCase("Rear Right Leg:") || string.trim().equalsIgnoreCase("Left Torso:") || string.trim().equalsIgnoreCase("Right Torso:") || string.trim().equalsIgnoreCase("Center Torso:") || string.trim().equalsIgnoreCase("Head:");
    }

    private boolean isProcessedComponent(String string) {
        if (string.trim().toLowerCase().startsWith("cockpit:")) {
            this.cockpitType = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("gyro:")) {
            this.gyroType = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("mass:")) {
            this.tonnage = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("engine:")) {
            this.engine = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("structure:")) {
            this.internalType = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("myomer:")) {
            this.myomerType = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("config:")) {
            this.chassisConfig = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("techbase:")) {
            this.techBase = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("era:")) {
            this.techYear = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("rules level:")) {
            this.rulesLevel = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("heat sinks:")) {
            this.heatSinks = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("walk mp:")) {
            this.walkMP = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("jump mp:")) {
            this.jumpMP = string;
            return true;
        }
        if (string.trim().toLowerCase().startsWith("armor:")) {
            this.armorType = string;
            return true;
        }
        return false;
    }

    private int weaponsList(String string) {
        if (string.trim().toLowerCase().startsWith("weapons:")) {
            return Integer.parseInt(string.substring(8));
        }
        return -1;
    }
}

